/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.ArchitectUtils;
import ca.sqlpower.architect.LockedColumnException;
import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.SQLDatabase;
import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.SQLObjectEvent;
import ca.sqlpower.architect.SQLObjectListener;
import ca.sqlpower.architect.SQLRelationship;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.SQLTestCase;
import ca.sqlpower.architect.TestSQLColumn;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.undo.UndoCompoundEvent;
import ca.sqlpower.architect.undo.UndoCompoundEventListener;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.commons.beanutils.BeanUtils;

public class TestSQLTable
extends SQLTestCase {
    private SQLTable table;

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(TestSQLTable.class);
        TestSetup wrapper = new TestSetup((Test)suite){

            protected void setUp() throws Exception {
                TestSQLTable.oneTimeSetUp();
            }

            protected void tearDown() throws Exception {
                TestSQLTable.oneTimeTearDown();
            }
        };
        return wrapper;
    }

    public static void oneTimeSetUp() throws Exception {
        System.out.println("TestSQLTable.oneTimeSetUp()");
        SQLDatabase mydb = new SQLDatabase(TestSQLTable.getDataSource());
        Connection con = null;
        Statement stmt = null;
        try {
            con = mydb.getConnection();
            stmt = con.createStatement();
            try {
                stmt.executeUpdate("DROP TABLE REGRESSION_TEST1");
                stmt.executeUpdate("DROP TABLE REGRESSION_TEST2");
            }
            catch (SQLException sqle) {
                System.out.println("+++ TestSQLDatabase exception should be for dropping a non-existant table");
                sqle.printStackTrace();
            }
            stmt.executeUpdate("CREATE TABLE REGRESSION_TEST1 (t1_c1 numeric(10), t1_c2 numeric(5))");
            stmt.executeUpdate("CREATE TABLE REGRESSION_TEST2 (t2_c1 char(10))");
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e) {
                System.out.println("Couldn't close statement");
            }
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException e) {
                System.out.println("Couldn't close connection");
            }
            mydb.disconnect();
        }
    }

    public static void oneTimeTearDown() {
        System.out.println("TestSQLTable.oneTimeTearDown()");
    }

    public TestSQLTable(String name) throws Exception {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.table = new SQLTable(null, true);
        this.table.addColumn(new SQLColumn(this.table, "one", 4, 10, 0));
        this.table.addColumn(new SQLColumn(this.table, "two", 4, 10, 0));
        this.table.addColumn(new SQLColumn(this.table, "three", 4, 10, 0));
        this.table.addColumn(new SQLColumn(this.table, "four", 4, 10, 0));
        this.table.addColumn(new SQLColumn(this.table, "five", 4, 10, 0));
        this.table.addColumn(new SQLColumn(this.table, "six", 4, 10, 0));
        this.table.getColumn(0).setPrimaryKeySeq(0);
        this.table.getColumn(1).setPrimaryKeySeq(1);
        this.table.getColumn(2).setPrimaryKeySeq(2);
        this.table.getColumn(0).setNullable(1);
        this.table.getColumn(0).setAutoIncrement(true);
    }

    protected SQLObject getSQLObjectUnderTest() {
        return this.table;
    }

    public void testConstructor() {
    }

    public void testGetDerivedInstance() throws Exception {
        SQLDatabase pp = new SQLDatabase();
        pp.setPlayPenDatabase(true);
        SQLTable table1 = this.db.getTableByName("REGRESSION_TEST1");
        TestSQLTable.assertNotNull((Object)table1);
        SQLTable derivedTable = SQLTable.getDerivedInstance(table1, pp);
        TreeMap derivedPropertyMap = new TreeMap(BeanUtils.describe((Object)derivedTable));
        TreeMap table1PropertyMap = new TreeMap(BeanUtils.describe((Object)table1));
        derivedPropertyMap.remove("parent");
        derivedPropertyMap.remove("parentDatabase");
        derivedPropertyMap.remove("schemaName");
        derivedPropertyMap.remove("schema");
        derivedPropertyMap.remove("shortDisplayName");
        table1PropertyMap.remove("parent");
        table1PropertyMap.remove("schemaName");
        table1PropertyMap.remove("schema");
        table1PropertyMap.remove("parentDatabase");
        table1PropertyMap.remove("shortDisplayName");
        TestSQLTable.assertEquals((String)"Derived table not properly copied", (String)derivedPropertyMap.toString(), (String)table1PropertyMap.toString());
    }

    public void testInherit() throws ArchitectException {
        SQLTable table1 = this.db.getTableByName("REGRESSION_TEST1");
        SQLTable table2 = this.db.getTableByName("REGRESSION_TEST2");
        TestSQLTable.assertEquals((int)2, (int)table1.getColumns().size());
        TestSQLTable.assertEquals((int)1, (int)table2.getColumns().size());
        table2.inherit(table1);
        TestSQLTable.assertEquals((String)"The wrong 1st column was inherited", (String)table1.getColumn(0).toString(), (String)table2.getColumn(1).toString());
        TestSQLTable.assertEquals((String)"The wrong 2nd column was inherited", (String)table1.getColumn(1).toString(), (String)table2.getColumn(2).toString());
        TestSQLTable.assertEquals((String)"The wrong number of columns were inherited", (int)table2.getColumns().size(), (int)3);
        try {
            table2.inherit(table2);
        }
        catch (ArchitectException ae) {
            if ("Cannot inherit from self".equals(ae.getMessage())) {
                System.out.println("Expected Behaviour is to not be able to inherit from self");
            }
            throw ae;
        }
    }

    public void testGetColumnByName() throws ArchitectException {
        SQLTable table1 = this.db.getTableByName("REGRESSION_TEST1");
        SQLColumn col2 = table1.getColumnByName("t1_c2");
        TestSQLTable.assertNotNull((Object)col2);
        TestSQLTable.assertEquals((String)"The wrong colomn us returned", (Object)col2, (Object)table1.getColumn(1));
        SQLColumn col1 = table1.getColumnByName("t1_c1");
        TestSQLTable.assertNotNull((Object)col1);
        TestSQLTable.assertEquals((String)"The wrong colomn us returned", (Object)col1, (Object)table1.getColumn(0));
        col1 = table1.getColumnByName("This_is_a_non_existant_column");
        TestSQLTable.assertNull((Object)col1);
        col1 = table1.getColumnByName("$#  #$%#%");
        TestSQLTable.assertNull((String)"Invalid column name", (Object)col1);
    }

    public void testAddColumn() throws ArchitectException {
        SQLTable table1 = this.db.getTableByName("REGRESSION_TEST1");
        SQLColumn newColumn = new SQLColumn(table1, "my new column", 4, 10, 0);
        table1.addColumn(2, newColumn);
        SQLColumn addedCol = table1.getColumn(2);
        TestSQLTable.assertSame((String)"Column at index 2 isn't same object as we added", (Object)newColumn, (Object)addedCol);
    }

    public void testAddColumnReference() throws ArchitectException {
        SQLTable table = this.db.getTableByName("REGRESSION_TEST1");
        SQLColumn col = table.getColumn(0);
        TestSQLTable.assertEquals((String)"Existing column had refcount != 1", (int)1, (int)col.getReferenceCount());
        table.addColumn(col);
        TestSQLTable.assertEquals((String)"refcount didn't increase", (int)2, (int)col.getReferenceCount());
    }

    public void tesRemoveColumnByZeroRefs() throws ArchitectException {
        SQLTable table = this.db.getTableByName("REGRESSION_TEST1");
        SQLColumn col = table.getColumn(0);
        table.addColumn(col);
        table.addColumn(col);
        col.removeReference();
        TestSQLTable.assertTrue((boolean)table.getColumns().contains(col));
        col.removeReference();
        TestSQLTable.assertTrue((boolean)table.getColumns().contains(col));
        col.removeReference();
        TestSQLTable.assertFalse((boolean)table.getColumns().contains(col));
    }

    public void testAddColumnAtEndOfPK() throws ArchitectException {
        SQLTable t = new SQLTable(ArchitectFrame.getMainInstance().getProject().getTargetDatabase(), true);
        t.setName("Test Table");
        SQLColumn pk1 = new SQLColumn(t, "PKColumn1", 4, 10, 0);
        SQLColumn pk2 = new SQLColumn(t, "PKColumn2", 4, 10, 0);
        SQLColumn pk3 = new SQLColumn(t, "PKColumn3", 4, 10, 0);
        SQLColumn at1 = new SQLColumn(t, "AT1", 4, 10, 0);
        SQLColumn at2 = new SQLColumn(t, "AT2", 4, 10, 0);
        SQLColumn at3 = new SQLColumn(t, "AT3", 4, 10, 0);
        t.addColumn(0, pk1);
        t.addColumn(1, pk2);
        t.addColumn(2, pk3);
        t.addColumn(3, at1);
        t.addColumn(4, at2);
        t.addColumn(5, at3);
        pk1.setPrimaryKeySeq(1);
        pk2.setPrimaryKeySeq(2);
        pk3.setPrimaryKeySeq(3);
        TestSQLTable.assertEquals((int)3, (int)t.getPkSize());
        SQLColumn newcol = new SQLColumn(t, "newcol", 4, 10, 0);
        t.addColumn(3, newcol);
        TestSQLTable.assertEquals((String)"New column should be at requested position", (int)3, (int)t.getColumnIndex(newcol));
        newcol.setPrimaryKeySeq(3);
        TestSQLTable.assertEquals((String)"New column should still be at requested position", (int)3, (int)t.getColumnIndex(newcol));
    }

    public void testMoveToPKClearsNullability() throws ArchitectException {
        SQLTable t = this.db.getTableByName("REGRESSION_TEST1");
        SQLColumn c = t.getColumnByName("t1_c1");
        TestSQLTable.assertNull((String)"Column shouldn't be in PK to begin", (Object)c.getPrimaryKeySeq());
        c.setNullable(1);
        t.changeColumnIndex(0, 0, true);
        TestSQLTable.assertTrue((boolean)c.isPrimaryKey());
        TestSQLTable.assertEquals((int)0, (int)c.getNullable());
    }

    public void testRemoveColumnOutBounds() throws ArchitectException {
        SQLTable table1 = this.db.getTableByName("REGRESSION_TEST1");
        IndexOutOfBoundsException exc = null;
        try {
            table1.removeColumn(16);
        }
        catch (IndexOutOfBoundsException e) {
            System.out.println("Method throws proper error");
            exc = e;
        }
        TestSQLTable.assertNotNull((String)"Should have thrown an exception", exc);
    }

    public void testRemoveColumn() throws ArchitectException {
        SQLTable table1 = this.db.getTableByName("REGRESSION_TEST1");
        SQLColumn col1 = table1.getColumn(0);
        SQLColumn col2 = table1.getColumn(1);
        TestSQLTable.assertEquals((String)"We removed a column when we shouldn't have", (int)table1.getColumns().size(), (int)2);
        table1.removeColumn(col1);
        TestSQLTable.assertEquals((String)"Either 0 or 2+ columns were removed", (int)table1.getColumns().size(), (int)1);
        TestSQLTable.assertEquals((String)"The wrong column was removed", (Object)col2, (Object)table1.getColumn(0));
        table1.removeColumn(0);
        TestSQLTable.assertEquals((String)"Last Column failed to be removed", (int)table1.getColumns().size(), (int)0);
        IndexOutOfBoundsException exc = null;
        try {
            table1.removeColumn(0);
        }
        catch (IndexOutOfBoundsException e) {
            System.out.println("Method throws proper error");
            exc = e;
        }
        TestSQLTable.assertNotNull((String)"Should have thrown an exception", exc);
    }

    public void testNormalizePrimaryKey() throws ArchitectException {
        SQLColumn col1 = this.db.getTableByName("REGRESSION_TEST2").getColumn(0);
        col1.setPrimaryKeySeq(new Integer(5));
        SQLTable table1 = this.db.getTableByName("REGRESSION_TEST1");
        SQLColumn col2 = new SQLColumn(col1);
        col2.setPrimaryKeySeq(new Integer(16));
        table1.addColumn(2, col1);
        table1.addColumn(3, col2);
        table1.normalizePrimaryKey();
        TestSQLTable.assertEquals((String)"Wrong number of primary keys", (int)table1.getPkSize(), (int)0);
        col1.setPrimaryKeySeq(new Integer(5));
        col2.setPrimaryKeySeq(new Integer(16));
        TestSQLTable.assertEquals((String)"Invalid key order", (Object)table1.getColumn(0), (Object)col1);
        TestSQLTable.assertEquals((String)"2nd key out of order", (Object)table1.getColumn(1), (Object)col2);
        TestSQLTable.assertEquals((String)"Too many or too few primary keys", (int)table1.getPkSize(), (int)2);
    }

    public void testFireDbChildrenInserted() throws Exception {
        SQLTable table1 = this.db.getTableByName("REGRESSION_TEST1");
        SQLColumn c1 = table1.getColumn(0);
        SQLTable.Folder<SQLColumn> folder = table1.getColumnsFolder();
        TestSQLColumn.TestSQLObjectListener test1 = new TestSQLColumn.TestSQLObjectListener();
        folder.addSQLObjectListener(test1);
        TestSQLColumn.TestSQLObjectListener test2 = new TestSQLColumn.TestSQLObjectListener();
        folder.addSQLObjectListener(test2);
        TestSQLTable.assertEquals((int)test1.getInsertedCount(), (int)0);
        TestSQLTable.assertEquals((int)test1.getRemovedCount(), (int)0);
        TestSQLTable.assertEquals((int)test1.getChangedCount(), (int)0);
        TestSQLTable.assertEquals((int)test1.getStructureChangedCount(), (int)0);
        TestSQLTable.assertEquals((int)test2.getInsertedCount(), (int)0);
        TestSQLTable.assertEquals((int)test2.getRemovedCount(), (int)0);
        TestSQLTable.assertEquals((int)test2.getChangedCount(), (int)0);
        TestSQLTable.assertEquals((int)test2.getStructureChangedCount(), (int)0);
        SQLColumn tmpCol = new SQLColumn();
        table1.addColumn(tmpCol);
        table1.changeColumnIndex(table1.getColumnIndex(c1), 2, false);
        TestSQLTable.assertEquals((int)test1.getInsertedCount(), (int)2);
        TestSQLTable.assertEquals((int)test1.getRemovedCount(), (int)1);
        TestSQLTable.assertEquals((int)test1.getChangedCount(), (int)0);
        TestSQLTable.assertEquals((int)test1.getStructureChangedCount(), (int)0);
        TestSQLTable.assertEquals((int)test2.getInsertedCount(), (int)2);
        TestSQLTable.assertEquals((int)test2.getRemovedCount(), (int)1);
        TestSQLTable.assertEquals((int)test2.getChangedCount(), (int)0);
        TestSQLTable.assertEquals((int)test2.getStructureChangedCount(), (int)0);
        folder.removeSQLObjectListener(test1);
        table1.changeColumnIndex(table1.getColumnIndex(c1), 1, false);
        TestSQLTable.assertEquals((int)test1.getInsertedCount(), (int)2);
        TestSQLTable.assertEquals((int)test1.getRemovedCount(), (int)1);
        TestSQLTable.assertEquals((int)test1.getChangedCount(), (int)0);
        TestSQLTable.assertEquals((int)test1.getStructureChangedCount(), (int)0);
        TestSQLTable.assertEquals((int)test2.getInsertedCount(), (int)3);
        TestSQLTable.assertEquals((int)test2.getRemovedCount(), (int)2);
        TestSQLTable.assertEquals((int)test2.getChangedCount(), (int)0);
        TestSQLTable.assertEquals((int)test2.getStructureChangedCount(), (int)0);
        table1.removeColumn(tmpCol);
        TestSQLTable.assertEquals((int)test2.getInsertedCount(), (int)3);
        TestSQLTable.assertEquals((int)test2.getRemovedCount(), (int)3);
        TestSQLTable.assertEquals((int)test2.getChangedCount(), (int)0);
        TestSQLTable.assertEquals((int)test2.getStructureChangedCount(), (int)0);
    }

    public void testDeleteLockedColumn() throws ArchitectException {
        ArchitectFrame af = ArchitectFrame.getMainInstance();
        SQLTable parentTable = new SQLTable(af.getProject().getPlayPen().getDatabase(), "parent", null, "TABLE", true);
        parentTable.addColumn(new SQLColumn(parentTable, "pkcol_1", 4, 10, 0));
        parentTable.addColumn(new SQLColumn(parentTable, "pkcol_2", 4, 10, 0));
        parentTable.addColumn(new SQLColumn(parentTable, "attribute_1", 4, 10, 0));
        SQLTable childTable1 = new SQLTable(af.getProject().getPlayPen().getDatabase(), "child_1", null, "TABLE", true);
        childTable1.addColumn(new SQLColumn(childTable1, "child_pkcol_1", 4, 10, 0));
        childTable1.addColumn(new SQLColumn(childTable1, "child_pkcol_2", 4, 10, 0));
        childTable1.addColumn(new SQLColumn(childTable1, "child_attribute", 4, 10, 0));
        SQLRelationship rel1 = new SQLRelationship();
        rel1.attachRelationship(parentTable, childTable1, false);
        rel1.addMapping(parentTable.getColumn(0), childTable1.getColumn(0));
        rel1.addMapping(parentTable.getColumn(1), childTable1.getColumn(1));
        try {
            SQLColumn inheritedCol = childTable1.getColumnByName("child_pkcol_1");
            childTable1.removeColumn(inheritedCol);
            TestSQLTable.fail((String)"Remove should have thrown LockedColumnException");
        }
        catch (LockedColumnException lockedColumnException) {
            // empty catch block
        }
    }

    public void testRemovePKColumn() throws ArchitectException {
        TestSQLTable.assertEquals((String)"There should be 6 columns to start", (int)6, (int)this.table.getColumns().size());
        this.table.removeColumn(this.table.getColumnIndex(this.table.getColumnByName("two")));
        TestSQLTable.assertEquals((String)"A column should have been removed", (int)5, (int)this.table.getColumns().size());
        TestSQLTable.assertEquals((int)2, (int)this.table.getPkSize());
        TestSQLTable.assertEquals((int)0, (int)this.table.getColumnIndex(this.table.getColumnByName("one")));
        TestSQLTable.assertEquals((int)1, (int)this.table.getColumnIndex(this.table.getColumnByName("three")));
        TestSQLTable.assertEquals((int)2, (int)this.table.getColumnIndex(this.table.getColumnByName("four")));
        TestSQLTable.assertEquals((int)3, (int)this.table.getColumnIndex(this.table.getColumnByName("five")));
        TestSQLTable.assertEquals((int)4, (int)this.table.getColumnIndex(this.table.getColumnByName("six")));
    }

    public void testRemoveFKColumn() throws ArchitectException {
        TestSQLTable.assertEquals((String)"There should be 6 columns to start", (int)6, (int)this.table.getColumns().size());
        this.table.removeColumn(this.table.getColumnIndex(this.table.getColumnByName("five")));
        TestSQLTable.assertEquals((String)"A column should have been removed", (int)5, (int)this.table.getColumns().size());
        TestSQLTable.assertEquals((int)3, (int)this.table.getPkSize());
        TestSQLTable.assertEquals((int)0, (int)this.table.getColumnIndex(this.table.getColumnByName("one")));
        TestSQLTable.assertEquals((int)1, (int)this.table.getColumnIndex(this.table.getColumnByName("two")));
        TestSQLTable.assertEquals((int)2, (int)this.table.getColumnIndex(this.table.getColumnByName("three")));
        TestSQLTable.assertEquals((int)3, (int)this.table.getColumnIndex(this.table.getColumnByName("four")));
        TestSQLTable.assertEquals((int)4, (int)this.table.getColumnIndex(this.table.getColumnByName("six")));
    }

    public void testAddColAtFirstIdx() throws ArchitectException {
        this.table.addColumn(0, new SQLColumn(this.table, "zero", 4, 10, 0));
        TestSQLTable.assertEquals((int)7, (int)this.table.getColumns().size());
        TestSQLTable.assertEquals((int)4, (int)this.table.getPkSize());
        TestSQLTable.assertTrue((boolean)this.table.getColumnByName("zero").isPrimaryKey());
        TestSQLTable.assertEquals((int)0, (int)this.table.getColumnIndex(this.table.getColumnByName("zero")));
        TestSQLTable.assertEquals((int)1, (int)this.table.getColumnIndex(this.table.getColumnByName("one")));
        TestSQLTable.assertEquals((int)2, (int)this.table.getColumnIndex(this.table.getColumnByName("two")));
        TestSQLTable.assertEquals((int)3, (int)this.table.getColumnIndex(this.table.getColumnByName("three")));
        TestSQLTable.assertEquals((int)4, (int)this.table.getColumnIndex(this.table.getColumnByName("four")));
        TestSQLTable.assertEquals((int)5, (int)this.table.getColumnIndex(this.table.getColumnByName("five")));
        TestSQLTable.assertEquals((int)6, (int)this.table.getColumnIndex(this.table.getColumnByName("six")));
    }

    public void testAddColAbovePK() throws ArchitectException {
        this.table.addColumn(2, new SQLColumn(this.table, "indextwo", 4, 10, 0));
        TestSQLTable.assertEquals((int)7, (int)this.table.getColumns().size());
        TestSQLTable.assertEquals((int)4, (int)this.table.getPkSize());
        TestSQLTable.assertTrue((boolean)this.table.getColumnByName("indextwo").isPrimaryKey());
        TestSQLTable.assertEquals((int)0, (int)this.table.getColumnIndex(this.table.getColumnByName("one")));
        TestSQLTable.assertEquals((int)1, (int)this.table.getColumnIndex(this.table.getColumnByName("two")));
        TestSQLTable.assertEquals((int)2, (int)this.table.getColumnIndex(this.table.getColumnByName("indextwo")));
        TestSQLTable.assertEquals((int)3, (int)this.table.getColumnIndex(this.table.getColumnByName("three")));
        TestSQLTable.assertEquals((int)4, (int)this.table.getColumnIndex(this.table.getColumnByName("four")));
        TestSQLTable.assertEquals((int)5, (int)this.table.getColumnIndex(this.table.getColumnByName("five")));
        TestSQLTable.assertEquals((int)6, (int)this.table.getColumnIndex(this.table.getColumnByName("six")));
    }

    public void testAddColBelowPK() throws ArchitectException {
        this.table.addColumn(4, new SQLColumn(this.table, "indexfour", 4, 10, 0));
        TestSQLTable.assertEquals((int)7, (int)this.table.getColumns().size());
        TestSQLTable.assertEquals((int)3, (int)this.table.getPkSize());
        TestSQLTable.assertFalse((boolean)this.table.getColumnByName("indexfour").isPrimaryKey());
        TestSQLTable.assertEquals((int)0, (int)this.table.getColumnIndex(this.table.getColumnByName("one")));
        TestSQLTable.assertEquals((int)1, (int)this.table.getColumnIndex(this.table.getColumnByName("two")));
        TestSQLTable.assertEquals((int)2, (int)this.table.getColumnIndex(this.table.getColumnByName("three")));
        TestSQLTable.assertEquals((int)3, (int)this.table.getColumnIndex(this.table.getColumnByName("four")));
        TestSQLTable.assertEquals((int)4, (int)this.table.getColumnIndex(this.table.getColumnByName("indexfour")));
        TestSQLTable.assertEquals((int)5, (int)this.table.getColumnIndex(this.table.getColumnByName("five")));
        TestSQLTable.assertEquals((int)6, (int)this.table.getColumnIndex(this.table.getColumnByName("six")));
    }

    public void testChangeFirstColumnIdx() throws ArchitectException {
        this.table.changeColumnIndex(0, 1, true);
        TestSQLTable.assertEquals((int)3, (int)this.table.getPkSize());
        TestSQLTable.assertEquals((int)0, (int)this.table.getColumnIndex(this.table.getColumnByName("two")));
        TestSQLTable.assertEquals((int)1, (int)this.table.getColumnIndex(this.table.getColumnByName("one")));
        TestSQLTable.assertEquals((int)2, (int)this.table.getColumnIndex(this.table.getColumnByName("three")));
        TestSQLTable.assertEquals((int)3, (int)this.table.getColumnIndex(this.table.getColumnByName("four")));
        TestSQLTable.assertEquals((int)4, (int)this.table.getColumnIndex(this.table.getColumnByName("five")));
        TestSQLTable.assertEquals((int)5, (int)this.table.getColumnIndex(this.table.getColumnByName("six")));
    }

    public void testChangeSecondColumnIdx() throws ArchitectException {
        this.table.changeColumnIndex(1, 0, true);
        TestSQLTable.assertEquals((int)3, (int)this.table.getPkSize());
        TestSQLTable.assertEquals((int)0, (int)this.table.getColumnIndex(this.table.getColumnByName("two")));
        TestSQLTable.assertEquals((int)1, (int)this.table.getColumnIndex(this.table.getColumnByName("one")));
        TestSQLTable.assertEquals((int)2, (int)this.table.getColumnIndex(this.table.getColumnByName("three")));
        TestSQLTable.assertEquals((int)3, (int)this.table.getColumnIndex(this.table.getColumnByName("four")));
        TestSQLTable.assertEquals((int)4, (int)this.table.getColumnIndex(this.table.getColumnByName("five")));
        TestSQLTable.assertEquals((int)5, (int)this.table.getColumnIndex(this.table.getColumnByName("six")));
    }

    public void testChangeSecondColumnIdxToFifth() throws ArchitectException {
        this.table.changeColumnIndex(1, 4, true);
        TestSQLTable.assertEquals((int)2, (int)this.table.getPkSize());
        TestSQLTable.assertEquals((int)0, (int)this.table.getColumnIndex(this.table.getColumnByName("one")));
        TestSQLTable.assertEquals((int)1, (int)this.table.getColumnIndex(this.table.getColumnByName("three")));
        TestSQLTable.assertEquals((int)2, (int)this.table.getColumnIndex(this.table.getColumnByName("four")));
        TestSQLTable.assertEquals((int)3, (int)this.table.getColumnIndex(this.table.getColumnByName("five")));
        TestSQLTable.assertEquals((int)4, (int)this.table.getColumnIndex(this.table.getColumnByName("two")));
        TestSQLTable.assertEquals((int)5, (int)this.table.getColumnIndex(this.table.getColumnByName("six")));
    }

    public void testChangeSFifthColumnIdxToSecond() throws Exception {
        EventLogger l = new EventLogger();
        EventLogger.TableSnapshot original = l.makeTableSnapshot(this.table);
        ArchitectUtils.listenToHierarchy((SQLObjectListener)l, this.table);
        this.table.changeColumnIndex(4, 1, true);
        ArchitectUtils.unlistenToHierarchy((SQLObjectListener)l, this.table);
        TestSQLTable.assertEquals((int)4, (int)this.table.getPkSize());
        TestSQLTable.assertEquals((int)0, (int)this.table.getColumnIndex(this.table.getColumnByName("one")));
        TestSQLTable.assertEquals((int)1, (int)this.table.getColumnIndex(this.table.getColumnByName("five")));
        TestSQLTable.assertEquals((int)2, (int)this.table.getColumnIndex(this.table.getColumnByName("two")));
        TestSQLTable.assertEquals((int)3, (int)this.table.getColumnIndex(this.table.getColumnByName("three")));
        TestSQLTable.assertEquals((int)4, (int)this.table.getColumnIndex(this.table.getColumnByName("four")));
        TestSQLTable.assertEquals((int)5, (int)this.table.getColumnIndex(this.table.getColumnByName("six")));
        System.out.println("Event log:\n" + l);
        EventLogger.TableSnapshot afterChange = l.makeTableSnapshot(this.table);
        System.out.println("Original: " + original);
        System.out.println("After: " + afterChange);
        l.rollBack(afterChange);
        TestSQLTable.assertEquals((String)original.toString(), (String)afterChange.toString());
    }

    public void testChangeSFifthColumnIdxToTop() throws Exception {
        EventLogger l = new EventLogger();
        EventLogger.TableSnapshot original = l.makeTableSnapshot(this.table);
        ArchitectUtils.listenToHierarchy((SQLObjectListener)l, this.table);
        this.table.changeColumnIndex(4, 0, true);
        ArchitectUtils.unlistenToHierarchy((SQLObjectListener)l, this.table);
        TestSQLTable.assertEquals((int)4, (int)this.table.getPkSize());
        TestSQLTable.assertEquals((int)0, (int)this.table.getColumnIndex(this.table.getColumnByName("five")));
        TestSQLTable.assertEquals((int)1, (int)this.table.getColumnIndex(this.table.getColumnByName("one")));
        TestSQLTable.assertEquals((int)2, (int)this.table.getColumnIndex(this.table.getColumnByName("two")));
        TestSQLTable.assertEquals((int)3, (int)this.table.getColumnIndex(this.table.getColumnByName("three")));
        TestSQLTable.assertEquals((int)4, (int)this.table.getColumnIndex(this.table.getColumnByName("four")));
        TestSQLTable.assertEquals((int)5, (int)this.table.getColumnIndex(this.table.getColumnByName("six")));
        System.out.println("Event log:\n" + l);
        EventLogger.TableSnapshot afterChange = l.makeTableSnapshot(this.table);
        System.out.println("Original: " + original);
        System.out.println("After: " + afterChange);
        l.rollBack(afterChange);
        TestSQLTable.assertEquals((String)original.toString(), (String)afterChange.toString());
    }

    public void testChangeSFifthColumnIdxToThird() throws ArchitectException {
        this.table.changeColumnIndex(4, 2, true);
        TestSQLTable.assertEquals((int)4, (int)this.table.getPkSize());
        TestSQLTable.assertEquals((int)0, (int)this.table.getColumnIndex(this.table.getColumnByName("one")));
        TestSQLTable.assertEquals((int)1, (int)this.table.getColumnIndex(this.table.getColumnByName("two")));
        TestSQLTable.assertEquals((int)2, (int)this.table.getColumnIndex(this.table.getColumnByName("five")));
        TestSQLTable.assertEquals((int)3, (int)this.table.getColumnIndex(this.table.getColumnByName("three")));
        TestSQLTable.assertEquals((int)4, (int)this.table.getColumnIndex(this.table.getColumnByName("four")));
        TestSQLTable.assertEquals((int)5, (int)this.table.getColumnIndex(this.table.getColumnByName("six")));
    }

    public void testChangeSForthColumnIdxToThird() throws ArchitectException {
        this.table.changeColumnIndex(3, 2, true);
        TestSQLTable.assertEquals((int)4, (int)this.table.getPkSize());
        TestSQLTable.assertEquals((int)0, (int)this.table.getColumnIndex(this.table.getColumnByName("one")));
        TestSQLTable.assertEquals((int)1, (int)this.table.getColumnIndex(this.table.getColumnByName("two")));
        TestSQLTable.assertEquals((int)2, (int)this.table.getColumnIndex(this.table.getColumnByName("four")));
        TestSQLTable.assertEquals((int)3, (int)this.table.getColumnIndex(this.table.getColumnByName("three")));
        TestSQLTable.assertEquals((int)4, (int)this.table.getColumnIndex(this.table.getColumnByName("five")));
        TestSQLTable.assertEquals((int)5, (int)this.table.getColumnIndex(this.table.getColumnByName("six")));
    }

    public void testChangeSThirdColumnIdxToForth() throws ArchitectException {
        this.table.changeColumnIndex(2, 3, true);
        TestSQLTable.assertEquals((int)2, (int)this.table.getPkSize());
        TestSQLTable.assertEquals((int)0, (int)this.table.getColumnIndex(this.table.getColumnByName("one")));
        TestSQLTable.assertEquals((int)1, (int)this.table.getColumnIndex(this.table.getColumnByName("two")));
        TestSQLTable.assertEquals((int)2, (int)this.table.getColumnIndex(this.table.getColumnByName("four")));
        TestSQLTable.assertEquals((int)3, (int)this.table.getColumnIndex(this.table.getColumnByName("three")));
        TestSQLTable.assertEquals((int)4, (int)this.table.getColumnIndex(this.table.getColumnByName("five")));
        TestSQLTable.assertEquals((int)5, (int)this.table.getColumnIndex(this.table.getColumnByName("six")));
    }

    public void testChangeFirstColumnKey() throws ArchitectException {
        SQLColumn col1 = this.table.getColumnByName("one");
        TestSQLTable.assertNotNull((Object)col1);
        col1.setPrimaryKeySeq(null);
        TestSQLTable.assertEquals((int)2, (int)this.table.getPkSize());
        TestSQLTable.assertTrue((this.table.getColumnIndex(col1) > 1 ? 1 : 0) != 0);
    }

    public void testChangeThirdColumnKey() throws ArchitectException {
        SQLColumn col3 = this.table.getColumnByName("three");
        TestSQLTable.assertNotNull((Object)col3);
        col3.setPrimaryKeySeq(null);
        TestSQLTable.assertEquals((int)2, (int)this.table.getPkSize());
        TestSQLTable.assertEquals((int)0, (int)this.table.getColumnIndex(this.table.getColumnByName("one")));
        TestSQLTable.assertEquals((int)1, (int)this.table.getColumnIndex(this.table.getColumnByName("two")));
        TestSQLTable.assertEquals((int)2, (int)this.table.getColumnIndex(this.table.getColumnByName("three")));
        TestSQLTable.assertEquals((int)3, (int)this.table.getColumnIndex(this.table.getColumnByName("four")));
        TestSQLTable.assertEquals((int)4, (int)this.table.getColumnIndex(this.table.getColumnByName("five")));
        TestSQLTable.assertEquals((int)5, (int)this.table.getColumnIndex(this.table.getColumnByName("six")));
    }

    public void testChangeForthColumnKey() throws ArchitectException {
        SQLColumn col4 = this.table.getColumnByName("four");
        TestSQLTable.assertNotNull((Object)col4);
        col4.setPrimaryKeySeq(0);
        TestSQLTable.assertEquals((int)4, (int)this.table.getPkSize());
        TestSQLTable.assertEquals((int)0, (int)this.table.getColumnIndex(this.table.getColumnByName("one")));
        TestSQLTable.assertEquals((int)1, (int)this.table.getColumnIndex(this.table.getColumnByName("four")));
        TestSQLTable.assertEquals((int)2, (int)this.table.getColumnIndex(this.table.getColumnByName("two")));
        TestSQLTable.assertEquals((int)3, (int)this.table.getColumnIndex(this.table.getColumnByName("three")));
        TestSQLTable.assertEquals((int)4, (int)this.table.getColumnIndex(this.table.getColumnByName("five")));
        TestSQLTable.assertEquals((int)5, (int)this.table.getColumnIndex(this.table.getColumnByName("six")));
    }

    public void testChangeFifthColumnKey() throws Exception {
        EventLogger l = new EventLogger();
        SQLColumn col5 = this.table.getColumnByName("five");
        TestSQLTable.assertNotNull((Object)col5);
        EventLogger.TableSnapshot original = l.makeTableSnapshot(this.table);
        ArchitectUtils.listenToHierarchy((SQLObjectListener)l, this.table);
        col5.setPrimaryKeySeq(0);
        ArchitectUtils.unlistenToHierarchy((SQLObjectListener)l, this.table);
        System.out.println("Event log:\n" + l);
        EventLogger.TableSnapshot afterChange = l.makeTableSnapshot(this.table);
        TestSQLTable.assertEquals((int)4, (int)this.table.getPkSize());
        TestSQLTable.assertEquals((int)0, (int)this.table.getColumnIndex(this.table.getColumnByName("one")));
        TestSQLTable.assertEquals((int)1, (int)this.table.getColumnIndex(this.table.getColumnByName("five")));
        TestSQLTable.assertEquals((int)2, (int)this.table.getColumnIndex(this.table.getColumnByName("two")));
        TestSQLTable.assertEquals((int)3, (int)this.table.getColumnIndex(this.table.getColumnByName("three")));
        TestSQLTable.assertEquals((int)4, (int)this.table.getColumnIndex(this.table.getColumnByName("four")));
        TestSQLTable.assertEquals((int)5, (int)this.table.getColumnIndex(this.table.getColumnByName("six")));
        System.out.println("Original: " + original);
        System.out.println("After: " + afterChange);
        l.rollBack(afterChange);
        TestSQLTable.assertEquals((String)original.toString(), (String)afterChange.toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EventLogger
    implements SQLObjectListener,
    UndoCompoundEventListener {
        private List<LogItem> log = new ArrayList<LogItem>();
        private static final String[] SECONDARY_COLUMN_PROPS = new String[]{"definitelyNullable", "primaryKey"};

        private void addToLog(LogItemType type, SQLObjectEvent e) {
            if (e == null) {
                throw new NullPointerException("Can't add null events, dude");
            }
            this.log.add(new LogItem(type, e));
        }

        @Override
        public void dbChildrenInserted(SQLObjectEvent e) {
            this.addToLog(LogItemType.INSERT, e);
        }

        @Override
        public void dbChildrenRemoved(SQLObjectEvent e) {
            this.addToLog(LogItemType.REMOVE, e);
        }

        @Override
        public void dbObjectChanged(SQLObjectEvent e) {
            this.addToLog(LogItemType.CHANGE, e);
        }

        @Override
        public void dbStructureChanged(SQLObjectEvent e) {
            throw new UnsupportedOperationException("Structure changes are not undoable");
        }

        @Override
        public void compoundEditStart(UndoCompoundEvent e) {
        }

        @Override
        public void compoundEditEnd(UndoCompoundEvent e) {
        }

        public TableSnapshot makeTableSnapshot(SQLTable t) throws Exception {
            return new TableSnapshot(t);
        }

        private static Map<String, Object> createColumnSnapshot(SQLColumn c) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
            TreeMap<String, Object> props = new TreeMap<String, Object>(BeanUtils.describe((Object)c));
            props.keySet().removeAll((Collection)Arrays.asList(SECONDARY_COLUMN_PROPS));
            return props;
        }

        public void rollForward(TableSnapshot snapshot) throws Exception {
            for (LogItem li : this.log) {
                int i;
                LogItemType type = li.getType();
                SQLObjectEvent e = li.getEvent();
                if (type == LogItemType.INSERT) {
                    i = 0;
                    while (i < e.getChangedIndices().length) {
                        snapshot.insertColumn(e.getChangedIndices()[i], (SQLColumn)e.getChildren()[i]);
                        ++i;
                    }
                    continue;
                }
                if (type == LogItemType.REMOVE) {
                    i = 0;
                    while (i < e.getChangedIndices().length) {
                        snapshot.removeColumn(e.getChangedIndices()[i], e.getChildren()[i]);
                        ++i;
                    }
                    continue;
                }
                if (type == LogItemType.CHANGE) {
                    snapshot.applyChange(e);
                    continue;
                }
                if (type == LogItemType.STRUCTURE_CHANGE) {
                    throw new UnsupportedOperationException("Structure changes are not undoable");
                }
                throw new UnsupportedOperationException("Unknown log item type " + (Object)((Object)type));
            }
        }

        public void rollBack(TableSnapshot snapshot) throws Exception {
            ArrayList<LogItem> revlog = new ArrayList<LogItem>(this.log);
            Collections.reverse(revlog);
            for (LogItem li : revlog) {
                int i;
                LogItemType type = li.getType();
                SQLObjectEvent e = li.getEvent();
                System.out.println("Rolling back: " + li);
                if (type == LogItemType.INSERT) {
                    i = 0;
                    while (i < e.getChangedIndices().length) {
                        snapshot.removeColumn(e.getChangedIndices()[i], e.getChildren()[i]);
                        ++i;
                    }
                    continue;
                }
                if (type == LogItemType.REMOVE) {
                    i = 0;
                    while (i < e.getChangedIndices().length) {
                        snapshot.insertColumn(e.getChangedIndices()[i], (SQLColumn)e.getChildren()[i]);
                        ++i;
                    }
                    continue;
                }
                if (type == LogItemType.CHANGE) {
                    snapshot.revertChange(e);
                    continue;
                }
                if (type == LogItemType.STRUCTURE_CHANGE) {
                    throw new UnsupportedOperationException("Structure changes are not undoable");
                }
                throw new UnsupportedOperationException("Unknown log item type " + (Object)((Object)type));
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            for (LogItem li : this.log) {
                sb.append((Object)li.getType()).append(": ").append(li.getEvent()).append("\n");
            }
            return sb.toString();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum LogItemType {
            INSERT,
            REMOVE,
            CHANGE,
            STRUCTURE_CHANGE;

        }

        private static class LogItem {
            private LogItemType type;
            private SQLObjectEvent event;

            public LogItem(LogItemType type, SQLObjectEvent event) {
                this.type = type;
                this.event = event;
            }

            public LogItemType getType() {
                return this.type;
            }

            public SQLObjectEvent getEvent() {
                return this.event;
            }

            public String toString() {
                return (Object)((Object)this.type) + ": " + this.event;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class TableSnapshot {
            private List<Map<String, Object>> snapshot = new ArrayList<Map<String, Object>>();

            public TableSnapshot(SQLTable t) throws Exception {
                for (SQLColumn c : t.getColumns()) {
                    this.snapshot.add(EventLogger.createColumnSnapshot(c));
                }
            }

            public boolean equals(Object obj) {
                return this.snapshot.equals(((TableSnapshot)obj).snapshot);
            }

            public int hashCode() {
                return this.snapshot.hashCode();
            }

            public List<Map<String, Object>> listValue() {
                return this.snapshot;
            }

            public void applyChange(SQLObjectEvent e) {
                if (e.getPropertyName() == null) {
                    System.out.println("error: this is not a property change event (no property name)");
                    return;
                }
                Map<String, Object> colprops = this.findColByName(e.getSQLSource().getName());
                if (colprops == null) {
                    System.out.println("can't apply change: no such column in snapshot: '" + e.getSQLSource().getName() + "'" + " (property '" + e.getPropertyName() + "' change '" + e.getOldValue() + "' -> '" + e.getNewValue() + "')");
                    return;
                }
                if (!colprops.containsKey(e.getPropertyName())) {
                    System.out.println("error: no such property '" + e.getPropertyName() + "' for column '" + e.getSQLSource().getName() + "'");
                    return;
                }
                colprops.put(e.getPropertyName(), e.getNewValue());
            }

            public void revertChange(SQLObjectEvent e) {
                if (e.getPropertyName() == null) {
                    System.out.println("error: this is not a property change event (no property name)");
                    return;
                }
                Map<String, Object> colprops = this.findColByName(e.getSQLSource().getName());
                if (colprops == null) {
                    System.out.println("can't revert change: no such column in snapshot: '" + e.getSQLSource().getName() + "'" + " (property '" + e.getPropertyName() + "' change '" + e.getNewValue() + "' -> '" + e.getOldValue() + "')");
                    return;
                }
                if (!colprops.containsKey(e.getPropertyName())) {
                    System.out.println("error: no such property '" + e.getPropertyName() + "' for column '" + e.getSQLSource().getName() + "'");
                    return;
                }
                System.out.println("revertChange: putting '" + e.getPropertyName() + "' = '" + e.getOldValue() + "'");
                colprops.put(e.getPropertyName(), e.getOldValue());
            }

            private Map<String, Object> findColByName(String name) {
                for (Map<String, Object> colprops : this.snapshot) {
                    if (!colprops.get("name").equals(name)) continue;
                    return colprops;
                }
                return null;
            }

            public String toString() {
                StringBuffer sb = new StringBuffer();
                for (Map<String, Object> colprops : this.snapshot) {
                    sb.append("  ").append(colprops.get("name")).append(": ");
                    sb.append(colprops);
                    sb.append("\n");
                }
                return sb.toString();
            }

            public void insertColumn(int index, SQLColumn object) throws Exception {
                this.snapshot.add(index, EventLogger.createColumnSnapshot(object));
            }

            public void removeColumn(int index, SQLObject object) {
                if (!object.getName().equals(this.snapshot.get(index).get("name"))) {
                    throw new IllegalStateException("Got a removeColumn for actual object '" + object.getName() + "', but corresponding snapshot name was '" + this.snapshot.get(index).get("name") + "'");
                }
                this.snapshot.remove(index);
            }
        }
    }
}

