/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.SQLDatabase;
import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.SQLObjectEvent;
import ca.sqlpower.architect.SQLObjectListener;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.SQLTestCase;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.commons.beanutils.BeanUtils;

public class TestSQLColumn
extends SQLTestCase {
    private SQLTable table1pk;
    private SQLTable table0pk;
    private SQLTable table3pk;

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(TestSQLColumn.class);
        TestSetup wrapper = new TestSetup((Test)suite){

            protected void setUp() throws Exception {
                TestSQLColumn.oneTimeSetUp();
            }

            protected void tearDown() throws Exception {
                TestSQLColumn.oneTimeTearDown();
            }
        };
        return wrapper;
    }

    public static void oneTimeSetUp() throws Exception {
        System.out.println("TestSQLColumn.oneTimeSetUp()");
        SQLDatabase mydb = new SQLDatabase(TestSQLColumn.getDataSource());
        Connection con = null;
        Statement stmt = null;
        try {
            con = mydb.getConnection();
            stmt = con.createStatement();
            TestSQLColumn.dropTableNoFail(con, "SQL_COLUMN_TEST_1PK");
            TestSQLColumn.dropTableNoFail(con, "SQL_COLUMN_TEST_3PK");
            TestSQLColumn.dropTableNoFail(con, "SQL_COLUMN_TEST_0PK");
            stmt.executeUpdate("CREATE TABLE SQL_COLUMN_TEST_1PK (\n cow numeric(11) CONSTRAINT test1pk PRIMARY KEY,\n moo varchar(10),\n foo char(10))");
            stmt.executeUpdate("CREATE TABLE SQL_COLUMN_TEST_3PK (\n cow numeric(11) NOT NULL,\n moo varchar(10) NOT NULL,\n foo char(10) NOT NULL,\n CONSTRAINT test3pk PRIMARY KEY (cow, moo, foo))");
            stmt.executeUpdate("CREATE TABLE SQL_COLUMN_TEST_0PK (\n cow numeric(11),\n moo varchar(10),\n foo char(10))");
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException ex) {
                System.out.println("Couldn't close statement");
                ex.printStackTrace();
            }
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException ex) {
                System.out.println("Couldn't close connection");
                ex.printStackTrace();
            }
        }
    }

    public static void oneTimeTearDown() {
        System.out.println("TestSQLColumn.oneTimeTearDown()");
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.table1pk = this.db.getTableByName("SQL_COLUMN_TEST_1PK");
        this.table0pk = this.db.getTableByName("SQL_COLUMN_TEST_0PK");
        this.table3pk = this.db.getTableByName("SQL_COLUMN_TEST_3PK");
    }

    private static void dropTableNoFail(Connection con, String tableName) throws SQLException {
        Statement stmt = null;
        try {
            try {
                stmt = con.createStatement();
                stmt.executeUpdate("DROP TABLE " + tableName);
            }
            catch (SQLException e) {
                System.out.println("Ignoring SQLException.  Assume " + tableName + " didn't exist.");
                e.printStackTrace();
            }
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    protected SQLObject getSQLObjectUnderTest() throws ArchitectException {
        return this.table1pk.getColumn(0);
    }

    public TestSQLColumn(String name) throws Exception {
        super(name);
    }

    public void testPopulateTable() throws ArchitectException {
        TestSQLColumn.assertEquals((String)"Table should have 4 folders as children", (int)4, (int)this.table1pk.getChildCount());
        TestSQLColumn.assertFalse((String)"Table columns should not have been populated already", (boolean)this.table1pk.getColumnsFolder().isPopulated());
        this.table1pk.getColumnsFolder().populate();
        TestSQLColumn.assertTrue((String)"Table columns should be populated", (boolean)this.table1pk.getColumnsFolder().isPopulated());
        TestSQLColumn.assertNotNull((String)"cow column not found", (Object)this.table1pk.getColumnByName("cow"));
        TestSQLColumn.assertNotNull((String)"moo column not found", (Object)this.table1pk.getColumnByName("moo"));
        TestSQLColumn.assertNotNull((String)"foo column not found", (Object)this.table1pk.getColumnByName("foo"));
    }

    public void testColumnOwnership() throws Exception {
        SQLColumn cowCol = this.table1pk.getColumnByName("cow");
        SQLColumn mooCol = this.table1pk.getColumnByName("moo");
        SQLColumn fooCol = this.table1pk.getColumnByName("foo");
        TestSQLColumn.assertEquals((String)"column doesn't belong to correct parent!", (Object)this.table1pk, (Object)cowCol.getParentTable());
        TestSQLColumn.assertEquals((String)"column doesn't belong to correct parent!", (Object)this.table1pk, (Object)mooCol.getParentTable());
        TestSQLColumn.assertEquals((String)"column doesn't belong to correct parent!", (Object)this.table1pk, (Object)fooCol.getParentTable());
    }

    public void testReferenceCountFiresEvents() {
        SQLColumn col = new SQLColumn();
        TestSQLObjectListener testListener = new TestSQLObjectListener();
        col.addSQLObjectListener(testListener);
        TestSQLColumn.assertEquals((String)"Strange the test listener has recieved events", (int)testListener.getChangedCount(), (int)0);
        col.addReference();
        TestSQLColumn.assertEquals((String)"Incorrect number of change events!", (int)testListener.getChangedCount(), (int)1);
        col.removeReference();
        TestSQLColumn.assertEquals((String)"Incorrect number of change events!", (int)testListener.getChangedCount(), (int)2);
    }

    public void testPKAttributes() throws Exception {
        SQLColumn cowCol = this.table1pk.getColumnByName("cow");
        SQLColumn fooCol = this.table1pk.getColumnByName("foo");
        TestSQLColumn.assertTrue((String)"table1pk.cow should have been flagged as PK", (boolean)cowCol.isPrimaryKey());
        TestSQLColumn.assertEquals((String)"table1pk.cow nullability incorrect", (int)cowCol.getNullable(), (int)0);
        TestSQLColumn.assertFalse((String)"table1pk.cow isDefinitelyNullable incorrect", (boolean)cowCol.isDefinitelyNullable());
        TestSQLColumn.assertFalse((String)"table1pk.foo should NOT have been flagged as PK", (boolean)fooCol.isPrimaryKey());
        TestSQLColumn.assertEquals((String)"table1pk.foo nullability incorrect", (int)fooCol.getNullable(), (int)1);
        TestSQLColumn.assertTrue((String)"table1pk.foo isDefinitelyNullable incorrect", (boolean)fooCol.isDefinitelyNullable());
    }

    public void testCompareTo() throws Exception {
        SQLColumn cowCol = this.table1pk.getColumnByName("cow");
        SQLColumn mooCol = this.table1pk.getColumnByName("moo");
        SQLColumn fooCol = this.table1pk.getColumnByName("foo");
        SQLColumn.ColumnNameComparator nameComp = new SQLColumn.ColumnNameComparator();
        TestSQLColumn.assertTrue((nameComp.compare(cowCol, mooCol) < 0 ? 1 : 0) != 0);
        TestSQLColumn.assertTrue((nameComp.compare(mooCol, fooCol) > 0 ? 1 : 0) != 0);
        TestSQLColumn.assertTrue((nameComp.compare(fooCol, cowCol) > 0 ? 1 : 0) != 0);
        TestSQLColumn.assertTrue((nameComp.compare(cowCol, fooCol) < 0 ? 1 : 0) != 0);
        TestSQLColumn.assertTrue((nameComp.compare(cowCol, cowCol) == 0 ? 1 : 0) != 0);
        cowCol.setName(mooCol.getName());
        TestSQLColumn.assertTrue((nameComp.compare(cowCol, mooCol) == 0 ? 1 : 0) != 0);
    }

    public void testNoArgConstructor() throws Exception {
        SQLColumn col = new SQLColumn();
        TestSQLColumn.assertEquals((String)"Reference count init", (int)1, (int)col.getReferenceCount());
        TestSQLColumn.assertEquals((int)0, (int)col.getChildCount());
    }

    public void testSmallConstructor() throws Exception {
        SQLColumn col = new SQLColumn(this.table0pk, "test_column", 4, 10, 30);
        TestSQLColumn.assertEquals((Object)this.table0pk, (Object)col.getParentTable());
        TestSQLColumn.assertEquals((String)"test_column", (String)col.getName());
        TestSQLColumn.assertEquals((int)4, (int)col.getType());
        TestSQLColumn.assertEquals((int)10, (int)col.getPrecision());
        TestSQLColumn.assertEquals((int)30, (int)col.getScale());
        TestSQLColumn.assertEquals((int)1, (int)col.getReferenceCount());
        TestSQLColumn.assertEquals((int)0, (int)col.getChildCount());
    }

    public void testMegaConstructor() throws Exception {
        SQLColumn col = new SQLColumn(this.table0pk, "test_column_2", 4, "my_test_integer", 44, 33, 1, "test remarks", "test default", null, true);
        TestSQLColumn.assertEquals((Object)this.table0pk, (Object)col.getParentTable());
        TestSQLColumn.assertEquals((String)"test_column_2", (String)col.getName());
        TestSQLColumn.assertEquals((int)4, (int)col.getType());
        TestSQLColumn.assertEquals((String)"my_test_integer", (String)col.getSourceDataTypeName());
        TestSQLColumn.assertEquals((int)44, (int)col.getPrecision());
        TestSQLColumn.assertEquals((int)33, (int)col.getScale());
        TestSQLColumn.assertEquals((int)1, (int)col.getNullable());
        TestSQLColumn.assertEquals((String)"test remarks", (String)col.getRemarks());
        TestSQLColumn.assertEquals((String)"test default", (String)col.getDefaultValue());
        TestSQLColumn.assertEquals(null, (Object)col.getPrimaryKeySeq());
        TestSQLColumn.assertTrue((boolean)col.isAutoIncrement());
        TestSQLColumn.assertEquals((int)1, (int)col.getReferenceCount());
        TestSQLColumn.assertEquals((int)0, (int)col.getChildCount());
    }

    public void testGetDerivedInstance() throws Exception {
        SQLColumn origCol = this.table1pk.getColumn(0);
        SQLColumn derivCol = SQLColumn.getDerivedInstance(origCol, this.table3pk);
        TestSQLColumn.assertEquals((Object)this.table3pk, (Object)derivCol.getParentTable());
        TestSQLColumn.assertEquals((Object)origCol, (Object)derivCol.getSourceColumn());
        TestSQLColumn.assertEquals((String)"NUMBER", (String)derivCol.getSourceDataTypeName());
        Map origProps = BeanUtils.describe((Object)origCol);
        Map derivProps = BeanUtils.describe((Object)derivCol);
        derivProps.remove("parentTable");
        derivProps.remove("parent");
        derivProps.remove("sourceColumn");
        derivProps.remove("sourceDataTypeName");
        origProps.remove("parentTable");
        origProps.remove("parent");
        origProps.remove("sourceColumn");
        origProps.remove("sourceDataTypeName");
        TestSQLColumn.assertEquals((String)"Derived instance properties differ from original", (String)origProps.toString(), (String)derivProps.toString());
    }

    public void testGetName() throws Exception {
        SQLColumn tmpCol = new SQLColumn();
        tmpCol.setName("cow");
        TestSQLColumn.assertEquals((String)tmpCol.getName(), (String)"cow");
        SQLColumn cowCol = this.table0pk.getColumnByName("COW");
        TestSQLColumn.assertEquals((String)cowCol.getName(), (String)"COW");
        SQLColumn mooCol = this.table0pk.getColumn(1);
        TestSQLColumn.assertEquals((String)mooCol.getName(), (String)"MOO");
    }

    public void testGetPhysicalName() throws Exception {
        SQLColumn tmpCol = new SQLColumn();
        tmpCol.setPhysicalName("cow");
        TestSQLColumn.assertEquals((String)tmpCol.getPhysicalName(), (String)"cow");
    }

    public void testGetParent() throws ArchitectException {
        SQLColumn tmpCol = new SQLColumn();
        TestSQLColumn.assertEquals((Object)tmpCol.getParent(), null);
        this.table0pk.addColumn(tmpCol);
        TestSQLColumn.assertEquals(this.table0pk.getColumnsFolder(), (Object)tmpCol.getParent());
    }

    public void testPopulate() throws Exception {
        SQLColumn tmpCol = new SQLColumn();
        TestSQLColumn.assertEquals((boolean)true, (boolean)tmpCol.isPopulated());
        tmpCol.populate();
        TestSQLColumn.assertEquals((boolean)true, (boolean)tmpCol.isPopulated());
        SQLColumn cowCol = this.table1pk.getColumn(0);
        TestSQLColumn.assertEquals((boolean)true, (boolean)cowCol.isPopulated());
        cowCol.populate();
        TestSQLColumn.assertEquals((boolean)true, (boolean)cowCol.isPopulated());
    }

    public void testGetShortDisplayName() throws Exception {
        SQLColumn cowCol = this.table1pk.getColumn(0);
        int idx = cowCol.getShortDisplayName().indexOf("COW");
        TestSQLColumn.assertFalse((idx < 0 ? 1 : 0) != 0);
    }

    public void testAllowsChildren() throws Exception {
        SQLColumn tmpCol = new SQLColumn();
        TestSQLColumn.assertEquals((boolean)false, (boolean)tmpCol.allowsChildren());
        SQLColumn cowCol = this.table1pk.getColumn(0);
        TestSQLColumn.assertEquals((boolean)false, (boolean)cowCol.allowsChildren());
    }

    public void testAddColumnsToTable() throws Exception {
        SQLColumn mooCol = this.table3pk.getColumn(1);
        TestSQLColumn.assertEquals((Object)mooCol.getParentTable(), (Object)this.table3pk);
        TestSQLColumn.assertEquals((int)mooCol.getChildCount(), (int)0);
        TestSQLColumn.assertEquals((String)mooCol.getName(), (String)"MOO");
        TestSQLColumn.assertEquals((int)mooCol.getScale(), (int)0);
        TestSQLColumn.assertEquals((int)mooCol.getPrecision(), (int)10);
        TestSQLColumn.assertEquals((int)mooCol.getType(), (int)12);
        TestSQLColumn.assertEquals((String)mooCol.getSourceDataTypeName(), (String)"VARCHAR2");
        TestSQLColumn.assertEquals((String)mooCol.getRemarks(), (String)"");
        TestSQLColumn.assertEquals((String)mooCol.getDefaultValue(), null);
        TestSQLColumn.assertEquals((boolean)mooCol.isPrimaryKey(), (boolean)true);
        TestSQLColumn.assertEquals((boolean)mooCol.isDefinitelyNullable(), (boolean)false);
    }

    public void testToString() throws Exception {
        SQLColumn cowCol = this.table1pk.getColumn(0);
        int idx = cowCol.getShortDisplayName().indexOf("COW");
        TestSQLColumn.assertFalse((idx < 0 ? 1 : 0) != 0);
    }

    public void testGetSourceColumn() throws Exception {
        SQLColumn tmpCol = new SQLColumn();
        TestSQLColumn.assertNull((Object)tmpCol.getSourceColumn());
        SQLColumn cowCol = this.table1pk.getColumn(0);
        TestSQLColumn.assertNull((Object)cowCol.getSourceColumn());
        tmpCol = SQLColumn.getDerivedInstance(cowCol, this.table3pk);
        TestSQLColumn.assertEquals((Object)this.table3pk, (Object)tmpCol.getParentTable());
        TestSQLColumn.assertEquals((Object)cowCol, (Object)tmpCol.getSourceColumn());
        tmpCol = SQLColumn.getDerivedInstance(new SQLColumn(), this.table3pk);
        TestSQLColumn.assertNotNull((Object)tmpCol.getSourceColumn());
    }

    public void testSetSourceColumn() throws Exception {
        SQLColumn tmpCol = new SQLColumn();
        TestSQLColumn.assertNull((Object)tmpCol.getSourceColumn());
        SQLColumn cowCol = this.table1pk.getColumn(0);
        TestSQLColumn.assertNull((Object)cowCol.getSourceColumn());
        tmpCol.setSourceColumn(cowCol);
        TestSQLColumn.assertEquals((Object)cowCol, (Object)tmpCol.getSourceColumn());
    }

    public void testGetType() throws Exception {
        SQLColumn tmpCol = new SQLColumn();
        TestSQLColumn.assertEquals((int)4, (int)tmpCol.getType());
        tmpCol.setType(1);
        TestSQLColumn.assertEquals((int)1, (int)tmpCol.getType());
        SQLColumn cowCol = this.table1pk.getColumn(0);
        TestSQLColumn.assertEquals((int)3, (int)cowCol.getType());
        cowCol.setType(1);
        TestSQLColumn.assertEquals((int)1, (int)cowCol.getType());
    }

    public void testGetSourceDataTypeName() throws Exception {
        SQLColumn tmpCol = new SQLColumn();
        TestSQLColumn.assertEquals(null, (String)tmpCol.getSourceDataTypeName());
        tmpCol.setSourceDataTypeName("xxx");
        TestSQLColumn.assertEquals((String)"xxx", (String)tmpCol.getSourceDataTypeName());
        SQLColumn cowCol = this.table1pk.getColumn(0);
        TestSQLColumn.assertEquals((String)"NUMBER", (String)cowCol.getSourceDataTypeName());
        cowCol.setSourceDataTypeName("yyy");
        TestSQLColumn.assertEquals((String)"yyy", (String)cowCol.getSourceDataTypeName());
    }

    public void testGetScale() throws Exception {
        SQLColumn tmpCol = new SQLColumn();
        TestSQLColumn.assertEquals((int)0, (int)tmpCol.getScale());
        tmpCol.setScale(123);
        TestSQLColumn.assertEquals((int)123, (int)tmpCol.getScale());
        SQLColumn cowCol = this.table1pk.getColumn(0);
        TestSQLColumn.assertEquals((int)0, (int)cowCol.getScale());
        cowCol.setScale(321);
        TestSQLColumn.assertEquals((int)321, (int)cowCol.getScale());
    }

    public void testGetPrecision() throws Exception {
        SQLColumn tmpCol = new SQLColumn();
        TestSQLColumn.assertEquals((int)10, (int)tmpCol.getPrecision());
        tmpCol.setPrecision(123);
        TestSQLColumn.assertEquals((int)123, (int)tmpCol.getPrecision());
        SQLColumn cowCol = this.table1pk.getColumn(0);
        TestSQLColumn.assertEquals((int)11, (int)cowCol.getPrecision());
        cowCol.setPrecision(321);
        TestSQLColumn.assertEquals((int)321, (int)cowCol.getPrecision());
    }

    public void testIsDefinitelyNullable() throws Exception {
        SQLColumn tmpCol = new SQLColumn();
        TestSQLColumn.assertEquals((boolean)false, (boolean)tmpCol.isDefinitelyNullable());
        tmpCol.setNullable(1);
        TestSQLColumn.assertEquals((boolean)true, (boolean)tmpCol.isDefinitelyNullable());
        tmpCol.setNullable(0);
        TestSQLColumn.assertEquals((boolean)false, (boolean)tmpCol.isDefinitelyNullable());
        tmpCol.setNullable(2);
        TestSQLColumn.assertEquals((boolean)false, (boolean)tmpCol.isDefinitelyNullable());
        SQLColumn cowCol = this.table1pk.getColumn(0);
        TestSQLColumn.assertEquals((boolean)false, (boolean)cowCol.isDefinitelyNullable());
        cowCol.setNullable(1);
        TestSQLColumn.assertEquals((boolean)true, (boolean)cowCol.isDefinitelyNullable());
        cowCol.setNullable(0);
        TestSQLColumn.assertEquals((boolean)false, (boolean)cowCol.isDefinitelyNullable());
        cowCol.setNullable(2);
        TestSQLColumn.assertEquals((boolean)false, (boolean)cowCol.isDefinitelyNullable());
    }

    public void testIsPrimaryKey() throws Exception {
        SQLColumn tmpCol = new SQLColumn();
        TestSQLColumn.assertEquals((boolean)false, (boolean)tmpCol.isPrimaryKey());
        tmpCol.setPrimaryKeySeq(new Integer(1));
        TestSQLColumn.assertEquals((boolean)true, (boolean)tmpCol.isPrimaryKey());
        tmpCol.setPrimaryKeySeq(null);
        TestSQLColumn.assertEquals((boolean)false, (boolean)tmpCol.isPrimaryKey());
        SQLColumn cowCol = this.table3pk.getColumn(0);
        TestSQLColumn.assertEquals((boolean)true, (boolean)cowCol.isPrimaryKey());
        cowCol.setPrimaryKeySeq(new Integer(2));
        TestSQLColumn.assertEquals((boolean)true, (boolean)cowCol.isPrimaryKey());
        cowCol.setPrimaryKeySeq(null);
        TestSQLColumn.assertEquals((boolean)false, (boolean)cowCol.isPrimaryKey());
    }

    public void testGetParentTable() throws Exception {
        SQLColumn tmpCol = new SQLColumn();
        TestSQLColumn.assertEquals(null, (Object)tmpCol.getParentTable());
        this.table0pk.addColumn(tmpCol);
        TestSQLColumn.assertEquals((Object)this.table0pk, (Object)tmpCol.getParentTable());
        this.table0pk.removeColumn(tmpCol);
        TestSQLColumn.assertEquals(null, (Object)tmpCol.getParentTable());
        SQLColumn cowCol = this.table3pk.getColumn(0);
        TestSQLColumn.assertEquals((Object)this.table3pk, (Object)cowCol.getParentTable());
        this.table3pk.removeColumn(cowCol);
        TestSQLColumn.assertEquals(null, (Object)cowCol.getParentTable());
        this.table0pk.addColumn(cowCol);
        TestSQLColumn.assertEquals((Object)this.table0pk, (Object)cowCol.getParentTable());
        this.table0pk.removeColumn(cowCol);
        TestSQLColumn.assertEquals(null, (Object)cowCol.getParentTable());
    }

    public void testGetNullable() throws Exception {
        SQLColumn tmpCol = new SQLColumn();
        TestSQLColumn.assertEquals((int)0, (int)tmpCol.getNullable());
        tmpCol.setNullable(1);
        TestSQLColumn.assertEquals((int)1, (int)tmpCol.getNullable());
        tmpCol.setNullable(2);
        TestSQLColumn.assertEquals((int)2, (int)tmpCol.getNullable());
        tmpCol.setNullable(0);
        TestSQLColumn.assertEquals((int)0, (int)tmpCol.getNullable());
        SQLColumn cowCol = this.table1pk.getColumn(0);
        TestSQLColumn.assertEquals((int)0, (int)cowCol.getNullable());
        cowCol.setNullable(1);
        TestSQLColumn.assertEquals((int)1, (int)cowCol.getNullable());
        cowCol.setNullable(2);
        TestSQLColumn.assertEquals((int)2, (int)cowCol.getNullable());
        cowCol.setNullable(0);
        TestSQLColumn.assertEquals((int)0, (int)cowCol.getNullable());
    }

    public void testGetRemarks() throws Exception {
        SQLColumn tmpCol = new SQLColumn();
        TestSQLColumn.assertEquals((String)"", (String)tmpCol.getRemarks());
        tmpCol.setRemarks("xxx");
        TestSQLColumn.assertEquals((String)"xxx", (String)tmpCol.getRemarks());
        SQLColumn cowCol = this.table1pk.getColumn(0);
        TestSQLColumn.assertEquals((String)"", (String)cowCol.getRemarks());
        cowCol.setRemarks("yyy");
        TestSQLColumn.assertEquals((String)"yyy", (String)cowCol.getRemarks());
    }

    public void testGetDefaultValue() throws Exception {
        SQLColumn tmpCol = new SQLColumn();
        TestSQLColumn.assertEquals(null, (String)tmpCol.getDefaultValue());
        tmpCol.setDefaultValue("xxx");
        TestSQLColumn.assertEquals((String)"xxx", (String)tmpCol.getDefaultValue());
        SQLColumn cowCol = this.table1pk.getColumn(0);
        TestSQLColumn.assertEquals(null, (String)cowCol.getDefaultValue());
        cowCol.setDefaultValue("yyy");
        TestSQLColumn.assertEquals((String)"yyy", (String)cowCol.getDefaultValue());
    }

    public void testGetPrimaryKeySeq() throws Exception {
        SQLColumn tmpCol = new SQLColumn();
        TestSQLColumn.assertEquals(null, (Object)tmpCol.getPrimaryKeySeq());
        tmpCol.setPrimaryKeySeq(new Integer(2));
        TestSQLColumn.assertEquals((Object)new Integer(2), (Object)tmpCol.getPrimaryKeySeq());
        SQLColumn cowCol = this.table1pk.getColumn(0);
        TestSQLColumn.assertEquals((Object)0, (Object)cowCol.getPrimaryKeySeq());
        cowCol.setPrimaryKeySeq(new Integer(20));
        TestSQLColumn.assertEquals((Object)new Integer(0), (Object)cowCol.getPrimaryKeySeq());
        this.table1pk.addColumn(tmpCol);
        tmpCol.setPrimaryKeySeq(new Integer(cowCol.getPrimaryKeySeq() - 1));
        TestSQLColumn.assertEquals((Object)new Integer(1), (Object)cowCol.getPrimaryKeySeq());
    }

    public void testIsAutoIncrement() throws Exception {
        SQLColumn tmpCol = new SQLColumn();
        TestSQLColumn.assertEquals((boolean)false, (boolean)tmpCol.isAutoIncrement());
        tmpCol.setAutoIncrement(true);
        TestSQLColumn.assertEquals((boolean)true, (boolean)tmpCol.isAutoIncrement());
        tmpCol.setAutoIncrement(false);
        TestSQLColumn.assertEquals((boolean)false, (boolean)tmpCol.isAutoIncrement());
        SQLColumn cowCol = this.table1pk.getColumn(0);
        TestSQLColumn.assertEquals((boolean)false, (boolean)cowCol.isAutoIncrement());
        cowCol.setAutoIncrement(true);
        TestSQLColumn.assertEquals((boolean)true, (boolean)cowCol.isAutoIncrement());
        cowCol.setAutoIncrement(false);
        TestSQLColumn.assertEquals((boolean)false, (boolean)cowCol.isAutoIncrement());
    }

    public void testCopyConstructor() throws Exception {
        SQLColumn cowCol = this.table1pk.getColumn(0);
        SQLColumn tmpCol = new SQLColumn(cowCol);
        HashSet<String> propsToIgnore = new HashSet<String>();
        propsToIgnore.add("parentTable");
        propsToIgnore.add("parent");
        Map origProps = BeanUtils.describe((Object)cowCol);
        Map derivProps = BeanUtils.describe((Object)tmpCol);
        origProps.keySet().removeAll(propsToIgnore);
        derivProps.keySet().removeAll(propsToIgnore);
        TestSQLColumn.assertEquals((String)"clone column properties differ from original", (String)origProps.toString(), (String)derivProps.toString());
    }

    public void testAddReference() throws Exception {
        int count = 1;
        SQLColumn tmpCol = new SQLColumn();
        TestSQLColumn.assertEquals((int)count, (int)tmpCol.getReferenceCount());
        tmpCol.addReference();
        TestSQLColumn.assertEquals((int)(++count), (int)tmpCol.getReferenceCount());
        tmpCol.addReference();
        TestSQLColumn.assertEquals((int)(++count), (int)tmpCol.getReferenceCount());
        tmpCol.removeReference();
        TestSQLColumn.assertEquals((int)(--count), (int)tmpCol.getReferenceCount());
        SQLColumn cowCol = this.table1pk.getColumn(0);
        count = 1;
        TestSQLColumn.assertEquals((int)count, (int)cowCol.getReferenceCount());
        cowCol.addReference();
        TestSQLColumn.assertEquals((int)(++count), (int)cowCol.getReferenceCount());
        cowCol.addReference();
        TestSQLColumn.assertEquals((int)(++count), (int)cowCol.getReferenceCount());
        cowCol.removeReference();
        TestSQLColumn.assertEquals((int)(--count), (int)cowCol.getReferenceCount());
    }

    public void testSetPopulated() throws Exception {
        SQLColumn tmpCol = new SQLColumn();
        tmpCol.setPopulated(false);
        TestSQLColumn.assertEquals((boolean)tmpCol.isPopulated(), (boolean)true);
        tmpCol.setPopulated(true);
        TestSQLColumn.assertEquals((boolean)tmpCol.isPopulated(), (boolean)true);
        SQLColumn cowCol = this.table3pk.getColumn(0);
        cowCol.setPopulated(false);
        TestSQLColumn.assertEquals((boolean)cowCol.isPopulated(), (boolean)true);
        cowCol.setPopulated(true);
        TestSQLColumn.assertEquals((boolean)cowCol.isPopulated(), (boolean)true);
    }

    public void testGetChildren() throws Exception {
        SQLColumn tmpCol = new SQLColumn();
        TestSQLColumn.assertEquals((boolean)tmpCol.getChildren().isEmpty(), (boolean)true);
        try {
            tmpCol.addChild(1, new SQLColumn());
            TestSQLColumn.fail((String)"SQLColumn should not have child");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        TestSQLColumn.assertEquals((int)tmpCol.getChildren().size(), (int)0);
        SQLColumn cowCol = this.table3pk.getColumn(0);
        TestSQLColumn.assertEquals((boolean)cowCol.getChildren().isEmpty(), (boolean)true);
        try {
            cowCol.addChild(1, new SQLColumn());
            TestSQLColumn.fail((String)"SQLColumn should not have child");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        TestSQLColumn.assertEquals((int)cowCol.getChildren().size(), (int)0);
    }

    public void testGetChild() throws Exception {
        SQLColumn tmpCol = new SQLColumn();
        try {
            tmpCol.getChild(0);
            tmpCol.getChild(1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        SQLColumn cowCol = this.table3pk.getColumn(0);
        try {
            cowCol.getChild(0);
            cowCol.getChild(1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testGetChildCount() throws Exception {
        SQLColumn tmpCol = new SQLColumn();
        int count = tmpCol.getChildCount();
        TestSQLColumn.assertEquals((int)count, (int)0);
        SQLColumn cowCol = this.table3pk.getColumn(0);
        count = cowCol.getChildCount();
        TestSQLColumn.assertEquals((int)count, (int)0);
    }

    public void testAddChildIntSQLObject() throws Exception {
        SQLColumn tmpCol = new SQLColumn();
        try {
            tmpCol.addChild(0, this.table1pk);
            TestSQLColumn.fail();
            tmpCol.addChild(2, this.table3pk);
            TestSQLColumn.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        SQLColumn cowCol = this.table3pk.getColumn(0);
        try {
            cowCol.addChild(0, this.table1pk);
            TestSQLColumn.fail();
            cowCol.addChild(2, this.table3pk);
            TestSQLColumn.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testAddChildSQLObject() throws Exception {
        SQLColumn tmpCol = new SQLColumn();
        try {
            tmpCol.addChild(this.table1pk);
            TestSQLColumn.fail();
            tmpCol.addChild(this.table3pk);
            TestSQLColumn.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        SQLColumn cowCol = this.table3pk.getColumn(0);
        try {
            cowCol.addChild(this.table1pk);
            TestSQLColumn.fail();
            cowCol.addChild(this.table3pk);
            TestSQLColumn.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testGetSQLObjectListeners() throws Exception {
        SQLColumn tmpCol = new SQLColumn();
        SQLColumn cowCol = this.table3pk.getColumn(0);
        LinkedList ll = (LinkedList)tmpCol.getSQLObjectListeners();
        TestSQLColumn.assertEquals((int)0, (int)ll.size());
        TestSQLObjectListener test1 = new TestSQLObjectListener();
        tmpCol.addSQLObjectListener(test1);
        TestSQLColumn.assertEquals((int)1, (int)ll.size());
        TestSQLObjectListener test2 = new TestSQLObjectListener();
        tmpCol.addSQLObjectListener(test2);
        TestSQLColumn.assertEquals((int)2, (int)ll.size());
        TestSQLColumn.assertEquals((int)test1.getInsertedCount(), (int)0);
        TestSQLColumn.assertEquals((int)test1.getRemovedCount(), (int)0);
        TestSQLColumn.assertEquals((int)test1.getChangedCount(), (int)0);
        TestSQLColumn.assertEquals((int)test1.getStructureChangedCount(), (int)0);
        TestSQLColumn.assertEquals((int)test2.getInsertedCount(), (int)0);
        TestSQLColumn.assertEquals((int)test2.getRemovedCount(), (int)0);
        TestSQLColumn.assertEquals((int)test2.getChangedCount(), (int)0);
        TestSQLColumn.assertEquals((int)test2.getStructureChangedCount(), (int)0);
        tmpCol.setName("xxx");
        TestSQLColumn.assertEquals((int)test1.getInsertedCount(), (int)0);
        TestSQLColumn.assertEquals((int)test1.getRemovedCount(), (int)0);
        TestSQLColumn.assertEquals((int)test1.getChangedCount(), (int)1);
        TestSQLColumn.assertEquals((int)test1.getStructureChangedCount(), (int)0);
        TestSQLColumn.assertEquals((int)test2.getInsertedCount(), (int)0);
        TestSQLColumn.assertEquals((int)test2.getRemovedCount(), (int)0);
        TestSQLColumn.assertEquals((int)test2.getChangedCount(), (int)1);
        TestSQLColumn.assertEquals((int)test2.getStructureChangedCount(), (int)0);
        tmpCol.setName("xxx");
        TestSQLColumn.assertEquals((int)test1.getInsertedCount(), (int)0);
        TestSQLColumn.assertEquals((int)test1.getRemovedCount(), (int)0);
        TestSQLColumn.assertEquals((int)test1.getChangedCount(), (int)1);
        TestSQLColumn.assertEquals((int)test1.getStructureChangedCount(), (int)0);
        TestSQLColumn.assertEquals((int)test2.getInsertedCount(), (int)0);
        TestSQLColumn.assertEquals((int)test2.getRemovedCount(), (int)0);
        TestSQLColumn.assertEquals((int)test2.getChangedCount(), (int)1);
        TestSQLColumn.assertEquals((int)test2.getStructureChangedCount(), (int)0);
        tmpCol.removeSQLObjectListener(test1);
        TestSQLColumn.assertEquals((int)1, (int)ll.size());
        TestSQLColumn.assertEquals((int)test1.getInsertedCount(), (int)0);
        TestSQLColumn.assertEquals((int)test1.getRemovedCount(), (int)0);
        TestSQLColumn.assertEquals((int)test1.getChangedCount(), (int)1);
        TestSQLColumn.assertEquals((int)test1.getStructureChangedCount(), (int)0);
        TestSQLColumn.assertEquals((int)test2.getInsertedCount(), (int)0);
        TestSQLColumn.assertEquals((int)test2.getRemovedCount(), (int)0);
        TestSQLColumn.assertEquals((int)test2.getChangedCount(), (int)1);
        TestSQLColumn.assertEquals((int)test2.getStructureChangedCount(), (int)0);
        tmpCol.setName("xxxx");
        TestSQLColumn.assertEquals((int)test1.getInsertedCount(), (int)0);
        TestSQLColumn.assertEquals((int)test1.getRemovedCount(), (int)0);
        TestSQLColumn.assertEquals((int)test1.getChangedCount(), (int)1);
        TestSQLColumn.assertEquals((int)test1.getStructureChangedCount(), (int)0);
        TestSQLColumn.assertEquals((int)0, (int)test2.getInsertedCount());
        TestSQLColumn.assertEquals((int)0, (int)test2.getRemovedCount());
        TestSQLColumn.assertEquals((int)2, (int)test2.getChangedCount());
        TestSQLColumn.assertEquals((int)0, (int)test2.getStructureChangedCount());
        TestSQLColumn.assertEquals((String)"name", (String)test2.getLastEventName());
        ll = (LinkedList)cowCol.getSQLObjectListeners();
        TestSQLColumn.assertEquals((int)0, (int)ll.size());
        test1 = new TestSQLObjectListener();
        cowCol.addSQLObjectListener(test1);
        TestSQLColumn.assertEquals((int)1, (int)ll.size());
        test2 = new TestSQLObjectListener();
        cowCol.addSQLObjectListener(test2);
        TestSQLColumn.assertEquals((int)2, (int)ll.size());
        TestSQLColumn.assertEquals((int)test1.getInsertedCount(), (int)0);
        TestSQLColumn.assertEquals((int)test1.getRemovedCount(), (int)0);
        TestSQLColumn.assertEquals((int)test1.getChangedCount(), (int)0);
        TestSQLColumn.assertEquals((int)test1.getStructureChangedCount(), (int)0);
        TestSQLColumn.assertEquals((int)test2.getInsertedCount(), (int)0);
        TestSQLColumn.assertEquals((int)test2.getRemovedCount(), (int)0);
        TestSQLColumn.assertEquals((int)test2.getChangedCount(), (int)0);
        TestSQLColumn.assertEquals((int)test2.getStructureChangedCount(), (int)0);
        cowCol.setName("xxx");
        TestSQLColumn.assertEquals((int)test1.getInsertedCount(), (int)0);
        TestSQLColumn.assertEquals((int)test1.getRemovedCount(), (int)0);
        TestSQLColumn.assertEquals((int)test1.getChangedCount(), (int)1);
        TestSQLColumn.assertEquals((int)test1.getStructureChangedCount(), (int)0);
        TestSQLColumn.assertEquals((int)test2.getInsertedCount(), (int)0);
        TestSQLColumn.assertEquals((int)test2.getRemovedCount(), (int)0);
        TestSQLColumn.assertEquals((int)test2.getChangedCount(), (int)1);
        TestSQLColumn.assertEquals((int)test2.getStructureChangedCount(), (int)0);
        cowCol.setName("xxxx");
        TestSQLColumn.assertEquals((int)test1.getInsertedCount(), (int)0);
        TestSQLColumn.assertEquals((int)test1.getRemovedCount(), (int)0);
        TestSQLColumn.assertEquals((int)test1.getChangedCount(), (int)2);
        TestSQLColumn.assertEquals((int)test1.getStructureChangedCount(), (int)0);
        TestSQLColumn.assertEquals((int)test2.getInsertedCount(), (int)0);
        TestSQLColumn.assertEquals((int)test2.getRemovedCount(), (int)0);
        TestSQLColumn.assertEquals((int)test2.getChangedCount(), (int)2);
        TestSQLColumn.assertEquals((int)test2.getStructureChangedCount(), (int)0);
        cowCol.removeSQLObjectListener(test1);
        TestSQLColumn.assertEquals((int)1, (int)ll.size());
        TestSQLColumn.assertEquals((int)test1.getInsertedCount(), (int)0);
        TestSQLColumn.assertEquals((int)test1.getRemovedCount(), (int)0);
        TestSQLColumn.assertEquals((int)test1.getChangedCount(), (int)2);
        TestSQLColumn.assertEquals((int)test1.getStructureChangedCount(), (int)0);
        TestSQLColumn.assertEquals((int)test2.getInsertedCount(), (int)0);
        TestSQLColumn.assertEquals((int)test2.getRemovedCount(), (int)0);
        TestSQLColumn.assertEquals((int)test2.getChangedCount(), (int)2);
        TestSQLColumn.assertEquals((int)test2.getStructureChangedCount(), (int)0);
        cowCol.setName("xxx");
        TestSQLColumn.assertEquals((int)test1.getInsertedCount(), (int)0);
        TestSQLColumn.assertEquals((int)test1.getRemovedCount(), (int)0);
        TestSQLColumn.assertEquals((int)test1.getChangedCount(), (int)2);
        TestSQLColumn.assertEquals((int)test1.getStructureChangedCount(), (int)0);
        TestSQLColumn.assertEquals((int)test2.getInsertedCount(), (int)0);
        TestSQLColumn.assertEquals((int)test2.getRemovedCount(), (int)0);
        TestSQLColumn.assertEquals((int)test2.getChangedCount(), (int)3);
        TestSQLColumn.assertEquals((int)test2.getStructureChangedCount(), (int)0);
        TestSQLColumn.assertEquals((String)"name", (String)test2.getLastEventName());
    }

    public static class TestSQLObjectListener
    implements SQLObjectListener {
        private int insertedCount = 0;
        private int removedCount = 0;
        private int changedCount = 0;
        private int structureChangedCount = 0;
        private String lastEventName = null;

        public void dbChildrenInserted(SQLObjectEvent e) {
            ++this.insertedCount;
        }

        public void dbChildrenRemoved(SQLObjectEvent e) {
            ++this.removedCount;
        }

        public void dbObjectChanged(SQLObjectEvent e) {
            ++this.changedCount;
            this.lastEventName = e.getPropertyName();
        }

        public void dbStructureChanged(SQLObjectEvent e) {
            ++this.structureChangedCount;
        }

        public int getInsertedCount() {
            return this.insertedCount;
        }

        public int getRemovedCount() {
            return this.removedCount;
        }

        public int getChangedCount() {
            return this.changedCount;
        }

        public int getStructureChangedCount() {
            return this.structureChangedCount;
        }

        public String getLastEventName() {
            return this.lastEventName;
        }
    }
}

