/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect;

import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.SQLTable;
import junit.framework.TestCase;

public class SQLObjectMagicTest
extends TestCase {
    SQLObject parent;
    SQLObject child = new SQLTable.Folder(1, false);

    protected void setUp() throws Exception {
        this.parent = new SQLTable();
        this.parent.addChild(this.child);
    }

    public void testOneLevel() {
        SQLObjectMagicTest.assertTrue((boolean)this.child.isMagicEnabled());
        this.child.setMagicEnabled(false);
        SQLObjectMagicTest.assertFalse((boolean)this.child.isMagicEnabled());
        this.child.setMagicEnabled(true);
        SQLObjectMagicTest.assertTrue((boolean)this.child.isMagicEnabled());
    }

    public void testMultipleDisables() {
        SQLObjectMagicTest.assertTrue((boolean)this.child.isMagicEnabled());
        this.child.setMagicEnabled(false);
        this.child.setMagicEnabled(false);
        this.child.setMagicEnabled(true);
        SQLObjectMagicTest.assertFalse((boolean)this.child.isMagicEnabled());
        this.child.setMagicEnabled(true);
        SQLObjectMagicTest.assertTrue((boolean)this.child.isMagicEnabled());
    }

    public void testParentChild() {
        SQLObjectMagicTest.assertTrue((boolean)this.child.isMagicEnabled());
        this.parent.setMagicEnabled(false);
        SQLObjectMagicTest.assertFalse((boolean)this.child.isMagicEnabled());
        this.child.setMagicEnabled(false);
        SQLObjectMagicTest.assertFalse((boolean)this.child.isMagicEnabled());
        this.child.setMagicEnabled(true);
        SQLObjectMagicTest.assertFalse((boolean)this.child.isMagicEnabled());
        this.parent.setMagicEnabled(true);
        try {
            this.child.setMagicEnabled(true);
        }
        catch (Throwable e) {
            System.out.println("Caught expected: " + e);
        }
        SQLObjectMagicTest.assertTrue((boolean)this.child.isMagicEnabled());
        this.child.setMagicEnabled(false);
        SQLObjectMagicTest.assertFalse((boolean)this.child.isMagicEnabled());
    }
}

