/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLObjectEvent;
import ca.sqlpower.architect.SQLObjectListener;
import ca.sqlpower.architect.undo.UndoCompoundEvent;
import ca.sqlpower.architect.undo.UndoCompoundEventListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SQLObject
implements Serializable {
    private static Logger logger = Logger.getLogger(SQLObject.class);
    protected boolean populated = false;
    private String physicalName;
    private String name;
    protected List children;
    protected int magicDisableCount = 0;
    private final transient List<SQLObjectListener> sqlObjectListeners = new LinkedList<SQLObjectListener>();
    protected LinkedList<UndoCompoundEventListener> undoEventListeners = new LinkedList();

    public synchronized void setMagicEnabled(boolean enable) {
        if (this.magicDisableCount < 0) {
            throw new IllegalStateException("magicDisableCount < 0");
        }
        if (enable) {
            if (this.magicDisableCount == 0) {
                throw new IllegalArgumentException("Sorry, you asked me to enable, but disable count already 0");
            }
            --this.magicDisableCount;
        } else {
            ++this.magicDisableCount;
        }
    }

    public boolean isMagicEnabled() {
        if (this.magicDisableCount > 0) {
            return false;
        }
        if (this.getParent() != null) {
            return this.getParent().isMagicEnabled();
        }
        return true;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String argName) {
        String oldValue = this.name;
        this.name = argName;
        this.fireDbObjectChanged("name", oldValue, this.name);
    }

    public final String getPhysicalName() {
        if (this.physicalName != null) {
            return this.physicalName;
        }
        return this.getName();
    }

    public final void setPhysicalName(String argName) {
        String oldPhysicalName = this.physicalName;
        this.physicalName = argName;
        this.fireDbObjectChanged("physicalName", oldPhysicalName, argName);
    }

    public abstract SQLObject getParent();

    protected abstract void setParent(SQLObject var1);

    protected abstract void populate() throws ArchitectException;

    public abstract String getShortDisplayName();

    public boolean isPopulated() {
        return this.populated;
    }

    public void setPopulated(boolean v) {
        this.populated = v;
    }

    public abstract boolean allowsChildren();

    public List getChildren() throws ArchitectException {
        if (!this.allowsChildren()) {
            return this.children;
        }
        this.populate();
        return Collections.unmodifiableList(this.children);
    }

    public SQLObject getChild(int index) throws ArchitectException {
        this.populate();
        return (SQLObject)this.children.get(index);
    }

    public int getChildCount() throws ArchitectException {
        this.populate();
        return this.children.size();
    }

    protected void addChildImpl(int index, SQLObject newChild) throws ArchitectException {
        if (this.children.size() > 0 && !this.children.get(0).getClass().isAssignableFrom(newChild.getClass()) && !newChild.getClass().isAssignableFrom(this.children.get(0).getClass())) {
            throw new ArchitectException("You Can't mix SQL Object Types! You gave: " + newChild.getClass().getName() + "; I need " + this.children.get(0).getClass());
        }
        this.children.add(index, newChild);
        newChild.setParent(this);
        this.fireDbChildInserted(index, newChild);
    }

    public void addChild(int index, SQLObject newChild) throws ArchitectException {
        this.addChildImpl(index, newChild);
    }

    public void addChild(SQLObject newChild) throws ArchitectException {
        this.addChildImpl(this.children.size(), newChild);
    }

    public SQLObject removeChild(int index) {
        SQLObject removedChild = (SQLObject)this.children.remove(index);
        if (removedChild != null) {
            removedChild.setParent(null);
            this.fireDbChildRemoved(index, removedChild);
        }
        return removedChild;
    }

    public boolean removeChild(SQLObject child) {
        int childIdx = this.children.indexOf(child);
        if (childIdx >= 0) {
            this.removeChild(childIdx);
        }
        return childIdx >= 0;
    }

    public List<SQLObjectListener> getSQLObjectListeners() {
        return this.sqlObjectListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSQLObjectListener(SQLObjectListener l) {
        if (l == null) {
            throw new NullPointerException("You can't add a null listener");
        }
        List<SQLObjectListener> list = this.sqlObjectListeners;
        synchronized (list) {
            if (this.sqlObjectListeners.contains(l)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("NOT Adding duplicate listener " + l + " to SQLObject " + this));
                }
                return;
            }
            this.sqlObjectListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSQLObjectListener(SQLObjectListener l) {
        List<SQLObjectListener> list = this.sqlObjectListeners;
        synchronized (list) {
            this.sqlObjectListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireDbChildrenInserted(int[] newIndices, List newChildren) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(String.valueOf(this.getClass().getName()) + " " + this.toString() + ": " + "firing dbChildrenInserted event"));
        }
        SQLObjectEvent e = new SQLObjectEvent(this, newIndices, newChildren.toArray(new SQLObject[newChildren.size()]));
        List<SQLObjectListener> list = this.sqlObjectListeners;
        synchronized (list) {
            Iterator<SQLObjectListener> it = this.sqlObjectListeners.iterator();
            int count = 0;
            while (it.hasNext()) {
                ++count;
                SQLObjectListener nextListener = it.next();
                nextListener.dbChildrenInserted(e);
            }
            logger.debug((Object)(String.valueOf(this.getClass().getName()) + ": notified " + count + " listeners"));
        }
    }

    protected void fireDbChildInserted(int newIndex, SQLObject newChild) {
        int[] newIndexArray = new int[]{newIndex};
        ArrayList<SQLObject> newChildList = new ArrayList<SQLObject>(1);
        newChildList.add(newChild);
        this.fireDbChildrenInserted(newIndexArray, newChildList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireDbChildrenRemoved(int[] oldIndices, List oldChildren) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(String.valueOf(this.getClass().getName()) + " " + this.toString() + ": " + "firing dbChildrenRemoved event"));
            logger.debug((Object)("Removing children " + oldChildren + " from " + oldIndices));
        }
        SQLObjectEvent e = new SQLObjectEvent(this, oldIndices, oldChildren.toArray(new SQLObject[oldChildren.size()]));
        int count = 0;
        List<SQLObjectListener> list = this.sqlObjectListeners;
        synchronized (list) {
            SQLObjectListener[] listeners = this.sqlObjectListeners.toArray(new SQLObjectListener[0]);
            int i = listeners.length - 1;
            while (i >= 0) {
                listeners[i].dbChildrenRemoved(e);
                ++count;
                --i;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Notified " + count + " listeners."));
        }
    }

    protected void fireDbChildRemoved(int oldIndex, SQLObject oldChild) {
        int[] oldIndexArray = new int[]{oldIndex};
        ArrayList<SQLObject> oldChildList = new ArrayList<SQLObject>(1);
        oldChildList.add(oldChild);
        this.fireDbChildrenRemoved(oldIndexArray, oldChildList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireDbObjectChanged(String propertyName, Object oldValue, Object newValue) {
        boolean same;
        SQLObjectEvent e = new SQLObjectEvent(this, propertyName, oldValue, newValue);
        boolean bl = oldValue == null ? oldValue == newValue : (same = oldValue.equals(newValue));
        if (same) {
            logger.debug((Object)("Object changed event aborted, the old value '" + oldValue + "' of " + propertyName + " equals the new value '" + newValue + "'"));
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(String.valueOf(this.getClass().getName()) + " " + this.toString() + ": " + "firing dbObjectChanged event"));
            logger.debug((Object)("Changed the old value '" + oldValue + "' of " + propertyName + " to '" + newValue + "'"));
        }
        int count = 0;
        List<SQLObjectListener> list = this.sqlObjectListeners;
        synchronized (list) {
            SQLObjectListener[] listeners = this.sqlObjectListeners.toArray(new SQLObjectListener[0]);
            int i = listeners.length - 1;
            while (i >= 0) {
                ++count;
                listeners[i].dbObjectChanged(e);
                --i;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Notified " + count + " listeners."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireDbStructureChanged() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(String.valueOf(this.getClass().getName()) + " " + this.toString() + ": " + "firing dbStructureChanged event"));
        }
        SQLObjectEvent e = new SQLObjectEvent(this, null);
        int count = 0;
        List<SQLObjectListener> list = this.sqlObjectListeners;
        synchronized (list) {
            SQLObjectListener[] listeners = this.sqlObjectListeners.toArray(new SQLObjectListener[0]);
            int i = listeners.length - 1;
            while (i >= 0) {
                ++count;
                listeners[i].dbStructureChanged(e);
                --i;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Notified " + count + " listeners."));
        }
    }

    public abstract Class<? extends SQLObject> getChildType();

    public void addUndoEventListener(UndoCompoundEventListener l) {
        if (this.undoEventListeners.contains(l)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("NOT Adding duplicate Undo listener " + l + " to SQLObject " + this));
            }
            return;
        }
        this.undoEventListeners.add(l);
    }

    public void removeUndoEventListener(UndoCompoundEventListener l) {
        this.undoEventListeners.remove(l);
    }

    private void fireUndoCompoundEvent(UndoCompoundEvent e) {
        UndoCompoundEventListener[] listeners = this.undoEventListeners.toArray(new UndoCompoundEventListener[0]);
        if (e.getType().isStartEvent()) {
            int i = listeners.length - 1;
            while (i >= 0) {
                listeners[i].compoundEditStart(e);
                --i;
            }
        } else {
            int i = listeners.length - 1;
            while (i >= 0) {
                listeners[i].compoundEditEnd(e);
                --i;
            }
        }
    }

    public void startCompoundEdit(String message) {
        this.fireUndoCompoundEvent(new UndoCompoundEvent((Object)this, UndoCompoundEvent.EventTypes.COMPOUND_EDIT_START, message));
    }

    public void endCompoundEdit(String message) {
        this.fireUndoCompoundEvent(new UndoCompoundEvent((Object)this, UndoCompoundEvent.EventTypes.COMPOUND_EDIT_END, message));
    }

    public LinkedList<UndoCompoundEventListener> getUndoEventListeners() {
        return this.undoEventListeners;
    }

    public SQLObject getChildByName(String name) throws ArchitectException {
        for (SQLObject o : this.getChildren()) {
            if (!o.getName().equals(name)) continue;
            return o;
        }
        return null;
    }

    public int getIndexOfChildByName(String name) throws ArchitectException {
        int i = 0;
        for (Object o : this.getChildren()) {
            SQLObject so = (SQLObject)o;
            if (so.getName().equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

