/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLCatalog;
import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.SQLDatabase;
import ca.sqlpower.architect.SQLExceptionNode;
import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.SQLObjectListener;
import ca.sqlpower.architect.SQLSchema;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.ddl.DB2DDLGenerator;
import ca.sqlpower.architect.ddl.OracleDDLGenerator;
import ca.sqlpower.architect.ddl.PostgresDDLGenerator;
import ca.sqlpower.architect.ddl.SQLServerDDLGenerator;
import ca.sqlpower.architect.undo.UndoCompoundEventListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchitectUtils {
    private static final Logger logger = Logger.getLogger(ArchitectUtils.class);
    public static final String APP_VERSION_MAJOR = "0";
    public static final String APP_VERSION_MINOR = "9";
    public static final String APP_VERSION_TINY = "1";
    public static final String APP_VERSION = "0.9.1";
    private static final long startupTimeMillis = System.currentTimeMillis();

    private ArchitectUtils() {
    }

    public static void startup() {
    }

    public static void configureLog4j() {
        String configName = "log4j.properties";
        URL config = ArchitectUtils.class.getClassLoader().getResource(configName);
        if (config == null) {
            System.err.println("Warning: Couldn't find log4j config resource '" + configName + "'");
        } else {
            PropertyConfigurator.configure((URL)config);
            logger.info((Object)"Log4J configured successfully");
        }
    }

    public static void listenToHierarchy(SQLObjectListener listener, SQLObject source) throws ArchitectException {
        logger.debug((Object)("Listening to new SQL Object " + source));
        source.addSQLObjectListener(listener);
        if (source.isPopulated() && source.allowsChildren()) {
            Iterator it = source.getChildren().iterator();
            while (it.hasNext()) {
                ArchitectUtils.listenToHierarchy(listener, (SQLObject)it.next());
            }
        }
    }

    public static void addUndoListenerToHierarchy(UndoCompoundEventListener listener, SQLObject source) throws ArchitectException {
        logger.debug((Object)("Undo Listening to new SQL Object " + source));
        source.addUndoEventListener(listener);
        if (source.isPopulated() && source.allowsChildren()) {
            Iterator it = source.getChildren().iterator();
            while (it.hasNext()) {
                ArchitectUtils.addUndoListenerToHierarchy(listener, (SQLObject)it.next());
            }
        }
    }

    public static void addUndoListenerToHierarchy(UndoCompoundEventListener listener, SQLObject[] sources) throws ArchitectException {
        if (sources == null) {
            return;
        }
        int i = 0;
        while (i < sources.length) {
            ArchitectUtils.addUndoListenerToHierarchy(listener, sources[i]);
            ++i;
        }
    }

    public static void listenToHierarchy(SQLObjectListener listener, SQLObject[] sources) throws ArchitectException {
        if (sources == null) {
            return;
        }
        int i = 0;
        while (i < sources.length) {
            ArchitectUtils.listenToHierarchy(listener, sources[i]);
            ++i;
        }
    }

    public static void undoUnlistenToHierarchy(UndoCompoundEventListener listener, SQLObject source) throws ArchitectException {
        logger.debug((Object)("Unlistening to SQL Object " + source));
        source.removeUndoEventListener(listener);
        if (source.isPopulated() && source.allowsChildren()) {
            for (SQLObject ob : source.getChildren()) {
                ArchitectUtils.undoUnlistenToHierarchy(listener, ob);
            }
        }
    }

    public static void undoUnlistenToHierarchy(UndoCompoundEventListener listener, SQLObject[] sources) throws ArchitectException {
        if (sources == null) {
            return;
        }
        int i = 0;
        while (i < sources.length) {
            ArchitectUtils.undoUnlistenToHierarchy(listener, sources[i]);
            ++i;
        }
    }

    public static void unlistenToHierarchy(SQLObjectListener listener, SQLObject source) throws ArchitectException {
        logger.debug((Object)("Removing " + listener + " from listener list of " + source));
        source.removeSQLObjectListener(listener);
        if (source.isPopulated() && source.allowsChildren()) {
            logger.debug((Object)("        Now removing for children: " + source.getChildren()));
            for (SQLObject ob : source.getChildren()) {
                ArchitectUtils.unlistenToHierarchy(listener, ob);
            }
        }
    }

    public static void unlistenToHierarchy(SQLObjectListener listener, SQLObject[] sources) throws ArchitectException {
        if (sources == null) {
            return;
        }
        int i = 0;
        while (i < sources.length) {
            ArchitectUtils.unlistenToHierarchy(listener, sources[i]);
            ++i;
        }
    }

    public static boolean areEqual(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public static List findColumnsSourcedFromDatabase(SQLDatabase target, SQLDatabase source) throws ArchitectException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Searching for dependencies on " + source + " in " + target));
        }
        ArrayList<SQLColumn> matches = new ArrayList<SQLColumn>();
        for (SQLObject so : target.getChildren()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("-->Next target item is " + so.getClass().getName() + ": " + so + " (" + so.getChildCount() + " children)"));
            }
            if (!(so instanceof SQLTable)) continue;
            SQLTable t = (SQLTable)so;
            for (SQLColumn next : t.getColumns()) {
                SQLColumn col;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("---->Next item in columns list is a " + next.getClass().getName()));
                }
                if (!source.equals((col = next).getSourceColumn().getParentTable().getParentDatabase())) continue;
                matches.add(col);
            }
        }
        return matches;
    }

    public static boolean pokeDatabase(SQLObject source) throws ArchitectException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("HELLO my class is " + source.getClass().getName() + ", my name is + " + source.getName()));
        }
        if (source.allowsChildren()) {
            int childCount;
            int j = 0;
            boolean done = false;
            try {
                childCount = source.getChildCount();
            }
            catch (ArchitectException e) {
                source.addChild(new SQLExceptionNode(e, "Error during initial database probe"));
                childCount = 1;
            }
            while (!done && j < childCount) {
                done = ArchitectUtils.pokeDatabase(source.getChild(j));
                ++j;
            }
            return done;
        }
        return true;
    }

    public static int countTablesSnapshot(SQLObject so) throws ArchitectException {
        if (so instanceof SQLTable) {
            return 1;
        }
        int count = 0;
        Iterator it = so.getChildren().iterator();
        while (it.hasNext()) {
            count += ArchitectUtils.countTablesSnapshot((SQLObject)it.next());
        }
        return count;
    }

    public static List findDescendentsByClass(SQLObject so, Class clazz, List list) throws ArchitectException {
        if (clazz.isAssignableFrom(so.getClass())) {
            list.add(so);
        } else {
            Iterator it = so.getChildren().iterator();
            while (it.hasNext()) {
                ArchitectUtils.findDescendentsByClass((SQLObject)it.next(), clazz, list);
            }
        }
        return list;
    }

    public static String truncateString(String s) {
        if (s == null || s.length() < 28) {
            return s;
        }
        return String.valueOf(s.substring(27)) + "...";
    }

    public static int countTables(SQLObject so) throws ArchitectException {
        if (so instanceof SQLTable) {
            return 1;
        }
        if (!so.allowsChildren() || !so.isPopulated() || so.getChildren() == null) {
            return 0;
        }
        int myCount = 0;
        Iterator it = so.getChildren().iterator();
        while (it.hasNext()) {
            myCount += ArchitectUtils.countTables((SQLObject)it.next());
        }
        return myCount;
    }

    public static Map<String, String> getDriverTemplateMap() {
        HashMap<String, String> drivers = new HashMap<String, String>();
        drivers.put("oracle.jdbc.OracleDriver", "jdbc:oracle:thin:@<Hostname>:<Port:1521>:<Instance>");
        drivers.put("oracle.jdbc.driver.OracleDriver", "jdbc:oracle:thin:@<Hostname>:<Port:1521>:<Instance>");
        drivers.put("com.microsoft.jdbc.sqlserver.SQLServerDriver", "jdbc:microsoft:sqlserver://<Hostname>:<Port:1433>;SelectMethod=cursor");
        drivers.put("org.postgresql.Driver", "jdbc:postgresql://<Hostname>:<Port:5432>/<Database>");
        drivers.put("ibm.sql.DB2Driver", "jdbc:db2:<Hostname>");
        drivers.put("org.apache.derby.jdbc.EmbeddedDriver", "jdbc:derby:<Database>;create=true");
        drivers.put("org.hsqldb.jdbcDriver", "jdbc:hsqldb:<Database>");
        drivers.put("ca.sqlpower.architect.MockJDBCDriver", "jdbc:mock:catalogTerm=<Catalog Term:Catalog>&schemaTerm=<Schema Term:Schema>");
        return drivers;
    }

    public static Map<String, String> getDriverTypeMap() {
        HashMap<String, String> driverSystems = new HashMap<String, String>();
        driverSystems.put("oracle.jdbc.driver.OracleDriver", "ORACLE");
        driverSystems.put("oracle.jdbc.OracleDriver", "ORACLE");
        driverSystems.put("com.microsoft.jdbc.sqlserver.SQLServerDriver", "SQL SERVER");
        driverSystems.put("org.postgresql.Driver", "POSTGRES");
        driverSystems.put("ibm.sql.DB2Driver", "DB2");
        driverSystems.put("org.apache.derby.jdbc.EmbeddedDriver", "DERBY");
        driverSystems.put("org.hsqldb.jdbcDriver", "HSQLDB");
        driverSystems.put("ca.sqlpower.architect.MockJDBCDriver", "OTHER");
        return driverSystems;
    }

    public static Map getDriverDDLGeneratorMap() {
        HashMap<String, Class> drivers = new HashMap<String, Class>();
        drivers.put("oracle.jdbc.driver.OracleDriver", OracleDDLGenerator.class);
        drivers.put("oracle.jdbc.OracleDriver", OracleDDLGenerator.class);
        drivers.put("com.microsoft.jdbc.sqlserver.SQLServerDriver", SQLServerDDLGenerator.class);
        drivers.put("org.postgresql.Driver", PostgresDDLGenerator.class);
        drivers.put("ibm.sql.DB2Driver", DB2DDLGenerator.class);
        return drivers;
    }

    public static String escapeXML(String src) {
        if (src == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer(src.length() + 10);
        int i = 0;
        int n = src.length();
        while (i < n) {
            char ch = src.charAt(i);
            switch (ch) {
                case '\'': {
                    sb.append("&apos;");
                    break;
                }
                case '\"': {
                    sb.append("&quot;");
                    break;
                }
                case '&': {
                    sb.append("&amp;");
                    break;
                }
                case '<': {
                    sb.append("&lt;");
                    break;
                }
                case '>': {
                    sb.append("&gt;");
                    break;
                }
                default: {
                    sb.append(ch);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static String quoteCSV(Object val) {
        if (val == null) {
            return "";
        }
        if (val instanceof String) {
            return ArchitectUtils.quoteCSVStr((String)val);
        }
        return val.toString();
    }

    public static String quoteCSVStr(String val) {
        CharSequence doubleQuote = "\"".subSequence(0, "\"".length());
        CharSequence doubleDoubleQuote = "\"\"".subSequence(0, "\"\"".length());
        CharSequence newLine = "\n".subSequence(0, "\n".length());
        CharSequence cr = "\r".subSequence(0, "\r".length());
        CharSequence comma = ",".subSequence(0, ",".length());
        if (val.contains(doubleQuote)) {
            StringBuffer sb = new StringBuffer(doubleQuote);
            sb.append(val.replace(doubleQuote, doubleDoubleQuote));
            sb.append(doubleQuote);
            return sb.toString();
        }
        if (val.contains(newLine) || val.contains(cr) || val.contains(comma)) {
            StringBuffer sb = new StringBuffer(doubleQuote);
            sb.append(val);
            sb.append(doubleQuote);
            return sb.toString();
        }
        return val;
    }

    public static List<SQLTable> extractTables(SQLObject start, List addTo) throws ArchitectException {
        if (start.allowsChildren()) {
            for (SQLObject so : start.getChildren()) {
                if (so instanceof SQLTable) {
                    addTo.add(so);
                    continue;
                }
                ArchitectUtils.extractTables(so, addTo);
            }
        }
        return addTo;
    }

    public static long getAppUptime() {
        return System.currentTimeMillis() - startupTimeMillis;
    }

    public static <T extends SQLObject> T getAncestor(SQLObject so, Class<T> ancestorType) {
        while (so != null) {
            if (so.getClass().equals(ancestorType)) {
                return (T)so;
            }
            so = so.getParent();
        }
        return null;
    }

    public static Collection<SQLTable> tablesUnder(SQLObject so) throws ArchitectException {
        ArrayList<SQLTable> tables = new ArrayList<SQLTable>();
        if (so instanceof SQLTable) {
            tables.add((SQLTable)so);
        } else if (so.allowsChildren()) {
            for (SQLObject child : so.getChildren()) {
                tables.addAll(ArchitectUtils.tablesUnder(child));
            }
        }
        return tables;
    }

    public static <T> T getTreeObject(JTree tree, Class<T> type) {
        TreePath[] paths = tree.getSelectionPaths();
        if (paths == null || paths.length == 0) {
            return null;
        }
        int i = 0;
        while (i < paths.length) {
            TreePath path = paths[i];
            Object[] objectArray = path.getPath();
            int n = 0;
            int n2 = objectArray.length;
            while (n < n2) {
                Object o = objectArray[n];
                if (o.getClass().equals(type)) {
                    return (T)o;
                }
                ++n;
            }
            ++i;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isCompatibleWithHierarchy(SQLDatabase db, String catalog, String schema, String name) throws ArchitectException {
        SQLObject tableContainer;
        SQLObject schemaContainer;
        if (catalog != null) {
            if (!db.isCatalogContainer()) return false;
            schemaContainer = db.getCatalogByName(catalog);
            if (schemaContainer == null) {
                return true;
            }
        } else {
            schemaContainer = db;
        }
        if (schema != null) {
            if (schemaContainer.getChildType() != SQLSchema.class) return schemaContainer.getChildType() == null;
            tableContainer = schemaContainer.getChildByName(schema);
            if (tableContainer == null) {
                return true;
            }
        } else {
            tableContainer = schemaContainer;
        }
        if (name == null) return false;
        return tableContainer.getChildType() == null || tableContainer.getChildType() == SQLTable.class;
    }

    public static SQLTable addSimulatedTable(SQLDatabase db, String catalog, String schema, String name) throws ArchitectException {
        SQLObject tableContainer;
        SQLObject schemaContainer;
        if (db.getTableByName(catalog, schema, name) != null) {
            throw new ArchitectException("The table " + catalog + "." + schema + "." + name + " already exists");
        }
        if (catalog != null) {
            if (!db.isCatalogContainer()) {
                throw new ArchitectException("You tried to add a table with a catalog ancestor to a database that doesn't support catalogs.");
            }
            schemaContainer = db.getCatalogByName(catalog);
            if (schemaContainer == null) {
                schemaContainer = new SQLCatalog(db, catalog, true);
                db.addChild(schemaContainer);
            }
        } else {
            schemaContainer = db;
        }
        if (schema != null) {
            Class<? extends SQLObject> childType = schemaContainer.getChildType();
            if (childType != null && childType != SQLSchema.class) {
                throw new ArchitectException("The schema container (" + schemaContainer + ") can't actually contain children of type SQLSchema.");
            }
            tableContainer = schemaContainer.getChildByName(schema);
            if (tableContainer == null) {
                tableContainer = new SQLSchema(schemaContainer, schema, true);
                schemaContainer.addChild(tableContainer);
            }
        } else {
            tableContainer = schemaContainer;
        }
        SQLTable newTable = new SQLTable(tableContainer, name, null, "TABLE", true);
        tableContainer.addChild(newTable);
        return newTable;
    }
}

