/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.io;

import com.darwinsys.io.Checkpointer;
import com.darwinsys.io.CrawlerCallback;
import com.darwinsys.io.FileHandler;
import com.darwinsys.io.NextFD;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Set;
import java.util.TreeSet;

public class Crawler
implements Checkpointer {
    private boolean debug = false;
    private boolean verbose = false;
    private static FileHandler visitor;
    private FilenameFilter chooser;
    public static final CrawlerCallback JUST_PRINT;
    private CrawlerCallback eHandler;
    private Set<String> seenSet = new TreeSet<String>();

    static {
        JUST_PRINT = new CrawlerCallback(){

            public void handleException(Throwable t) {
                try {
                    System.err.printf("File %s caused exception (%s)\n", visitor.getFile().getAbsolutePath(), t);
                    Throwable t2 = t.getCause();
                    if (t2 != null) {
                        System.err.println("Cause: " + t2);
                    }
                }
                catch (Throwable h) {
                    System.err.println("ERROR IN ERROR HANDLER: " + h);
                }
            }
        };
    }

    public Crawler(FilenameFilter chooser, FileHandler fileVisitor) {
        if (chooser == null) {
            throw new NullPointerException("Chooser may not be null");
        }
        this.chooser = chooser;
        Crawler.setVisitor(fileVisitor);
    }

    public void crawl(File startDir) throws IOException {
        File[] dir = startDir.listFiles();
        if (dir == null) {
            System.err.println("Warning: list of " + startDir + " returned null");
            return;
        }
        int i = 0;
        while (i < dir.length) {
            File next = dir[i];
            String nextFileName = next.getName();
            if (nextFileName == null) {
                System.err.println("Warning: " + startDir + " contains null filename(s)");
            } else if (next.isDirectory() && !this.seen(next)) {
                this.checkpoint(next);
                this.crawl(next);
            } else {
                int nextFreeFD = -1;
                if (this.chooser.accept(startDir, nextFileName) && next.isFile()) {
                    block19: {
                        if (!next.canRead()) {
                            System.err.println(String.valueOf(nextFileName) + " not readable, ignored.");
                        }
                        try {
                            try {
                                if (this.chooser != null) {
                                    if (this.chooser.accept(startDir, nextFileName)) {
                                        nextFreeFD = NextFD.getNextFD();
                                        this.visitFile(next);
                                    }
                                } else {
                                    this.visitFile(next);
                                }
                            }
                            catch (Throwable e) {
                                if (this.eHandler != null) {
                                    this.eHandler.handleException(e);
                                    break block19;
                                }
                                if (e instanceof IOException) {
                                    throw (IOException)e;
                                }
                                IOException exception = new IOException("Crawl Error");
                                exception.initCause(e);
                                throw exception;
                            }
                        }
                        catch (Throwable throwable) {
                            if (nextFreeFD != -1 && NextFD.getNextFD() != nextFreeFD) {
                                System.err.printf("Hey, processing %s lost a file descriptor!", next);
                            }
                            throw throwable;
                        }
                    }
                    if (nextFreeFD != -1 && NextFD.getNextFD() != nextFreeFD) {
                        System.err.printf("Hey, processing %s lost a file descriptor!", next);
                    }
                }
            }
            ++i;
        }
    }

    private void visitFile(File next) throws IOException {
        if (this.verbose) {
            System.out.printf("Starting file: %s%n", next.getAbsolutePath());
        }
        visitor.visit(next);
    }

    private boolean seen(File next) throws IOException {
        String path = next.getCanonicalPath();
        boolean seen = this.seenSet.contains(path);
        if (!seen) {
            this.seenSet.add(path);
        }
        return seen;
    }

    private void checkpoint(File next) {
    }

    public CrawlerCallback getEHandler() {
        return this.eHandler;
    }

    public void setEHandler(CrawlerCallback handler) {
        this.eHandler = handler;
        if (this.debug) {
            Thread.setDefaultUncaughtExceptionHandler(this.eHandler);
        }
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public static FileHandler getVisitor() {
        return visitor;
    }

    public static void setVisitor(FileHandler visitor) {
        Crawler.visitor = visitor;
    }
}

