/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.graphics;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageOutputStream;

public class JigglyTextImageWriter {
    int width;
    int height;
    Font font;
    private int nc;
    private static Color[] colors = new Color[]{Color.BLUE, Color.RED, Color.BLACK, Color.GREEN};

    public JigglyTextImageWriter(Font font, int width, int height) {
        this.font = font;
        this.width = width;
        this.height = height;
    }

    public void write(String msg, OutputStream os) throws IOException {
        BufferedImage img = new BufferedImage(this.width, this.height, 1);
        Graphics2D g = img.createGraphics();
        g.setFont(this.font);
        g.setColor(Color.white);
        g.fillRect(0, 0, this.width, this.height);
        char[] msgChars = msg.toCharArray();
        int y = 100;
        int x = 0;
        int i = 0;
        while (i < msgChars.length) {
            g.setColor(this.randomColor());
            g.drawChars(msgChars, i, 1, x += 20, y);
            ++i;
        }
        ImageOutputStream ios = ImageIO.createImageOutputStream(os);
        if (!ImageIO.write((RenderedImage)img, "jpeg", ios)) {
            throw new IOException("Write Failed");
        }
    }

    private Color randomColor() {
        return colors[this.nc++ % colors.length];
    }
}

