#!/usr/bin/env python
# generated by wxGlade 0.3.2 on Mon Apr 12 01:28:29 2004

####(c)www.stani.be-------------------------------------------------------------

import _spe.info
INFO=_spe.info.copy()

INFO['description']=\
"""Blender browser as tab."""

__doc__=INFO['doc']%INFO

####wxGlade---------------------------------------------------------------------

import wx, os

class wxgPanel(wx.Panel):
    def __init__(self, *args, **kwds):
        # begin wxGlade: wxgPanel.__init__
        kwds["style"] = wx.TAB_TRAVERSAL
        wx.Panel.__init__(self, *args, **kwds)
        self.logo = wx.StaticBitmap(self, -1, wx.Bitmap("../skins/default/blenpy.png", wx.BITMAP_TYPE_ANY))
        self.modules = wx.ListBox(self, -1, choices=["Blender", "Armatures", "BezTriples", "Cameras", "CurNurbs", "Curves", "Effects", "Images", "Ipos", "IpoCurves", "Keys", "Lamps", "Lattices", "Materials", "Meshes", "Metaballs", "NMeshes", "Objects", "Registry", "Scenes", "Sounds", "Texts", "Text3ds", "Textures", "Worlds"], style=wx.LB_SINGLE)
        self.filling = wx.StaticText(self, -1, "Only available when Spe is launched from Blender. How? Open the file _spe/spe.blend and press Alt+P in the lower right text window.\n\nBlender is a free 3d modeller, renderer and animation program with a Python scripting engine (http://www.blender.org).")

        self.__set_properties()
        self.__do_layout()
        # end wxGlade

    def __set_properties(self):
        # begin wxGlade: wxgPanel.__set_properties
        self.modules.SetSize((94, 212))
        self.modules.SetSelection(0)
        # end wxGlade

    def __do_layout(self):
        # begin wxGlade: wxgPanel.__do_layout
        main = wx.BoxSizer(wx.HORIZONTAL)
        sideBar = wx.StaticBoxSizer(wx.StaticBox(self, -1, ""), wx.VERTICAL)
        sideBar.Add(self.logo, 0, wx.RIGHT, 50)
        sideBar.Add(self.modules, 1, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
        main.Add(sideBar, 0, wx.EXPAND, 0)
        main.Add(self.filling, 10, wx.ALL|wx.EXPAND, 4)
        self.SetAutoLayout(1)
        self.SetSizer(main)
        main.Fit(self)
        main.SetSizeHints(self)
        # end wxGlade
        self.main = main

# end of class wxgPanel

####Custom----------------------------------------------------------------------

import sm.wxp
import _spe.help

class Panel(wxgPanel):
    #---constructors
    def __init__(self, panel, *args, **kwds):
        wx.Bitmap       = panel.app.bitmap
        self.Blender    = panel.Blender
        wxgPanel.__init__(self, parent=panel,id=-1)
        self.update()
        self.SetHelpText(_spe.help.BLENDER)
        #events
        wx.EVT_LISTBOX(self.modules,self.modules.GetId(),self.update)
    
    #---methods
    def update(self,event=None):
        if self.Blender:
            welcome             = 'This is an inventory of all %s in the Blender drawing. Currently there %s %s %s%s...\n\n %s'
            label               = self.modules.GetStringSelection()
            l                   = label.lower()
            if label =='Blender':
                object          = self.Blender
                welcome         = 'Blender Module'
            elif label=='Registry':
                welcome         = 'Registry Keys'
                label           = 'Blender.Registry'
                object          = {}
                for key in self.Blender.Registry.Keys():
                    object[key] = self.Blender.Registry.GetKey(key)
            else:
                if label == 'NMeshes':
                    attr        = 'NMesh'
                    NMesh       = self.Blender.NMesh
                    names       = NMesh.GetNames()
                    object      = [NMesh.GetRaw(name) for name in names]
                    welcome     = welcome%(l,('is only','are')[len(object)-1],len(object),l[:-1],('','s')[len(object)-1],', '.join(names))
                else:
                    if label in ['Meshes']:
                        attr    = label[:-2]
                    else:
                        attr    = label[:-1]
                    try:
                        object  = getattr(self.Blender,attr).Get()
                    except:
                        object  = []
                        welcome += 'There was an error retrieving the list.'
                    welcome     = welcome%(l,('is only','are')[len(object)-1],len(object),l[:-1],('','s')[len(object)-1],', '.join([str(o) for o in object]))
                label   = 'Blender.%s.Get()'%attr
            self.main.Remove(self.filling)
            self.filling.Destroy()
            self.filling = sm.wxp.SmFilling(parent=self, 
                                   rootObject=object, 
                                   rootLabel=label, 
                                   welcome=welcome,
                                   rootIsNamespace=1)
            self.main.Add(self.filling, 1, wx.ALL | wx.EXPAND, 0)
            self.main.Layout()
            self.filling.SetFocus()
