# generated by wxGlade 0.2 on Sat Dec  7 14:30:59 2002
# $Id: color_dialog.py,v 1.7 2004/05/18 09:27:00 agriggio Exp $

from wxPython.wx import *
#from wxPyColourChooser import wxPyColourChooser
from wxPython.lib.colourchooser import wxPyColourChooser
import misc

class wxGladeColorDialog(wxDialog):
    def __init__(self, colors_dict):
        wxDialog.__init__(self, None, -1, "")
        self.colors_dict = colors_dict
        choices = self.colors_dict.keys()
        choices.sort()
        # begin wxGlade: wxGladeColorDialog.__init__
        self.panel_1 = wxPanel(self, -1)
        self.use_sys_color = wxRadioButton(self.panel_1, -1, "System colour",
                                           style=wxRB_SINGLE)
        self.sys_color = wxComboBox(self.panel_1, -1, choices=choices,
                                    style=wxCB_DROPDOWN|wxCB_READONLY)
        self.use_chooser = wxRadioButton(self.panel_1, -1, "Custom colour",
                                         style=wxRB_SINGLE)
        self.color_chooser = wxPyColourChooser(self, -1)
        self.ok = wxButton(self, wxID_OK, "OK")
        self.cancel = wxButton(self, wxID_CANCEL, "Cancel")

        self.__set_properties()
        self.__do_layout()
        # end wxGlade
        
        EVT_RADIOBUTTON(self, self.use_sys_color.GetId(),
                        self.on_use_sys_color)
        EVT_RADIOBUTTON(self, self.use_chooser.GetId(), self.on_use_chooser)

    def on_use_sys_color(self, event):
        self.sys_color.Enable(True)
        self.color_chooser.Enable(False)
        self.use_chooser.SetValue(0)
        
    def on_use_chooser(self, event):
        self.sys_color.Enable(False)
        self.color_chooser.Enable(True)
        self.use_sys_color.SetValue(0)

    def get_value(self):
        if self.use_sys_color.GetValue():
            return self.sys_color.GetStringSelection()
        else:
            return misc.color_to_string(self.color_chooser.GetValue())

    def set_value(self, value):
        value = value.strip()
        if value in self.colors_dict:
            self.use_sys_color.SetValue(1)
            self.use_chooser.SetValue(0)
            self.sys_color.SetValue(value)
            self.sys_color.Enable(True)
            self.color_chooser.Enable(False)
        else:
            self.use_chooser.SetValue(1)
            self.use_sys_color.SetValue(0)
            try: self.color_chooser.SetValue(misc.string_to_color(value))
            except: pass
            self.sys_color.Enable(False)
            self.color_chooser.Enable(True)

    def __set_properties(self):
        # begin wxGlade: wxGladeColorDialog.__set_properties
        self.SetTitle("Select widget colour")
        self.use_sys_color.SetValue(1)
        self.sys_color.SetSelection(0)
        self.ok.SetDefault()
        # end wxGlade
        self.use_chooser.SetValue(0)
        self.color_chooser.Enable(False)

    def __do_layout(self):
        # begin wxGlade: wxGladeColorDialog.__do_layout
        sizer_1 = wxBoxSizer(wxVERTICAL)
        sizer_3 = wxBoxSizer(wxHORIZONTAL)
        sizer_2 = wxBoxSizer(wxVERTICAL)
        sizer_2.Add(self.use_sys_color, 0, wxLEFT|wxRIGHT|wxTOP|wxEXPAND, 5)
        sizer_2.Add(self.sys_color, 0, wxALL|wxEXPAND, 5)
        static_line_1 = wxStaticLine(self.panel_1, -1)
        sizer_2.Add(static_line_1, 0, wxALL|wxEXPAND, 5)
        sizer_2.Add(self.use_chooser, 0, wxLEFT|wxRIGHT|wxTOP|wxEXPAND, 5)
        self.panel_1.SetAutoLayout(1)
        self.panel_1.SetSizer(sizer_2)
        sizer_2.Fit(self.panel_1)
        sizer_2.SetSizeHints(self.panel_1)
        sizer_1.Add(self.panel_1, 0, wxEXPAND, 0)
        sizer_1.Add(self.color_chooser, 0, wxALL, 5)
        static_line_1_copy = wxStaticLine(self, -1)
        sizer_1.Add(static_line_1_copy, 0, wxALL|wxEXPAND, 5)
        sizer_3.Add(self.ok, 0, wxRIGHT, 13)
        sizer_3.Add(self.cancel, 0, 0, 5)
        sizer_1.Add(sizer_3, 0, wxALL|wxALIGN_RIGHT, 10)
        self.SetAutoLayout(1)
        self.SetSizer(sizer_1)
        sizer_1.Fit(self)
        sizer_1.SetSizeHints(self)
        self.Layout()
        # end wxGlade
        self.CenterOnScreen()

# end of class wxGladeColorDialog

