#!/bin/sh

# I tried: `REP_LOAD_PATH=... exec ...' but solaris /bin/sh won't play along

REP_LOAD_PATH="/usr/local/share/sawfish/1.3/lisp"
export REP_LOAD_PATH

exec rep "$0" "$@"

!#

#| nokogiri-main.jl -- entry point

   $Id: main.jl.in,v 1.12 2003/01/12 20:30:47 jsh Exp $

   Copyright (C) 2000 John Harper <john@dcs.warwick.ac.uk>

   This file is part of sawfish.

   sawfish is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   sawfish is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with sawfish; see the file COPYING.  If not, write to
   the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
|#

(structure ()

    (open rep
	  rep.system
	  rep.io.streams
	  sawfish.gtk.widget
	  sawfish.ui.i18n
	  sawfish.ui.shell
	  sawfish.ui.group)

  (define socket-id nil)

  (when (get-command-line-option "--help")
    (write standard-output "\
usage: sawfish-ui [OPTIONS...]\n
where OPTIONS are any of:\n
  --group=GROUP-NAME
  --flatten
  --single-level
  --socket-id=WINDOW-ID\n")
    (throw 'quit 0))

  (let ((group (get-command-line-option "--group" t)))
    (when group
      (setq group (read-from-string group))
      (set-top-group (if (listp group) group `(root ,group)))))

  ;; XXX remove the "or t" when trees work again
  (when (or t (get-command-line-option "--flatten"))
    (setq *nokogiri-flatten-groups* t))

  (when (get-command-line-option "--single-level")
    (setq *nokogiri-single-level* t))

  (let ((id (get-command-line-option "--socket-id" t)))
    (when id
      (setq socket-id (string->number id))))

  (setq interrupt-mode 'exit)
  (i18n-init)
  (add-widget-prefix 'sawfish.ui.widgets)
  (run-shell socket-id))


;; Local variables:
;; major-mode: lisp-mode
;; End:
