require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_SH_VMPARAM_H_)) {
    eval 'sub _SH_VMPARAM_H_ () {1;}' unless defined(&_SH_VMPARAM_H_);
    require 'sys/queue.ph';
    eval 'sub VM_MIN_ADDRESS () {(( &vaddr_t)0);}' unless defined(&VM_MIN_ADDRESS);
    eval 'sub VM_MAXUSER_ADDRESS () {(( &vaddr_t)0x7ffff000);}' unless defined(&VM_MAXUSER_ADDRESS);
    eval 'sub VM_MAX_ADDRESS () {(( &vaddr_t)0x7ffff000);}' unless defined(&VM_MAX_ADDRESS);
    eval 'sub VM_MIN_KERNEL_ADDRESS () {(( &vaddr_t)0xc0000000);}' unless defined(&VM_MIN_KERNEL_ADDRESS);
    eval 'sub VM_MAX_KERNEL_ADDRESS () {(( &vaddr_t)0xe0000000);}' unless defined(&VM_MAX_KERNEL_ADDRESS);
    eval 'sub USRSTACK () { &VM_MAXUSER_ADDRESS;}' unless defined(&USRSTACK);
    eval 'sub KERNBASE () { &VM_MIN_KERNEL_ADDRESS;}' unless defined(&KERNBASE);
    eval 'sub MAXTSIZ () {(64* 1024* 1024);}' unless defined(&MAXTSIZ);
    unless(defined(&MAXDSIZ)) {
	eval 'sub MAXDSIZ () {(512* 1024* 1024);}' unless defined(&MAXDSIZ);
    }
    unless(defined(&MAXSSIZ)) {
	eval 'sub MAXSSIZ () {(32* 1024* 1024);}' unless defined(&MAXSSIZ);
    }
    unless(defined(&DFLDSIZ)) {
	eval 'sub DFLDSIZ () {(128* 1024* 1024);}' unless defined(&DFLDSIZ);
    }
    unless(defined(&DFLSSIZ)) {
	eval 'sub DFLSSIZ () {(2* 1024* 1024);}' unless defined(&DFLSSIZ);
    }
    eval 'sub STACKGAP_RANDOM () {(256* 1024);}' unless defined(&STACKGAP_RANDOM);
    unless(defined(&SHMMAXPGS)) {
	eval 'sub SHMMAXPGS () {1024;}' unless defined(&SHMMAXPGS);
    }
    unless(defined(&USRIOSIZE)) {
	eval 'sub USRIOSIZE () {( &MAXBSIZE /  &PAGE_SIZE * 8);}' unless defined(&USRIOSIZE);
    }
    eval 'sub VM_PHYS_SIZE () {( &USRIOSIZE *  &PAGE_SIZE);}' unless defined(&VM_PHYS_SIZE);
    eval 'sub __HAVE_VM_PAGE_MD () {1;}' unless defined(&__HAVE_VM_PAGE_MD);
    eval 'sub PVH_REFERENCED () {1;}' unless defined(&PVH_REFERENCED);
    eval 'sub PVH_MODIFIED () {2;}' unless defined(&PVH_MODIFIED);
    unless(defined(&_LOCORE)) {
	eval 'sub VM_MDPAGE_INIT {
	    my($pg) = @_;
    	    eval q( &do { \'struct vm_page_md\' * &pvh = ($pg)-> &mdpage;  &SLIST_INIT( ($pvh->{pvh_head}));  ($pvh->{pvh_flags}) = 0; }  &while ( 0));
	}' unless defined(&VM_MDPAGE_INIT);
    }
}
1;
