require '_h2ph_pre.ph';

no warnings 'redefine';

require 'sys/types.ph';
require 'sys/audioio.ph';
unless(defined(&HDA_GCAP)) {
    sub HDA_GCAP () {	0x;}
}
unless(defined(&HDA_GCAP_OSS)) {
    sub HDA_GCAP_OSS {
	my($x) = @_;
	eval q((($x & 0xf000) >> 12));
    }
}
unless(defined(&HDA_GCAP_ISS)) {
    sub HDA_GCAP_ISS {
	my($x) = @_;
	eval q((($x & 0xf00) >> 8));
    }
}
unless(defined(&HDA_GCAP_BSS)) {
    sub HDA_GCAP_BSS {
	my($x) = @_;
	eval q((($x & 0xf8) >> 3));
    }
}
unless(defined(&HDA_GCAP_NSDO_MASK)) {
    sub HDA_GCAP_NSDO_MASK () {	0x6;}
}
unless(defined(&HDA_GCAP_NSDO_1)) {
    sub HDA_GCAP_NSDO_1 () {	0x;}
}
unless(defined(&HDA_GCAP_NSDO_2)) {
    sub HDA_GCAP_NSDO_2 () {	0x2;}
}
unless(defined(&HDA_GCAP_NSDO_4)) {
    sub HDA_GCAP_NSDO_4 () {	0x4;}
}
unless(defined(&HDA_GCAP_NSDO_RESERVED)) {
    sub HDA_GCAP_NSDO_RESERVED () {	0x6;}
}
unless(defined(&HDA_GCAP_64OK)) {
    sub HDA_GCAP_64OK () {	0x1;}
}
unless(defined(&HDA_VMIN)) {
    sub HDA_VMIN () {	0x2;}
}
unless(defined(&HDA_VMAJ)) {
    sub HDA_VMAJ () {	0x3;}
}
unless(defined(&HDA_OUTPAY)) {
    sub HDA_OUTPAY () {	0x4;}
}
unless(defined(&HDA_INPAY)) {
    sub HDA_INPAY () {	0x6;}
}
unless(defined(&HDA_GCTL)) {
    sub HDA_GCTL () {	0x8;}
}
unless(defined(&HDA_GCTL_UNSOL)) {
    sub HDA_GCTL_UNSOL () {	0x80;}
}
unless(defined(&HDA_GCTL_FCNTRL)) {
    sub HDA_GCTL_FCNTRL () {	0x2;}
}
unless(defined(&HDA_GCTL_CRST)) {
    sub HDA_GCTL_CRST () {	0x1;}
}
unless(defined(&HDA_WAKEEN)) {
    sub HDA_WAKEEN () {	0xc;}
}
unless(defined(&HDA_WAKEEN_SDIWEN)) {
    sub HDA_WAKEEN_SDIWEN () {	0x7fff;}
}
unless(defined(&HDA_STATESTS)) {
    sub HDA_STATESTS () {	0xe;}
}
unless(defined(&HDA_STATESTS_SDIWAKE)) {
    sub HDA_STATESTS_SDIWAKE () {	0x7fff;}
}
unless(defined(&HDA_GSTS)) {
    sub HDA_GSTS () {	0x10;}
}
unless(defined(&HDA_GSTS_FSTS)) {
    sub HDA_GSTS_FSTS () {	0x2;}
}
unless(defined(&HDA_OUTSTRMPAY)) {
    sub HDA_OUTSTRMPAY () {	0x18;}
}
unless(defined(&HDA_INSTRMPAY)) {
    sub HDA_INSTRMPAY () {	0x1a;}
}
unless(defined(&HDA_INTCTL)) {
    sub HDA_INTCTL () {	0x20;}
}
unless(defined(&HDA_INTCTL_GIE)) {
    sub HDA_INTCTL_GIE () {	0x80000000;}
}
unless(defined(&HDA_INTCTL_CIE)) {
    sub HDA_INTCTL_CIE () {	0x40000000;}
}
unless(defined(&HDA_INTCTL_SIE)) {
    sub HDA_INTCTL_SIE () {	0x3fffffff;}
}
unless(defined(&HDA_INTSTS)) {
    sub HDA_INTSTS () {	0x24;}
}
unless(defined(&HDA_INTSTS_GIS)) {
    sub HDA_INTSTS_GIS () {	0x80000000;}
}
unless(defined(&HDA_INTSTS_CIS)) {
    sub HDA_INTSTS_CIS () {	0x40000000;}
}
unless(defined(&HDA_INTSTS_SIS)) {
    sub HDA_INTSTS_SIS () {	0x3fffffff;}
}
unless(defined(&HDA_WALCLK)) {
    sub HDA_WALCLK () {	0x30;}
}
unless(defined(&HDA_SSYNC)) {
    sub HDA_SSYNC () {	0x34;}
}
unless(defined(&HDA_SSYNC_SSYNC)) {
    sub HDA_SSYNC_SSYNC () {	0x3fffffff;}
}
unless(defined(&HDA_CORBLBASE)) {
    sub HDA_CORBLBASE () {	0x40;}
}
unless(defined(&HDA_CORBUBASE)) {
    sub HDA_CORBUBASE () {	0x44;}
}
unless(defined(&HDA_CORBWP)) {
    sub HDA_CORBWP () {	0x48;}
}
unless(defined(&HDA_CORBWP_CORBWP)) {
    sub HDA_CORBWP_CORBWP () {	0xff;}
}
unless(defined(&HDA_CORBRP)) {
    sub HDA_CORBRP () {	0x4a;}
}
unless(defined(&HDA_CORBRP_CORBRPRST)) {
    sub HDA_CORBRP_CORBRPRST () {	0x8000;}
}
unless(defined(&HDA_CORBRP_CORBRP)) {
    sub HDA_CORBRP_CORBRP () {	0xff;}
}
unless(defined(&HDA_CORBCTL)) {
    sub HDA_CORBCTL () {	0x4c;}
}
unless(defined(&HDA_CORBCTL_CORBRUN)) {
    sub HDA_CORBCTL_CORBRUN () {	0x2;}
}
unless(defined(&HDA_CORBCTL_CMEIE)) {
    sub HDA_CORBCTL_CMEIE () {	0x1;}
}
unless(defined(&HDA_CORBSTS)) {
    sub HDA_CORBSTS () {	0x4d;}
}
unless(defined(&HDA_CORBSTS_CMEI)) {
    sub HDA_CORBSTS_CMEI () {	0x1;}
}
unless(defined(&HDA_CORBSIZE)) {
    sub HDA_CORBSIZE () {	0x4e;}
}
unless(defined(&HDA_CORBSIZE_CORBSZCAP_MASK)) {
    sub HDA_CORBSIZE_CORBSZCAP_MASK () {	0xf0;}
}
unless(defined(&HDA_CORBSIZE_CORBSZCAP_2)) {
    sub HDA_CORBSIZE_CORBSZCAP_2 () {	0x10;}
}
unless(defined(&HDA_CORBSIZE_CORBSZCAP_16)) {
    sub HDA_CORBSIZE_CORBSZCAP_16 () {	0x20;}
}
unless(defined(&HDA_CORBSIZE_CORBSZCAP_256)) {
    sub HDA_CORBSIZE_CORBSZCAP_256 () {	0x40;}
}
unless(defined(&HDA_CORBSIZE_CORBSIZE_MASK)) {
    sub HDA_CORBSIZE_CORBSIZE_MASK () {	0x3;}
}
unless(defined(&HDA_CORBSIZE_CORBSIZE_2)) {
    sub HDA_CORBSIZE_CORBSIZE_2 () {	0x;}
}
unless(defined(&HDA_CORBSIZE_CORBSIZE_16)) {
    sub HDA_CORBSIZE_CORBSIZE_16 () {	0x1;}
}
unless(defined(&HDA_CORBSIZE_CORBSIZE_256)) {
    sub HDA_CORBSIZE_CORBSIZE_256 () {	0x2;}
}
unless(defined(&HDA_RIRBLBASE)) {
    sub HDA_RIRBLBASE () {	0x50;}
}
unless(defined(&HDA_RIRBUBASE)) {
    sub HDA_RIRBUBASE () {	0x54;}
}
unless(defined(&HDA_RIRBWP)) {
    sub HDA_RIRBWP () {	0x58;}
}
unless(defined(&HDA_RIRBWP_RIRBWPRST)) {
    sub HDA_RIRBWP_RIRBWPRST () {	0x8000;}
}
unless(defined(&HDA_RIRBWP_RIRBWP)) {
    sub HDA_RIRBWP_RIRBWP () {	0xff;}
}
unless(defined(&HDA_RINTCNT)) {
    sub HDA_RINTCNT () {	0x5a;}
}
unless(defined(&HDA_RINTCNT_RINTCNT)) {
    sub HDA_RINTCNT_RINTCNT () {	0xff;}
}
unless(defined(&HDA_RIRBCTL)) {
    sub HDA_RIRBCTL () {	0x5c;}
}
unless(defined(&HDA_RIRBCTL_RIRBOIC)) {
    sub HDA_RIRBCTL_RIRBOIC () {	0x4;}
}
unless(defined(&HDA_RIRBCTL_RIRBDMAEN)) {
    sub HDA_RIRBCTL_RIRBDMAEN () {	0x2;}
}
unless(defined(&HDA_RIRBCTL_RINTCTL)) {
    sub HDA_RIRBCTL_RINTCTL () {	0x1;}
}
unless(defined(&HDA_RIRBSTS)) {
    sub HDA_RIRBSTS () {	0x5d;}
}
unless(defined(&HDA_RIRBSTS_RIRBOIS)) {
    sub HDA_RIRBSTS_RIRBOIS () {	0x4;}
}
unless(defined(&HDA_RIRBSTS_RINTFL)) {
    sub HDA_RIRBSTS_RINTFL () {	0x1;}
}
unless(defined(&HDA_RIRBSIZE)) {
    sub HDA_RIRBSIZE () {	0x5e;}
}
unless(defined(&HDA_RIRBSIZE_RIRBSZCAP_MASK)) {
    sub HDA_RIRBSIZE_RIRBSZCAP_MASK () {	0xf0;}
}
unless(defined(&HDA_RIRBSIZE_RIRBSZCAP_2)) {
    sub HDA_RIRBSIZE_RIRBSZCAP_2 () {	0x10;}
}
unless(defined(&HDA_RIRBSIZE_RIRBSZCAP_16)) {
    sub HDA_RIRBSIZE_RIRBSZCAP_16 () {	0x20;}
}
unless(defined(&HDA_RIRBSIZE_RIRBSZCAP_256)) {
    sub HDA_RIRBSIZE_RIRBSZCAP_256 () {	0x40;}
}
unless(defined(&HDA_RIRBSIZE_RIRBSIZE_MASK)) {
    sub HDA_RIRBSIZE_RIRBSIZE_MASK () {	0x3;}
}
unless(defined(&HDA_RIRBSIZE_RIRBSIZE_2)) {
    sub HDA_RIRBSIZE_RIRBSIZE_2 () {	0x;}
}
unless(defined(&HDA_RIRBSIZE_RIRBSIZE_16)) {
    sub HDA_RIRBSIZE_RIRBSIZE_16 () {	0x1;}
}
unless(defined(&HDA_RIRBSIZE_RIRBSIZE_256)) {
    sub HDA_RIRBSIZE_RIRBSIZE_256 () {	0x2;}
}
unless(defined(&HDA_IC)) {
    sub HDA_IC () {	0x60;}
}
unless(defined(&HDA_IR)) {
    sub HDA_IR () {	0x64;}
}
unless(defined(&HDA_IRS)) {
    sub HDA_IRS () {	0x68;}
}
unless(defined(&HDA_IRS_IRRADD)) {
    sub HDA_IRS_IRRADD () {	0xf0;}
}
unless(defined(&HDA_IRS_IRRUNSOL)) {
    sub HDA_IRS_IRRUNSOL () {	0x8;}
}
unless(defined(&HDA_IRS_IRV)) {
    sub HDA_IRS_IRV () {	0x2;}
}
unless(defined(&HDA_IRS_ICB)) {
    sub HDA_IRS_ICB () {	0x1;}
}
unless(defined(&HDA_DPLBASE)) {
    sub HDA_DPLBASE () {	0x70;}
}
unless(defined(&HDA_DPLBASE_DPLBASE)) {
    sub HDA_DPLBASE_DPLBASE () {	0xffffff80;}
}
unless(defined(&HDA_DPLBASE_ENABLE)) {
    sub HDA_DPLBASE_ENABLE () {	0x1;}
}
unless(defined(&HDA_DPUBASE)) {
    sub HDA_DPUBASE () {	0x74;}
}
unless(defined(&HDA_SD_BASE)) {
    sub HDA_SD_BASE () {	0x80;}
}
unless(defined(&HDA_SD_CTL)) {
    sub HDA_SD_CTL () {	0x;}
}
unless(defined(&HDA_SD_CTL_DEIE)) {
    sub HDA_SD_CTL_DEIE () {	0x10;}
}
unless(defined(&HDA_SD_CTL_FEIE)) {
    sub HDA_SD_CTL_FEIE () {	0x8;}
}
unless(defined(&HDA_SD_CTL_IOCE)) {
    sub HDA_SD_CTL_IOCE () {	0x4;}
}
unless(defined(&HDA_SD_CTL_RUN)) {
    sub HDA_SD_CTL_RUN () {	0x2;}
}
unless(defined(&HDA_SD_CTL_SRST)) {
    sub HDA_SD_CTL_SRST () {	0x1;}
}
unless(defined(&HDA_SD_CTL2)) {
    sub HDA_SD_CTL2 () {	0x2;}
}
unless(defined(&HDA_SD_CTL2_STRM)) {
    sub HDA_SD_CTL2_STRM () {	0xf0;}
}
unless(defined(&HDA_SD_CTL2_STRM_SHIFT)) {
    sub HDA_SD_CTL2_STRM_SHIFT () {	4;}
}
unless(defined(&HDA_SD_CTL2_DIR)) {
    sub HDA_SD_CTL2_DIR () {	0x8;}
}
unless(defined(&HDA_SD_CTL2_TP)) {
    sub HDA_SD_CTL2_TP () {	0x4;}
}
unless(defined(&HDA_SD_CTL2_STRIPE)) {
    sub HDA_SD_CTL2_STRIPE () {	0x3;}
}
unless(defined(&HDA_SD_STS)) {
    sub HDA_SD_STS () {	0x3;}
}
unless(defined(&HDA_SD_STS_FIFORDY)) {
    sub HDA_SD_STS_FIFORDY () {	0x20;}
}
unless(defined(&HDA_SD_STS_DESE)) {
    sub HDA_SD_STS_DESE () {	0x10;}
}
unless(defined(&HDA_SD_STS_FIFOE)) {
    sub HDA_SD_STS_FIFOE () {	0x8;}
}
unless(defined(&HDA_SD_STS_BCIS)) {
    sub HDA_SD_STS_BCIS () {	0x4;}
}
unless(defined(&HDA_SD_LPIB)) {
    sub HDA_SD_LPIB () {	0x4;}
}
unless(defined(&HDA_SD_CBL)) {
    sub HDA_SD_CBL () {	0x8;}
}
unless(defined(&HDA_SD_LVI)) {
    sub HDA_SD_LVI () {	0xc;}
}
unless(defined(&HDA_SD_LVI_LVI)) {
    sub HDA_SD_LVI_LVI () {	0xff;}
}
unless(defined(&HDA_SD_FIFOW)) {
    sub HDA_SD_FIFOW () {	0xe;}
}
unless(defined(&HDA_SD_FIFOS)) {
    sub HDA_SD_FIFOS () {	0x10;}
}
unless(defined(&HDA_SD_FMT)) {
    sub HDA_SD_FMT () {	0x12;}
}
unless(defined(&HDA_SD_FMT_BASE)) {
    sub HDA_SD_FMT_BASE () {	0x4000;}
}
unless(defined(&HDA_SD_FMT_BASE_48)) {
    sub HDA_SD_FMT_BASE_48 () {	0x;}
}
unless(defined(&HDA_SD_FMT_BASE_44)) {
    sub HDA_SD_FMT_BASE_44 () {	0x4000;}
}
unless(defined(&HDA_SD_FMT_MULT)) {
    sub HDA_SD_FMT_MULT () {	0x3800;}
}
unless(defined(&HDA_SD_FMT_MULT_X1)) {
    sub HDA_SD_FMT_MULT_X1 () {	0x;}
}
unless(defined(&HDA_SD_FMT_MULT_X2)) {
    sub HDA_SD_FMT_MULT_X2 () {	0x800;}
}
unless(defined(&HDA_SD_FMT_MULT_X3)) {
    sub HDA_SD_FMT_MULT_X3 () {	0x1000;}
}
unless(defined(&HDA_SD_FMT_MULT_X4)) {
    sub HDA_SD_FMT_MULT_X4 () {	0x1800;}
}
unless(defined(&HDA_SD_FMT_DIV)) {
    sub HDA_SD_FMT_DIV () {	0x700;}
}
unless(defined(&HDA_SD_FMT_DIV_BY1)) {
    sub HDA_SD_FMT_DIV_BY1 () {	0x;}
}
unless(defined(&HDA_SD_FMT_DIV_BY2)) {
    sub HDA_SD_FMT_DIV_BY2 () {	0x100;}
}
unless(defined(&HDA_SD_FMT_DIV_BY3)) {
    sub HDA_SD_FMT_DIV_BY3 () {	0x200;}
}
unless(defined(&HDA_SD_FMT_DIV_BY4)) {
    sub HDA_SD_FMT_DIV_BY4 () {	0x300;}
}
unless(defined(&HDA_SD_FMT_DIV_BY5)) {
    sub HDA_SD_FMT_DIV_BY5 () {	0x400;}
}
unless(defined(&HDA_SD_FMT_DIV_BY6)) {
    sub HDA_SD_FMT_DIV_BY6 () {	0x500;}
}
unless(defined(&HDA_SD_FMT_DIV_BY7)) {
    sub HDA_SD_FMT_DIV_BY7 () {	0x600;}
}
unless(defined(&HDA_SD_FMT_DIV_BY8)) {
    sub HDA_SD_FMT_DIV_BY8 () {	0x700;}
}
unless(defined(&HDA_SD_FMT_BITS)) {
    sub HDA_SD_FMT_BITS () {	0x70;}
}
unless(defined(&HDA_SD_FMT_BITS_8_16)) {
    sub HDA_SD_FMT_BITS_8_16 () {	0x;}
}
unless(defined(&HDA_SD_FMT_BITS_16_16)) {
    sub HDA_SD_FMT_BITS_16_16 () {	0x10;}
}
unless(defined(&HDA_SD_FMT_BITS_20_32)) {
    sub HDA_SD_FMT_BITS_20_32 () {	0x20;}
}
unless(defined(&HDA_SD_FMT_BITS_24_32)) {
    sub HDA_SD_FMT_BITS_24_32 () {	0x30;}
}
unless(defined(&HDA_SD_FMT_BITS_32_32)) {
    sub HDA_SD_FMT_BITS_32_32 () {	0x40;}
}
unless(defined(&HDA_SD_FMT_CHAN)) {
    sub HDA_SD_FMT_CHAN () {	0xf;}
}
unless(defined(&HDA_SD_BDPL)) {
    sub HDA_SD_BDPL () {	0x18;}
}
unless(defined(&HDA_SD_BDPU)) {
    sub HDA_SD_BDPU () {	0x1c;}
}
unless(defined(&HDA_SD_SIZE)) {
    sub HDA_SD_SIZE () {	0x20;}
}
unless(defined(&CORB_GET_PARAMETER)) {
    sub CORB_GET_PARAMETER () {	0xf00;}
}
unless(defined(&COP_VENDOR_ID)) {
    sub COP_VENDOR_ID () {	0x;}
}
unless(defined(&COP_VID_VENDOR)) {
    sub COP_VID_VENDOR {
	my($x) = @_;
	eval q(($x >> 16));
    }
}
unless(defined(&COP_VID_DEVICE)) {
    sub COP_VID_DEVICE {
	my($x) = @_;
	eval q(($x & 0xffff));
    }
}
unless(defined(&COP_REVISION_ID)) {
    sub COP_REVISION_ID () {	0x2;}
}
unless(defined(&COP_RID_MAJ)) {
    sub COP_RID_MAJ {
	my($x) = @_;
	eval q((($x >> 20) & 0xf));
    }
}
unless(defined(&COP_RID_MIN)) {
    sub COP_RID_MIN {
	my($x) = @_;
	eval q((($x >> 16) & 0xf));
    }
}
unless(defined(&COP_RID_REVISION)) {
    sub COP_RID_REVISION {
	my($x) = @_;
	eval q((($x >> 8) & 0xff));
    }
}
unless(defined(&COP_RID_STEPPING)) {
    sub COP_RID_STEPPING {
	my($x) = @_;
	eval q(($x & 0xff));
    }
}
unless(defined(&COP_SUBORDINATE_NODE_COUNT)) {
    sub COP_SUBORDINATE_NODE_COUNT () {	0x4;}
}
unless(defined(&COP_START_NID)) {
    sub COP_START_NID {
	my($x) = @_;
	eval q((($x & 0xff0000) >> 16));
    }
}
unless(defined(&COP_NSUBNODES)) {
    sub COP_NSUBNODES {
	my($x) = @_;
	eval q(($x & 0xff));
    }
}
unless(defined(&COP_FUNCTION_GROUP_TYPE)) {
    sub COP_FUNCTION_GROUP_TYPE () {	0x5;}
}
unless(defined(&COP_FTYPE)) {
    sub COP_FTYPE {
	my($x) = @_;
	eval q(($x & 0xff));
    }
}
unless(defined(&COP_FTYPE_RESERVED)) {
    sub COP_FTYPE_RESERVED () {	0x1;}
}
unless(defined(&COP_FTYPE_AUDIO)) {
    sub COP_FTYPE_AUDIO () {	0x1;}
}
unless(defined(&COP_FTYPE_MODEM)) {
    sub COP_FTYPE_MODEM () {	0x2;}
}
unless(defined(&COP_AUDIO_FUNCTION_GROUP_CAPABILITY)) {
    sub COP_AUDIO_FUNCTION_GROUP_CAPABILITY () {	0x8;}
}
unless(defined(&COP_AUDIO_WIDGET_CAP)) {
    sub COP_AUDIO_WIDGET_CAP () {	0x9;}
}
unless(defined(&COP_AWCAP_TYPE)) {
    sub COP_AWCAP_TYPE {
	my($x) = @_;
	eval q((($x >> 20) & 0xf));
    }
}
unless(defined(&COP_AWTYPE_AUDIO_OUTPUT)) {
    sub COP_AWTYPE_AUDIO_OUTPUT () {	0x;}
}
unless(defined(&COP_AWTYPE_AUDIO_INPUT)) {
    sub COP_AWTYPE_AUDIO_INPUT () {	0x1;}
}
unless(defined(&COP_AWTYPE_AUDIO_MIXER)) {
    sub COP_AWTYPE_AUDIO_MIXER () {	0x2;}
}
unless(defined(&COP_AWTYPE_AUDIO_SELECTOR)) {
    sub COP_AWTYPE_AUDIO_SELECTOR () {	0x3;}
}
unless(defined(&COP_AWTYPE_PIN_COMPLEX)) {
    sub COP_AWTYPE_PIN_COMPLEX () {	0x4;}
}
unless(defined(&COP_AWTYPE_POWER)) {
    sub COP_AWTYPE_POWER () {	0x5;}
}
unless(defined(&COP_AWTYPE_VOLUME_KNOB)) {
    sub COP_AWTYPE_VOLUME_KNOB () {	0x6;}
}
unless(defined(&COP_AWTYPE_BEEP_GENERATOR)) {
    sub COP_AWTYPE_BEEP_GENERATOR () {	0x7;}
}
unless(defined(&COP_AWTYPE_VENDOR_DEFINED)) {
    sub COP_AWTYPE_VENDOR_DEFINED () {	0xf;}
}
unless(defined(&COP_AWCAP_STEREO)) {
    sub COP_AWCAP_STEREO () {	0x1;}
}
unless(defined(&COP_AWCAP_INAMP)) {
    sub COP_AWCAP_INAMP () {	0x2;}
}
unless(defined(&COP_AWCAP_OUTAMP)) {
    sub COP_AWCAP_OUTAMP () {	0x4;}
}
unless(defined(&COP_AWCAP_AMPOV)) {
    sub COP_AWCAP_AMPOV () {	0x8;}
}
unless(defined(&COP_AWCAP_FORMATOV)) {
    sub COP_AWCAP_FORMATOV () {	0x10;}
}
unless(defined(&COP_AWCAP_STRIPE)) {
    sub COP_AWCAP_STRIPE () {	0x20;}
}
unless(defined(&COP_AWCAP_PROC)) {
    sub COP_AWCAP_PROC () {	0x40;}
}
unless(defined(&COP_AWCAP_UNSOL)) {
    sub COP_AWCAP_UNSOL () {	0x80;}
}
unless(defined(&COP_AWCAP_CONNLIST)) {
    sub COP_AWCAP_CONNLIST () {	0x100;}
}
unless(defined(&COP_AWCAP_DIGITAL)) {
    sub COP_AWCAP_DIGITAL () {	0x200;}
}
unless(defined(&COP_AWCAP_POWER)) {
    sub COP_AWCAP_POWER () {	0x400;}
}
unless(defined(&COP_AWCAP_LRSWAP)) {
    sub COP_AWCAP_LRSWAP () {	0x800;}
}
unless(defined(&COP_AWCAP_DELAY)) {
    sub COP_AWCAP_DELAY {
	my($x) = @_;
	eval q((($x >> 16) & 0xf));
    }
}
unless(defined(&COP_PCM)) {
    sub COP_PCM () {	0xa;}
}
unless(defined(&COP_PCM_B32)) {
    sub COP_PCM_B32 () {	0x100000;}
}
unless(defined(&COP_PCM_B24)) {
    sub COP_PCM_B24 () {	0x80000;}
}
unless(defined(&COP_PCM_B20)) {
    sub COP_PCM_B20 () {	0x40000;}
}
unless(defined(&COP_PCM_B16)) {
    sub COP_PCM_B16 () {	0x20000;}
}
unless(defined(&COP_PCM_B8)) {
    sub COP_PCM_B8 () {	0x10000;}
}
unless(defined(&COP_PCM_R3840)) {
    sub COP_PCM_R3840 () {	0x800;}
}
unless(defined(&COP_PCM_R1920)) {
    sub COP_PCM_R1920 () {	0x400;}
}
unless(defined(&COP_PCM_R1764)) {
    sub COP_PCM_R1764 () {	0x200;}
}
unless(defined(&COP_PCM_R960)) {
    sub COP_PCM_R960 () {	0x100;}
}
unless(defined(&COP_PCM_R882)) {
    sub COP_PCM_R882 () {	0x80;}
}
unless(defined(&COP_PCM_R480)) {
    sub COP_PCM_R480 () {	0x40;}
}
unless(defined(&COP_PCM_R441)) {
    sub COP_PCM_R441 () {	0x20;}
}
unless(defined(&COP_PCM_R320)) {
    sub COP_PCM_R320 () {	0x10;}
}
unless(defined(&COP_PCM_R220)) {
    sub COP_PCM_R220 () {	0x8;}
}
unless(defined(&COP_PCM_R160)) {
    sub COP_PCM_R160 () {	0x4;}
}
unless(defined(&COP_PCM_R110)) {
    sub COP_PCM_R110 () {	0x2;}
}
unless(defined(&COP_PCM_R80)) {
    sub COP_PCM_R80 () {	0x1;}
}
unless(defined(&COP_STREAM_FORMATS)) {
    sub COP_STREAM_FORMATS () {	0xb;}
}
unless(defined(&COP_STREAM_FORMAT_PCM)) {
    sub COP_STREAM_FORMAT_PCM () {	0x1;}
}
unless(defined(&COP_STREAM_FORMAT_FLOAT32)) {
    sub COP_STREAM_FORMAT_FLOAT32 () {	0x2;}
}
unless(defined(&COP_STREAM_FORMAT_AC3)) {
    sub COP_STREAM_FORMAT_AC3 () {	0x3;}
}
unless(defined(&COP_PINCAP)) {
    sub COP_PINCAP () {	0xc;}
}
unless(defined(&COP_PINCAP_IMPEDANCE)) {
    sub COP_PINCAP_IMPEDANCE () {	0x1;}
}
unless(defined(&COP_PINCAP_TRIGGER)) {
    sub COP_PINCAP_TRIGGER () {	0x2;}
}
unless(defined(&COP_PINCAP_PRESENCE)) {
    sub COP_PINCAP_PRESENCE () {	0x4;}
}
unless(defined(&COP_PINCAP_HEADPHONE)) {
    sub COP_PINCAP_HEADPHONE () {	0x8;}
}
unless(defined(&COP_PINCAP_OUTPUT)) {
    sub COP_PINCAP_OUTPUT () {	0x10;}
}
unless(defined(&COP_PINCAP_INPUT)) {
    sub COP_PINCAP_INPUT () {	0x20;}
}
unless(defined(&COP_PINCAP_BALANCE)) {
    sub COP_PINCAP_BALANCE () {	0x40;}
}
unless(defined(&COP_PINCAP_VREF)) {
    sub COP_PINCAP_VREF {
	my($x) = @_;
	eval q((($x >> 8) & 0xff));
    }
}
unless(defined(&COP_PINCAP_EAPD)) {
    sub COP_PINCAP_EAPD () {	0x10000;}
}
unless(defined(&COP_INPUT_AMPCAP)) {
    sub COP_INPUT_AMPCAP () {	0xd;}
}
unless(defined(&COP_AMPCAP_OFFSET)) {
    sub COP_AMPCAP_OFFSET {
	my($x) = @_;
	eval q(($x & 0x7f));
    }
}
unless(defined(&COP_AMPCAP_NUMSTEPS)) {
    sub COP_AMPCAP_NUMSTEPS {
	my($x) = @_;
	eval q((($x >> 8) & 0x7f));
    }
}
unless(defined(&COP_AMPCAP_STEPSIZE)) {
    sub COP_AMPCAP_STEPSIZE {
	my($x) = @_;
	eval q((($x >> 16) & 0x7f));
    }
}
unless(defined(&COP_AMPCAP_MUTE)) {
    sub COP_AMPCAP_MUTE () {	0x80000000;}
}
unless(defined(&COP_CONNECTION_LIST_LENGTH)) {
    sub COP_CONNECTION_LIST_LENGTH () {	0xe;}
}
unless(defined(&COP_CLL_LONG)) {
    sub COP_CLL_LONG () {	0x80;}
}
unless(defined(&COP_CLL_LENGTH)) {
    sub COP_CLL_LENGTH {
	my($x) = @_;
	eval q(($x & 0x7f));
    }
}
unless(defined(&COP_SUPPORTED_POWER_STATES)) {
    sub COP_SUPPORTED_POWER_STATES () {	0xf;}
}
unless(defined(&COP_PROCESSING_CAPABILITIES)) {
    sub COP_PROCESSING_CAPABILITIES () {	0x10;}
}
unless(defined(&COP_GPIO_COUNT)) {
    sub COP_GPIO_COUNT () {	0x11;}
}
unless(defined(&COP_OUTPUT_AMPCAP)) {
    sub COP_OUTPUT_AMPCAP () {	0x12;}
}
unless(defined(&COP_VOLUME_KNOB_CAPABILITIES)) {
    sub COP_VOLUME_KNOB_CAPABILITIES () {	0x13;}
}
unless(defined(&COP_VKCAP_DELTA)) {
    sub COP_VKCAP_DELTA () {	0x80;}
}
unless(defined(&COP_VKCAP_NUMSTEPS)) {
    sub COP_VKCAP_NUMSTEPS {
	my($x) = @_;
	eval q(($x & 0x7f));
    }
}
unless(defined(&CORB_GET_CONNECTION_SELECT_CONTROL)) {
    sub CORB_GET_CONNECTION_SELECT_CONTROL () {	0xf01;}
}
unless(defined(&CORB_CSC_INDEX)) {
    sub CORB_CSC_INDEX {
	my($x) = @_;
	eval q(($x & 0xff));
    }
}
unless(defined(&CORB_SET_CONNECTION_SELECT_CONTROL)) {
    sub CORB_SET_CONNECTION_SELECT_CONTROL () {	0x701;}
}
unless(defined(&CORB_GET_CONNECTION_LIST_ENTRY)) {
    sub CORB_GET_CONNECTION_LIST_ENTRY () {	0xf02;}
}
unless(defined(&CORB_CLE_LONG_0)) {
    sub CORB_CLE_LONG_0 {
	my($x) = @_;
	eval q(($x & 0xffff));
    }
}
unless(defined(&CORB_CLE_LONG_1)) {
    sub CORB_CLE_LONG_1 {
	my($x) = @_;
	eval q((($x & 0xffff0000) >> 16));
    }
}
unless(defined(&CORB_CLE_SHORT_0)) {
    sub CORB_CLE_SHORT_0 {
	my($x) = @_;
	eval q(($x & 0xff));
    }
}
unless(defined(&CORB_CLE_SHORT_1)) {
    sub CORB_CLE_SHORT_1 {
	my($x) = @_;
	eval q((($x >> 8) & 0xff));
    }
}
unless(defined(&CORB_CLE_SHORT_2)) {
    sub CORB_CLE_SHORT_2 {
	my($x) = @_;
	eval q((($x >> 16) & 0xff));
    }
}
unless(defined(&CORB_CLE_SHORT_3)) {
    sub CORB_CLE_SHORT_3 {
	my($x) = @_;
	eval q((($x >> 24) & 0xff));
    }
}
unless(defined(&CORB_GET_PROCESSING_STATE)) {
    sub CORB_GET_PROCESSING_STATE () {	0xf03;}
}
unless(defined(&CORB_SET_PROCESSING_STATE)) {
    sub CORB_SET_PROCESSING_STATE () {	0x703;}
}
unless(defined(&CORB_GET_COEFFICIENT_INDEX)) {
    sub CORB_GET_COEFFICIENT_INDEX () {	0xd00;}
}
unless(defined(&CORB_SET_COEFFICIENT_INDEX)) {
    sub CORB_SET_COEFFICIENT_INDEX () {	0x500;}
}
unless(defined(&CORB_GET_PROCESSING_COEFFICIENT)) {
    sub CORB_GET_PROCESSING_COEFFICIENT () {	0xc00;}
}
unless(defined(&CORB_SET_PROCESSING_COEFFICIENT)) {
    sub CORB_SET_PROCESSING_COEFFICIENT () {	0x400;}
}
unless(defined(&CORB_GET_AMPLIFIER_GAIN_MUTE)) {
    sub CORB_GET_AMPLIFIER_GAIN_MUTE () {	0xb00;}
}
unless(defined(&CORB_GAGM_INPUT)) {
    sub CORB_GAGM_INPUT () {	0x;}
}
unless(defined(&CORB_GAGM_OUTPUT)) {
    sub CORB_GAGM_OUTPUT () {	0x8000;}
}
unless(defined(&CORB_GAGM_RIGHT)) {
    sub CORB_GAGM_RIGHT () {	0x;}
}
unless(defined(&CORB_GAGM_LEFT)) {
    sub CORB_GAGM_LEFT () {	0x2000;}
}
unless(defined(&CORB_GAGM_MUTE)) {
    sub CORB_GAGM_MUTE () {	0x80;}
}
unless(defined(&CORB_GAGM_GAIN)) {
    sub CORB_GAGM_GAIN {
	my($x) = @_;
	eval q(($x & 0x7f));
    }
}
unless(defined(&CORB_SET_AMPLIFIER_GAIN_MUTE)) {
    sub CORB_SET_AMPLIFIER_GAIN_MUTE () {	0x300;}
}
unless(defined(&CORB_AGM_GAIN_MASK)) {
    sub CORB_AGM_GAIN_MASK () {	0x7f;}
}
unless(defined(&CORB_AGM_MUTE)) {
    sub CORB_AGM_MUTE () {	0x80;}
}
unless(defined(&CORB_AGM_INDEX_SHIFT)) {
    sub CORB_AGM_INDEX_SHIFT () {	8;}
}
unless(defined(&CORB_AGM_RIGHT)) {
    sub CORB_AGM_RIGHT () {	0x1000;}
}
unless(defined(&CORB_AGM_LEFT)) {
    sub CORB_AGM_LEFT () {	0x2000;}
}
unless(defined(&CORB_AGM_INPUT)) {
    sub CORB_AGM_INPUT () {	0x4000;}
}
unless(defined(&CORB_AGM_OUTPUT)) {
    sub CORB_AGM_OUTPUT () {	0x8000;}
}
unless(defined(&CORB_GET_CONVERTER_FORMAT)) {
    sub CORB_GET_CONVERTER_FORMAT () {	0xa00;}
}
unless(defined(&CORB_SET_CONVERTER_FORMAT)) {
    sub CORB_SET_CONVERTER_FORMAT () {	0x200;}
}
unless(defined(&CORB_GET_DIGITAL_CONVERTER_CONTROL)) {
    sub CORB_GET_DIGITAL_CONVERTER_CONTROL () {	0xf0d;}
}
unless(defined(&CORB_SET_DIGITAL_CONVERTER_CONTROL_L)) {
    sub CORB_SET_DIGITAL_CONVERTER_CONTROL_L () {	0x70d;}
}
unless(defined(&CORB_SET_DIGITAL_CONVERTER_CONTROL_H)) {
    sub CORB_SET_DIGITAL_CONVERTER_CONTROL_H () {	0x70e;}
}
unless(defined(&CORB_GET_POWER_STATE)) {
    sub CORB_GET_POWER_STATE () {	0xf05;}
}
unless(defined(&CORB_SET_POWER_STATE)) {
    sub CORB_SET_POWER_STATE () {	0x705;}
}
unless(defined(&CORB_PS_D0)) {
    sub CORB_PS_D0 () {	0x;}
}
unless(defined(&CORB_PS_D1)) {
    sub CORB_PS_D1 () {	0x1;}
}
unless(defined(&CORB_PS_D2)) {
    sub CORB_PS_D2 () {	0x2;}
}
unless(defined(&CORB_PS_D3)) {
    sub CORB_PS_D3 () {	0x3;}
}
unless(defined(&CORB_GET_CONVERTER_STREAM_CHANNEL)) {
    sub CORB_GET_CONVERTER_STREAM_CHANNEL () {	0xf06;}
}
unless(defined(&CORB_SET_CONVERTER_STREAM_CHANNEL)) {
    sub CORB_SET_CONVERTER_STREAM_CHANNEL () {	0x706;}
}
unless(defined(&CORB_GET_INPUT_CONVERTER_SDI_SELECT)) {
    sub CORB_GET_INPUT_CONVERTER_SDI_SELECT () {	0xf04;}
}
unless(defined(&CORB_SET_INPUT_CONVERTER_SDI_SELECT)) {
    sub CORB_SET_INPUT_CONVERTER_SDI_SELECT () {	0x704;}
}
unless(defined(&CORB_GET_PIN_WIDGET_CONTROL)) {
    sub CORB_GET_PIN_WIDGET_CONTROL () {	0xf07;}
}
unless(defined(&CORB_SET_PIN_WIDGET_CONTROL)) {
    sub CORB_SET_PIN_WIDGET_CONTROL () {	0x707;}
}
unless(defined(&CORB_PWC_HEADPHONE)) {
    sub CORB_PWC_HEADPHONE () {	0x80;}
}
unless(defined(&CORB_PWC_OUTPUT)) {
    sub CORB_PWC_OUTPUT () {	0x40;}
}
unless(defined(&CORB_PWC_INPUT)) {
    sub CORB_PWC_INPUT () {	0x20;}
}
unless(defined(&CORB_PWC_VREF_HIZ)) {
    sub CORB_PWC_VREF_HIZ () {	0x;}
}
unless(defined(&CORB_PWC_VREF_50)) {
    sub CORB_PWC_VREF_50 () {	0x1;}
}
unless(defined(&CORB_PWC_VREF_GND)) {
    sub CORB_PWC_VREF_GND () {	0x2;}
}
unless(defined(&CORB_PWC_VREF_80)) {
    sub CORB_PWC_VREF_80 () {	0x4;}
}
unless(defined(&CORB_PWC_VREF_100)) {
    sub CORB_PWC_VREF_100 () {	0x5;}
}
unless(defined(&CORB_GET_UNSOLICITED_RESPONSE)) {
    sub CORB_GET_UNSOLICITED_RESPONSE () {	0xf08;}
}
unless(defined(&CORB_SET_UNSOLICITED_RESPONSE)) {
    sub CORB_SET_UNSOLICITED_RESPONSE () {	0x708;}
}
unless(defined(&CORB_UNSOL_ENABLE)) {
    sub CORB_UNSOL_ENABLE () {	0x80;}
}
unless(defined(&CORB_UNSOL_TAG)) {
    sub CORB_UNSOL_TAG {
	my($x) = @_;
	eval q(($x & 0x3f));
    }
}
unless(defined(&CORB_GET_PIN_SENSE)) {
    sub CORB_GET_PIN_SENSE () {	0xf09;}
}
unless(defined(&CORB_PS_PRESENSE)) {
    sub CORB_PS_PRESENSE () {	0x80000000;}
}
unless(defined(&CORB_PS_IMPEDANCE)) {
    sub CORB_PS_IMPEDANCE {
	my($x) = @_;
	eval q(($x & 0x7fffffff));
    }
}
unless(defined(&CORB_EXECUTE_PIN_SENSE)) {
    sub CORB_EXECUTE_PIN_SENSE () {	0x709;}
}
unless(defined(&CORB_PS_RIGHT)) {
    sub CORB_PS_RIGHT () {	0x1;}
}
unless(defined(&CORB_GET_EAPD_BTL_ENABLE)) {
    sub CORB_GET_EAPD_BTL_ENABLE () {	0xf0c;}
}
unless(defined(&CORB_SET_EAPD_BTL_ENABLE)) {
    sub CORB_SET_EAPD_BTL_ENABLE () {	0x70c;}
}
unless(defined(&CORB_GET_GPI_DATA)) {
    sub CORB_GET_GPI_DATA () {	0xf10;}
}
unless(defined(&CORB_SET_GPI_DATA)) {
    sub CORB_SET_GPI_DATA () {	0x710;}
}
unless(defined(&CORB_GET_GPI_WAKE_ENABLE_MASK)) {
    sub CORB_GET_GPI_WAKE_ENABLE_MASK () {	0xf11;}
}
unless(defined(&CORB_SET_GPI_WAKE_ENABLE_MASK)) {
    sub CORB_SET_GPI_WAKE_ENABLE_MASK () {	0x711;}
}
unless(defined(&CORB_GET_GPI_UNSOLICITED_ENABLE_MASK)) {
    sub CORB_GET_GPI_UNSOLICITED_ENABLE_MASK () {	0xf12;}
}
unless(defined(&CORB_SET_GPI_UNSOLICITED_ENABLE_MASK)) {
    sub CORB_SET_GPI_UNSOLICITED_ENABLE_MASK () {	0x712;}
}
unless(defined(&CORB_GET_GPI_STICKY_MASK)) {
    sub CORB_GET_GPI_STICKY_MASK () {	0xf13;}
}
unless(defined(&CORB_SET_GPI_STICKY_MASK)) {
    sub CORB_SET_GPI_STICKY_MASK () {	0x713;}
}
unless(defined(&CORB_GET_GPO_DATA)) {
    sub CORB_GET_GPO_DATA () {	0xf14;}
}
unless(defined(&CORB_SET_GPO_DATA)) {
    sub CORB_SET_GPO_DATA () {	0x714;}
}
unless(defined(&CORB_GET_GPIO_DATA)) {
    sub CORB_GET_GPIO_DATA () {	0xf15;}
}
unless(defined(&CORB_SET_GPIO_DATA)) {
    sub CORB_SET_GPIO_DATA () {	0x715;}
}
unless(defined(&CORB_GET_GPIO_ENABLE_MASK)) {
    sub CORB_GET_GPIO_ENABLE_MASK () {	0xf16;}
}
unless(defined(&CORB_SET_GPIO_ENABLE_MASK)) {
    sub CORB_SET_GPIO_ENABLE_MASK () {	0x716;}
}
unless(defined(&CORB_GET_GPIO_DIRECTION)) {
    sub CORB_GET_GPIO_DIRECTION () {	0xf17;}
}
unless(defined(&CORB_SET_GPIO_DIRECTION)) {
    sub CORB_SET_GPIO_DIRECTION () {	0x717;}
}
unless(defined(&CORB_GET_GPIO_WAKE_ENABLE_MASK)) {
    sub CORB_GET_GPIO_WAKE_ENABLE_MASK () {	0xf18;}
}
unless(defined(&CORB_SET_GPIO_WAKE_ENABLE_MASK)) {
    sub CORB_SET_GPIO_WAKE_ENABLE_MASK () {	0x718;}
}
unless(defined(&CORB_GET_GPIO_UNSOLICITED_ENABLE_MASK)) {
    sub CORB_GET_GPIO_UNSOLICITED_ENABLE_MASK () {	0xf19;}
}
unless(defined(&CORB_SET_GPIO_UNSOLICITED_ENABLE_MASK)) {
    sub CORB_SET_GPIO_UNSOLICITED_ENABLE_MASK () {	0x719;}
}
unless(defined(&CORB_GET_GPIO_STICKY_MASK)) {
    sub CORB_GET_GPIO_STICKY_MASK () {	0xf1a;}
}
unless(defined(&CORB_SET_GPIO_STICKY_MASK)) {
    sub CORB_SET_GPIO_STICKY_MASK () {	0x71a;}
}
unless(defined(&CORB_GET_BEEP_GENERATION)) {
    sub CORB_GET_BEEP_GENERATION () {	0xf0a;}
}
unless(defined(&CORB_SET_BEEP_GENERATION)) {
    sub CORB_SET_BEEP_GENERATION () {	0x70a;}
}
unless(defined(&CORB_GET_VOLUME_KNOB)) {
    sub CORB_GET_VOLUME_KNOB () {	0xf0f;}
}
unless(defined(&CORB_SET_VOLUME_KNOB)) {
    sub CORB_SET_VOLUME_KNOB () {	0x70f;}
}
unless(defined(&CORB_VKNOB_DIRECT)) {
    sub CORB_VKNOB_DIRECT () {	0x80;}
}
unless(defined(&CORB_VKNOB_VOLUME)) {
    sub CORB_VKNOB_VOLUME {
	my($x) = @_;
	eval q(($x & 0x7f));
    }
}
unless(defined(&CORB_GET_SUBSYSTEM_ID)) {
    sub CORB_GET_SUBSYSTEM_ID () {	0xf20;}
}
unless(defined(&CORB_SET_SUBSYSTEM_ID_1)) {
    sub CORB_SET_SUBSYSTEM_ID_1 () {	0x720;}
}
unless(defined(&CORB_SET_SUBSYSTEM_ID_2)) {
    sub CORB_SET_SUBSYSTEM_ID_2 () {	0x721;}
}
unless(defined(&CORB_SET_SUBSYSTEM_ID_3)) {
    sub CORB_SET_SUBSYSTEM_ID_3 () {	0x722;}
}
unless(defined(&CORB_SET_SUBSYSTEM_ID_4)) {
    sub CORB_SET_SUBSYSTEM_ID_4 () {	0x723;}
}
unless(defined(&CORB_GET_CONFIGURATION_DEFAULT)) {
    sub CORB_GET_CONFIGURATION_DEFAULT () {	0xf1c;}
}
unless(defined(&CORB_SET_CONFIGURATION_DEFAULT_1)) {
    sub CORB_SET_CONFIGURATION_DEFAULT_1 () {	0x71c;}
}
unless(defined(&CORB_SET_CONFIGURATION_DEFAULT_2)) {
    sub CORB_SET_CONFIGURATION_DEFAULT_2 () {	0x71d;}
}
unless(defined(&CORB_SET_CONFIGURATION_DEFAULT_3)) {
    sub CORB_SET_CONFIGURATION_DEFAULT_3 () {	0x71e;}
}
unless(defined(&CORB_SET_CONFIGURATION_DEFAULT_4)) {
    sub CORB_SET_CONFIGURATION_DEFAULT_4 () {	0x71f;}
}
unless(defined(&CORB_CD_SEQUENCE)) {
    sub CORB_CD_SEQUENCE {
	my($x) = @_;
	eval q(($x & 0xf));
    }
}
unless(defined(&CORB_CD_SEQUENCE_MAX)) {
    sub CORB_CD_SEQUENCE_MAX () {	0xf;}
}
unless(defined(&CORB_CD_ASSOCIATION)) {
    sub CORB_CD_ASSOCIATION {
	my($x) = @_;
	eval q((($x >> 4) & 0xf));
    }
}
unless(defined(&CORB_CD_ASSOCIATION_MAX)) {
    sub CORB_CD_ASSOCIATION_MAX () {	0xf;}
}
unless(defined(&CORB_CD_MISC_MASK)) {
    sub CORB_CD_MISC_MASK () {	0xf00;}
}
unless(defined(&CORB_CD_COLOR)) {
    sub CORB_CD_COLOR {
	my($x) = @_;
	eval q((($x >> 12) & 0xf));
    }
}
unless(defined(&CORB_CD_COLOR_UNKNOWN)) {
    sub CORB_CD_COLOR_UNKNOWN () {	0x;}
}
unless(defined(&CORB_CD_BLACK)) {
    sub CORB_CD_BLACK () {	0x1;}
}
unless(defined(&CORB_CD_GRAY)) {
    sub CORB_CD_GRAY () {	0x2;}
}
unless(defined(&CORB_CD_BLUE)) {
    sub CORB_CD_BLUE () {	0x3;}
}
unless(defined(&CORB_CD_GREEN)) {
    sub CORB_CD_GREEN () {	0x4;}
}
unless(defined(&CORB_CD_RED)) {
    sub CORB_CD_RED () {	0x5;}
}
unless(defined(&CORB_CD_ORANGE)) {
    sub CORB_CD_ORANGE () {	0x6;}
}
unless(defined(&CORB_CD_YELLOW)) {
    sub CORB_CD_YELLOW () {	0x7;}
}
unless(defined(&CORB_CD_PURPLE)) {
    sub CORB_CD_PURPLE () {	0x8;}
}
unless(defined(&CORB_CD_PINK)) {
    sub CORB_CD_PINK () {	0x9;}
}
unless(defined(&CORB_CD_WHITE)) {
    sub CORB_CD_WHITE () {	0xe;}
}
unless(defined(&CORB_CD_COLOR_OTHER)) {
    sub CORB_CD_COLOR_OTHER () {	0xf;}
}
unless(defined(&CORB_CD_CONNECTION_MASK)) {
    sub CORB_CD_CONNECTION_MASK () {	0xf0000;}
}
unless(defined(&CORB_CD_DEVICE)) {
    sub CORB_CD_DEVICE {
	my($x) = @_;
	eval q((($x >> 20) & 0xf));
    }
}
unless(defined(&CORB_CD_LINEOUT)) {
    sub CORB_CD_LINEOUT () {	0x;}
}
unless(defined(&CORB_CD_SPEAKER)) {
    sub CORB_CD_SPEAKER () {	0x1;}
}
unless(defined(&CORB_CD_HEADPHONE)) {
    sub CORB_CD_HEADPHONE () {	0x2;}
}
unless(defined(&CORB_CD_CD)) {
    sub CORB_CD_CD () {	0x3;}
}
unless(defined(&CORB_CD_SPDIFOUT)) {
    sub CORB_CD_SPDIFOUT () {	0x4;}
}
unless(defined(&CORB_CD_DIGITALOUT)) {
    sub CORB_CD_DIGITALOUT () {	0x5;}
}
unless(defined(&CORB_CD_MODEMLINE)) {
    sub CORB_CD_MODEMLINE () {	0x6;}
}
unless(defined(&CORB_CD_MODEMHANDSET)) {
    sub CORB_CD_MODEMHANDSET () {	0x7;}
}
unless(defined(&CORB_CD_LINEIN)) {
    sub CORB_CD_LINEIN () {	0x8;}
}
unless(defined(&CORB_CD_AUX)) {
    sub CORB_CD_AUX () {	0x9;}
}
unless(defined(&CORB_CD_MICIN)) {
    sub CORB_CD_MICIN () {	0xa;}
}
unless(defined(&CORB_CD_TELEPHONY)) {
    sub CORB_CD_TELEPHONY () {	0xb;}
}
unless(defined(&CORB_CD_SPDIFIN)) {
    sub CORB_CD_SPDIFIN () {	0xc;}
}
unless(defined(&CORB_CD_DIGITALIN)) {
    sub CORB_CD_DIGITALIN () {	0xd;}
}
unless(defined(&CORB_CD_DEVICE_OTHER)) {
    sub CORB_CD_DEVICE_OTHER () {	0xf;}
}
unless(defined(&CORB_CD_LOCATION_MASK)) {
    sub CORB_CD_LOCATION_MASK () {	0x3f000000;}
}
unless(defined(&CORB_CD_PORT_MASK)) {
    sub CORB_CD_PORT_MASK () {	0xc0000000;}
}
unless(defined(&CORB_GET_STRIPE_CONTROL)) {
    sub CORB_GET_STRIPE_CONTROL () {	0xf24;}
}
unless(defined(&CORB_SET_STRIPE_CONTROL)) {
    sub CORB_SET_STRIPE_CONTROL () {	0x720;}
}
unless(defined(&CORB_EXECUTE_FUNCTION_RESET)) {
    sub CORB_EXECUTE_FUNCTION_RESET () {	0x7ff;}
}
unless(defined(&CORB_NID_ROOT)) {
    sub CORB_NID_ROOT () {	0;}
}
unless(defined(&HDA_MAX_CHANNELS)) {
    sub HDA_MAX_CHANNELS () {	16;}
}
unless(defined(&BDLIST_ENTRY_IOC)) {
    sub BDLIST_ENTRY_IOC () {	0x1;}
}
unless(defined(&HDA_BDL_MAX)) {
    sub HDA_BDL_MAX () {	256;}
}
unless(defined(&RIRB_UNSOLICITED_RESPONSE)) {
    sub RIRB_UNSOLICITED_RESPONSE () {	(1<< 4);}
}
if(defined(&AZALIA_DEBUG)) {
    eval 'sub DPRINTF {
        my($x) = @_;
	    eval q( &do {  &printf $x; }  &while (0));
    }' unless defined(&DPRINTF);
} else {
    eval 'sub DPRINTF {
        my($x) = @_;
	    eval q( &do {}  &while (0));
    }' unless defined(&DPRINTF);
}
unless(defined(&PTR_UPPER32)) {
    sub PTR_UPPER32 {
	my($x) = @_;
	eval q((( &uint64_t)($x) >> 32));
    }
}
unless(defined(&FLAGBUFLEN)) {
    sub FLAGBUFLEN () {	256;}
}
unless(defined(&MAX_VOLUME_255)) {
    sub MAX_VOLUME_255 () {	1;}
}
unless(defined(&WIDGET_CHANNELS)) {
    sub WIDGET_CHANNELS {
	my($w) = @_;
	eval q((($w)-> &widgetcap &  &COP_AWCAP_STEREO ? 2: 1));
    }
}
unless(defined(&IS_MI_TARGET_INAMP)) {
    sub IS_MI_TARGET_INAMP {
	my($x) = @_;
	eval q((($x) <= 15));
    }
}
unless(defined(&MI_TARGET_INAMP)) {
    sub MI_TARGET_INAMP {
	my($x) = @_;
	eval q(($x));
    }
}
unless(defined(&MI_TARGET_OUTAMP)) {
    sub MI_TARGET_OUTAMP () {	0x100;}
}
unless(defined(&MI_TARGET_CONNLIST)) {
    sub MI_TARGET_CONNLIST () {	0x101;}
}
unless(defined(&MI_TARGET_PINDIR)) {
    sub MI_TARGET_PINDIR () {	0x102;}
}
unless(defined(&MI_TARGET_PINBOOST)) {
    sub MI_TARGET_PINBOOST () {	0x103;}
}
unless(defined(&MI_TARGET_DAC)) {
    sub MI_TARGET_DAC () {	0x104;}
}
unless(defined(&MI_TARGET_ADC)) {
    sub MI_TARGET_ADC () {	0x105;}
}
unless(defined(&MI_TARGET_VOLUME)) {
    sub MI_TARGET_VOLUME () {	0x106;}
}
unless(defined(&VALID_WIDGET_NID)) {
    sub VALID_WIDGET_NID {
	my($nid, $codec) = @_;
	eval q(($nid == ($codec)-> &audiofunc || ($nid >= ($codec)-> &wstart  && $nid < ($codec)-> &wend)));
    }
}
unless(defined(&FOR_EACH_WIDGET)) {
    sub FOR_EACH_WIDGET {
	my($this, $i) = @_;
	eval q( &for ($i = ($this)-> &wstart; $i < ($this)-> &wend; $i++));
    }
}
1;
