require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&BCW_PCI_BAR0)) {
    sub BCW_PCI_BAR0 () {	0x10;}
}
unless(defined(&BCW_SAVEDINTRMASK)) {
    sub BCW_SAVEDINTRMASK () {	0xb007a864;}
}
unless(defined(&BCW_ADDR_SPACE0)) {
    sub BCW_ADDR_SPACE0 () {	0x80;}
}
unless(defined(&BCW_ADDR_SPACE1)) {
    sub BCW_ADDR_SPACE1 () {	0x84;}
}
unless(defined(&BCW_REG0_WIN)) {
    sub BCW_REG0_WIN () {	0x80;}
}
unless(defined(&BCW_REG1_WIN)) {
    sub BCW_REG1_WIN () {	0x84;}
}
unless(defined(&BCW_SPROM_CONTROL)) {
    sub BCW_SPROM_CONTROL () {	0x88;}
}
unless(defined(&BCW_ADDR1_BURST_CONTROL)) {
    sub BCW_ADDR1_BURST_CONTROL () {	0x8c;}
}
unless(defined(&BCW_PCII)) {
    sub BCW_PCII () {	0x90;}
}
unless(defined(&BCW_PCICR)) {
    sub BCW_PCICR () {	0x94;}
}
unless(defined(&BCW_BI)) {
    sub BCW_BI () {	0x98;}
}
unless(defined(&BCW_PCICI)) {
    sub BCW_PCICI () {	0xb0;}
}
unless(defined(&BCW_PCICO)) {
    sub BCW_PCICO () {	0xb4;}
}
unless(defined(&BCW_PCICOE)) {
    sub BCW_PCICOE () {	0xb8;}
}
unless(defined(&BCW_GPIOI)) {
    sub BCW_GPIOI () {	0xb0;}
}
unless(defined(&BCW_GPIOO)) {
    sub BCW_GPIOO () {	0xb4;}
}
unless(defined(&BCW_GPIOE)) {
    sub BCW_GPIOE () {	0xb8;}
}
unless(defined(&BCW_XTALPOWERUP)) {
    sub BCW_XTALPOWERUP () {	0x40;}
}
unless(defined(&BCW_PLLPOWERDOWN)) {
    sub BCW_PLLPOWERDOWN () {	0x80;}
}
unless(defined(&BCW_CORE_SELECT)) {
    sub BCW_CORE_SELECT {
	my($x) = @_;
	eval q((0x18000000 + ($x * 0x1000)));
    }
}
unless(defined(&BCW_CORE_COMMON)) {
    sub BCW_CORE_COMMON () {	0x800;}
}
unless(defined(&BCW_CORE_PCI)) {
    sub BCW_CORE_PCI () {	0x804;}
}
unless(defined(&BCW_CORE_ENET)) {
    sub BCW_CORE_ENET () {	0x806;}
}
unless(defined(&BCW_CORE_PCMCIA)) {
    sub BCW_CORE_PCMCIA () {	0x80d;}
}
unless(defined(&BCW_CORE_80211)) {
    sub BCW_CORE_80211 () {	0x812;}
}
unless(defined(&BCW_CORE_PCIE)) {
    sub BCW_CORE_PCIE () {	0x820;}
}
unless(defined(&BCW_CORE_MIMOPHY)) {
    sub BCW_CORE_MIMOPHY () {	0x821;}
}
unless(defined(&BCW_CORE_NONEXIST)) {
    sub BCW_CORE_NONEXIST () {	0x8ff;}
}
unless(defined(&BCW_CORE_COMMON_CHIPID)) {
    sub BCW_CORE_COMMON_CHIPID () {	0x;}
}
unless(defined(&BCW_SONICS_WIN)) {
    sub BCW_SONICS_WIN () {	0x18002000;}
}
unless(defined(&BCW_SPCI_TR2)) {
    sub BCW_SPCI_TR2 () {	0x108;}
}
unless(defined(&SBTOPCI_PREF)) {
    sub SBTOPCI_PREF () {	0x4;}
}
unless(defined(&SBTOPCI_BURST)) {
    sub SBTOPCI_BURST () {	0x8;}
}
unless(defined(&BCW_SBINTVEC)) {
    sub BCW_SBINTVEC () {	0xf94;}
}
unless(defined(&SBIV_ENET0)) {
    sub SBIV_ENET0 () {	0x2;}
}
unless(defined(&SBIV_ENET1)) {
    sub SBIV_ENET1 () {	0x40;}
}
unless(defined(&BCW_DEVCTL)) {
    sub BCW_DEVCTL () {	0x;}
}
unless(defined(&BCW_DC_IP)) {
    sub BCW_DC_IP () {	0x400;}
}
unless(defined(&BCW_DC_ER)) {
    sub BCW_DC_ER () {	0x8000;}
}
unless(defined(&BCW_INT_STS)) {
    sub BCW_INT_STS () {	0x20;}
}
unless(defined(&BCW_INT_MASK)) {
    sub BCW_INT_MASK () {	0x24;}
}
unless(defined(&I_TO)) {
    sub I_TO () {	0x80;}
}
unless(defined(&I_PC)) {
    sub I_PC () {	0x400;}
}
unless(defined(&I_PD)) {
    sub I_PD () {	0x800;}
}
unless(defined(&I_DE)) {
    sub I_DE () {	0x1000;}
}
unless(defined(&I_RU)) {
    sub I_RU () {	0x2000;}
}
unless(defined(&I_RO)) {
    sub I_RO () {	0x4000;}
}
unless(defined(&I_XU)) {
    sub I_XU () {	0x8000;}
}
unless(defined(&I_RI)) {
    sub I_RI () {	0x10000;}
}
unless(defined(&I_XI)) {
    sub I_XI () {	0x1000000;}
}
unless(defined(&BCW_MACCTL)) {
    sub BCW_MACCTL () {	0xa8;}
}
unless(defined(&BCW_EMC_CRC32_ENAB)) {
    sub BCW_EMC_CRC32_ENAB () {	0x1;}
}
unless(defined(&BCW_EMC_PDOWN)) {
    sub BCW_EMC_PDOWN () {	0x4;}
}
unless(defined(&BCW_EMC_EDET)) {
    sub BCW_EMC_EDET () {	0x8;}
}
unless(defined(&BCW_EMC_LED)) {
    sub BCW_EMC_LED () {	0xe0;}
}
unless(defined(&BCW_DMAI_CTL)) {
    sub BCW_DMAI_CTL () {	0x100;}
}
unless(defined(&BCW_DMA_TXCTL)) {
    sub BCW_DMA_TXCTL () {	0x200;}
}
unless(defined(&XC_XE)) {
    sub XC_XE () {	0x1;}
}
unless(defined(&XC_LE)) {
    sub XC_LE () {	0x4;}
}
unless(defined(&BCW_DMA_TXADDR)) {
    sub BCW_DMA_TXADDR () {	0x204;}
}
unless(defined(&BCW_DMA_DPTR)) {
    sub BCW_DMA_DPTR () {	0x208;}
}
unless(defined(&BCW_DMA_RXCTL)) {
    sub BCW_DMA_RXCTL () {	0x210;}
}
unless(defined(&BCW_DMA_RXADDR)) {
    sub BCW_DMA_RXADDR () {	0x214;}
}
unless(defined(&BCW_DMA_RXDPTR)) {
    sub BCW_DMA_RXDPTR () {	0x218;}
}
unless(defined(&RS_CD_MASK)) {
    sub RS_CD_MASK () {	0xfff;}
}
unless(defined(&RS_DMA_IDLE)) {
    sub RS_DMA_IDLE () {	0x2000;}
}
unless(defined(&RS_ERROR)) {
    sub RS_ERROR () {	0xf0000;}
}
unless(defined(&BCW_RX_CTL)) {
    sub BCW_RX_CTL () {	0x400;}
}
unless(defined(&ERC_DB)) {
    sub ERC_DB () {	0x1;}
}
unless(defined(&ERC_AM)) {
    sub ERC_AM () {	0x2;}
}
unless(defined(&ERC_PE)) {
    sub ERC_PE () {	0x8;}
}
unless(defined(&BCW_RX_MAX)) {
    sub BCW_RX_MAX () {	0x404;}
}
unless(defined(&BCW_TX_MAX)) {
    sub BCW_TX_MAX () {	0x408;}
}
unless(defined(&BCW_MI_CTL)) {
    sub BCW_MI_CTL () {	0x410;}
}
unless(defined(&BCW_MI_COMM)) {
    sub BCW_MI_COMM () {	0x414;}
}
unless(defined(&BCW_MI_STS)) {
    sub BCW_MI_STS () {	0x41c;}
}
unless(defined(&BCW_MIINTR)) {
    sub BCW_MIINTR () {	0x1;}
}
unless(defined(&BCW_FILT_LOW)) {
    sub BCW_FILT_LOW () {	0x420;}
}
unless(defined(&BCW_FILT_HI)) {
    sub BCW_FILT_HI () {	0x424;}
}
unless(defined(&BCW_FILT_CTL)) {
    sub BCW_FILT_CTL () {	0x428;}
}
unless(defined(&BCW_ENET_CTL)) {
    sub BCW_ENET_CTL () {	0x42c;}
}
unless(defined(&EC_EE)) {
    sub EC_EE () {	0x1;}
}
unless(defined(&EC_ED)) {
    sub EC_ED () {	0x2;}
}
unless(defined(&EC_ES)) {
    sub EC_ES () {	0x4;}
}
unless(defined(&EC_EP)) {
    sub EC_EP () {	0x8;}
}
unless(defined(&BCW_TX_CTL)) {
    sub BCW_TX_CTL () {	0x430;}
}
unless(defined(&EXC_FD)) {
    sub EXC_FD () {	0x1;}
}
unless(defined(&BCW_TX_WATER)) {
    sub BCW_TX_WATER () {	0x434;}
}
unless(defined(&BCW_RX_PKTS)) {
    sub BCW_RX_PKTS () {	0x58c;}
}
unless(defined(&BCW_SBTPSFLAG)) {
    sub BCW_SBTPSFLAG () {	0xf18;}
}
unless(defined(&SBTPS_BACKPLANEFLAGMASK)) {
    sub SBTPS_BACKPLANEFLAGMASK () {	0x3f;}
}
unless(defined(&SBTPS_INT_ALWAYS)) {
    sub SBTPS_INT_ALWAYS () {	0x40;}
}
unless(defined(&BCW_SBIMSTATE)) {
    sub BCW_SBIMSTATE () {	0xf90;}
}
unless(defined(&SBIM_REJECT)) {
    sub SBIM_REJECT () {	0x200000;}
}
unless(defined(&SBIM_INBANDERR)) {
    sub SBIM_INBANDERR () {	0x20000;}
}
unless(defined(&SBIM_TIMEOUT)) {
    sub SBIM_TIMEOUT () {	0x40000;}
}
unless(defined(&BCW_SBTMSTATELOW)) {
    sub BCW_SBTMSTATELOW () {	0xf98;}
}
unless(defined(&SBTML_RESET)) {
    sub SBTML_RESET () {	0x1;}
}
unless(defined(&SBTML_REJ)) {
    sub SBTML_REJ () {	0x6;}
}
unless(defined(&SBTML_REJ22)) {
    sub SBTML_REJ22 () {	0x2;}
}
unless(defined(&SBTML_REJ23)) {
    sub SBTML_REJ23 () {	0x4;}
}
unless(defined(&SBTML_CLK)) {
    sub SBTML_CLK () {	0x10000;}
}
unless(defined(&SBTML_FGC)) {
    sub SBTML_FGC () {	0x20000;}
}
unless(defined(&SBTML_80211FLAG)) {
    sub SBTML_80211FLAG () {	0x40000;}
}
unless(defined(&SBTML_80211PHY)) {
    sub SBTML_80211PHY () {	0x20000000;}
}
unless(defined(&BCW_SBTMSTATEHI)) {
    sub BCW_SBTMSTATEHI () {	0xf9c;}
}
unless(defined(&SBTMH_SERR)) {
    sub SBTMH_SERR () {	0x1;}
}
unless(defined(&SBTMH_INT)) {
    sub SBTMH_INT () {	0x2;}
}
unless(defined(&SBTMH_BUSY)) {
    sub SBTMH_BUSY () {	0x4;}
}
unless(defined(&BCW_CIR_SBID_LO)) {
    sub BCW_CIR_SBID_LO () {	0xff8;}
}
unless(defined(&BCW_CIR_SBID_LO_INITIATOR)) {
    sub BCW_CIR_SBID_LO_INITIATOR () {	0x80;}
}
unless(defined(&SBREV_MASK)) {
    sub SBREV_MASK () {	0xf0000000;}
}
unless(defined(&SBREV_MASK_SHIFT)) {
    sub SBREV_MASK_SHIFT () {	28;}
}
unless(defined(&BCW_CIR_SBID_HI)) {
    sub BCW_CIR_SBID_HI () {	0xffc;}
}
unless(defined(&BCW_SPROM_CONTROL)) {
    sub BCW_SPROM_CONTROL () {	0x88;}
}
unless(defined(&BCW_SBF)) {
    sub BCW_SBF () {	0x120;}
}
unless(defined(&BCW_SBF_MAC_ENABLED)) {
    sub BCW_SBF_MAC_ENABLED () {	0x1;}
}
unless(defined(&BCW_SBF_CORE_READY)) {
    sub BCW_SBF_CORE_READY () {	0x4;}
}
unless(defined(&BCW_SBF_400_MAGIC)) {
    sub BCW_SBF_400_MAGIC () {	0x400;}
}
unless(defined(&BCW_SBF_REGISTER_BYTESWAP)) {
    sub BCW_SBF_REGISTER_BYTESWAP () {	0x10000;}
}
unless(defined(&BCW_SBF_ADHOC)) {
    sub BCW_SBF_ADHOC () {	0x20000;}
}
unless(defined(&BCW_SBF_AP)) {
    sub BCW_SBF_AP () {	0x40000;}
}
unless(defined(&BCW_SBF_RADIOREG_LOCK)) {
    sub BCW_SBF_RADIOREG_LOCK () {	0x80000;}
}
unless(defined(&BCW_SBF_MONITOR)) {
    sub BCW_SBF_MONITOR () {	0x400000;}
}
unless(defined(&BCW_SBF_PROMISC)) {
    sub BCW_SBF_PROMISC () {	0x1000000;}
}
unless(defined(&BCW_SBF_PS1)) {
    sub BCW_SBF_PS1 () {	0x2000000;}
}
unless(defined(&BCW_SBF_PS2)) {
    sub BCW_SBF_PS2 () {	0x4000000;}
}
unless(defined(&BCW_SBF_SSID_BCAST)) {
    sub BCW_SBF_SSID_BCAST () {	0x8000000;}
}
unless(defined(&BCW_SBF_TIME_UPDATE)) {
    sub BCW_SBF_TIME_UPDATE () {	0x10000000;}
}
unless(defined(&BCW_GIR)) {
    sub BCW_GIR () {	0x128;}
}
unless(defined(&BCW_MMIO_RAM_CONTROL)) {
    sub BCW_MMIO_RAM_CONTROL () {	0x130;}
}
unless(defined(&BCW_MMIO_RAM_DATA)) {
    sub BCW_MMIO_RAM_DATA () {	0x134;}
}
unless(defined(&BCW_SHM_CONTROL)) {
    sub BCW_SHM_CONTROL () {	0x160;}
}
unless(defined(&BCW_SHM_DATA)) {
    sub BCW_SHM_DATA () {	0x164;}
}
unless(defined(&BCW_SHM_DATALOW)) {
    sub BCW_SHM_DATALOW () {	0x164;}
}
unless(defined(&BCW_SHM_DATAHIGH)) {
    sub BCW_SHM_DATAHIGH () {	0x166;}
}
unless(defined(&BCW_SHM_CONTROL_SHARED)) {
    sub BCW_SHM_CONTROL_SHARED () {	0x1;}
}
unless(defined(&BCW_SHM_CONTROL_80211)) {
    sub BCW_SHM_CONTROL_80211 () {	0x2;}
}
unless(defined(&BCW_SHM_CONTROL_PCM)) {
    sub BCW_SHM_CONTROL_PCM () {	0x3;}
}
unless(defined(&BCW_SHM_CONTROL_HWMAC)) {
    sub BCW_SHM_CONTROL_HWMAC () {	0x4;}
}
unless(defined(&BCW_SHM_CONTROL_MCODE)) {
    sub BCW_SHM_CONTROL_MCODE () {	0x300;}
}
unless(defined(&BCW_SHM_CONTROL_INIMCODE)) {
    sub BCW_SHM_CONTROL_INIMCODE () {	0x301;}
}
unless(defined(&BCW_SHM_MICROCODEFLAGSLOW)) {
    sub BCW_SHM_MICROCODEFLAGSLOW () {	0x5e;}
}
unless(defined(&BCW_SHM_MICROCODEFLAGSHIGH)) {
    sub BCW_SHM_MICROCODEFLAGSHIGH () {	0x60;}
}
unless(defined(&BCW_DMA_TXCONTROL)) {
    sub BCW_DMA_TXCONTROL {
	my($x) = @_;
	eval q((0x200 + ($x * 0x20)));
    }
}
unless(defined(&BCW_DMA_TXRINGADDR)) {
    sub BCW_DMA_TXRINGADDR {
	my($x) = @_;
	eval q((0x204 + ($x * 0x20)));
    }
}
unless(defined(&BCW_DMA_TXSTOPADDR)) {
    sub BCW_DMA_TXSTOPADDR {
	my($x) = @_;
	eval q((0x208 + ($x * 0x20)));
    }
}
unless(defined(&BCW_DMA_TXSTATUS)) {
    sub BCW_DMA_TXSTATUS {
	my($x) = @_;
	eval q((0x20c + ($x * 0x20)));
    }
}
unless(defined(&BCW_DMA_RXCONTROL)) {
    sub BCW_DMA_RXCONTROL {
	my($x) = @_;
	eval q((0x200 + ($x * 0x20)));
    }
}
unless(defined(&BCW_DMA_RXRINGADDR)) {
    sub BCW_DMA_RXRINGADDR {
	my($x) = @_;
	eval q((0x204 + ($x * 0x20)));
    }
}
unless(defined(&BCW_DMA_RXSTOPADDR)) {
    sub BCW_DMA_RXSTOPADDR {
	my($x) = @_;
	eval q((0x208 + ($x * 0x20)));
    }
}
unless(defined(&BCW_DMA_RXSTATUS)) {
    sub BCW_DMA_RXSTATUS {
	my($x) = @_;
	eval q((0x20c + ($x * 0x20)));
    }
}
unless(defined(&BCW_DMA64_TXCONTROL)) {
    sub BCW_DMA64_TXCONTROL {
	my($x) = @_;
	eval q((0x200 + ($x * 0x40)));
    }
}
unless(defined(&BCW_DMA64_TXSTOPADDR)) {
    sub BCW_DMA64_TXSTOPADDR {
	my($x) = @_;
	eval q((0x204 + ($x * 0x40)));
    }
}
unless(defined(&BCW_DMA64_TXRINGADDRLOW)) {
    sub BCW_DMA64_TXRINGADDRLOW {
	my($x) = @_;
	eval q((0x208 + ($x * 0x40)));
    }
}
unless(defined(&BCW_DMA64_TXRINGADDRHIGH)) {
    sub BCW_DMA64_TXRINGADDRHIGH {
	my($x) = @_;
	eval q((0x20c + ($x * 0x40)));
    }
}
unless(defined(&BCW_DMA64_TXSTATUS)) {
    sub BCW_DMA64_TXSTATUS {
	my($x) = @_;
	eval q((0x210 + ($x * 0x40)));
    }
}
unless(defined(&BCW_DMA64_TXERROR)) {
    sub BCW_DMA64_TXERROR {
	my($x) = @_;
	eval q((0x214 + ($x * 0x40)));
    }
}
unless(defined(&BCW_DMA64_RXCONTROL)) {
    sub BCW_DMA64_RXCONTROL {
	my($x) = @_;
	eval q((0x220 + ($x * 0x40)));
    }
}
unless(defined(&BCW_DMA64_RXSTOPADDR)) {
    sub BCW_DMA64_RXSTOPADDR {
	my($x) = @_;
	eval q((0x224 + ($x * 0x40)));
    }
}
unless(defined(&BCW_DMA64_RXRINGADDRLOW)) {
    sub BCW_DMA64_RXRINGADDRLOW {
	my($x) = @_;
	eval q((0x228 + ($x * 0x40)));
    }
}
unless(defined(&BCW_DMA64_RXRINGADDRHIGH)) {
    sub BCW_DMA64_RXRINGADDRHIGH {
	my($x) = @_;
	eval q((0x22c + ($x * 0x40)));
    }
}
unless(defined(&BCW_DMA64_RXSTATUS)) {
    sub BCW_DMA64_RXSTATUS {
	my($x) = @_;
	eval q((0x230 + ($x * 0x40)));
    }
}
unless(defined(&BCW_DMA64_RXERROR)) {
    sub BCW_DMA64_RXERROR {
	my($x) = @_;
	eval q((0x234 + ($x * 0x40)));
    }
}
unless(defined(&BCW_DMA_CONTROL_ENABLE)) {
    sub BCW_DMA_CONTROL_ENABLE () {	0x1;}
}
unless(defined(&BCW_DMA_CONTROL_SUSPEND)) {
    sub BCW_DMA_CONTROL_SUSPEND () {	0x2;}
}
unless(defined(&BCW_DMA_CONTROL_LOOPBACK)) {
    sub BCW_DMA_CONTROL_LOOPBACK () {	0x4;}
}
unless(defined(&BCW_DMA_CONTROL_FLUSH)) {
    sub BCW_DMA_CONTROL_FLUSH () {	0x10;}
}
unless(defined(&BCW_DMA_CONTROL_ADDREXT)) {
    sub BCW_DMA_CONTROL_ADDREXT () {	0x30000;}
}
unless(defined(&BCW_RADIO_BASEBAND)) {
    sub BCW_RADIO_BASEBAND () {	0x3e6;}
}
unless(defined(&BCW_RADIO_CONTROL)) {
    sub BCW_RADIO_CONTROL () {	0x3f6;}
}
unless(defined(&BCW_RADIO_DATA)) {
    sub BCW_RADIO_DATA () {	0x3fa;}
}
unless(defined(&BCW_RADIO_DATALOW)) {
    sub BCW_RADIO_DATALOW () {	0x3fa;}
}
unless(defined(&BCW_RADIO_DATAHIGH)) {
    sub BCW_RADIO_DATAHIGH () {	0x3f8;}
}
unless(defined(&BCW_RADIO_ID)) {
    sub BCW_RADIO_ID () {	0x1;}
}
unless(defined(&BCW_PHY_CONTROL)) {
    sub BCW_PHY_CONTROL () {	0x3fc;}
}
unless(defined(&BCW_PHY_DATA)) {
    sub BCW_PHY_DATA () {	0x3fe;}
}
unless(defined(&BCW_MMIO_BASE)) {
    sub BCW_MMIO_BASE () {	0x1000;}
}
unless(defined(&BCW_SPROM_SUBPRODID)) {
    sub BCW_SPROM_SUBPRODID () {	0x1004;}
}
unless(defined(&BCW_SPROM_SUBVENID)) {
    sub BCW_SPROM_SUBVENID () {	0x1006;}
}
unless(defined(&BCW_SPROM_PRODID)) {
    sub BCW_SPROM_PRODID () {	0x1008;}
}
unless(defined(&BCW_SPROM_IL0MACADDR)) {
    sub BCW_SPROM_IL0MACADDR () {	0x1048;}
}
unless(defined(&BCW_SPROM_ET0MACADDR)) {
    sub BCW_SPROM_ET0MACADDR () {	0x104e;}
}
unless(defined(&BCW_SPROM_ET1MACADDR)) {
    sub BCW_SPROM_ET1MACADDR () {	0x1054;}
}
unless(defined(&BCW_SPROM_PA0B0)) {
    sub BCW_SPROM_PA0B0 () {	0x105e;}
}
unless(defined(&BCW_SPROM_PA0B1)) {
    sub BCW_SPROM_PA0B1 () {	0x1060;}
}
unless(defined(&BCW_SPROM_PA0B2)) {
    sub BCW_SPROM_PA0B2 () {	0x1062;}
}
unless(defined(&BCW_SPROM_PAMAXPOWER)) {
    sub BCW_SPROM_PAMAXPOWER () {	0x1066;}
}
unless(defined(&BCW_SPROM_PA1B0)) {
    sub BCW_SPROM_PA1B0 () {	0x106a;}
}
unless(defined(&BCW_SPROM_PA1B1)) {
    sub BCW_SPROM_PA1B1 () {	0x106c;}
}
unless(defined(&BCW_SPROM_PA1B2)) {
    sub BCW_SPROM_PA1B2 () {	0x106e;}
}
unless(defined(&BCW_SPROM_IDLETSSI)) {
    sub BCW_SPROM_IDLETSSI () {	0x1070;}
}
unless(defined(&BCW_SPROM_BOARDFLAGS)) {
    sub BCW_SPROM_BOARDFLAGS () {	0x1072;}
}
unless(defined(&BCW_BF_BTCOEXIST)) {
    sub BCW_BF_BTCOEXIST () {	0x1;}
}
unless(defined(&BCW_BF_PACTRL)) {
    sub BCW_BF_PACTRL () {	0x2;}
}
unless(defined(&BCW_BF_AIRLINEMODE)) {
    sub BCW_BF_AIRLINEMODE () {	0x4;}
}
unless(defined(&BCW_BF_RSSI)) {
    sub BCW_BF_RSSI () {	0x8;}
}
unless(defined(&BCW_BF_ENETSPI)) {
    sub BCW_BF_ENETSPI () {	0x10;}
}
unless(defined(&BCW_BF_XTAL)) {
    sub BCW_BF_XTAL () {	0x20;}
}
unless(defined(&BCW_BF_CCKHIPWR)) {
    sub BCW_BF_CCKHIPWR () {	0x40;}
}
unless(defined(&BCW_BF_ENETADM)) {
    sub BCW_BF_ENETADM () {	0x80;}
}
unless(defined(&BCW_BF_ENETVLAN)) {
    sub BCW_BF_ENETVLAN () {	0x100;}
}
unless(defined(&BCW_BF_AFTERBURNER)) {
    sub BCW_BF_AFTERBURNER () {	0x200;}
}
unless(defined(&BCW_BF_NOPCI)) {
    sub BCW_BF_NOPCI () {	0x400;}
}
unless(defined(&BCW_BF_FEM)) {
    sub BCW_BF_FEM () {	0x800;}
}
unless(defined(&BCW_BF_EXTLNA)) {
    sub BCW_BF_EXTLNA () {	0x1000;}
}
unless(defined(&BCW_BF_HGPA)) {
    sub BCW_BF_HGPA () {	0x2000;}
}
unless(defined(&BCW_BF_BTCMOD)) {
    sub BCW_BF_BTCMOD () {	0x4000;}
}
unless(defined(&BCW_BF_ALTIQ)) {
    sub BCW_BF_ALTIQ () {	0x8000;}
}
unless(defined(&BCW_SPROM_ANTGAIN)) {
    sub BCW_SPROM_ANTGAIN () {	0x1074;}
}
unless(defined(&BCW_PHY_TYPEA)) {
    sub BCW_PHY_TYPEA () {	0x;}
}
unless(defined(&BCW_PHY_TYPEB)) {
    sub BCW_PHY_TYPEB () {	0x1;}
}
unless(defined(&BCW_PHY_TYPEG)) {
    sub BCW_PHY_TYPEG () {	0x2;}
}
unless(defined(&BCW_PHY_TYPEN)) {
    sub BCW_PHY_TYPEN () {	0x4;}
}
unless(defined(&BCW_INTR_READY)) {
    sub BCW_INTR_READY () {	(1<< 0);}
}
unless(defined(&BCW_UCODE_REVISION)) {
    sub BCW_UCODE_REVISION () {	0x;}
}
unless(defined(&BCW_UCODE_PATCHLEVEL)) {
    sub BCW_UCODE_PATCHLEVEL () {	0x2;}
}
unless(defined(&BCW_UCODE_DATE)) {
    sub BCW_UCODE_DATE () {	0x4;}
}
unless(defined(&BCW_UCODE_TIME)) {
    sub BCW_UCODE_TIME () {	0x6;}
}
unless(defined(&BCW_UCODE_STATUS)) {
    sub BCW_UCODE_STATUS () {	0x40;}
}
unless(defined(&BCW_GPIO_MASK)) {
    sub BCW_GPIO_MASK () {	0x49e;}
}
unless(defined(&BCW_GPIO_CTRL)) {
    sub BCW_GPIO_CTRL () {	0x6c;}
}
unless(defined(&BCW_MMIO_PHY_RADIO)) {
    sub BCW_MMIO_PHY_RADIO () {	0x3e2;}
}
unless(defined(&BCW_MMIO_CHANNEL)) {
    sub BCW_MMIO_CHANNEL () {	0x3f0;}
}
unless(defined(&BCW_MMIO_CHANNEL_EXT)) {
    sub BCW_MMIO_CHANNEL_EXT () {	0x3f4;}
}
unless(defined(&BCW_MMIO_GPIO_CONTROL)) {
    sub BCW_MMIO_GPIO_CONTROL () {	0x49c;}
}
unless(defined(&BCW_NR_LEDS)) {
    sub BCW_NR_LEDS () {	4;}
}
unless(defined(&BCW_PHY_G_LO_CONTROL)) {
    sub BCW_PHY_G_LO_CONTROL () {	0x810;}
}
unless(defined(&BCW_PHY_ILT_A_CTRL)) {
    sub BCW_PHY_ILT_A_CTRL () {	0x72;}
}
unless(defined(&BCW_PHY_ILT_A_DATA1)) {
    sub BCW_PHY_ILT_A_DATA1 () {	0x73;}
}
unless(defined(&BCW_PHY_ILT_G_CTRL)) {
    sub BCW_PHY_ILT_G_CTRL () {	0x472;}
}
unless(defined(&BCW_PHY_ILT_G_DATA1)) {
    sub BCW_PHY_ILT_G_DATA1 () {	0x473;}
}
unless(defined(&BCW_PHY_G_CRS)) {
    sub BCW_PHY_G_CRS () {	0x429;}
}
unless(defined(&BCW_PHY_A_CRS)) {
    sub BCW_PHY_A_CRS () {	0x29;}
}
unless(defined(&BCW_PHY_NRSSILT_CTRL)) {
    sub BCW_PHY_NRSSILT_CTRL () {	0x803;}
}
unless(defined(&BCW_PHY_NRSSILT_DATA)) {
    sub BCW_PHY_NRSSILT_DATA () {	0x804;}
}
unless(defined(&BCW_PHY_A_PCTL)) {
    sub BCW_PHY_A_PCTL () {	0x7b;}
}
unless(defined(&BCW_PHY_G_PCTL)) {
    sub BCW_PHY_G_PCTL () {	0x29;}
}
unless(defined(&BCW_READ16)) {
    sub BCW_READ16 {
	my($sc, $reg) = @_;
	eval q( &bus_space_read_2(($sc)-> &sc_iot, ($sc)-> &sc_ioh, ($reg)));
    }
}
unless(defined(&BCW_READ)) {
    sub BCW_READ {
	my($sc, $reg) = @_;
	eval q( &bus_space_read_4(($sc)-> &sc_iot, ($sc)-> &sc_ioh, ($reg)));
    }
}
unless(defined(&BCW_WRITE16)) {
    sub BCW_WRITE16 {
	my($sc, $reg, $val) = @_;
	eval q( &bus_space_write_2(($sc)-> &sc_iot, ($sc)-> &sc_ioh, ($reg), ($val)));
    }
}
unless(defined(&BCW_WRITE)) {
    sub BCW_WRITE {
	my($sc, $reg, $val) = @_;
	eval q( &bus_space_write_4(($sc)-> &sc_iot, ($sc)-> &sc_ioh, ($reg), ($val)));
    }
}
1;
