require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_ARM32_PMAP_H_)) {
    eval 'sub _ARM32_PMAP_H_ () {1;}' unless defined(&_ARM32_PMAP_H_);
    if(defined(&_KERNEL)) {
	require 'arm/cpuconf.ph';
	require 'arm/pte.ph';
	unless(defined(&_LOCORE)) {
	    require 'arm/cpufunc.ph';
	}
	eval 'sub L2_BUCKET_LOG2 () {4;}' unless defined(&L2_BUCKET_LOG2);
	eval 'sub L2_BUCKET_SIZE () {(1<<  &L2_BUCKET_LOG2);}' unless defined(&L2_BUCKET_SIZE);
	eval 'sub L2_LOG2 () {((32-  &L1_S_SHIFT) -  &L2_BUCKET_LOG2);}' unless defined(&L2_LOG2);
	eval 'sub L2_SIZE () {(1<<  &L2_LOG2);}' unless defined(&L2_SIZE);
	unless(defined(&_LOCORE)) {
	    eval 'sub cs_cache_id () { ($cs_s->{cs_cache_u}->{csu_cache_b[0]});}' unless defined(&cs_cache_id);
	    eval 'sub cs_cache_d () { ($cs_s->{cs_cache_u}->{csu_cache_b[1]});}' unless defined(&cs_cache_d);
	    eval 'sub cs_cache () { ($cs_s->{cs_cache_u}->{csu_cache});}' unless defined(&cs_cache);
	    eval 'sub cs_tlb_id () { ($cs_s->{cs_tlb_u}->{csu_tlb_b[0]});}' unless defined(&cs_tlb_id);
	    eval 'sub cs_tlb_d () { ($cs_s->{cs_tlb_u}->{csu_tlb_b[1]});}' unless defined(&cs_tlb_d);
	    eval 'sub cs_tlb () { ($cs_s->{cs_tlb_u}->{csu_tlb});}' unless defined(&cs_tlb);
	    eval 'sub PMAP_CACHE_STATE_ALL () {0xffffffff;}' unless defined(&PMAP_CACHE_STATE_ALL);
	    eval 'sub PTE_KERNEL () {0;}' unless defined(&PTE_KERNEL);
	    eval 'sub PTE_USER () {1;}' unless defined(&PTE_USER);
	    eval 'sub PTE_NOCACHE () {0;}' unless defined(&PTE_NOCACHE);
	    eval 'sub PTE_CACHE () {1;}' unless defined(&PTE_CACHE);
	    eval 'sub PTE_PAGETABLE () {2;}' unless defined(&PTE_PAGETABLE);
	    eval 'sub PVF_MOD () {0x1;}' unless defined(&PVF_MOD);
	    eval 'sub PVF_REF () {0x2;}' unless defined(&PVF_REF);
	    eval 'sub PVF_WIRED () {0x4;}' unless defined(&PVF_WIRED);
	    eval 'sub PVF_WRITE () {0x8;}' unless defined(&PVF_WRITE);
	    eval 'sub PVF_EXEC () {0x10;}' unless defined(&PVF_EXEC);
	    eval 'sub PVF_UNC () {0x20;}' unless defined(&PVF_UNC);
	    eval 'sub PVF_KNC () {0x40;}' unless defined(&PVF_KNC);
	    eval 'sub PVF_NC () {( &PVF_UNC| &PVF_KNC);}' unless defined(&PVF_NC);
	    eval 'sub pmap_kernel () {
	        eval q(( &kernel_pmap_store));
	    }' unless defined(&pmap_kernel);
	    eval 'sub pmap_resident_count {
	        my($pmap) = @_;
    		eval q((($pmap)-> ($pm_stats->{resident_count})));
	    }' unless defined(&pmap_resident_count);
	    eval 'sub pmap_wired_count {
	        my($pmap) = @_;
    		eval q((($pmap)-> ($pm_stats->{wired_count})));
	    }' unless defined(&pmap_wired_count);
	    eval 'sub pmap_is_modified {
	        my($pg) = @_;
    		eval q(((($pg)-> ($mdpage->{pvh_attrs}) &  &PVF_MOD) != 0));
	    }' unless defined(&pmap_is_modified);
	    eval 'sub pmap_is_referenced {
	        my($pg) = @_;
    		eval q(((($pg)-> ($mdpage->{pvh_attrs}) &  &PVF_REF) != 0));
	    }' unless defined(&pmap_is_referenced);
	    eval 'sub pmap_copy {
	        my($dp, $sp, $da, $l, $sa) = @_;
    		eval q();
	    }' unless defined(&pmap_copy);
	    eval 'sub pmap_phys_address {
	        my($ppn) = @_;
    		eval q(( &ptoa($ppn)));
	    }' unless defined(&pmap_phys_address);
	    eval 'sub pmap_proc_iflush {
	        my($p, $va, $len) = @_;
    		eval q();
	    }' unless defined(&pmap_proc_iflush);
	    eval 'sub pmap_unuse_final {
	        my($p) = @_;
    		eval q();
	    }' unless defined(&pmap_unuse_final);
	    eval 'sub PMAP_NEED_PROCWR () {1;}' unless defined(&PMAP_NEED_PROCWR);
	    eval 'sub PMAP_GROWKERNEL () {1;}' unless defined(&PMAP_GROWKERNEL);
	    eval 'sub PMAP_PAGEIDLEZERO {
	        my($pg) = @_;
    		eval q( &pmap_pageidlezero(($pg)));
	    }' unless defined(&PMAP_PAGEIDLEZERO);
	    if(((defined(&ARM_MMU_SA1) ? &ARM_MMU_SA1 : 0) == 1)  && ((defined(&ARM_NMMUS) ? &ARM_NMMUS : 0) == 1)) {
		eval 'sub PMAP_NEEDS_PTE_SYNC () {1;}' unless defined(&PMAP_NEEDS_PTE_SYNC);
		eval 'sub PMAP_INCLUDE_PTE_SYNC () {1;}' unless defined(&PMAP_INCLUDE_PTE_SYNC);
	    }
 elsif(((defined(&ARM_MMU_SA1) ? &ARM_MMU_SA1 : 0) == 0)) {
		eval 'sub PMAP_NEEDS_PTE_SYNC () {0;}' unless defined(&PMAP_NEEDS_PTE_SYNC);
	    }
	    unless(defined(&PMAP_NEEDS_PTE_SYNC)) {
		eval 'sub PMAP_NEEDS_PTE_SYNC () { &pmap_needs_pte_sync;}' unless defined(&PMAP_NEEDS_PTE_SYNC);
		eval 'sub PMAP_INCLUDE_PTE_SYNC () {1;}' unless defined(&PMAP_INCLUDE_PTE_SYNC);
	    }
	    eval 'sub PTE_SYNC {
	        my($pte) = @_;
    		eval q( &do {  &if ( &PMAP_NEEDS_PTE_SYNC)  &cpu_dcache_wb_range(( &vaddr_t)($pte), $sizeof{ &pt_entry_t});}  &while ( 0));
	    }' unless defined(&PTE_SYNC);
	    eval 'sub PTE_SYNC_RANGE {
	        my($pte, $cnt) = @_;
    		eval q( &do {  &if ( &PMAP_NEEDS_PTE_SYNC) {  &cpu_dcache_wb_range(( &vaddr_t)($pte), ($cnt) << 2); } }  &while ( 0));
	    }' unless defined(&PTE_SYNC_RANGE);
	    eval 'sub l1pte_valid {
	        my($pde) = @_;
    		eval q((($pde) != 0));
	    }' unless defined(&l1pte_valid);
	    eval 'sub l1pte_section_p {
	        my($pde) = @_;
    		eval q(((($pde) &  &L1_TYPE_MASK) ==  &L1_TYPE_S));
	    }' unless defined(&l1pte_section_p);
	    eval 'sub l1pte_page_p {
	        my($pde) = @_;
    		eval q(((($pde) &  &L1_TYPE_MASK) ==  &L1_TYPE_C));
	    }' unless defined(&l1pte_page_p);
	    eval 'sub l1pte_fpage_p {
	        my($pde) = @_;
    		eval q(((($pde) &  &L1_TYPE_MASK) ==  &L1_TYPE_F));
	    }' unless defined(&l1pte_fpage_p);
	    eval 'sub l2pte_index {
	        my($v) = @_;
    		eval q(((($v) &  &L2_ADDR_BITS) >>  &L2_S_SHIFT));
	    }' unless defined(&l2pte_index);
	    eval 'sub l2pte_valid {
	        my($pte) = @_;
    		eval q((($pte) != 0));
	    }' unless defined(&l2pte_valid);
	    eval 'sub l2pte_pa {
	        my($pte) = @_;
    		eval q((($pte) &  &L2_S_FRAME));
	    }' unless defined(&l2pte_pa);
	    eval 'sub l2pte_minidata {
	        my($pte) = @_;
    		eval q(((($pte) & ( &L2_B |  &L2_C |  &L2_XSCALE_T_TEX( &TEX_XSCALE_X))) == ( &L2_C |  &L2_XSCALE_T_TEX( &TEX_XSCALE_X))));
	    }' unless defined(&l2pte_minidata);
	    eval 'sub pmap_pde_v {
	        my($pde) = @_;
    		eval q( &l1pte_valid(*($pde)));
	    }' unless defined(&pmap_pde_v);
	    eval 'sub pmap_pde_section {
	        my($pde) = @_;
    		eval q( &l1pte_section_p(*($pde)));
	    }' unless defined(&pmap_pde_section);
	    eval 'sub pmap_pde_page {
	        my($pde) = @_;
    		eval q( &l1pte_page_p(*($pde)));
	    }' unless defined(&pmap_pde_page);
	    eval 'sub pmap_pde_fpage {
	        my($pde) = @_;
    		eval q( &l1pte_fpage_p(*($pde)));
	    }' unless defined(&pmap_pde_fpage);
	    eval 'sub pmap_pte_v {
	        my($pte) = @_;
    		eval q( &l2pte_valid(*($pte)));
	    }' unless defined(&pmap_pte_v);
	    eval 'sub pmap_pte_pa {
	        my($pte) = @_;
    		eval q( &l2pte_pa(*($pte)));
	    }' unless defined(&pmap_pte_pa);
	    eval 'sub KERNEL_PD_SIZE () {( &L1_TABLE_SIZE - ( &KERNEL_BASE >>  &L1_S_SHIFT) * $sizeof{ &pd_entry_t});}' unless defined(&KERNEL_PD_SIZE);
	    if(((defined(&ARM_MMU_GENERIC) ? &ARM_MMU_GENERIC : 0) + (defined(&ARM_MMU_SA1) ? &ARM_MMU_SA1 : 0)) != 0) {
		if(defined( &CPU_ARM8)) {
		}
		if(defined( &CPU_ARM9)) {
		}
		if(defined( &CPU_ARM10)) {
		}
	    }
	    if((defined(&ARM_MMU_SA1) ? &ARM_MMU_SA1 : 0) == 1) {
	    }
	    if((defined(&ARM_MMU_XSCALE) ? &ARM_MMU_XSCALE : 0) == 1) {
		eval 'sub PMAP_UAREA {
		    my($va) = @_;
    		    eval q( &pmap_uarea($va));
		}' unless defined(&PMAP_UAREA);
	    }
	}
	eval 'sub PMAP_CACHE_VIVT () {1;}' unless defined(&PMAP_CACHE_VIVT);
	eval 'sub PMAP_DOMAINS () {15;}' unless defined(&PMAP_DOMAINS);
	eval 'sub PMAP_DOMAIN_KERNEL () {15;}' unless defined(&PMAP_DOMAIN_KERNEL);
	eval 'sub L1_S_PROT_U () {( &L1_S_AP( &AP_U));}' unless defined(&L1_S_PROT_U);
	eval 'sub L1_S_PROT_W () {( &L1_S_AP( &AP_W));}' unless defined(&L1_S_PROT_W);
	eval 'sub L1_S_PROT_MASK () {( &L1_S_PROT_U| &L1_S_PROT_W);}' unless defined(&L1_S_PROT_MASK);
	eval 'sub L1_S_CACHE_MASK_generic () {( &L1_S_B| &L1_S_C);}' unless defined(&L1_S_CACHE_MASK_generic);
	eval 'sub L1_S_CACHE_MASK_xscale () {( &L1_S_B| &L1_S_C| &L1_S_XSCALE_TEX( &TEX_XSCALE_X));}' unless defined(&L1_S_CACHE_MASK_xscale);
	eval 'sub L2_L_PROT_U () {( &L2_AP( &AP_U));}' unless defined(&L2_L_PROT_U);
	eval 'sub L2_L_PROT_W () {( &L2_AP( &AP_W));}' unless defined(&L2_L_PROT_W);
	eval 'sub L2_L_PROT_MASK () {( &L2_L_PROT_U| &L2_L_PROT_W);}' unless defined(&L2_L_PROT_MASK);
	eval 'sub L2_L_CACHE_MASK_generic () {( &L2_B| &L2_C);}' unless defined(&L2_L_CACHE_MASK_generic);
	eval 'sub L2_L_CACHE_MASK_xscale () {( &L2_B| &L2_C| &L2_XSCALE_L_TEX( &TEX_XSCALE_X));}' unless defined(&L2_L_CACHE_MASK_xscale);
	eval 'sub L2_S_PROT_U_generic () {( &L2_AP( &AP_U));}' unless defined(&L2_S_PROT_U_generic);
	eval 'sub L2_S_PROT_W_generic () {( &L2_AP( &AP_W));}' unless defined(&L2_S_PROT_W_generic);
	eval 'sub L2_S_PROT_MASK_generic () {( &L2_S_PROT_U| &L2_S_PROT_W);}' unless defined(&L2_S_PROT_MASK_generic);
	eval 'sub L2_S_PROT_U_xscale () {( &L2_AP0( &AP_U));}' unless defined(&L2_S_PROT_U_xscale);
	eval 'sub L2_S_PROT_W_xscale () {( &L2_AP0( &AP_W));}' unless defined(&L2_S_PROT_W_xscale);
	eval 'sub L2_S_PROT_MASK_xscale () {( &L2_S_PROT_U| &L2_S_PROT_W);}' unless defined(&L2_S_PROT_MASK_xscale);
	eval 'sub L2_S_CACHE_MASK_generic () {( &L2_B| &L2_C);}' unless defined(&L2_S_CACHE_MASK_generic);
	eval 'sub L2_S_CACHE_MASK_xscale () {( &L2_B| &L2_C| &L2_XSCALE_T_TEX( &TEX_XSCALE_X));}' unless defined(&L2_S_CACHE_MASK_xscale);
	eval 'sub L1_S_PROTO_generic () {( &L1_TYPE_S |  &L1_S_IMP);}' unless defined(&L1_S_PROTO_generic);
	eval 'sub L1_S_PROTO_xscale () {( &L1_TYPE_S);}' unless defined(&L1_S_PROTO_xscale);
	eval 'sub L1_C_PROTO_generic () {( &L1_TYPE_C |  &L1_C_IMP2);}' unless defined(&L1_C_PROTO_generic);
	eval 'sub L1_C_PROTO_xscale () {( &L1_TYPE_C);}' unless defined(&L1_C_PROTO_xscale);
	eval 'sub L2_L_PROTO () {( &L2_TYPE_L);}' unless defined(&L2_L_PROTO);
	eval 'sub L2_S_PROTO_generic () {( &L2_TYPE_S);}' unless defined(&L2_S_PROTO_generic);
	eval 'sub L2_S_PROTO_xscale () {( &L2_TYPE_XSCALE_XS);}' unless defined(&L2_S_PROTO_xscale);
	if((defined(&ARM_NMMUS) ? &ARM_NMMUS : 0) > 1) {
	    eval 'sub L2_S_PROT_U () { &pte_l2_s_prot_u;}' unless defined(&L2_S_PROT_U);
	    eval 'sub L2_S_PROT_W () { &pte_l2_s_prot_w;}' unless defined(&L2_S_PROT_W);
	    eval 'sub L2_S_PROT_MASK () { &pte_l2_s_prot_mask;}' unless defined(&L2_S_PROT_MASK);
	    eval 'sub L1_S_CACHE_MASK () { &pte_l1_s_cache_mask;}' unless defined(&L1_S_CACHE_MASK);
	    eval 'sub L2_L_CACHE_MASK () { &pte_l2_l_cache_mask;}' unless defined(&L2_L_CACHE_MASK);
	    eval 'sub L2_S_CACHE_MASK () { &pte_l2_s_cache_mask;}' unless defined(&L2_S_CACHE_MASK);
	    eval 'sub L1_S_PROTO () { &pte_l1_s_proto;}' unless defined(&L1_S_PROTO);
	    eval 'sub L1_C_PROTO () { &pte_l1_c_proto;}' unless defined(&L1_C_PROTO);
	    eval 'sub L2_S_PROTO () { &pte_l2_s_proto;}' unless defined(&L2_S_PROTO);
	    eval 'sub pmap_copy_page {
	        my($s, $d) = @_;
    		eval q((* &pmap_copy_page_func)(($s), ($d)));
	    }' unless defined(&pmap_copy_page);
	    eval 'sub pmap_zero_page {
	        my($d) = @_;
    		eval q((* &pmap_zero_page_func)(($d)));
	    }' unless defined(&pmap_zero_page);
	}
 elsif(((defined(&ARM_MMU_GENERIC) ? &ARM_MMU_GENERIC : 0) + (defined(&ARM_MMU_SA1) ? &ARM_MMU_SA1 : 0)) != 0) {
	    eval 'sub L2_S_PROT_U () { &L2_S_PROT_U_generic;}' unless defined(&L2_S_PROT_U);
	    eval 'sub L2_S_PROT_W () { &L2_S_PROT_W_generic;}' unless defined(&L2_S_PROT_W);
	    eval 'sub L2_S_PROT_MASK () { &L2_S_PROT_MASK_generic;}' unless defined(&L2_S_PROT_MASK);
	    eval 'sub L1_S_CACHE_MASK () { &L1_S_CACHE_MASK_generic;}' unless defined(&L1_S_CACHE_MASK);
	    eval 'sub L2_L_CACHE_MASK () { &L2_L_CACHE_MASK_generic;}' unless defined(&L2_L_CACHE_MASK);
	    eval 'sub L2_S_CACHE_MASK () { &L2_S_CACHE_MASK_generic;}' unless defined(&L2_S_CACHE_MASK);
	    eval 'sub L1_S_PROTO () { &L1_S_PROTO_generic;}' unless defined(&L1_S_PROTO);
	    eval 'sub L1_C_PROTO () { &L1_C_PROTO_generic;}' unless defined(&L1_C_PROTO);
	    eval 'sub L2_S_PROTO () { &L2_S_PROTO_generic;}' unless defined(&L2_S_PROTO);
	    eval 'sub pmap_copy_page {
	        my($s, $d) = @_;
    		eval q( &pmap_copy_page_generic(($s), ($d)));
	    }' unless defined(&pmap_copy_page);
	    eval 'sub pmap_zero_page {
	        my($d) = @_;
    		eval q( &pmap_zero_page_generic(($d)));
	    }' unless defined(&pmap_zero_page);
	}
 elsif((defined(&ARM_MMU_XSCALE) ? &ARM_MMU_XSCALE : 0) == 1) {
	    eval 'sub L2_S_PROT_U () { &L2_S_PROT_U_xscale;}' unless defined(&L2_S_PROT_U);
	    eval 'sub L2_S_PROT_W () { &L2_S_PROT_W_xscale;}' unless defined(&L2_S_PROT_W);
	    eval 'sub L2_S_PROT_MASK () { &L2_S_PROT_MASK_xscale;}' unless defined(&L2_S_PROT_MASK);
	    eval 'sub L1_S_CACHE_MASK () { &L1_S_CACHE_MASK_xscale;}' unless defined(&L1_S_CACHE_MASK);
	    eval 'sub L2_L_CACHE_MASK () { &L2_L_CACHE_MASK_xscale;}' unless defined(&L2_L_CACHE_MASK);
	    eval 'sub L2_S_CACHE_MASK () { &L2_S_CACHE_MASK_xscale;}' unless defined(&L2_S_CACHE_MASK);
	    eval 'sub L1_S_PROTO () { &L1_S_PROTO_xscale;}' unless defined(&L1_S_PROTO);
	    eval 'sub L1_C_PROTO () { &L1_C_PROTO_xscale;}' unless defined(&L1_C_PROTO);
	    eval 'sub L2_S_PROTO () { &L2_S_PROTO_xscale;}' unless defined(&L2_S_PROTO);
	    eval 'sub pmap_copy_page {
	        my($s, $d) = @_;
    		eval q( &pmap_copy_page_xscale(($s), ($d)));
	    }' unless defined(&pmap_copy_page);
	    eval 'sub pmap_zero_page {
	        my($d) = @_;
    		eval q( &pmap_zero_page_xscale(($d)));
	    }' unless defined(&pmap_zero_page);
	}
	eval 'sub L1_S_PROT {
	    my($ku, $pr) = @_;
    	    eval q((((($ku) ==  &PTE_USER) ?  &L1_S_PROT_U : 0) | ((($pr) &  &VM_PROT_WRITE) ?  &L1_S_PROT_W : 0)));
	}' unless defined(&L1_S_PROT);
	eval 'sub L2_L_PROT {
	    my($ku, $pr) = @_;
    	    eval q((((($ku) ==  &PTE_USER) ?  &L2_L_PROT_U : 0) | ((($pr) &  &VM_PROT_WRITE) ?  &L2_L_PROT_W : 0)));
	}' unless defined(&L2_L_PROT);
	eval 'sub L2_S_PROT {
	    my($ku, $pr) = @_;
    	    eval q((((($ku) ==  &PTE_USER) ?  &L2_S_PROT_U : 0) | ((($pr) &  &VM_PROT_WRITE) ?  &L2_S_PROT_W : 0)));
	}' unless defined(&L2_S_PROT);
	eval 'sub L1_S_MAPPABLE_P {
	    my($va, $pa, $size) = @_;
    	    eval q((((($va) | ($pa)) &  &L1_S_OFFSET) == 0 && ($size) >=  &L1_S_SIZE));
	}' unless defined(&L1_S_MAPPABLE_P);
	eval 'sub L2_L_MAPPABLE_P {
	    my($va, $pa, $size) = @_;
    	    eval q((((($va) | ($pa)) &  &L2_L_OFFSET) == 0 && ($size) >=  &L2_L_SIZE));
	}' unless defined(&L2_L_MAPPABLE_P);
	eval 'sub POOL_VTOPHYS {
	    my($va) = @_;
    	    eval q( &vtophys(( &vaddr_t) ($va)));
	}' unless defined(&POOL_VTOPHYS);
    }
}
1;
