require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_ALPHA_INTR_H_)) {
    eval 'sub _ALPHA_INTR_H_ () {1;}' unless defined(&_ALPHA_INTR_H_);
    require 'sys/evcount.ph';
    require 'sys/lock.ph';
    require 'sys/queue.ph';
    require 'machine/atomic.ph';
    eval 'sub SCB_IOVECBASE () {0x800;}' unless defined(&SCB_IOVECBASE);
    eval 'sub SCB_VECSIZE () {0x10;}' unless defined(&SCB_VECSIZE);
    eval 'sub SCB_SIZE () {0x2000;}' unless defined(&SCB_SIZE);
    eval 'sub SCB_VECTOIDX {
        my($x) = @_;
	    eval q((($x) >> 4));
    }' unless defined(&SCB_VECTOIDX);
    eval 'sub SCB_IDXTOVEC {
        my($x) = @_;
	    eval q((($x) << 4));
    }' unless defined(&SCB_IDXTOVEC);
    eval 'sub SCB_NIOVECS () { &SCB_VECTOIDX( &SCB_SIZE -  &SCB_IOVECBASE);}' unless defined(&SCB_NIOVECS);
    eval 'sub IPL_NONE () {1;}' unless defined(&IPL_NONE);
    eval 'sub IPL_BIO () {1;}' unless defined(&IPL_BIO);
    eval 'sub IPL_NET () {1;}' unless defined(&IPL_NET);
    eval 'sub IPL_TTY () {1;}' unless defined(&IPL_TTY);
    eval 'sub IPL_CLOCK () {2;}' unless defined(&IPL_CLOCK);
    eval 'sub IPL_HIGH () {3;}' unless defined(&IPL_HIGH);
    eval 'sub IPL_SERIAL () {1;}' unless defined(&IPL_SERIAL);
    eval 'sub IPL_AUDIO () {1;}' unless defined(&IPL_AUDIO);
    eval 'sub IPL_SOFTSERIAL () {0;}' unless defined(&IPL_SOFTSERIAL);
    eval 'sub IPL_SOFTNET () {1;}' unless defined(&IPL_SOFTNET);
    eval 'sub IPL_SOFTCLOCK () {2;}' unless defined(&IPL_SOFTCLOCK);
    eval 'sub IPL_SOFT () {3;}' unless defined(&IPL_SOFT);
    eval 'sub IPL_NSOFT () {4;}' unless defined(&IPL_NSOFT);
    eval 'sub IST_UNUSABLE () {-1;}' unless defined(&IST_UNUSABLE);
    eval 'sub IST_NONE () {0;}' unless defined(&IST_NONE);
    eval 'sub IST_PULSE () {1;}' unless defined(&IST_PULSE);
    eval 'sub IST_EDGE () {2;}' unless defined(&IST_EDGE);
    eval 'sub IST_LEVEL () {3;}' unless defined(&IST_LEVEL);
    if(defined(&_KERNEL)) {
	eval 'sub splassert {
	    my($wantipl) = @_;
    	    eval q();
	}' unless defined(&splassert);
	eval 'sub splx {
	    my($s) = @_;
    	    eval q((($s) ==  &ALPHA_PSL_IPL_0 ?  &spl0() :  &alpha_pal_swpipl($s)));
	}' unless defined(&splx);
	eval 'sub splsoft () {
	    eval q( &_splraise( &ALPHA_PSL_IPL_SOFT));
	}' unless defined(&splsoft);
	eval 'sub splsoftserial () {
	    eval q( &splsoft());
	}' unless defined(&splsoftserial);
	eval 'sub splsoftclock () {
	    eval q( &splsoft());
	}' unless defined(&splsoftclock);
	eval 'sub splsoftnet () {
	    eval q( &splsoft());
	}' unless defined(&splsoftnet);
	eval 'sub splnet () {
	    eval q( &_splraise( &ALPHA_PSL_IPL_IO));
	}' unless defined(&splnet);
	eval 'sub splbio () {
	    eval q( &_splraise( &ALPHA_PSL_IPL_IO));
	}' unless defined(&splbio);
	eval 'sub spltty () {
	    eval q( &_splraise( &ALPHA_PSL_IPL_IO));
	}' unless defined(&spltty);
	eval 'sub splserial () {
	    eval q( &_splraise( &ALPHA_PSL_IPL_IO));
	}' unless defined(&splserial);
	eval 'sub splaudio () {
	    eval q( &_splraise( &ALPHA_PSL_IPL_IO));
	}' unless defined(&splaudio);
	eval 'sub splvm () {
	    eval q( &_splraise( &ALPHA_PSL_IPL_IO));
	}' unless defined(&splvm);
	eval 'sub splclock () {
	    eval q( &_splraise( &ALPHA_PSL_IPL_CLOCK));
	}' unless defined(&splclock);
	eval 'sub splstatclock () {
	    eval q( &_splraise( &ALPHA_PSL_IPL_CLOCK));
	}' unless defined(&splstatclock);
	eval 'sub splhigh () {
	    eval q( &_splraise( &ALPHA_PSL_IPL_HIGH));
	}' unless defined(&splhigh);
	eval 'sub spllpt () {
	    eval q( &spltty());
	}' unless defined(&spllpt);
	eval 'sub ALPHA_IPI_HALT () {0x1;}' unless defined(&ALPHA_IPI_HALT);
	eval 'sub ALPHA_IPI_TBIA () {0x2;}' unless defined(&ALPHA_IPI_TBIA);
	eval 'sub ALPHA_IPI_TBIAP () {0x4;}' unless defined(&ALPHA_IPI_TBIAP);
	eval 'sub ALPHA_IPI_SHOOTDOWN () {0x8;}' unless defined(&ALPHA_IPI_SHOOTDOWN);
	eval 'sub ALPHA_IPI_IMB () {0x10;}' unless defined(&ALPHA_IPI_IMB);
	eval 'sub ALPHA_IPI_AST () {0x20;}' unless defined(&ALPHA_IPI_AST);
	eval 'sub ALPHA_NIPIS () {6;}' unless defined(&ALPHA_NIPIS);
	eval 'sub ALPHA_SHARED_INTR_DISABLE {
	    my($asi, $num) = @_;
    	    eval q((($asi)[$num]. &intr_maxstrays != 0 && ($asi)[$num]. &intr_nstrays == ($asi)[$num]. &intr_maxstrays));
	}' unless defined(&ALPHA_SHARED_INTR_DISABLE);
	eval 'sub setsoft {
	    my($x) = @_;
    	    eval q( &atomic_setbits_ulong( &ssir, 1<< ($x)));
	}' unless defined(&setsoft);
	eval 'sub __GENERIC_SOFT_INTERRUPTS () {1;}' unless defined(&__GENERIC_SOFT_INTERRUPTS);
	eval 'sub softintr_schedule {
	    my($arg) = @_;
    	    eval q( &do { \'struct alpha_soft_intrhand\' * &__sih = ($arg);  ($__sih->{sih_pending}) = 1;  &setsoft( ($__sih->{sih_intrhead}->{softintr_ipl})); }  &while (0));
	}' unless defined(&softintr_schedule);
	eval 'sub setsoftnet () {
	    eval q( &softintr_schedule( &softnet_intrhand));
	}' unless defined(&setsoftnet);
	eval 'sub setsoftclock () {
	    eval q( &softintr_schedule( &softclock_intrhand));
	}' unless defined(&setsoftclock);
	eval 'sub SCB_ALLOC_FAILED () {( -1);}' unless defined(&SCB_ALLOC_FAILED);
    }
}
1;
