require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LOCORE)) {
}
unless(defined(&PT_ENTRY_NULL)) {
    sub PT_ENTRY_NULL () {	(( &pt_entry_t *) 0);}
}
unless(defined(&PG_RO)) {
    sub PG_RO () {	0x40000000;}
}
unless(defined(&PG_SVPN)) {
    sub PG_SVPN () {	0xfffff000;}
}
unless(defined(&PG_HVPN)) {
    sub PG_HVPN () {	0xffffe000;}
}
unless(defined(&PG_ODDPG)) {
    sub PG_ODDPG () {	0x1000;}
}
unless(defined(&PG_ASID)) {
    sub PG_ASID () {	0xff;}
}
unless(defined(&PG_G)) {
    sub PG_G () {	0x1;}
}
unless(defined(&PG_V)) {
    sub PG_V () {	0x2;}
}
unless(defined(&PG_NV)) {
    sub PG_NV () {	0x;}
}
unless(defined(&PG_M)) {
    sub PG_M () {	0x4;}
}
unless(defined(&PG_ATTR)) {
    sub PG_ATTR () {	0x3f;}
}
unless(defined(&PG_UNCACHED)) {
    sub PG_UNCACHED () {	0x10;}
}
unless(defined(&PG_CACHED_NC)) {
    sub PG_CACHED_NC () {	0x18;}
}
unless(defined(&PG_CACHED_CE)) {
    sub PG_CACHED_CE () {	0x20;}
}
unless(defined(&PG_CACHED_CEW)) {
    sub PG_CACHED_CEW () {	0x28;}
}
unless(defined(&PG_CACHEMODE)) {
    sub PG_CACHEMODE () {	0x38;}
}
if(defined(&TGT_COHERENT)) {
    eval 'sub PG_CACHED () { &PG_CACHED_CE;}' unless defined(&PG_CACHED);
} else {
    eval 'sub PG_CACHED () { &PG_CACHED_NC;}' unless defined(&PG_CACHED);
}
unless(defined(&PG_ROPAGE)) {
    sub PG_ROPAGE () {	( &PG_V |  &PG_RO |  &PG_CACHED);}
}
unless(defined(&PG_RWPAGE)) {
    sub PG_RWPAGE () {	( &PG_V |  &PG_M |  &PG_CACHED);}
}
unless(defined(&PG_CWPAGE)) {
    sub PG_CWPAGE () {	( &PG_V |  &PG_CACHED);}
}
unless(defined(&PG_IOPAGE)) {
    sub PG_IOPAGE () {	( &PG_G |  &PG_V |  &PG_M |  &PG_UNCACHED);}
}
unless(defined(&PG_FRAME)) {
    sub PG_FRAME () {	0x3fffffc0;}
}
unless(defined(&PG_SHIFT)) {
    sub PG_SHIFT () {	6;}
}
unless(defined(&pfn_is_ext)) {
    sub pfn_is_ext {
	my($x) = @_;
	eval q((($x) & 0x3c000000));
    }
}
unless(defined(&vad_to_pfn)) {
    sub vad_to_pfn {
	my($x) = @_;
	eval q(((($x) >>  &PG_SHIFT) &  &PG_FRAME));
    }
}
unless(defined(&vad_to_pfn64)) {
    sub vad_to_pfn64 {
	my($x) = @_;
	eval q(((( &quad_t)($x) >>  &PG_SHIFT) &  &PG_FRAME));
    }
}
unless(defined(&vad_to_vpn)) {
    sub vad_to_vpn {
	my($x) = @_;
	eval q(((($x) &  &PG_SVPN)));
    }
}
unless(defined(&vpn_to_vad)) {
    sub vpn_to_vad {
	my($x) = @_;
	eval q(((($x) &  &PG_SVPN)));
    }
}
unless(defined(&uvtopte)) {
    sub uvtopte {
	my($adr) = @_;
	eval q(((($adr) >>  &PGSHIFT) & ( &NPTEPG -1)));
    }
}
unless(defined(&PG_SIZE_4K)) {
    sub PG_SIZE_4K () {	0x;}
}
unless(defined(&PG_SIZE_16K)) {
    sub PG_SIZE_16K () {	0x6000;}
}
unless(defined(&PG_SIZE_64K)) {
    sub PG_SIZE_64K () {	0x1e000;}
}
unless(defined(&PG_SIZE_256K)) {
    sub PG_SIZE_256K () {	0x7e000;}
}
unless(defined(&PG_SIZE_1M)) {
    sub PG_SIZE_1M () {	0x1fe000;}
}
unless(defined(&PG_SIZE_4M)) {
    sub PG_SIZE_4M () {	0x7fe000;}
}
unless(defined(&PG_SIZE_16M)) {
    sub PG_SIZE_16M () {	0x1ffe000;}
}
if(defined( &_KERNEL)  && !defined( &_LOCORE)) {
    eval 'sub pfn_to_pad {
        my($pte) = @_;
	    eval q({  &vaddr_t  &pa;  &pa = ((($pte &  &PG_FRAME) <<  &PG_SHIFT));  &pa; });
    }' unless defined(&pfn_to_pad);
    eval 'sub kvtopte {
        my($va) = @_;
	    eval q(( &Sysmap + ((( &vaddr_t)($va) -  &VM_MIN_KERNEL_ADDRESS) >>  &PGSHIFT)));
    }' unless defined(&kvtopte);
    eval 'sub ptetokv {
        my($pte) = @_;
	    eval q((((( &pt_entry_t *)($pte) -  &Sysmap) <<  &PGSHIFT) +  &VM_MIN_KERNEL_ADDRESS));
    }' unless defined(&ptetokv);
}
1;
