/* include/libast/sysdefs.h.  Generated by configure.  */
/*
 * Copyright (C) 1997-2004, Michael Jennings
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies of the Software, its documentation and marketing & publicity
 * materials, and acknowledgment shall be given in the documentation, materials
 * and software packages that this Software was used.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

/**
 * @file sysdefs.h
 * LibAST autotools fill-in header file.
 *
 * This file makes sure that all autoconf/automake-related definitions
 * LibAST headers need are defined one way or the other.
 *
 * @author Michael Jennings <mej@eterm.org>
 * @version $Revision: 1.4 $
 * @date $Date: 2004/01/21 23:20:46 $
 */

#ifndef _LIBAST_SYSDEFS_H_
#define _LIBAST_SYSDEFS_H_

/* This GNU goop has to go before the system headers */
#ifdef __GNUC__
# ifndef __USE_GNU
#  define __USE_GNU
# endif
# ifndef _GNU_SOURCE
#  define _GNU_SOURCE
# endif
# ifndef _BSD_SOURCE
#  define _BSD_SOURCE
# endif
# ifndef _XOPEN_SOURCE
/* FIXME -- Do some systems still need this? */
/* #  define _XOPEN_SOURCE */
# endif
#endif

/* The LibAST version string. */
#ifndef LIBAST_VERSION
#  define LIBAST_VERSION "0.7"
#endif

/* Support for the X Window system. */
#ifndef LIBAST_X11_SUPPORT
#  define LIBAST_X11_SUPPORT 1
#endif

/* Support for the Imlib2 image library. */
#ifndef LIBAST_IMLIB2_SUPPORT
#  define LIBAST_IMLIB2_SUPPORT 0
#endif

/* Support for MMX instructions. */
#ifndef LIBAST_MMX_SUPPORT
#  define LIBAST_MMX_SUPPORT 0
#endif

/* Regexp's based on Perl's PCRE, or... */
#ifndef LIBAST_REGEXP_SUPPORT_PCRE
#  define LIBAST_REGEXP_SUPPORT_PCRE 0
#endif

/* ...standard POSIX regexp support, or... */
#ifndef LIBAST_REGEXP_SUPPORT_POSIX
#  define LIBAST_REGEXP_SUPPORT_POSIX 1
#endif

/* ...BSD-style regexp support. */
#ifndef LIBAST_REGEXP_SUPPORT_BSD
#  define LIBAST_REGEXP_SUPPORT_BSD 0
#endif

/* Support for backquote execution in config files. */
#ifndef ALLOW_BACKQUOTE_EXEC
#  define ALLOW_BACKQUOTE_EXEC 1
#endif

/* App-definable; requests 0.5 API compatibility (pollutes namespace). */
#ifndef LIBAST_COMPAT_05_API
#  define LIBAST_COMPAT_05_API 0
#endif

/* A bunch of security checks. */
#ifndef HAVE_RLIMIT_MEMLOCK
#  define HAVE_RLIMIT_MEMLOCK 0
#endif
#ifndef HAVE_RLIMIT_NPROC
#  define HAVE_RLIMIT_NPROC 0
#endif
#ifndef HAVE_SYMLINK_OPEN_ERRNO_BUG
#  define HAVE_SYMLINK_OPEN_ERRNO_BUG 0
#endif
#ifndef HAVE_SYMLINK_OPEN_SECURITY_HOLE
#  define HAVE_SYMLINK_OPEN_SECURITY_HOLE 0
#endif
#ifndef HAVE_SNPRINTF_BUG
#  define HAVE_SNPRINTF_BUG 0
#endif
#ifndef HAVE_VSNPRINTF_BUG
#  define HAVE_VSNPRINTF_BUG 0
#endif

/* Sizes of basic variables. */
#ifndef SIZEOF_CHAR
#  define SIZEOF_CHAR 1
#endif
#ifndef SIZEOF_INT
#  define SIZEOF_INT 4
#endif
#ifndef SIZEOF_LONG
#  define SIZEOF_LONG 8
#endif
#ifndef SIZEOF_LONG_LONG
#  define SIZEOF_LONG_LONG 8
#endif
#ifndef SIZEOF_SHORT
#  define SIZEOF_SHORT 2
#endif
#ifndef WORDS_BIGENDIAN
#  define WORDS_BIGENDIAN 1
#endif

/* Substitutes for some non-standard functions. */
#ifndef HAVE_MEMMEM
#  define HAVE_MEMMEM 0
#endif
#ifndef HAVE_MEMMOVE
#  define HAVE_MEMMOVE 1
#endif
#ifndef HAVE_PUTENV
#  define HAVE_PUTENV 1
#endif
#ifndef HAVE_STRCASECHR
#  define HAVE_STRCASECHR 0
#endif
#ifndef HAVE_STRCASEPBRK
#  define HAVE_STRCASEPBRK 0
#endif
#ifndef HAVE_STRCASESTR
#  define HAVE_STRCASESTR 1
#endif
#ifndef HAVE_STRNLEN
#  define HAVE_STRNLEN 0
#endif
#ifndef HAVE_STRREV
#  define HAVE_STRREV 0
#endif
#ifndef HAVE_STRSEP
#  define HAVE_STRSEP 1
#endif
#ifndef HAVE_USLEEP
#  define HAVE_USLEEP 1
#endif
#ifndef HAVE_SNPRINTF
#  define HAVE_SNPRINTF 1
#endif
#ifndef HAVE_VSNPRINTF
#  define HAVE_VSNPRINTF 1
#endif

/* Header checks used in libast.h */
#ifndef TIME_WITH_SYS_TIME
#  define TIME_WITH_SYS_TIME 1
#endif
#ifndef HAVE_MALLOC_H
#  define HAVE_MALLOC_H 0
#endif
#ifndef HAVE_PCRE_H
#  define HAVE_PCRE_H 1
#endif
#ifndef HAVE_PCRE_PCRE_H
#  define HAVE_PCRE_PCRE_H 0
#endif
#ifndef HAVE_REGEX_H
#  define HAVE_REGEX_H 1
#endif
#ifndef WITH_DMALLOC
#  define WITH_DMALLOC 0
#endif
#ifndef MALLOC_CALL_DEBUG
#  define MALLOC_CALL_DEBUG 0
#endif


#endif /* _LIBAST_SYSDEFS_H_ */
