### Name: groupGeneric
### Title: Group Generic Functions
### Aliases: .Method .Generic .Group .Class Math Math.data.frame
###   Math.factor Ops Ops.data.frame Ops.factor Ops.ordered Summary
###   Summary.data.frame Summary.factor Arith Compare Complex Math2 group
###   generic
### Keywords: methods

### ** Examples

methods("Math")
methods("Ops")
methods("Summary")

d.fr <- data.frame(x=1:9, y=rnorm(9))
data.class(1 + d.fr) == "data.frame" ##-- add to d.f. ...

if(.isMethodsDispatchOn()) {# package "methods" is attached or loaded
  setClass("testComplex", representation(zz = "complex"))
  ## method for whole group "Complex"
  setMethod("Complex", "testComplex",
            function(z) c("groupMethod", callGeneric(z@zz)))
  ## exception for Arg() :
  setMethod("Arg", "testComplex",
            function(z) c("ArgMethod", Arg(z@zz)))
  z1 <- 1+2i
  z2 <- new("testComplex", zz = z1)
  stopifnot(identical(Mod(z2), c("groupMethod", Mod(z1))))
  stopifnot(identical(Arg(z2), c("ArgMethod", Arg(z1))))
}



