#!/usr/bin/perl

# OpenWebMail Statistics Generator v1.1 - Dimitrios 'sehh' Michelinakis <sehh@altered.com>

use strict;
use GD::Graph::linespoints;
use Date::Calc qw(:all);
use vars qw($logfile $graphtitle $graphxlabel $graphylabel);

# CONFIGURATION VARIABLES
$logfile = "openwebmail.log";
my $prefix = "stats-";
my $year = 2004;
my @months = ("6","7");
my @keywords = ("login","pop3 error");
$graphtitle = 'Monthly Statistics';
$graphxlabel ='Day';
$graphylabel = 'Count';
# END OF VARIABLES


# NO NEED TO EDIT ANYTHING BELOW THIS LINE
for(my $i=0;$i<@months;$i++) {
 my @dates;
 for(my $j=0;$j<Days_in_Month($year,$months[$i]);$j++) { $dates[$j] = $j+1; }
 for(my $ii=0;$ii<@keywords;$ii++) {
  print "Generating statistics for month: $months[$i], keyword: $keywords[$ii].\n";
  my @result = &generateNumbers("$keywords[$ii]",$months[$i]);
  (my $file = $keywords[$ii]) =~ s/ //;
  &generateImage("$prefix$months[$i]-$file.png", ([@dates],[@result]) );
 }
}

sub generateNumbers {
 my $keyword = $_[0];
 my $month = $_[1];
 my @result;
 my @months = ('', 'Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec');
 open (LOG, $logfile) or die $!;
 while (<LOG>) { if (/ $months[$month] ([ \d]\d).*- $keyword -/) { my $tmp=$1-1; $result[$tmp]++; } }
 return @result;
}

sub generateImage {
my ($output, @data) = @_ ;
my $mygraph = GD::Graph::linespoints->new(550, 250);
$mygraph->set(
    title          => $graphtitle,
    x_label        => $graphxlabel,
    y_label        => $graphylabel,
    x_label_position => 1/2,
    y_long_ticks   => 1,
    transparent    => 0,
    line_types     => [3],
    marker_size    => 3,
    # BLACK-WHITE
     dclrs          => [ 'black' ], # gray
     textclr        => 'black', # gray
     labelclr       => 'black', # gray
     valuesclr      => 'black', # gray
     accentclr      => 'gray',  # gray
     axislabelclr   => 'black', # gray
     legendclr      => 'gray',
     fgclr          => 'lgray',
     bgclr          => 'white',
    # COLOR
     #dclrs          => [ '#aafffa' ],
     #textclr        => 'white',
     #labelclr       => 'white',
     #valuesclr      => 'white',
     #accentclr      => 'white',
     #axislabelclr   => 'white',
     #legendclr      => 'white',
     #fgclr          => 'gray',
     #bgclr          => '#003366',
) or warn $mygraph->error;
my $myimage = $mygraph->plot(\@data) or die $mygraph->error;
open(IMG, ">$output") or die $!;
binmode IMG;
print IMG $myimage->png;
close IMG;
}
