// -*- c++ -*-
//
// $Id: functions.h,v 1.1.1.1.2.2 2001/10/29 04:33:20 bbarrett Exp $
//
// Copyright 1997-2001, University of Notre Dame.
// Authors: Jeffrey M. Squyres, Jeremy G. Siek, Michael P. McNally, and
//          Andrew Lumsdaine
// 
// This file is part of the Notre Dame C++ bindings for MPI.
// 
// You should have received a copy of the License Agreement for the Notre
// Dame C++ bindings for MPI along with the software; see the file
// LICENSE.  If not, contact Office of Research, University of Notre
// Dame, Notre Dame, IN 46556.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted subject to the conditions specified in the
// LICENSE file.
// 
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
// INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
// STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
// IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.
// 
// Additional copyrights may follow.
//

//
// Point-to-Point Communication
//

_MPIPP_STATIC_ void 
Attach_buffer(void* buffer, int size);

_MPIPP_STATIC_ int 
Detach_buffer(void*& buffer);

//
// Process Topologies
//

_MPIPP_STATIC_ void
Compute_dims(int nnodes, int ndims, int dims[]);

//
// Environmental Inquiry
//

_MPIPP_STATIC_ void 
Get_processor_name(char* name, int& resultlen);

_MPIPP_STATIC_ void
Get_error_string(int errorcode, char* string, int& resultlen);

_MPIPP_STATIC_ int 
Get_error_class(int errorcode);

_MPIPP_STATIC_ double 
Wtime();

_MPIPP_STATIC_ double 
Wtick();

_MPIPP_STATIC_ void
Init(int& argc, char**& argv);

_MPIPP_STATIC_ void
Init();

_MPIPP_STATIC_ void
Real_init();

_MPIPP_STATIC_ void
Finalize();

_MPIPP_STATIC_ MPI2CPP_BOOL_T
Is_initialized();

//
// Profiling
//

_MPIPP_STATIC_ void
Pcontrol(const int level, ...);


#if MPI2CPP_HAVE_MPI_GET_VERSION
_MPIPP_STATIC_ void
Get_version(int& version, int& subversion);
#endif

_MPIPP_STATIC_ _REAL_MPI_::Aint
Get_address(void* location);
