### Name: singer
### Title: Heights of New York Choral Society singers
### Aliases: singer
### Keywords: datasets

### ** Examples

# Separate histogram for each voice part (Figure 1.2 from Cleveland)
histogram(~ height | voice.part,
          data = singer,
          aspect=1,
          layout = c(2, 4), 
          nint=15,
          xlab = "Height (inches)")

# Quantile-Quantile plot (Figure 2.11 from Cleveland)
qqmath(~ height | voice.part,
       data=singer,
       aspect=1, 
       layout=c(2,4),
       prepanel = prepanel.qqmathline,
       panel = function(x, y) {
         panel.grid()
         panel.qqmathline(y, distribution = qnorm)
         panel.qqmath(x, y)
       },
       xlab = "Unit Normal Quantile",
       ylab="Height (inches)")



