### Name: Startup
### Title: Initialization at Start of an R Session
### Aliases: Startup Rprofile .Rprofile Rprofile.site Renviron.site
###   .Renviron .First .First.sys
### Keywords: environment

### ** Examples

## Not run: 
##D # Example ~/.Renviron on Unix
##D R_LIBS=~/R/library
##D PAGER=/usr/local/bin/less
##D 
##D # Example .Renviron on Windows
##D R_LIBS=C:/R/library
##D MY_TCLTK=yes
##D TCL_LIBRARY=c:/packages/Tcl/lib/tcl8.4
##D 
##D # Example of .Rprofile
##D options(width=65, digits=5)
##D options(show.signif.stars=FALSE)
##D ps.options(horizontal=FALSE)
##D set.seed(1234)
##D .First <- function() cat("\n   Welcome to R!\n\n")
##D .Last <- function()  cat("\n   Goodbye!\n\n")
##D 
##D # Example of Rprofile.site
##D local({
##D   old <- getOption("defaultPackages")
##D   options(defaultPackages = c(old, "MASS"))
##D })
##D 
##D ## if .Renviron contains
##D FOOBAR="coo\bar"doh\ex"abc\"def'"
##D 
##D ## then we get
##D > cat(Sys.getenv("FOOBAR"), "\n")
##D coo\bardoh\exabc"def'
## End(Not run)


