/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.resource;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.ImageData;

class FileImageDescriptor
extends ImageDescriptor {
    private Class location;
    private String name;

    FileImageDescriptor(Class clazz, String filename) {
        this.location = clazz;
        this.name = filename;
    }

    public boolean equals(Object o) {
        if (!(o instanceof FileImageDescriptor)) {
            return false;
        }
        FileImageDescriptor other = (FileImageDescriptor)o;
        if (this.location != null ? !this.location.equals(other.location) : other.location != null) {
            return false;
        }
        return this.name.equals(other.name);
    }

    public ImageData getImageData() {
        InputStream in = this.getStream();
        ImageData result = null;
        if (in != null) {
            try {
                try {
                    result = new ImageData(in);
                }
                catch (SWTException e) {
                    if (e.code != 40) {
                        throw e;
                    }
                }
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        return result;
    }

    private InputStream getStream() {
        InputStream is = null;
        if (this.location != null) {
            is = this.location.getResourceAsStream(this.name);
        } else {
            try {
                is = new FileInputStream(this.name);
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
        }
        if (is == null) {
            return null;
        }
        return new BufferedInputStream(is);
    }

    public int hashCode() {
        int code = this.name.hashCode();
        if (this.location != null) {
            code += this.location.hashCode();
        }
        return code;
    }

    public String toString() {
        return "FileImageDescriptor(location=" + this.location + ", name=" + this.name + ")";
    }
}

