/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.eclipse.osgi.framework.adaptor.FrameworkAdaptor;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;

public class MessageResourceBundle {
    private static FrameworkAdaptor adaptor;
    static final Object ASSIGNED;
    private static final String EXTENSION = ".properties";
    private static String[] nlSuffixes;
    static int SEVERITY_ERROR;
    static int SEVERITY_WARNING;

    static {
        ASSIGNED = new Object();
        SEVERITY_ERROR = 4;
        SEVERITY_WARNING = 2;
    }

    private static String[] buildVariants(String root) {
        if (nlSuffixes == null) {
            String nl = Locale.getDefault().toString();
            ArrayList<String> result = new ArrayList<String>(4);
            while (true) {
                result.add(String.valueOf('_') + nl + EXTENSION);
                int lastSeparator = nl.lastIndexOf(95);
                if (lastSeparator == -1) break;
                nl = nl.substring(0, lastSeparator);
            }
            result.add(EXTENSION);
            nlSuffixes = result.toArray(new String[result.size()]);
        }
        root = root.replace('.', '/');
        String[] variants = new String[nlSuffixes.length];
        int i = 0;
        while (i < variants.length) {
            variants[i] = String.valueOf(root) + nlSuffixes[i];
            ++i;
        }
        return variants;
    }

    static void makeAccessible(final Field field) {
        if (System.getSecurityManager() == null) {
            field.setAccessible(true);
        } else {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    field.setAccessible(true);
                    return null;
                }
            });
        }
    }

    private static void computeMissingMessages(String bundleName, Class clazz, Map fieldMap, Field[] fieldArray, boolean isAccessible) {
        int numFields = fieldArray.length;
        int i = 0;
        while (i < numFields) {
            Field field = fieldArray[i];
            if ((field.getModifiers() & 0x19) == 9 && fieldMap.get(field.getName()) != ASSIGNED) {
                try {
                    String value = "NLS missing message: " + field.getName() + " in: " + bundleName;
                    if (Debug.DEBUG_MESSAGE_BUNDLES) {
                        System.out.println(value);
                    }
                    MessageResourceBundle.log(SEVERITY_WARNING, value, null);
                    if (!isAccessible) {
                        MessageResourceBundle.makeAccessible(field);
                    }
                    field.set(null, value);
                }
                catch (Exception e) {
                    MessageResourceBundle.log(SEVERITY_ERROR, "Error setting the missing message value for: " + field.getName(), e);
                }
            }
            ++i;
        }
    }

    public static void load(String bundleName, Class clazz) {
        long start = System.currentTimeMillis();
        Field[] fieldArray = clazz.getDeclaredFields();
        ClassLoader loader = clazz.getClassLoader();
        boolean isAccessible = (clazz.getModifiers() & 1) != 0;
        int len = fieldArray.length;
        HashMap<String, Field> fields = new HashMap<String, Field>(len * 2);
        int i = 0;
        while (i < len) {
            fields.put(fieldArray[i].getName(), fieldArray[i]);
            ++i;
        }
        String[] variants = MessageResourceBundle.buildVariants(bundleName);
        int i2 = 0;
        while (i2 < variants.length) {
            InputStream input;
            InputStream inputStream = input = loader == null ? ClassLoader.getSystemResourceAsStream(variants[i2]) : loader.getResourceAsStream(variants[i2]);
            if (input != null) {
                try {
                    try {
                        MessagesProperties properties = new MessagesProperties(fields, bundleName, isAccessible);
                        properties.load(input);
                    }
                    catch (IOException e) {
                        MessageResourceBundle.log(SEVERITY_ERROR, "Error loading " + variants[i2], e);
                    }
                }
                catch (Throwable throwable) {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            ++i2;
        }
        MessageResourceBundle.computeMissingMessages(bundleName, clazz, fields, fieldArray, isAccessible);
        if (Debug.DEBUG_MESSAGE_BUNDLES) {
            System.out.println("Time to load message bundle: " + bundleName + " was " + (System.currentTimeMillis() - start) + "ms.");
        }
    }

    static void log(int severity, String msg, Exception e) {
        if (adaptor != null) {
            adaptor.getFrameworkLog().log(new FrameworkLogEntry("org.eclipse.osgi " + severity + ' ' + 1, msg, 0, e, null));
        } else {
            System.out.println(msg);
            if (e != null) {
                e.printStackTrace();
            }
        }
    }

    static void setAdaptor(FrameworkAdaptor adaptor) {
        MessageResourceBundle.adaptor = adaptor;
    }

    private static class MessagesProperties
    extends Properties {
        private static final int MOD_EXPECTED = 9;
        private static final int MOD_MASK = 25;
        private static final long serialVersionUID = 1L;
        private final String bundleName;
        private final Map fields;
        private final boolean isAccessible;

        public MessagesProperties(Map fieldMap, String bundleName, boolean isAccessible) {
            this.fields = fieldMap;
            this.bundleName = bundleName;
            this.isAccessible = isAccessible;
        }

        public synchronized Object put(Object key, Object value) {
            Object fieldObject = this.fields.put(key, ASSIGNED);
            if (fieldObject == ASSIGNED) {
                return null;
            }
            if (fieldObject == null) {
                String msg = "NLS unused message: " + key + " in: " + this.bundleName;
                if (Debug.DEBUG_MESSAGE_BUNDLES) {
                    System.out.println(msg);
                }
                MessageResourceBundle.log(SEVERITY_WARNING, msg, null);
                return null;
            }
            Field field = (Field)fieldObject;
            if ((field.getModifiers() & 0x19) != 9) {
                return null;
            }
            try {
                if (!this.isAccessible) {
                    MessageResourceBundle.makeAccessible(field);
                }
                field.set(null, value);
            }
            catch (Exception e) {
                MessageResourceBundle.log(SEVERITY_ERROR, "Exception setting field value.", e);
            }
            return null;
        }
    }
}

