/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.help.internal.HelpPlugin;
import org.osgi.framework.Bundle;

public class ProductPreferences {
    private static final String TRUE = String.valueOf(true);
    private static Properties[] productPreferences;

    public static int countCommonItems(Set set, Collection collection) {
        if (set != null && collection != null) {
            HashSet setCopy = new HashSet(set);
            setCopy.retainAll(collection);
            return setCopy.size();
        }
        return 0;
    }

    public static List findBestMatch(Set items, List[] lists) {
        if (lists.length == 1) {
            return lists[0];
        }
        if (lists.length > 0) {
            List bestMatchSoFar = lists[0];
            int bestCount = 0;
            int i = 0;
            while (i < lists.length) {
                int count = ProductPreferences.countCommonItems(items, lists[i]);
                if (count > bestCount) {
                    bestCount = count;
                    bestMatchSoFar = lists[i];
                }
                ++i;
            }
            return bestMatchSoFar;
        }
        return null;
    }

    public static boolean getBoolean(Plugin plugin, String key) {
        Properties[] properties = ProductPreferences.getProductPreferences();
        String defaultValue = plugin.getPluginPreferences().getDefaultString(key);
        String currentValue = plugin.getPluginPreferences().getString(key);
        String pluginId = plugin.getBundle().getSymbolicName();
        if (currentValue != null && currentValue.equalsIgnoreCase(TRUE)) {
            return true;
        }
        int i = 0;
        while (i < properties.length) {
            String value = (String)properties[i].get(String.valueOf(pluginId) + '/' + key);
            if (value == null) {
                value = defaultValue;
            }
            if (value != null && value.equalsIgnoreCase(TRUE)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static List getOrderedList(Plugin plugin, String key, List items) {
        List primary = ProductPreferences.tokenize(plugin.getPluginPreferences().getString(key));
        Properties[] productPreferences = ProductPreferences.getProductPreferences();
        ArrayList<List> secondaryLists = new ArrayList<List>();
        int i = 0;
        while (i < productPreferences.length) {
            String value = productPreferences[i].getProperty(String.valueOf(plugin.getBundle().getSymbolicName()) + '/' + key);
            if (value != null) {
                secondaryLists.add(ProductPreferences.tokenize(value));
            }
            ++i;
        }
        List[] secondary = secondaryLists.toArray(new List[secondaryLists.size()]);
        return ProductPreferences.getOrderedList(items, primary, secondary);
    }

    public static List getOrderedList(List items, List primary, List[] secondary) {
        ArrayList<String> orderedList = new ArrayList<String>();
        HashSet itemsRemaining = new HashSet(items);
        if (primary != null) {
            for (String item : primary) {
                if (!itemsRemaining.contains(item)) continue;
                orderedList.add(item);
                itemsRemaining.remove(item);
            }
        }
        if (!itemsRemaining.isEmpty()) {
            if (secondary.length > 0) {
                List bestMatch = ProductPreferences.findBestMatch(itemsRemaining, secondary);
                for (String item : bestMatch) {
                    if (!itemsRemaining.contains(item)) continue;
                    orderedList.add(item);
                    itemsRemaining.remove(item);
                }
            }
            for (String item : items) {
                if (!itemsRemaining.contains(item)) continue;
                orderedList.add(item);
            }
        }
        return orderedList;
    }

    public static synchronized Properties[] getProductPreferences() {
        if (productPreferences == null) {
            ArrayList<Properties> collection = new ArrayList<Properties>();
            IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.core.runtime.products");
            int i = 0;
            while (i < elements.length) {
                if (elements[i].getName().equals("product")) {
                    String contributor = elements[i].getContributor().getName();
                    IConfigurationElement[] propertyElements = elements[i].getChildren("property");
                    int j = 0;
                    while (j < propertyElements.length) {
                        Properties properties;
                        String value;
                        String name = propertyElements[j].getAttribute("name");
                        if (name != null && name.equals("preferenceCustomization") && (value = propertyElements[j].getAttribute("value")) != null && (properties = ProductPreferences.loadPropertiesFile(contributor, value)) != null) {
                            collection.add(properties);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            productPreferences = collection.toArray(new Properties[collection.size()]);
        }
        return productPreferences;
    }

    public static Set getUniqueValues(Plugin plugin, String key, Properties[] properties) {
        HashSet<String> set = new HashSet<String>();
        String defaultValue = plugin.getPluginPreferences().getDefaultString(key);
        String currentValue = plugin.getPluginPreferences().getString(key);
        String pluginId = plugin.getBundle().getSymbolicName();
        int i = 0;
        while (i < properties.length) {
            String value = (String)properties[i].get(String.valueOf(pluginId) + '/' + key);
            set.add(value != null ? value : defaultValue);
            ++i;
        }
        set.add(currentValue != null ? currentValue : defaultValue);
        return set;
    }

    public static String getValue(String key, Properties primary, Properties[] secondary) {
        String value = null;
        if (primary != null) {
            value = primary.getProperty(key);
        }
        if (value == null) {
            int i = 0;
            while (i < secondary.length) {
                if (secondary[i] != primary && (value = secondary[i].getProperty(key)) != null) break;
                ++i;
            }
        }
        return value;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Properties loadPropertiesFile(String bundleId, String path) {
        InputStream in;
        block10: {
            Properties properties;
            Bundle bundle = Platform.getBundle((String)bundleId);
            if (bundle == null) return null;
            URL url = bundle.getEntry(path);
            if (url == null) return null;
            in = null;
            try {
                in = url.openStream();
                Properties properties2 = new Properties();
                properties2.load(in);
                properties = properties2;
                if (in == null) return properties;
            }
            catch (IOException e) {
                try {
                    HelpPlugin.logError("Error opening product's plugin customization file: " + bundleId + "/" + path, e);
                    break block10;
                }
                catch (Throwable throwable) {
                    if (in == null) throw throwable;
                    try {
                        in.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {
                in.close();
                return properties;
            }
            catch (IOException iOException) {}
            return properties;
        }
        if (in == null) return null;
        try {
            in.close();
            return null;
        }
        catch (IOException iOException) {}
        return null;
    }

    public static List tokenize(String str) {
        if (str != null) {
            StringTokenizer tok = new StringTokenizer(str, " \n\r\t;,");
            ArrayList<String> list = new ArrayList<String>();
            while (tok.hasMoreElements()) {
                list.add(tok.nextToken());
            }
            return list;
        }
        return new ArrayList();
    }
}

