/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.handlers;

import org.eclipse.core.commands.IHandler;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.services.EvaluationResultCache;

final class HandlerActivation
extends EvaluationResultCache
implements IHandlerActivation {
    private final String commandId;
    private final int depth;
    private final IHandler handler;
    private final IHandlerService handlerService;

    HandlerActivation(String commandId, IHandler handler, Expression expression, int depth, IHandlerService handlerService) {
        super(expression);
        if (commandId == null) {
            throw new NullPointerException("The command identifier for a handler activation cannot be null");
        }
        if (handlerService == null) {
            throw new NullPointerException("The handler service for an activation cannot be null");
        }
        this.commandId = commandId;
        this.depth = depth;
        this.handler = handler;
        this.handlerService = handlerService;
    }

    public final void clearActive() {
        this.clearResult();
    }

    public final int compareTo(Object object) {
        IHandlerActivation activation = (IHandlerActivation)object;
        int thisPriority = this.getSourcePriority();
        int thatPriority = activation.getSourcePriority();
        int difference = thatPriority - thisPriority;
        if (difference != 0) {
            return difference;
        }
        int thisDepth = this.getDepth();
        int thatDepth = activation.getDepth();
        difference = thatDepth - thisDepth;
        return difference;
    }

    public final String getCommandId() {
        return this.commandId;
    }

    public final int getDepth() {
        return this.depth;
    }

    public final IHandler getHandler() {
        return this.handler;
    }

    public final IHandlerService getHandlerService() {
        return this.handlerService;
    }

    public final boolean isActive(IEvaluationContext context) {
        return this.evaluate(context);
    }

    public final String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("HandlerActivation(commandId=");
        buffer.append(this.commandId);
        buffer.append(",handler=");
        buffer.append(this.handler);
        buffer.append(",expression=");
        buffer.append(this.getExpression());
        buffer.append(",sourcePriority=");
        buffer.append(this.getSourcePriority());
        buffer.append(')');
        return buffer.toString();
    }
}

