/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.views.IViewDescriptor;

public class ShowInAction
extends Action {
    private IWorkbenchWindow window;
    private IViewDescriptor desc;

    protected ShowInAction(IWorkbenchWindow window, IViewDescriptor desc) {
        super(String.valueOf('&') + desc.getLabel());
        this.setImageDescriptor(desc.getImageDescriptor());
        window.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.show_in_action_context");
        this.window = window;
        this.desc = desc;
    }

    public void run() {
        IWorkbenchPage page = this.window.getActivePage();
        if (page == null) {
            this.beep();
            return;
        }
        IWorkbenchPart sourcePart = page.getActivePart();
        if (sourcePart == null) {
            this.beep();
            return;
        }
        ShowInContext context = this.getContext(sourcePart);
        if (context == null) {
            this.beep();
            return;
        }
        try {
            IViewPart view = page.showView(this.desc.getId());
            IShowInTarget target = this.getShowInTarget(view);
            if (target == null || !target.show(context)) {
                this.beep();
            }
            ((WorkbenchPage)page).performedShowIn(this.desc.getId());
        }
        catch (PartInitException e) {
            WorkbenchPlugin.log("Error showing view in ShowInAction.run", e.getStatus());
        }
    }

    private IShowInSource getShowInSource(IWorkbenchPart sourcePart) {
        if (sourcePart instanceof IShowInSource) {
            return (IShowInSource)((Object)sourcePart);
        }
        Object o = sourcePart.getAdapter(IShowInSource.class);
        if (o instanceof IShowInSource) {
            return (IShowInSource)o;
        }
        return null;
    }

    private IShowInTarget getShowInTarget(IWorkbenchPart targetPart) {
        if (targetPart instanceof IShowInTarget) {
            return (IShowInTarget)((Object)targetPart);
        }
        Object o = targetPart.getAdapter(IShowInTarget.class);
        if (o instanceof IShowInTarget) {
            return (IShowInTarget)o;
        }
        return null;
    }

    private ShowInContext getContext(IWorkbenchPart sourcePart) {
        IShowInSource source = this.getShowInSource(sourcePart);
        if (source != null) {
            ShowInContext context = source.getShowInContext();
            if (context != null) {
                return context;
            }
        } else if (sourcePart instanceof IEditorPart) {
            IEditorInput input = ((IEditorPart)sourcePart).getEditorInput();
            ISelectionProvider sp = sourcePart.getSite().getSelectionProvider();
            ISelection sel = sp == null ? null : sp.getSelection();
            return new ShowInContext(input, sel);
        }
        return null;
    }

    private void beep() {
        this.window.getShell().getDisplay().beep();
    }
}

