/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.ActiveEditorAction;

public abstract class BaseSaveAction
extends ActiveEditorAction {
    private List partsWithListeners = new ArrayList(1);
    private final IPropertyListener propListener = new IPropertyListener(){

        public void propertyChanged(Object source, int propId) {
            if (source == BaseSaveAction.this.getActiveEditor() && propId == 257) {
                BaseSaveAction.this.updateState();
            }
        }
    };
    private IViewPart activeView;
    private final IPropertyListener propListener2 = new IPropertyListener(){

        public void propertyChanged(Object source, int propId) {
            if (source == BaseSaveAction.this.activeView && propId == 257) {
                BaseSaveAction.this.updateState();
            }
        }
    };

    protected BaseSaveAction(String text, IWorkbenchWindow window) {
        super(text, window);
    }

    protected void editorActivated(IEditorPart part) {
        if (part != null) {
            part.addPropertyListener(this.propListener);
            this.partsWithListeners.add(part);
        }
    }

    protected void editorDeactivated(IEditorPart part) {
        if (part != null) {
            part.removePropertyListener(this.propListener);
            this.partsWithListeners.remove(part);
        }
    }

    public void pageActivated(IWorkbenchPage page) {
        super.pageActivated(page);
        this.updateActiveView();
        this.updateState();
    }

    public void pageClosed(IWorkbenchPage page) {
        super.pageClosed(page);
        this.updateActiveView();
        this.updateState();
    }

    public void partActivated(IWorkbenchPart part) {
        super.partActivated(part);
        if (part instanceof IViewPart) {
            this.updateActiveView();
            this.updateState();
        }
    }

    public void partClosed(IWorkbenchPart part) {
        super.partClosed(part);
        if (part instanceof IViewPart) {
            this.updateActiveView();
            this.updateState();
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
        super.partDeactivated(part);
        if (part instanceof IViewPart) {
            this.updateActiveView();
            this.updateState();
        }
    }

    private void updateActiveView() {
        if (this.getActivePage() == null) {
            this.setActiveView(null);
        } else {
            this.setActiveView(this.getActivePage().getActivePart());
        }
    }

    private void setActiveView(IWorkbenchPart part) {
        if (this.activeView == part) {
            return;
        }
        if (this.activeView != null) {
            this.activeView.removePropertyListener(this.propListener2);
            this.partsWithListeners.remove(this.activeView);
        }
        this.activeView = part instanceof IViewPart ? (IViewPart)part : null;
        if (this.activeView != null) {
            this.activeView.addPropertyListener(this.propListener2);
            this.partsWithListeners.add(this.activeView);
        }
    }

    protected final ISaveablePart getSaveableView() {
        if (this.activeView == null) {
            return null;
        }
        if (this.activeView instanceof ISaveablePart) {
            return (ISaveablePart)((Object)this.activeView);
        }
        return (ISaveablePart)this.activeView.getAdapter(ISaveablePart.class);
    }

    public void dispose() {
        super.dispose();
        for (IWorkbenchPart part : this.partsWithListeners) {
            part.removePropertyListener(this.propListener);
            part.removePropertyListener(this.propListener2);
        }
        this.partsWithListeners.clear();
    }
}

