/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.ui.refactoring.history;

import com.ibm.icu.text.MessageFormat;
import java.lang.reflect.InvocationTargetException;
import java.text.ChoiceFormat;
import java.text.Format;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CheckConditionsOperation;
import org.eclipse.ltk.core.refactoring.CreateChangeOperation;
import org.eclipse.ltk.core.refactoring.PerformChangeOperation;
import org.eclipse.ltk.core.refactoring.PerformRefactoringHistoryOperation;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusEntry;
import org.eclipse.ltk.core.refactoring.history.IRefactoringHistoryService;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistory;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringHistoryImplementation;
import org.eclipse.ltk.internal.ui.refactoring.ChangeExceptionHandler;
import org.eclipse.ltk.internal.ui.refactoring.ExceptionHandler;
import org.eclipse.ltk.internal.ui.refactoring.IErrorWizardPage;
import org.eclipse.ltk.internal.ui.refactoring.IPreviewWizardPage;
import org.eclipse.ltk.internal.ui.refactoring.Messages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringHistoryPreviewPage;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringPluginImages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringPreviewChangeFilter;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringStatusEntryFilter;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIMessages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIPlugin;
import org.eclipse.ltk.internal.ui.refactoring.UIPerformChangeOperation;
import org.eclipse.ltk.internal.ui.refactoring.WorkbenchRunnableAdapter;
import org.eclipse.ltk.internal.ui.refactoring.history.RefactoringHistoryErrorPage;
import org.eclipse.ltk.internal.ui.refactoring.history.RefactoringHistoryOverviewPage;
import org.eclipse.ltk.ui.refactoring.history.RefactoringHistoryControlConfiguration;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class RefactoringHistoryWizard
extends Wizard {
    private static final String PREFERENCE_DO_NOT_SHOW_APPLY_ERROR = String.valueOf(RefactoringUIPlugin.getPluginId()) + ".do.not.show.apply.refactoring";
    private static final String PREFERENCE_DO_NOT_SHOW_SKIP = String.valueOf(RefactoringUIPlugin.getPluginId()) + ".do.not.show.skip.refactoring";
    private static final String PREFERENCE_DO_NOT_WARN_FINISH = String.valueOf(RefactoringUIPlugin.getPluginId()) + ".do.not.warn.finish.wizard";
    private static final String PREFERENCE_DO_NOT_WARN_UNDO_ON_CANCEL = String.valueOf(RefactoringUIPlugin.getPluginId()) + ".do.not.warn.undo.on.cancel.refactoring";
    public static final int STATUS_CODE_INTERRUPTED = 10003;
    private boolean fAboutToPerformFired = false;
    private boolean fCancelException = false;
    private RefactoringHistoryControlConfiguration fControlConfiguration;
    private int fCurrentRefactoring = 0;
    private RefactoringDescriptorProxy[] fDescriptorProxies = null;
    private final RefactoringHistoryErrorPage fErrorPage;
    private int fExecutedRefactorings = 0;
    private boolean fInAddPages = false;
    private NoOverviewWizardPage fNoOverviewPage;
    private final String fOverviewDescription;
    private RefactoringHistoryOverviewPage fOverviewPage;
    private final String fOverviewTitle;
    private RefactoringPreviewChangeFilter fPreviewChangeFilter = new RefactoringPreviewChangeFilter(){

        public final boolean select(Change change) {
            return RefactoringHistoryWizard.this.selectPreviewChange(change);
        }
    };
    private final RefactoringHistoryPreviewPage fPreviewPage;
    private RefactoringHistory fRefactoringHistory;
    private final boolean fShowOverview;
    private RefactoringStatusEntryFilter fStatusEntryFilter = new RefactoringStatusEntryFilter(){

        public final boolean select(RefactoringStatusEntry entry) {
            return RefactoringHistoryWizard.this.selectStatusEntry(entry);
        }
    };

    private static String getLabelAsText(String label) {
        Assert.isNotNull((Object)label);
        StringBuffer buffer = new StringBuffer(label.length());
        int index = 0;
        while (index < label.length()) {
            char character = label.charAt(index);
            if (character != '&') {
                buffer.append(character);
            }
            ++index;
        }
        return buffer.toString();
    }

    public RefactoringHistoryWizard(boolean overview, String caption, String title, String description) {
        Assert.isNotNull((Object)caption);
        Assert.isNotNull((Object)title);
        Assert.isNotNull((Object)description);
        this.fShowOverview = overview;
        this.fOverviewTitle = title;
        this.fOverviewDescription = description;
        this.fErrorPage = new RefactoringHistoryErrorPage();
        this.fErrorPage.setFilter(this.fStatusEntryFilter);
        this.fPreviewPage = new RefactoringHistoryPreviewPage();
        this.fPreviewPage.setFilter(this.fPreviewChangeFilter);
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(caption);
        this.setDefaultPageImageDescriptor(RefactoringPluginImages.DESC_WIZBAN_REFACTOR);
    }

    public RefactoringHistoryWizard(String caption, String title, String description) {
        this(true, caption, title, description);
    }

    protected RefactoringStatus aboutToPerformHistory(IProgressMonitor monitor) {
        Assert.isNotNull((Object)monitor);
        this.fExecutedRefactorings = 0;
        return new RefactoringStatus();
    }

    protected RefactoringStatus aboutToPerformRefactoring(Refactoring refactoring, RefactoringDescriptor descriptor, IProgressMonitor monitor) {
        Assert.isNotNull((Object)refactoring);
        Assert.isNotNull((Object)descriptor);
        return new RefactoringStatus();
    }

    public final void addPage(IWizardPage page) {
        Assert.isTrue((boolean)this.fInAddPages);
        super.addPage(page);
    }

    public final void addPages() {
        try {
            this.fInAddPages = true;
            this.addUserDefinedPages();
            Assert.isNotNull((Object)this.fRefactoringHistory);
            Assert.isNotNull((Object)this.fControlConfiguration);
            if (this.fShowOverview) {
                this.fOverviewPage = new RefactoringHistoryOverviewPage(this.fRefactoringHistory, this.fOverviewTitle, this.fOverviewDescription, this.fControlConfiguration);
                this.addPage((IWizardPage)this.fOverviewPage);
            } else {
                this.fNoOverviewPage = new NoOverviewWizardPage();
                this.addPage((IWizardPage)this.fNoOverviewPage);
            }
            this.addPage(this.fErrorPage);
            this.addPage(this.fPreviewPage);
        }
        finally {
            this.fInAddPages = false;
        }
    }

    protected void addUserDefinedPages() {
        Assert.isTrue((boolean)this.fInAddPages);
    }

    public boolean canFinish() {
        IWizardPage page = this.getContainer().getCurrentPage();
        if (page == this.fErrorPage) {
            RefactoringStatus status = this.fErrorPage.getStatus();
            return status == null || !status.hasFatalError();
        }
        return true;
    }

    private RefactoringStatus checkConditions(Refactoring refactoring, IProgressMonitor monitor, int style) throws OperationCanceledException {
        Assert.isNotNull((Object)refactoring);
        Assert.isNotNull((Object)monitor);
        RefactoringStatus status = new RefactoringStatus();
        try {
            CheckConditionsOperation operation = new CheckConditionsOperation(refactoring, style);
            operation.run(monitor);
            status.merge(operation.getStatus());
        }
        catch (CoreException exception) {
            RefactoringUIPlugin.log(exception);
            status.addFatalError(RefactoringUIMessages.RefactoringWizard_internal_error_1);
        }
        return status;
    }

    private Change createChange(Refactoring refactoring, IProgressMonitor monitor) throws OperationCanceledException, CoreException {
        Assert.isNotNull((Object)refactoring);
        Assert.isNotNull((Object)monitor);
        CreateChangeOperation operation = new CreateChangeOperation(refactoring);
        operation.run(monitor);
        return operation.getChange();
    }

    protected Refactoring createRefactoring(RefactoringDescriptor descriptor, RefactoringStatus status) throws CoreException {
        Assert.isNotNull((Object)descriptor);
        return descriptor.createRefactoring(status);
    }

    private Refactoring createRefactoring(RefactoringDescriptor descriptor, RefactoringStatus status, IProgressMonitor monitor) throws CoreException {
        Refactoring refactoring = this.createRefactoring(descriptor, status);
        if (refactoring != null) {
            status.merge(this.aboutToPerformRefactoring(refactoring, descriptor, monitor));
            if (!status.hasFatalError()) {
                return refactoring;
            }
        } else {
            status.addFatalError(Messages.format(RefactoringUIMessages.RefactoringHistoryWizard_error_instantiate_refactoring, descriptor.getDescription()));
        }
        return null;
    }

    public void dispose() {
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void handleException(Throwable exception) {
                RefactoringUIPlugin.log(exception);
            }

            public final void run() throws Exception {
                RefactoringStatusEntry entry;
                if (RefactoringHistoryWizard.this.fAboutToPerformFired && (entry = RefactoringHistoryWizard.this.historyPerformed((IProgressMonitor)new NullProgressMonitor()).getEntryWithHighestSeverity()) != null) {
                    RefactoringUIPlugin.log(entry.toStatus());
                }
            }
        });
        super.dispose();
    }

    private RefactoringStatus fireAboutToPerformHistory(final IProgressMonitor monitor) {
        final RefactoringStatus status = new RefactoringStatus();
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void handleException(Throwable exception) {
                RefactoringUIPlugin.log(exception);
                status.addFatalError(RefactoringUIMessages.RefactoringWizard_unexpected_exception_1);
            }

            public final void run() throws Exception {
                status.merge(RefactoringHistoryWizard.this.aboutToPerformHistory(monitor));
            }
        });
        return status;
    }

    public final IErrorWizardPage getErrorPage() {
        return this.fErrorPage;
    }

    /*
     * Unable to fully structure code
     */
    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.fOverviewPage || page == this.fNoOverviewPage) {
            this.fCurrentRefactoring = 0;
            return this.getRefactoringPage();
        }
        if (page == this.fPreviewPage) {
            ++this.fCurrentRefactoring;
            return this.getRefactoringPage();
        }
        if (page == this.fErrorPage) {
            status = this.fErrorPage.getStatus();
            wizard = this.getContainer();
            if (status.hasFatalError()) {
                store = RefactoringUIPlugin.getDefault().getPreferenceStore();
                message = null;
                key = null;
                if (!RefactoringUIMessages.RefactoringHistoryPreviewPage_apply_error_title.equals(this.fErrorPage.getTitle())) {
                    message = Messages.format(RefactoringUIMessages.RefactoringHistoryWizard_fatal_error_message, this.fErrorPage.getTitle());
                    key = RefactoringHistoryWizard.PREFERENCE_DO_NOT_SHOW_SKIP;
                } else {
                    message = RefactoringUIMessages.RefactoringHistoryWizard_error_applying_changes;
                    key = RefactoringHistoryWizard.PREFERENCE_DO_NOT_SHOW_APPLY_ERROR;
                }
                if (!store.getBoolean(key)) {
                    dialog = new MessageDialogWithToggle(this.getShell(), wizard.getShell().getText(), null, message, 2, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0, RefactoringUIMessages.RefactoringHistoryWizard_do_not_show_message, false);
                    dialog.open();
                    store.setValue(key, dialog.getToggleState());
                    if (dialog.getReturnCode() == 1) {
                        return null;
                    }
                }
                ++this.fCurrentRefactoring;
                return this.getRefactoringPage();
            }
            refactoring = this.fErrorPage.getRefactoring();
            if (refactoring != null) {
                runnable = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        Assert.isNotNull((Object)monitor);
                        try {
                            try {
                                RefactoringHistoryWizard.this.fPreviewPage.setRefactoring(refactoring);
                                final Change change = RefactoringHistoryWizard.this.createChange(refactoring, monitor);
                                RefactoringHistoryWizard.this.getShell().getDisplay().syncExec(new Runnable(){

                                    public final void run() {
                                        RefactoringHistoryWizard.this.fPreviewPage.setChange(change);
                                    }
                                });
                            }
                            catch (CoreException exception) {
                                throw new InvocationTargetException(exception);
                            }
                            catch (OperationCanceledException exception) {
                                throw new InterruptedException(exception.getLocalizedMessage());
                            }
                        }
                        finally {
                            monitor.done();
                        }
                    }
                };
                try {
                    wizard.run(true, false, runnable);
                }
                catch (InvocationTargetException exception) {
                    throwable = exception.getTargetException();
                    if (throwable == null) ** GOTO lbl45
                    RefactoringUIPlugin.log(exception);
                    this.fErrorPage.setStatus(RefactoringStatus.createFatalErrorStatus((String)RefactoringUIMessages.RefactoringWizard_unexpected_exception_1));
                    return this.fErrorPage;
                }
                catch (InterruptedException v0) {
                    return this.fErrorPage;
                }
            } else {
                this.fPreviewPage.setRefactoring(null);
                this.fPreviewPage.setChange(null);
            }
lbl45:
            // 3 sources

            descriptor = this.getRefactoringDescriptor();
            if (descriptor != null) {
                this.fPreviewPage.setTitle(descriptor, this.fCurrentRefactoring, this.fDescriptorProxies.length);
            } else {
                this.fPreviewPage.setTitle(RefactoringUIMessages.PreviewWizardPage_changes);
            }
            this.fPreviewPage.setStatus(status);
            this.fPreviewPage.setNextPageDisabled(this.isLastRefactoring());
            return this.fPreviewPage;
        }
        return super.getNextPage(page);
    }

    public final IPreviewWizardPage getPreviewPage() {
        return this.fPreviewPage;
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        if (page == this.fErrorPage || page == this.fPreviewPage) {
            return null;
        }
        return super.getPreviousPage(page);
    }

    private RefactoringDescriptorProxy getRefactoringDescriptor() {
        RefactoringDescriptorProxy[] proxies = this.getRefactoringDescriptors();
        if (this.fCurrentRefactoring >= 0 && this.fCurrentRefactoring < proxies.length) {
            return proxies[this.fCurrentRefactoring];
        }
        return null;
    }

    private RefactoringDescriptorProxy[] getRefactoringDescriptors() {
        if (this.fDescriptorProxies == null) {
            RefactoringDescriptorProxy[] proxies = this.fRefactoringHistory.getDescriptors();
            RefactoringDescriptorProxy[] result = new RefactoringDescriptorProxy[proxies.length];
            System.arraycopy(proxies, 0, result, 0, proxies.length);
            Arrays.sort(result, new Comparator(){

                public final int compare(Object first, Object second) {
                    RefactoringDescriptorProxy predecessor = (RefactoringDescriptorProxy)first;
                    RefactoringDescriptorProxy successor = (RefactoringDescriptorProxy)second;
                    long delta = predecessor.getTimeStamp() - successor.getTimeStamp();
                    if (delta > 0L) {
                        return 1;
                    }
                    if (delta < 0L) {
                        return -1;
                    }
                    return 0;
                }
            });
            this.fDescriptorProxies = result;
        }
        return this.fDescriptorProxies;
    }

    private IWizardPage getRefactoringPage() {
        final IWizardPage[] result = new IWizardPage[1];
        final RefactoringStatus status = new RefactoringStatus();
        IWizardContainer wizard = this.getContainer();
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                block24: {
                    Assert.isNotNull((Object)monitor);
                    try {
                        try {
                            monitor.beginTask(RefactoringUIMessages.RefactoringHistoryWizard_preparing_refactoring, 220);
                            result[0] = null;
                            if (!RefactoringHistoryWizard.this.fAboutToPerformFired) {
                                try {
                                    status.merge(RefactoringHistoryWizard.this.fireAboutToPerformHistory((IProgressMonitor)new SubProgressMonitor(monitor, 50, 2)));
                                }
                                finally {
                                    RefactoringHistoryWizard.this.fAboutToPerformFired = true;
                                }
                            }
                            boolean last = RefactoringHistoryWizard.this.isLastRefactoring();
                            RefactoringDescriptorProxy proxy = RefactoringHistoryWizard.this.getRefactoringDescriptor();
                            RefactoringHistoryWizard.this.preparePreviewPage(status, proxy, last);
                            RefactoringHistoryWizard.this.prepareErrorPage(status, proxy, status.hasFatalError(), last || status.hasFatalError());
                            RefactoringHistoryWizard.this.fErrorPage.setRefactoring(null);
                            if (!status.isOK()) {
                                result[0] = RefactoringHistoryWizard.this.fErrorPage;
                                break block24;
                            }
                            if (proxy != null) {
                                IRefactoringHistoryService service = RefactoringCore.getHistoryService();
                                try {
                                    service.connect();
                                    RefactoringDescriptor descriptor = proxy.requestDescriptor((IProgressMonitor)new SubProgressMonitor(monitor, 10, 2));
                                    if (descriptor != null) {
                                        Refactoring refactoring = RefactoringHistoryWizard.this.createRefactoring(descriptor, status, (IProgressMonitor)new SubProgressMonitor(monitor, 60, 2));
                                        if (refactoring != null && status.isOK()) {
                                            RefactoringHistoryWizard.this.fPreviewPage.setRefactoring(refactoring);
                                            RefactoringHistoryWizard.this.fErrorPage.setRefactoring(refactoring);
                                            status.merge(RefactoringHistoryWizard.this.checkConditions(refactoring, (IProgressMonitor)new SubProgressMonitor(monitor, 20, 2), 2));
                                            if (!status.isOK()) {
                                                RefactoringHistoryWizard.this.prepareErrorPage(status, proxy, status.hasFatalError(), last);
                                                result[0] = RefactoringHistoryWizard.this.fErrorPage;
                                            } else {
                                                status.merge(RefactoringHistoryWizard.this.checkConditions(refactoring, (IProgressMonitor)new SubProgressMonitor(monitor, 65, 2), 4));
                                                if (!status.isOK()) {
                                                    RefactoringHistoryWizard.this.prepareErrorPage(status, proxy, status.hasFatalError(), last);
                                                    result[0] = RefactoringHistoryWizard.this.fErrorPage;
                                                } else {
                                                    final Change change = RefactoringHistoryWizard.this.createChange(refactoring, (IProgressMonitor)new SubProgressMonitor(monitor, 5, 2));
                                                    RefactoringHistoryWizard.this.getShell().getDisplay().syncExec(new Runnable(){

                                                        public final void run() {
                                                            RefactoringHistoryWizard.this.fPreviewPage.setChange(change);
                                                        }
                                                    });
                                                    result[0] = RefactoringHistoryWizard.this.fPreviewPage;
                                                }
                                            }
                                        } else {
                                            RefactoringHistoryWizard.this.prepareErrorPage(status, proxy, status.hasFatalError(), last);
                                            result[0] = RefactoringHistoryWizard.this.fErrorPage;
                                        }
                                    } else {
                                        status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringUIMessages.RefactoringHistoryWizard_error_resolving_refactoring));
                                        RefactoringHistoryWizard.this.prepareErrorPage(status, proxy, status.hasFatalError(), last);
                                        result[0] = RefactoringHistoryWizard.this.fErrorPage;
                                    }
                                    break block24;
                                }
                                finally {
                                    service.disconnect();
                                }
                            }
                            RefactoringHistoryWizard.this.prepareErrorPage(status, proxy, status.hasFatalError(), last);
                            result[0] = RefactoringHistoryWizard.this.fErrorPage;
                        }
                        catch (CoreException exception) {
                            throw new InvocationTargetException(exception);
                        }
                        catch (OperationCanceledException exception) {
                            throw new InterruptedException(exception.getLocalizedMessage());
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            }
        };
        try {
            wizard.run(true, false, runnable);
        }
        catch (InvocationTargetException exception) {
            RefactoringUIPlugin.log(exception);
            Throwable throwable = exception.getTargetException();
            if (throwable != null) {
                this.fErrorPage.setNextPageDisabled(this.isLastRefactoring());
                this.fErrorPage.setStatus(RefactoringStatus.createFatalErrorStatus((String)RefactoringUIMessages.RefactoringWizard_unexpected_exception_1));
                result[0] = this.fErrorPage;
            }
        }
        catch (InterruptedException interruptedException) {
            result[0] = null;
        }
        this.getContainer().updateButtons();
        return result[0];
    }

    protected RefactoringStatus historyPerformed(IProgressMonitor monitor) {
        Assert.isNotNull((Object)monitor);
        return new RefactoringStatus();
    }

    private boolean isLastRefactoring() {
        return this.fCurrentRefactoring >= this.getRefactoringDescriptors().length - 1;
    }

    private boolean isSecondLastRefactoring() {
        return this.fCurrentRefactoring >= this.getRefactoringDescriptors().length - 2;
    }

    public boolean performCancel() {
        if (this.fExecutedRefactorings > 0 && !this.fCancelException) {
            IPreferenceStore store = RefactoringUIPlugin.getDefault().getPreferenceStore();
            if (!store.getBoolean(PREFERENCE_DO_NOT_WARN_UNDO_ON_CANCEL)) {
                MessageFormat format = new MessageFormat(RefactoringUIMessages.RefactoringHistoryWizard_undo_message_pattern);
                String message = RefactoringUIMessages.RefactoringHistoryWizard_undo_message_explanation;
                String[] messages = new String[]{String.valueOf(RefactoringUIMessages.RefactoringHistoryWizard_one_refactoring_undone) + message, String.valueOf(RefactoringUIMessages.RefactoringHistoryWizard_several_refactorings_undone) + message};
                ChoiceFormat choice = new ChoiceFormat(new double[]{1.0, Double.MAX_VALUE}, messages);
                format.setFormatByArgumentIndex(0, (Format)choice);
                MessageDialogWithToggle dialog = new MessageDialogWithToggle(this.getShell(), this.getShell().getText(), null, format.format((Object)new Object[]{new Integer(this.fExecutedRefactorings)}), 2, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0, RefactoringUIMessages.RefactoringHistoryWizard_do_not_show_message, false);
                dialog.open();
                store.setValue(PREFERENCE_DO_NOT_WARN_UNDO_ON_CANCEL, dialog.getToggleState());
                if (dialog.getReturnCode() == 1) {
                    return false;
                }
            }
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public final void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    int index = 0;
                    while (index < RefactoringHistoryWizard.this.fExecutedRefactorings) {
                        try {
                            RefactoringCore.getUndoManager().performUndo(null, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                            if (RefactoringHistoryWizard.this.fExecutedRefactorings > 0) {
                                RefactoringHistoryWizard refactoringHistoryWizard = RefactoringHistoryWizard.this;
                                refactoringHistoryWizard.fExecutedRefactorings = refactoringHistoryWizard.fExecutedRefactorings - 1;
                            }
                        }
                        catch (CoreException exception) {
                            throw new InvocationTargetException(exception);
                        }
                        ++index;
                    }
                }
            };
            try {
                this.getContainer().run(false, false, runnable);
            }
            catch (InvocationTargetException exception) {
                RefactoringUIPlugin.log(exception);
                this.fCancelException = true;
                this.fErrorPage.setStatus(RefactoringStatus.createFatalErrorStatus((String)RefactoringUIMessages.RefactoringHistoryWizard_internal_error));
                this.fErrorPage.setNextPageDisabled(true);
                this.fErrorPage.setTitle(RefactoringUIMessages.RefactoringHistoryWizard_internal_error_title);
                this.fErrorPage.setDescription(RefactoringUIMessages.RefactoringHistoryWizard_internal_error_description);
                this.getContainer().showPage((IWizardPage)this.fErrorPage);
                return false;
            }
            catch (InterruptedException interruptedException) {}
        }
        return super.performCancel();
    }

    public boolean performFinish() {
        if (this.fOverviewPage != null) {
            this.fOverviewPage.performFinish();
        }
        IWizardContainer wizard = this.getContainer();
        final RefactoringStatus status = new RefactoringStatus();
        RefactoringDescriptorProxy[] proxies = this.getRefactoringDescriptors();
        ArrayList<RefactoringDescriptorProxy> list = new ArrayList<RefactoringDescriptorProxy>(proxies.length);
        int index = this.fCurrentRefactoring;
        while (index < proxies.length) {
            list.add(proxies[index]);
            ++index;
        }
        RefactoringDescriptorProxy[] descriptors = new RefactoringDescriptorProxy[list.size()];
        list.toArray(descriptors);
        boolean last = this.isLastRefactoring();
        if (wizard.getCurrentPage() == this.fPreviewPage && last) {
            Refactoring refactoring = this.fPreviewPage.getRefactoring();
            Change change = this.fPreviewPage.getChange();
            if (refactoring != null && change != null) {
                status.merge(this.performPreviewChange(change, refactoring));
                if (!status.isOK()) {
                    RefactoringStatusEntry entry = status.getEntryWithHighestSeverity();
                    if (entry.getSeverity() == 1 && entry.getCode() == 10003) {
                        return false;
                    }
                    this.fErrorPage.setStatus(status);
                    this.fErrorPage.setNextPageDisabled(true);
                    this.fErrorPage.setTitle(RefactoringUIMessages.RefactoringHistoryPreviewPage_apply_error_title);
                    this.fErrorPage.setDescription(RefactoringUIMessages.RefactoringHistoryPreviewPage_apply_error);
                    wizard.showPage((IWizardPage)this.fErrorPage);
                    return false;
                }
            }
        } else {
            IPreferenceStore store = RefactoringUIPlugin.getDefault().getPreferenceStore();
            if (!store.getBoolean(PREFERENCE_DO_NOT_WARN_FINISH) && proxies.length > 0) {
                MessageDialogWithToggle dialog = new MessageDialogWithToggle(this.getShell(), wizard.getShell().getText(), null, Messages.format(RefactoringUIMessages.RefactoringHistoryWizard_warning_finish, RefactoringHistoryWizard.getLabelAsText(IDialogConstants.FINISH_LABEL)), 2, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0, RefactoringUIMessages.RefactoringHistoryWizard_do_not_show_message, false);
                dialog.open();
                store.setValue(PREFERENCE_DO_NOT_WARN_FINISH, dialog.getToggleState());
                if (dialog.getReturnCode() == 1) {
                    return false;
                }
            }
            PerformRefactoringHistoryOperation operation = new PerformRefactoringHistoryOperation((RefactoringHistory)new RefactoringHistoryImplementation(descriptors)){

                protected RefactoringStatus aboutToPerformRefactoring(final Refactoring refactoring, final RefactoringDescriptor descriptor, final IProgressMonitor monitor) {
                    final RefactoringStatus[] result = new RefactoringStatus[]{new RefactoringStatus()};
                    SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                        public void handleException(Throwable exception) {
                            RefactoringUIPlugin.log(exception);
                        }

                        public final void run() throws Exception {
                            result[0] = RefactoringHistoryWizard.this.aboutToPerformRefactoring(refactoring, descriptor, monitor);
                        }
                    });
                    return result[0];
                }

                protected Refactoring createRefactoring(RefactoringDescriptor descriptor, RefactoringStatus state) throws CoreException {
                    return RefactoringHistoryWizard.this.createRefactoring(descriptor, state);
                }

                protected void refactoringPerformed(final Refactoring refactoring, final IProgressMonitor monitor) {
                    SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                        public void handleException(Throwable exception) {
                            RefactoringUIPlugin.log(exception);
                        }

                        public final void run() throws Exception {
                            RefactoringHistoryWizard.this.refactoringPerformed(refactoring, monitor);
                        }
                    });
                }

                public void run(IProgressMonitor monitor) throws CoreException {
                    try {
                        monitor.beginTask(RefactoringUIMessages.RefactoringHistoryWizard_preparing_refactorings, 100);
                        if (!RefactoringHistoryWizard.this.fAboutToPerformFired) {
                            try {
                                status.merge(RefactoringHistoryWizard.this.fireAboutToPerformHistory((IProgressMonitor)new SubProgressMonitor(monitor, 20, 2)));
                            }
                            finally {
                                RefactoringHistoryWizard.this.fAboutToPerformFired = true;
                            }
                        }
                        if (!status.isOK()) {
                            int severity = status.getSeverity();
                            throw new CoreException((IStatus)new Status(severity != 4 ? severity : 4, RefactoringUIPlugin.getPluginId(), 0, null, null));
                        }
                        super.run((IProgressMonitor)new SubProgressMonitor(monitor, 80, 2));
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            try {
                wizard.run(false, false, (IRunnableWithProgress)new WorkbenchRunnableAdapter((IWorkspaceRunnable)operation, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot()));
            }
            catch (InvocationTargetException exception) {
                RefactoringUIPlugin.log(exception);
                Throwable throwable = exception.getTargetException();
                if (throwable != null) {
                    String message = throwable.getLocalizedMessage();
                    if (message != null && !"".equals(message)) {
                        status.merge(RefactoringStatus.createFatalErrorStatus((String)message));
                    }
                    this.fErrorPage.setStatus(status);
                    this.fErrorPage.setNextPageDisabled(status.hasFatalError());
                    this.fErrorPage.setTitle(RefactoringUIMessages.RefactoringHistoryPreviewPage_apply_error_title);
                    this.fErrorPage.setDescription(RefactoringUIMessages.RefactoringHistoryPreviewPage_apply_error);
                    wizard.showPage((IWizardPage)this.fErrorPage);
                    return false;
                }
            }
            catch (InterruptedException interruptedException) {}
            RefactoringStatus result = operation.getExecutionStatus();
            if (!result.isOK()) {
                this.fErrorPage.setStatus(result);
                this.fErrorPage.setNextPageDisabled(true);
                this.fErrorPage.setTitle(RefactoringUIMessages.RefactoringHistoryPreviewPage_finish_error_title);
                this.fErrorPage.setDescription(RefactoringUIMessages.RefactoringHistoryPreviewPage_finish_error_description);
                wizard.showPage((IWizardPage)this.fErrorPage);
                return false;
            }
        }
        return true;
    }

    public final RefactoringStatus performPreviewChange(Change change, final Refactoring refactoring) {
        Assert.isNotNull((Object)change);
        Assert.isNotNull((Object)refactoring);
        UIPerformChangeOperation operation = new UIPerformChangeOperation(this.getShell().getDisplay(), change, this.getContainer()){

            public void run(IProgressMonitor monitor) throws CoreException {
                try {
                    monitor.beginTask(RefactoringUIMessages.RefactoringHistoryWizard_preparing_changes, 12);
                    super.run((IProgressMonitor)new SubProgressMonitor(monitor, 10, 2));
                    RefactoringHistoryWizard.this.refactoringPerformed(refactoring, (IProgressMonitor)new SubProgressMonitor(monitor, 2, 2));
                }
                finally {
                    monitor.done();
                }
            }
        };
        RefactoringStatus status = this.performPreviewChange(operation, refactoring);
        if (status.isOK()) {
            status.merge(operation.getValidationStatus());
        }
        return status;
    }

    private RefactoringStatus performPreviewChange(PerformChangeOperation operation, Refactoring refactoring) {
        Assert.isNotNull((Object)operation);
        Assert.isNotNull((Object)refactoring);
        operation.setUndoManager(RefactoringCore.getUndoManager(), refactoring.getName());
        IWizardContainer wizard = this.getContainer();
        Shell shell = wizard.getShell();
        try {
            try {
                wizard.run(false, false, (IRunnableWithProgress)new WorkbenchRunnableAdapter((IWorkspaceRunnable)operation, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot()));
            }
            catch (InvocationTargetException exception) {
                Throwable throwable = exception.getTargetException();
                if (operation.changeExecutionFailed()) {
                    Change change = operation.getChange();
                    ChangeExceptionHandler handler = new ChangeExceptionHandler(shell, refactoring);
                    if (throwable instanceof RuntimeException) {
                        handler.handle(change, (RuntimeException)throwable);
                    } else if (throwable instanceof CoreException) {
                        handler.handle(change, (CoreException)throwable);
                    }
                }
                ExceptionHandler.handle(exception, shell, RefactoringUIMessages.RefactoringWizard_refactoring, RefactoringUIMessages.RefactoringWizard_unexpected_exception_1);
            }
            catch (InterruptedException exception) {
                RefactoringStatus refactoringStatus = RefactoringStatus.create((IStatus)new Status(1, RefactoringUIPlugin.getPluginId(), 10003, exception.getLocalizedMessage(), (Throwable)exception));
                this.fPreviewPage.setNextPageDisabled(this.isSecondLastRefactoring());
                this.getContainer().updateButtons();
                return refactoringStatus;
            }
        }
        finally {
            this.fPreviewPage.setNextPageDisabled(this.isSecondLastRefactoring());
            this.getContainer().updateButtons();
        }
        return new RefactoringStatus();
    }

    private void prepareErrorPage(final RefactoringStatus status, final RefactoringDescriptorProxy descriptor, final boolean fatal, final boolean disabled) {
        this.getShell().getDisplay().syncExec(new Runnable(){

            public final void run() {
                RefactoringHistoryWizard.this.fErrorPage.setTitle(descriptor, RefactoringHistoryWizard.this.fCurrentRefactoring, RefactoringHistoryWizard.this.fDescriptorProxies.length);
                RefactoringHistoryWizard.this.fErrorPage.setNextPageDisabled(disabled && fatal);
                RefactoringHistoryWizard.this.fErrorPage.setPageComplete(!fatal);
                RefactoringHistoryWizard.this.fErrorPage.setStatus(null);
                RefactoringHistoryWizard.this.fErrorPage.setStatus(status);
                RefactoringHistoryWizard.this.getContainer().updateButtons();
            }
        });
    }

    private void preparePreviewPage(final RefactoringStatus status, final RefactoringDescriptorProxy descriptor, final boolean disabled) {
        this.getShell().getDisplay().syncExec(new Runnable(){

            public final void run() {
                RefactoringHistoryWizard.this.fPreviewPage.setTitle(descriptor, RefactoringHistoryWizard.this.fCurrentRefactoring, RefactoringHistoryWizard.this.fDescriptorProxies.length);
                RefactoringHistoryWizard.this.fPreviewPage.setNextPageDisabled(disabled);
                RefactoringHistoryWizard.this.fPreviewPage.setPageComplete(!disabled);
                RefactoringHistoryWizard.this.fPreviewPage.setStatus(status);
                RefactoringHistoryWizard.this.getContainer().updateButtons();
            }
        });
    }

    protected RefactoringStatus refactoringPerformed(Refactoring refactoring, IProgressMonitor monitor) {
        Assert.isNotNull((Object)refactoring);
        Assert.isNotNull((Object)monitor);
        ++this.fExecutedRefactorings;
        return new RefactoringStatus();
    }

    protected boolean selectPreviewChange(Change change) {
        return true;
    }

    protected boolean selectStatusEntry(RefactoringStatusEntry entry) {
        return true;
    }

    public final void setConfiguration(RefactoringHistoryControlConfiguration configuration) {
        Assert.isNotNull((Object)configuration);
        this.fControlConfiguration = configuration;
    }

    public final void setInput(RefactoringHistory history) {
        Assert.isNotNull((Object)history);
        this.fRefactoringHistory = history;
    }

    private final class NoOverviewWizardPage
    extends WizardPage {
        private static final String PAGE_NAME = "NoOverviewWizardPage";

        private NoOverviewWizardPage() {
            super(PAGE_NAME);
            RefactoringDescriptorProxy[] proxies = RefactoringHistoryWizard.this.getRefactoringDescriptors();
            if (proxies.length > 0) {
                this.setTitle(proxies[0], 1, proxies.length);
            } else {
                this.setTitle(RefactoringHistoryWizard.this.fOverviewTitle);
            }
            this.setDescription(RefactoringUIMessages.RefactoringHistoryPreviewPage_description);
        }

        public boolean canFlipToNextPage() {
            return true;
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout());
            composite.setLayoutData((Object)new GridData(272));
            this.setControl((Control)composite);
            Dialog.applyDialogFont((Control)composite);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.jdt.ui.refactoring_preview_wizard_page_context");
        }

        public IWizardPage getNextPage() {
            return this.getWizard().getNextPage((IWizardPage)this);
        }

        public IWizardPage getPreviousPage() {
            return this.getWizard().getPreviousPage((IWizardPage)this);
        }

        public void setPageComplete(boolean complete) {
            super.setPageComplete(true);
        }

        public void setTitle(RefactoringDescriptorProxy descriptor, int current, int total) {
            String message = descriptor != null ? descriptor.getDescription() : RefactoringUIMessages.RefactoringHistoryOverviewPage_title;
            if (total > 1) {
                this.setTitle(Messages.format(RefactoringUIMessages.RefactoringHistoryPreviewPage_refactoring_pattern, new String[]{message, String.valueOf(current + 1), String.valueOf(total)}));
            } else {
                this.setTitle(message);
            }
        }
    }
}

