/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import com.ibm.icu.text.MessageFormat;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.IDebugHelpContextIds;
import org.eclipse.debug.internal.ui.IInternalDebugUIConstants;
import org.eclipse.debug.internal.ui.launchConfigurations.AbstractLaunchConfigurationAction;
import org.eclipse.debug.internal.ui.launchConfigurations.ClosedProjectFilter;
import org.eclipse.debug.internal.ui.launchConfigurations.CollapseAllLaunchConfigurationAction;
import org.eclipse.debug.internal.ui.launchConfigurations.CreateLaunchConfigurationAction;
import org.eclipse.debug.internal.ui.launchConfigurations.DeleteLaunchConfigurationAction;
import org.eclipse.debug.internal.ui.launchConfigurations.DeletedProjectFilter;
import org.eclipse.debug.internal.ui.launchConfigurations.DuplicateLaunchConfigurationAction;
import org.eclipse.debug.internal.ui.launchConfigurations.FilterLaunchConfigurationAction;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationTabGroupViewer;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationTypeFilter;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationView;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchGroupExtension;
import org.eclipse.debug.internal.ui.launchConfigurations.WorkingSetsFilter;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationTabGroup;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IPageChangeProvider;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.WorkbenchJob;

public class LaunchConfigurationsDialog
extends TitleAreaDialog
implements ILaunchConfigurationDialog,
IPageChangeProvider,
IPropertyChangeListener {
    private static ILaunchConfigurationDialog fgCurrentlyVisibleLaunchConfigurationDialog;
    protected static final int ID_LAUNCH_BUTTON = 1025;
    protected static final int ID_CLOSE_BUTTON = 1026;
    protected static final int ID_CANCEL_BUTTON = 1027;
    protected static final float MAX_DIALOG_WIDTH_PERCENT = 0.75f;
    protected static final float MAX_DIALOG_HEIGHT_PERCENT = 0.56f;
    protected static final Point DEFAULT_INITIAL_DIALOG_SIZE;
    private static final int[] DEFAULT_SASH_WEIGHTS;
    public static final int LAUNCH_CONFIGURATION_DIALOG_OPEN_ON_LAST_LAUNCHED = 2;
    public static final int LAUNCH_CONFIGURATION_DIALOG_OPEN_ON_SELECTION = 3;
    public static final int LAUNCH_CONFIGURATION_DIALOG_REUSE_OPEN = 4;
    private static final String EMPTY_STRING = "";
    private static final String DELIMITER = ", ";
    private int fOpenMode = 2;
    private static final String DIALOG_SASH_WEIGHTS_1;
    private static final String DIALOG_SASH_WEIGHTS_2;
    private static final String DIALOG_EXPANDED_NODES;
    private Control fLastControl;
    private SashForm fSashForm;
    private LaunchConfigurationView fLaunchConfigurationView;
    private LaunchConfigurationTabGroupViewer fTabViewer;
    private Button fProgressMonitorCancelButton;
    private ProgressMonitorPart fProgressMonitorPart;
    private LaunchGroupExtension fGroup;
    private Image fBannerImage;
    private IStructuredSelection fInitialSelection;
    private IStatus fInitialStatus;
    private ListenerList changeListeners = new ListenerList();
    private long fActiveRunningOperations = 0L;
    private IAction fDoubleClickAction;
    private ClosedProjectFilter fClosedProjectFilter;
    private DeletedProjectFilter fDeletedProjectFilter;
    private LaunchConfigurationTypeFilter fLCTFilter;
    private WorkingSetsFilter fWorkingSetsFilter;

    static {
        DEFAULT_INITIAL_DIALOG_SIZE = new Point(800, 640);
        DEFAULT_SASH_WEIGHTS = new int[]{190, 610};
        DIALOG_SASH_WEIGHTS_1 = String.valueOf(IDebugUIConstants.PLUGIN_ID) + ".DIALOG_SASH_WEIGHTS_1";
        DIALOG_SASH_WEIGHTS_2 = String.valueOf(IDebugUIConstants.PLUGIN_ID) + ".DIALOG_SASH_WEIGHTS_2";
        DIALOG_EXPANDED_NODES = String.valueOf(IDebugUIConstants.PLUGIN_ID) + ".EXPANDED_NODES";
    }

    public static ILaunchConfigurationDialog getCurrentlyVisibleLaunchConfigurationDialog() {
        return fgCurrentlyVisibleLaunchConfigurationDialog;
    }

    public static void setCurrentlyVisibleLaunchConfigurationDialog(ILaunchConfigurationDialog dialog) {
        fgCurrentlyVisibleLaunchConfigurationDialog = dialog;
    }

    public LaunchConfigurationsDialog(Shell shell, LaunchGroupExtension group) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setLaunchGroup(group);
    }

    protected void addContent(Composite dialogComp) {
        Composite topComp = new Composite(dialogComp, 0);
        GridData gd = new GridData(1808);
        topComp.setLayoutData((Object)gd);
        GridLayout topLayout = new GridLayout(2, false);
        topLayout.marginHeight = 5;
        topLayout.marginWidth = 5;
        topComp.setLayout((Layout)topLayout);
        this.setTitle(LaunchConfigurationsMessages.LaunchConfigurationDialog_Create__manage__and_run_launch_configurations_8);
        this.setMessage(LaunchConfigurationsMessages.LaunchConfigurationDialog_Ready_to_launch_2);
        this.setModeLabelState();
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        SashForm sash = new SashForm(topComp, 65536);
        sash.setOrientation(256);
        sash.setLayoutData((Object)gd);
        sash.setFont(dialogComp.getFont());
        sash.setVisible(true);
        this.fSashForm = sash;
        Control launchConfigSelectionArea = this.createLaunchConfigurationSelectionArea((Composite)this.fSashForm);
        gd = new GridData(1040);
        launchConfigSelectionArea.setLayoutData((Object)gd);
        Composite editAreaComp = this.createLaunchConfigurationEditArea((Composite)this.fSashForm);
        gd = new GridData(1808);
        editAreaComp.setLayoutData((Object)gd);
        dialogComp.layout(true);
        LaunchConfigurationsDialog.applyDialogFont((Control)dialogComp);
    }

    public void addPageChangedListener(IPageChangedListener listener) {
        this.changeListeners.add((Object)listener);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1025) {
            this.handleLaunchPressed();
        } else if (buttonId == 1026) {
            this.handleClosePressed();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    private int shouldSaveCurrentConfig() {
        if (this.getTabViewer().isDirty()) {
            if (this.getTabViewer().canSave()) {
                return this.showSaveChangesDialog();
            }
            return this.showUnsavedChangesDialog();
        }
        return 3;
    }

    public boolean close() {
        if (!this.isSafeToClose()) {
            return false;
        }
        this.persistSashWeights();
        this.persistExpansion();
        LaunchConfigurationsDialog.setCurrentlyVisibleLaunchConfigurationDialog(null);
        this.getBannerImage().dispose();
        this.getTabViewer().dispose();
        if (this.fLaunchConfigurationView != null) {
            this.fLaunchConfigurationView.dispose();
        }
        DebugUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        return super.close();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.getShellTitle());
    }

    public void create() {
        super.create();
        if (this.getTabViewer().getInput() == null) {
            this.getTabViewer().inputChanged(null);
        }
    }

    protected Control createButtonBar(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginLeft = this.convertHorizontalDLUsToPixels(7);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        composite.setFont(font);
        if (this.isHelpAvailable()) {
            this.createHelpControl(composite);
        }
        Composite monitorComposite = new Composite(composite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        monitorComposite.setLayout((Layout)layout);
        monitorComposite.setLayoutData((Object)new GridData(768));
        GridLayout pmLayout = new GridLayout();
        this.fProgressMonitorPart = new ProgressMonitorPart(monitorComposite, (Layout)pmLayout);
        this.fProgressMonitorPart.setLayoutData((Object)new GridData(768));
        this.fProgressMonitorPart.setFont(font);
        this.fProgressMonitorCancelButton = this.createButton(monitorComposite, 1027, LaunchConfigurationsMessages.LaunchConfigurationDialog_Cancel_3, true);
        this.fProgressMonitorCancelButton.setFont(font);
        monitorComposite.setVisible(false);
        boolean helpAvailable = this.isHelpAvailable();
        this.setHelpAvailable(false);
        super.createButtonBar(composite);
        this.setHelpAvailable(helpAvailable);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button button = this.createButton(parent, 1025, this.getLaunchButtonText(), true);
        button.setEnabled(false);
        this.createButton(parent, 1026, LaunchConfigurationsMessages.LaunchConfigurationDialog_Close_1, false);
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.initializeContent();
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getDialogArea(), this.getHelpContextId());
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogComp = (Composite)super.createDialogArea(parent);
        this.addContent(dialogComp);
        return dialogComp;
    }

    protected Composite createLaunchConfigurationEditArea(Composite parent) {
        this.setTabViewer(new LaunchConfigurationTabGroupViewer(parent, this));
        this.getTabViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                LaunchConfigurationsDialog.this.handleTabSelectionChanged();
            }
        });
        return (Composite)this.getTabViewer().getControl();
    }

    protected void createToolbarActions(ToolBarManager tmanager) {
        tmanager.add((IAction)this.getNewAction());
        tmanager.add((IAction)this.getDuplicateAction());
        tmanager.add((IAction)this.getDeleteAction());
        tmanager.add((IContributionItem)new Separator());
        tmanager.add(this.getCollapseAllAction());
        tmanager.add(this.getFilterAction());
        tmanager.update(true);
        DebugUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    protected Control createLaunchConfigurationSelectionArea(Composite parent) {
        Composite comp = new Composite(parent, 0x800000);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        comp.setLayout((Layout)gridLayout);
        comp.setLayoutData((Object)new GridData(1808));
        ViewForm viewForm = new ViewForm(comp, 0x800800);
        ToolBar toolBar = new ToolBar((Composite)viewForm, 0x800000);
        toolBar.setBackground(parent.getBackground());
        ToolBarManager toolBarManager = new ToolBarManager(toolBar);
        viewForm.setTopLeft((Control)toolBar);
        viewForm.setLayoutData((Object)new GridData(1808));
        Composite viewFormContents = new Composite((Composite)viewForm, 0x800000);
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 5;
        gridLayout.marginWidth = 5;
        viewFormContents.setLayout((Layout)gridLayout);
        viewFormContents.setBackground(new Color((Device)parent.getDisplay(), 255, 255, 255));
        this.fLaunchConfigurationView = new LaunchConfigurationView(this.getLaunchGroup(), this.createViewerFilters());
        this.fLaunchConfigurationView.createLaunchDialogControl(viewFormContents);
        this.createToolbarActions(toolBarManager);
        this.fDoubleClickAction = new Action(){

            public void run() {
                IStructuredSelection selection = (IStructuredSelection)LaunchConfigurationsDialog.this.fLaunchConfigurationView.getViewer().getSelection();
                Object target = selection.getFirstElement();
                if (target instanceof ILaunchConfiguration) {
                    if (LaunchConfigurationsDialog.this.getTabViewer().canLaunch()) {
                        LaunchConfigurationsDialog.this.handleLaunchPressed();
                    }
                } else {
                    LaunchConfigurationsDialog.this.getNewAction().run();
                }
            }
        };
        this.fLaunchConfigurationView.setAction("Double_Click_ActionId", this.fDoubleClickAction);
        Viewer viewer = this.fLaunchConfigurationView.getViewer();
        Control control = viewer.getControl();
        GridData gd = new GridData(1808);
        control.setLayoutData((Object)gd);
        viewForm.setContent((Control)viewFormContents);
        AbstractLaunchConfigurationAction.IConfirmationRequestor requestor = new AbstractLaunchConfigurationAction.IConfirmationRequestor(){

            public boolean getConfirmation() {
                int status = LaunchConfigurationsDialog.this.shouldSaveCurrentConfig();
                return status == 2 || status == 3;
            }
        };
        this.getDuplicateAction().setConfirmationRequestor(requestor);
        this.getNewAction().setConfirmationRequestor(requestor);
        ((StructuredViewer)viewer).addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                LaunchConfigurationsDialog.this.handleLaunchConfigurationSelectionChanged(event);
                LaunchConfigurationsDialog.this.getNewAction().setEnabled(LaunchConfigurationsDialog.this.getNewAction().isEnabled());
                LaunchConfigurationsDialog.this.getDeleteAction().setEnabled(LaunchConfigurationsDialog.this.getDeleteAction().isEnabled());
                LaunchConfigurationsDialog.this.getDuplicateAction().setEnabled(LaunchConfigurationsDialog.this.getDuplicateAction().isEnabled());
            }
        });
        return comp;
    }

    private ViewerFilter[] createViewerFilters() {
        ArrayList<ViewerFilter> filters = new ArrayList<ViewerFilter>();
        this.fClosedProjectFilter = new ClosedProjectFilter();
        if (DebugUIPlugin.getDefault().getPreferenceStore().getBoolean(IInternalDebugUIConstants.PREF_FILTER_LAUNCH_CLOSED)) {
            filters.add(this.fClosedProjectFilter);
        }
        this.fDeletedProjectFilter = new DeletedProjectFilter();
        if (DebugUIPlugin.getDefault().getPreferenceStore().getBoolean(IInternalDebugUIConstants.PREF_FILTER_LAUNCH_DELETED)) {
            filters.add(this.fDeletedProjectFilter);
        }
        this.fLCTFilter = new LaunchConfigurationTypeFilter();
        if (DebugUIPlugin.getDefault().getPreferenceStore().getBoolean(IInternalDebugUIConstants.PREF_FILTER_LAUNCH_TYPES)) {
            filters.add(this.fLCTFilter);
        }
        this.fWorkingSetsFilter = new WorkingSetsFilter();
        if (DebugUIPlugin.getDefault().getPreferenceStore().getBoolean(IInternalDebugUIConstants.PREF_FILTER_WORKING_SETS)) {
            filters.add(this.fWorkingSetsFilter);
        }
        return filters.toArray(new ViewerFilter[filters.size()]);
    }

    public void doInitialTreeSelection() {
        this.fLaunchConfigurationView.getViewer().setSelection((ISelection)this.fInitialSelection);
    }

    protected void firePageChanged(final PageChangedEvent event) {
        Object[] listeners = this.changeListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final IPageChangedListener l = (IPageChangedListener)listeners[i];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.pageChanged(event);
                }
            });
            ++i;
        }
    }

    public String generateName(String name) {
        if (name == null) {
            name = EMPTY_STRING;
        }
        return this.getLaunchManager().generateUniqueLaunchConfigurationNameFrom(name);
    }

    public ILaunchConfigurationTab getActiveTab() {
        return this.getTabViewer().getActiveTab();
    }

    protected Image getBannerImage() {
        ImageDescriptor descriptor;
        if (this.fBannerImage == null && (descriptor = this.getLaunchGroup().getBannerImageDescriptor()) != null) {
            this.fBannerImage = descriptor.createImage();
        }
        return this.fBannerImage;
    }

    protected AbstractLaunchConfigurationAction getDeleteAction() {
        return (AbstractLaunchConfigurationAction)this.fLaunchConfigurationView.getAction(DeleteLaunchConfigurationAction.ID_DELETE_ACTION);
    }

    protected IAction getFilterAction() {
        return this.fLaunchConfigurationView.getAction(FilterLaunchConfigurationAction.ID_FILTER_ACTION);
    }

    protected IAction getCollapseAllAction() {
        return this.fLaunchConfigurationView.getAction(CollapseAllLaunchConfigurationAction.ID_COLLAPSEALL_ACTION);
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return this.getDialogSettings();
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = DebugUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(this.getDialogSettingsSectionName());
        if (section == null) {
            section = settings.addNewSection(this.getDialogSettingsSectionName());
        }
        return section;
    }

    protected String getDialogSettingsSectionName() {
        return String.valueOf(IDebugUIConstants.PLUGIN_ID) + ".LAUNCH_CONFIGURATIONS_DIALOG_SECTION";
    }

    protected Display getDisplay() {
        Shell shell = this.getShell();
        if (shell != null) {
            return shell.getDisplay();
        }
        return Display.getDefault();
    }

    protected AbstractLaunchConfigurationAction getDuplicateAction() {
        return (AbstractLaunchConfigurationAction)this.fLaunchConfigurationView.getAction(DuplicateLaunchConfigurationAction.ID_DUPLICATE_ACTION);
    }

    protected String getHelpContextId() {
        return IDebugHelpContextIds.LAUNCH_CONFIGURATION_DIALOG;
    }

    protected IStatus getInitialStatus() {
        return this.fInitialStatus;
    }

    protected ILaunchConfiguration getLastLaunchedWorkbenchConfiguration() {
        return DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLastLaunch(this.getLaunchGroup().getIdentifier());
    }

    protected String getLaunchButtonText() {
        return DebugPlugin.getDefault().getLaunchManager().getLaunchMode(this.getMode()).getLabel();
    }

    public LaunchGroupExtension getLaunchGroup() {
        return this.fGroup;
    }

    public String getMode() {
        return this.getLaunchGroup().getMode();
    }

    protected AbstractLaunchConfigurationAction getNewAction() {
        return (AbstractLaunchConfigurationAction)this.fLaunchConfigurationView.getAction(CreateLaunchConfigurationAction.ID_CREATE_ACTION);
    }

    protected int getOpenMode() {
        return this.fOpenMode;
    }

    public Object getSelectedPage() {
        return this.getActiveTab();
    }

    protected String getShellTitle() {
        String title = DebugUIPlugin.removeAccelerators(this.getLaunchGroup().getLabel());
        if (title == null) {
            title = LaunchConfigurationsMessages.LaunchConfigurationDialog_Launch_Configurations_18;
        }
        return title;
    }

    public ILaunchConfigurationTabGroup getTabGroup() {
        if (this.getTabViewer() != null) {
            return this.getTabViewer().getTabGroup();
        }
        return null;
    }

    public ILaunchConfigurationTab[] getTabs() {
        if (this.getTabGroup() == null) {
            return null;
        }
        return this.getTabGroup().getTabs();
    }

    protected LaunchConfigurationTabGroupViewer getTabViewer() {
        return this.fTabViewer;
    }

    protected void handleClosePressed() {
        int status = this.shouldSaveCurrentConfig();
        if (status != 1) {
            if (status == 2) {
                this.getTabViewer().handleApplyPressed();
            }
            this.cancelPressed();
        }
    }

    protected void handleLaunchConfigurationSelectionChanged(SelectionChangedEvent event) {
        Object input = this.getTabViewer().getInput();
        Object newInput = null;
        ISelection selection = event.getSelection();
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            Button button = this.getButton(1025);
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            if (structuredSelection.size() == 1) {
                newInput = structuredSelection.getFirstElement();
                button.setEnabled(true);
            } else {
                button.setEnabled(false);
            }
        }
        if (!this.isEqual(input, newInput)) {
            LaunchConfigurationTabGroupViewer viewer = this.getTabViewer();
            ILaunchConfiguration original = viewer.getOriginal();
            if (original != null && newInput == null && this.getLaunchManager().getMovedTo(original) != null) {
                return;
            }
            boolean deleted = false;
            if (original != null) {
                deleted = !original.exists();
            }
            boolean renamed = false;
            if (newInput instanceof ILaunchConfiguration) {
                renamed = this.getLaunchManager().getMovedFrom((ILaunchConfiguration)newInput) != null;
            }
            Object in = input;
            if (viewer.isDirty() && !deleted && !renamed) {
                if (this.fLaunchConfigurationView != null) {
                    this.fLaunchConfigurationView.setAutoSelect(false);
                }
                int ret = this.showUnsavedChangesDialog();
                boolean cansave = viewer.canSave();
                if (ret == 2) {
                    if (cansave) {
                        viewer.handleApplyPressed();
                    } else {
                        viewer.handleRevertPressed();
                    }
                    in = newInput;
                } else if (ret == 3 && cansave) {
                    viewer.handleRevertPressed();
                    if (viewer.isDirty()) {
                        viewer.handleApplyPressed();
                    }
                    in = newInput;
                }
                if (this.fLaunchConfigurationView != null) {
                    if (in != null) {
                        this.fLaunchConfigurationView.getViewer().setSelection((ISelection)new StructuredSelection(in));
                    }
                    this.fLaunchConfigurationView.setAutoSelect(true);
                }
            } else {
                viewer.setInput(newInput);
                if (newInput != null) {
                    if (viewer.isDirty()) {
                        viewer.handleApplyPressed();
                    }
                    if (this.getShell() != null && this.getShell().isVisible()) {
                        this.resize();
                    }
                }
            }
        }
    }

    protected void handleLaunchPressed() {
        ILaunchConfiguration config = this.getTabViewer().getOriginal();
        if (this.getTabViewer().isDirty()) {
            this.getTabViewer().handleApplyPressed();
            config = this.getTabViewer().getOriginal();
        }
        String mode = this.getMode();
        this.close();
        if (config != null) {
            DebugUITools.launch(config, mode);
        }
    }

    public void handleStatus(IStatus status) {
        IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler(status);
        if (handler != null) {
            try {
                handler.handleStatus(status, (Object)this);
                return;
            }
            catch (CoreException e) {
                status = e.getStatus();
            }
        }
        String title = null;
        switch (status.getSeverity()) {
            case 4: {
                title = LaunchConfigurationsMessages.LaunchConfigurationsDialog_Error_1;
                break;
            }
            case 2: {
                title = LaunchConfigurationsMessages.LaunchConfigurationsDialog_Warning_2;
                break;
            }
            default: {
                title = LaunchConfigurationsMessages.LaunchConfigurationsDialog_Information_3;
            }
        }
        ErrorDialog.openError((Shell)this.getShell(), (String)title, null, (IStatus)status);
    }

    protected void handleTabSelectionChanged() {
        this.updateMessage();
        this.firePageChanged(new PageChangedEvent((IPageChangeProvider)this, this.getSelectedPage()));
    }

    protected void initializeBounds() {
        IDialogSettings settings = this.getDialogSettings();
        if (this.fSashForm != null) {
            int w2;
            int w1;
            try {
                w1 = settings.getInt(DIALOG_SASH_WEIGHTS_1);
                w2 = settings.getInt(DIALOG_SASH_WEIGHTS_2);
            }
            catch (NumberFormatException numberFormatException) {
                w1 = DEFAULT_SASH_WEIGHTS[0];
                w2 = DEFAULT_SASH_WEIGHTS[1];
            }
            this.fSashForm.setWeights(new int[]{w1, w2});
        }
        super.initializeBounds();
    }

    protected Point getInitialSize() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings.get(DIALOG_SASH_WEIGHTS_1) != null) {
            return super.getInitialSize();
        }
        return DEFAULT_INITIAL_DIALOG_SIZE;
    }

    protected void initializeContent() {
        this.doInitialTreeSelection();
        IStatus status = this.getInitialStatus();
        if (status != null) {
            this.handleStatus(status);
        }
        this.fLaunchConfigurationView.getFilteringTextControl().setFocus();
        this.restoreExpansion();
    }

    protected boolean isEqual(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    protected boolean isSafeToClose() {
        return this.fActiveRunningOperations == 0L;
    }

    public int open() {
        ILaunchConfiguration lastLaunchedConfig;
        int mode = this.getOpenMode();
        LaunchConfigurationsDialog.setCurrentlyVisibleLaunchConfigurationDialog(this);
        if (mode == 2 && (lastLaunchedConfig = this.getLastLaunchedWorkbenchConfiguration()) != null) {
            this.setInitialSelection((IStructuredSelection)new StructuredSelection((Object)lastLaunchedConfig));
        }
        return super.open();
    }

    protected void persistExpansion() {
        if (this.fLaunchConfigurationView != null) {
            IDialogSettings settings = this.getDialogSettings();
            TreeItem[] items = this.fLaunchConfigurationView.getTreeViewer().getTree().getItems();
            String value = settings.get(DIALOG_EXPANDED_NODES);
            if (value == null) {
                value = EMPTY_STRING;
            }
            ArrayList<String> list = new ArrayList<String>();
            String[] persisted = value.split(DELIMITER);
            int i = 0;
            while (i < persisted.length) {
                list.add(persisted[i]);
                ++i;
            }
            String type = EMPTY_STRING;
            int i2 = 0;
            while (i2 < items.length) {
                type = ((ILaunchConfigurationType)items[i2].getData()).getIdentifier();
                if (!list.contains(type) & items[i2].getExpanded()) {
                    list.add(type);
                } else if (!items[i2].getExpanded()) {
                    list.remove(type);
                }
                ++i2;
            }
            value = EMPTY_STRING;
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                value = String.valueOf(value) + iter.next() + DELIMITER;
            }
            settings.put(DIALOG_EXPANDED_NODES, value);
        }
    }

    protected void restoreExpansion() {
        IDialogSettings settings;
        String value;
        if (this.fLaunchConfigurationView != null && (value = (settings = this.getDialogSettings()).get(DIALOG_EXPANDED_NODES)) != null) {
            String[] nodes = value.split(DELIMITER);
            TreeItem[] items = this.fLaunchConfigurationView.getTreeViewer().getTree().getItems();
            ArrayList<Object> toexpand = new ArrayList<Object>();
            if (this.fInitialSelection != null && !this.fInitialSelection.isEmpty()) {
                Object obj = this.fInitialSelection.getFirstElement();
                if (obj instanceof ILaunchConfigurationType) {
                    toexpand.add(obj);
                } else if (obj instanceof ILaunchConfiguration) {
                    try {
                        toexpand.add(((ILaunchConfiguration)obj).getType());
                    }
                    catch (CoreException e) {
                        DebugUIPlugin.log(e);
                    }
                }
            }
            int i = 0;
            while (i < nodes.length) {
                int k = 0;
                while (k < items.length) {
                    ILaunchConfigurationType type = (ILaunchConfigurationType)items[k].getData();
                    if (type.getIdentifier().equals(nodes[i])) {
                        toexpand.add(type);
                    }
                    ++k;
                }
                ++i;
            }
            this.fLaunchConfigurationView.getTreeViewer().setExpandedElements(toexpand.toArray());
        }
    }

    protected void persistSashWeights() {
        IDialogSettings settings = this.getDialogSettings();
        if (this.fSashForm != null) {
            int[] sashWeights = this.fSashForm.getWeights();
            settings.put(DIALOG_SASH_WEIGHTS_1, sashWeights[0]);
            settings.put(DIALOG_SASH_WEIGHTS_2, sashWeights[1]);
        }
    }

    protected void refreshStatus() {
        this.updateMessage();
        this.updateButtons();
    }

    public void removePageChangedListener(IPageChangedListener listener) {
        this.changeListeners.remove((Object)listener);
    }

    protected void resize() {
        if (this.getTabGroup() != null) {
            Point shell = this.getShell().getSize();
            int maxx = (int)((float)this.getDisplay().getBounds().width * 0.75f);
            int maxy = (int)((float)this.getDisplay().getBounds().height * 0.56f);
            maxx = maxx < LaunchConfigurationsDialog.DEFAULT_INITIAL_DIALOG_SIZE.x ? LaunchConfigurationsDialog.DEFAULT_INITIAL_DIALOG_SIZE.x : maxx;
            maxy = maxy < LaunchConfigurationsDialog.DEFAULT_INITIAL_DIALOG_SIZE.y ? LaunchConfigurationsDialog.DEFAULT_INITIAL_DIALOG_SIZE.y : maxy;
            Point psize = this.getShell().computeSize(-1, maxy);
            if ((psize.x > maxx ? maxx : psize.x) > shell.x || (psize.y > maxy ? maxy : psize.y) > shell.y) {
                this.setShellSize(Math.min(psize.x, maxx), Math.min(psize.y, maxy));
            }
        }
    }

    public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        if (this.getShell() != null && this.getShell().isVisible()) {
            if (this.getShell() != null) {
                this.fLastControl = this.getShell().getDisplay().getFocusControl();
                if (this.fLastControl != null && this.fLastControl.getShell() != this.getShell()) {
                    this.fLastControl = null;
                }
                this.fProgressMonitorCancelButton.setEnabled(true);
                this.fProgressMonitorPart.attachToCancelComponent((Control)this.fProgressMonitorCancelButton);
                this.fProgressMonitorPart.getParent().setVisible(true);
                this.fProgressMonitorCancelButton.setFocus();
            }
            ++this.fActiveRunningOperations;
            try {
                ModalContext.run((IRunnableWithProgress)runnable, (boolean)fork, (IProgressMonitor)this.fProgressMonitorPart, (Display)this.getShell().getDisplay());
            }
            finally {
                --this.fActiveRunningOperations;
                if (this.getShell() != null) {
                    this.fProgressMonitorPart.getParent().setVisible(false);
                    this.fProgressMonitorPart.removeFromCancelComponent((Control)this.fProgressMonitorCancelButton);
                    if (this.fLastControl != null) {
                        this.fLastControl.setFocus();
                    }
                }
            }
        } else {
            PlatformUI.getWorkbench().getProgressService().run(fork, cancelable, runnable);
        }
    }

    public void setActiveTab(ILaunchConfigurationTab tab) {
        this.getTabViewer().setActiveTab(tab);
    }

    public void setActiveTab(int index) {
        this.getTabViewer().setActiveTab(index);
    }

    public void setInitialSelection(IStructuredSelection selection) {
        this.fInitialSelection = selection;
    }

    public void setInitialStatus(IStatus status) {
        this.fInitialStatus = status;
    }

    protected void setLaunchGroup(LaunchGroupExtension group) {
        this.fGroup = group;
    }

    protected void setModeLabelState() {
        this.setTitleImage(this.getBannerImage());
    }

    public void setName(String name) {
        this.getTabViewer().setName(name);
    }

    protected ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    public void setOpenMode(int mode) {
        this.fOpenMode = mode;
    }

    protected void setShellSize(int width, int height) {
        Rectangle bounds = this.getShell().getMonitor().getBounds();
        this.getShell().setSize(Math.min(width, bounds.width), Math.min(height, bounds.height));
    }

    protected void setTabViewer(LaunchConfigurationTabGroupViewer viewer) {
        this.fTabViewer = viewer;
    }

    private int showDiscardChangesDialog() {
        StringBuffer buffer = new StringBuffer(MessageFormat.format((String)LaunchConfigurationsMessages.LaunchConfigurationDialog_The_configuration___35, (Object[])new String[]{this.getTabViewer().getWorkingCopy().getName()}));
        buffer.append(this.getTabViewer().getErrorMesssage());
        buffer.append(LaunchConfigurationsMessages.LaunchConfigurationDialog_Do_you_wish_to_discard_changes_37);
        MessageDialog dialog = new MessageDialog(this.getShell(), LaunchConfigurationsMessages.LaunchConfigurationDialog_Discard_changes__38, null, buffer.toString(), 3, new String[]{LaunchConfigurationsMessages.LaunchConfigurationDialog_Yes_32, LaunchConfigurationsMessages.LaunchConfigurationDialog_No_33}, 1);
        int val = 3;
        if (dialog.open() == 0) {
            if (this.fLaunchConfigurationView != null) {
                this.fLaunchConfigurationView.setAutoSelect(false);
            }
            this.getTabViewer().handleRevertPressed();
            val = 2;
            if (this.fLaunchConfigurationView != null) {
                this.fLaunchConfigurationView.setAutoSelect(true);
            }
        }
        return val;
    }

    private int showSaveChangesDialog() {
        String message = MessageFormat.format((String)LaunchConfigurationsMessages.LaunchConfigurationDialog_The_configuration___29, (Object[])new String[]{this.getTabViewer().getWorkingCopy().getName()});
        MessageDialog dialog = new MessageDialog(this.getShell(), LaunchConfigurationsMessages.LaunchConfigurationDialog_Save_changes__31, null, message, 3, new String[]{LaunchConfigurationsMessages.LaunchConfigurationDialog_Yes_32, LaunchConfigurationsMessages.LaunchConfigurationDialog_No_33, LaunchConfigurationsMessages.LaunchConfigurationsDialog_c_ancel}, 0);
        int ret = dialog.open();
        int val = 1;
        if (ret == 0 || ret == 1) {
            val = ret == 0 ? 2 : 3;
        }
        return val;
    }

    private int showUnsavedChangesDialog() {
        if (this.getTabViewer().canSave()) {
            return this.showSaveChangesDialog();
        }
        return this.showDiscardChangesDialog();
    }

    public void updateButtons() {
        this.getNewAction().setEnabled(this.getNewAction().isEnabled());
        this.getDeleteAction().setEnabled(this.getDeleteAction().isEnabled());
        this.getDuplicateAction().setEnabled(this.getDuplicateAction().isEnabled());
        this.getTabViewer().refresh();
        this.getButton(1025).setEnabled(this.getTabViewer().canLaunch());
    }

    public void updateMessage() {
        this.setErrorMessage(this.getTabViewer().getErrorMesssage());
        this.setMessage(this.getTabViewer().getMessage());
    }

    public boolean isTreeSelectionEmpty() {
        return this.fLaunchConfigurationView.getTreeViewer().getSelection().isEmpty();
    }

    public void propertyChange(final PropertyChangeEvent event) {
        WorkbenchJob job = new WorkbenchJob(EMPTY_STRING){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                TreeViewer viewer = LaunchConfigurationsDialog.this.fLaunchConfigurationView.getTreeViewer();
                TreeSelection sel = (TreeSelection)viewer.getSelection();
                TreePath path = null;
                int pidx = -1;
                int cidx = -1;
                if (!sel.isEmpty()) {
                    path = sel.getPaths()[0];
                    pidx = LaunchConfigurationsDialog.this.findIndexOfParent(path.getFirstSegment());
                    if (path.getSegmentCount() == 2) {
                        cidx = LaunchConfigurationsDialog.this.findIndexOfChild(path.getFirstSegment(), path.getLastSegment());
                    }
                }
                boolean newvalue = Boolean.valueOf(event.getNewValue().toString());
                if (event.getProperty().equals(IInternalDebugUIConstants.PREF_FILTER_LAUNCH_CLOSED)) {
                    LaunchConfigurationsDialog.this.updateFilter(newvalue, LaunchConfigurationsDialog.this.fClosedProjectFilter);
                } else if (event.getProperty().equals(IInternalDebugUIConstants.PREF_FILTER_LAUNCH_DELETED)) {
                    LaunchConfigurationsDialog.this.updateFilter(newvalue, LaunchConfigurationsDialog.this.fDeletedProjectFilter);
                } else if (event.getProperty().equals(IInternalDebugUIConstants.PREF_FILTER_LAUNCH_TYPES)) {
                    LaunchConfigurationsDialog.this.updateFilter(newvalue, LaunchConfigurationsDialog.this.fLCTFilter);
                } else if (event.getProperty().equals(IInternalDebugUIConstants.PREF_FILTER_WORKING_SETS)) {
                    LaunchConfigurationsDialog.this.updateFilter(newvalue, LaunchConfigurationsDialog.this.fWorkingSetsFilter);
                } else if (event.getProperty().equals(IInternalDebugUIConstants.PREF_FILTER_TYPE_LIST) && DebugUIPlugin.getDefault().getPreferenceStore().getBoolean(IInternalDebugUIConstants.PREF_FILTER_LAUNCH_TYPES)) {
                    viewer.removeFilter((ViewerFilter)LaunchConfigurationsDialog.this.fLCTFilter);
                    viewer.addFilter((ViewerFilter)LaunchConfigurationsDialog.this.fLCTFilter);
                }
                LaunchConfigurationsDialog.this.updateSelection(path, pidx, cidx);
                return null;
            }
        };
        job.runInUIThread((IProgressMonitor)new NullProgressMonitor());
    }

    private void updateFilter(boolean state, ViewerFilter filter) {
        TreeViewer viewer = (TreeViewer)this.fLaunchConfigurationView.getViewer();
        if (state) {
            viewer.addFilter(filter);
        } else {
            viewer.removeFilter(filter);
        }
    }

    private void updateSelection(TreePath path, int pidx, int cidx) {
        TreeViewer viewer = this.fLaunchConfigurationView.getTreeViewer();
        Tree tree = viewer.getTree();
        int pcount = tree.getItemCount();
        if (tree.getItemCount() == 0) {
            this.setErrorMessage(null);
            this.setMessage(LaunchConfigurationsMessages.LaunchConfigurationsDialog_7);
            this.updateButtons();
        } else if (path != null) {
            Object sel = path.getLastSegment();
            int pidex = this.findIndexOfParent(path.getFirstSegment());
            if (path.getSegmentCount() == 1) {
                if (pidex == -1) {
                    if (pidx > pcount) {
                        pidx = pcount - 1;
                    }
                    sel = pidx == 0 ? tree.getItem(pidx).getData() : tree.getItem(pidx - 1).getData();
                } else {
                    sel = tree.getItem(pidex).getData();
                }
            } else if (pidex == -1) {
                if (pidx > pcount) {
                    pidx = pcount - 1;
                }
                sel = pidx == 0 ? tree.getItem(pidx).getData() : tree.getItem(pidx - 1).getData();
            } else {
                int cidex = this.findIndexOfChild(path.getFirstSegment(), path.getLastSegment());
                TreeItem parent = tree.getItem(pidex);
                int ccount = parent.getItemCount();
                if (cidex == -1) {
                    if (parent.getItemCount() == 0) {
                        sel = parent.getData();
                    } else {
                        if (cidx > ccount) {
                            cidx = ccount - 1;
                        }
                        sel = cidx == 0 ? parent.getItem(cidx).getData() : parent.getItem(cidx - 1).getData();
                    }
                } else {
                    sel = parent.getItem(cidex).getData();
                }
            }
            viewer.setSelection((ISelection)new StructuredSelection(sel));
            this.updateButtons();
            this.updateMessage();
        } else {
            this.setErrorMessage(null);
            this.setMessage(LaunchConfigurationsMessages.LaunchConfigurationDialog_Ready_to_launch_2);
        }
    }

    private int findIndexOfParent(Object parent) {
        Tree tree = this.fLaunchConfigurationView.getTreeViewer().getTree();
        TreeItem[] roots = tree.getItems();
        int i = 0;
        while (i < roots.length) {
            if (roots[i].getData().equals(parent)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int findIndexOfChild(Object parent, Object child) {
        Tree tree = this.fLaunchConfigurationView.getTreeViewer().getTree();
        int pidx = this.findIndexOfParent(parent);
        if (pidx != -1) {
            TreeItem root = tree.getItem(pidx);
            TreeItem[] children = root.getItems();
            Object data = null;
            int j = 0;
            while (j < children.length) {
                data = children[j].getData();
                if (data != null && data.equals(child)) {
                    return j;
                }
                ++j;
            }
        }
        return -1;
    }
}

