/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaUIMessages;
import org.eclipse.jdt.internal.ui.text.java.CompletionProposalCategory;
import org.eclipse.jdt.internal.ui.text.java.CompletionProposalComputerRegistry;
import org.eclipse.jdt.internal.ui.text.java.JavaTextMessages;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistantExtension2;
import org.eclipse.jface.text.contentassist.IContentAssistantExtension3;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;

public class ContentAssistProcessor
implements IContentAssistProcessor {
    private static final boolean DEBUG = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.jdt.ui/debug/ResultCollector"));
    private static final Comparator ORDER_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            CompletionProposalCategory d1 = (CompletionProposalCategory)o1;
            CompletionProposalCategory d2 = (CompletionProposalCategory)o2;
            return d1.getSortOrder() - d2.getSortOrder();
        }
    };
    private final List fCategories;
    private final String fPartition;
    private final ContentAssistant fAssistant;
    private char[] fCompletionAutoActivationCharacters;
    private int fRepetition = -1;
    private List fCategoryIteration = null;
    private String fIterationGesture = null;
    private int fNumberOfComputedResults = 0;
    private String fErrorMessage;

    public ContentAssistProcessor(ContentAssistant assistant, String partition) {
        Assert.isNotNull((Object)partition);
        Assert.isNotNull((Object)assistant);
        this.fPartition = partition;
        this.fCategories = CompletionProposalComputerRegistry.getDefault().getProposalCategories();
        this.fAssistant = assistant;
        this.fAssistant.addCompletionListener(new ICompletionListener(){

            public void assistSessionStarted(ContentAssistEvent event) {
                if (event.processor != ContentAssistProcessor.this) {
                    return;
                }
                ContentAssistProcessor.this.fCategoryIteration = ContentAssistProcessor.this.getCategoryIteration();
                for (CompletionProposalCategory cat : ContentAssistProcessor.this.fCategories) {
                    cat.sessionStarted();
                }
                ContentAssistProcessor.this.fRepetition = 0;
                ContentAssistProcessor.this.fIterationGesture = ContentAssistProcessor.this.getIterationGesture();
                if (event.assistant instanceof IContentAssistantExtension2) {
                    IContentAssistantExtension2 extension = (IContentAssistantExtension2)event.assistant;
                    if (ContentAssistProcessor.this.fCategoryIteration.size() == 1) {
                        extension.setRepeatedInvocationMode(false);
                        extension.setShowEmptyList(false);
                    } else {
                        extension.setRepeatedInvocationMode(true);
                        extension.setStatusLineVisible(true);
                        extension.setStatusMessage(ContentAssistProcessor.this.createIterationMessage());
                        extension.setShowEmptyList(true);
                        if (extension instanceof IContentAssistantExtension3) {
                            IContentAssistantExtension3 ext3 = (IContentAssistantExtension3)extension;
                            ((ContentAssistant)ext3).setRepeatedInvocationTrigger(ContentAssistProcessor.this.getIterationBinding());
                        }
                    }
                }
            }

            public void assistSessionEnded(ContentAssistEvent event) {
                if (event.processor != ContentAssistProcessor.this) {
                    return;
                }
                for (CompletionProposalCategory cat : ContentAssistProcessor.this.fCategories) {
                    cat.sessionEnded();
                }
                ContentAssistProcessor.this.fCategoryIteration = null;
                ContentAssistProcessor.this.fRepetition = -1;
                ContentAssistProcessor.this.fIterationGesture = null;
                if (event.assistant instanceof IContentAssistantExtension2) {
                    IContentAssistantExtension2 extension = (IContentAssistantExtension2)event.assistant;
                    extension.setShowEmptyList(false);
                    extension.setRepeatedInvocationMode(false);
                    extension.setStatusLineVisible(false);
                    if (extension instanceof IContentAssistantExtension3) {
                        IContentAssistantExtension3 ext3 = (IContentAssistantExtension3)extension;
                        ((ContentAssistant)ext3).setRepeatedInvocationTrigger(KeySequence.getInstance());
                    }
                }
            }

            public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
            }
        });
    }

    public final ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        long start = DEBUG ? System.currentTimeMillis() : 0L;
        this.clearState();
        IProgressMonitor monitor = this.createProgressMonitor();
        monitor.beginTask(JavaTextMessages.ContentAssistProcessor_computing_proposals, this.fCategories.size() + 1);
        ContentAssistInvocationContext context = this.createContext(viewer, offset);
        long setup = DEBUG ? System.currentTimeMillis() : 0L;
        monitor.subTask(JavaTextMessages.ContentAssistProcessor_collecting_proposals);
        List proposals = this.collectProposals(viewer, offset, monitor, context);
        long collect = DEBUG ? System.currentTimeMillis() : 0L;
        monitor.subTask(JavaTextMessages.ContentAssistProcessor_sorting_proposals);
        List filtered = this.filterAndSortProposals(proposals, monitor, context);
        this.fNumberOfComputedResults = filtered.size();
        long filter = DEBUG ? System.currentTimeMillis() : 0L;
        ICompletionProposal[] result = filtered.toArray(new ICompletionProposal[filtered.size()]);
        monitor.done();
        if (DEBUG) {
            System.err.println("Code Assist Stats (" + result.length + " proposals)");
            System.err.println("Code Assist (setup):\t" + (setup - start));
            System.err.println("Code Assist (collect):\t" + (collect - setup));
            System.err.println("Code Assist (sort):\t" + (filter - collect));
        }
        return result;
    }

    private void clearState() {
        this.fErrorMessage = null;
        this.fNumberOfComputedResults = 0;
    }

    private List collectProposals(ITextViewer viewer, int offset, IProgressMonitor monitor, ContentAssistInvocationContext context) {
        ArrayList proposals = new ArrayList();
        List providers = this.getCategories();
        for (CompletionProposalCategory cat : providers) {
            List computed = cat.computeCompletionProposals(context, this.fPartition, new SubProgressMonitor(monitor, 1));
            proposals.addAll(computed);
            if (this.fErrorMessage != null) continue;
            this.fErrorMessage = cat.getErrorMessage();
        }
        return proposals;
    }

    protected List filterAndSortProposals(List proposals, IProgressMonitor monitor, ContentAssistInvocationContext context) {
        return proposals;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        this.clearState();
        IProgressMonitor monitor = this.createProgressMonitor();
        monitor.beginTask(JavaTextMessages.ContentAssistProcessor_computing_contexts, this.fCategories.size() + 1);
        monitor.subTask(JavaTextMessages.ContentAssistProcessor_collecting_contexts);
        List proposals = this.collectContextInformation(viewer, offset, monitor);
        monitor.subTask(JavaTextMessages.ContentAssistProcessor_sorting_contexts);
        List filtered = this.filterAndSortContextInformation(proposals, monitor);
        this.fNumberOfComputedResults = filtered.size();
        IContextInformation[] result = filtered.toArray(new IContextInformation[filtered.size()]);
        monitor.done();
        return result;
    }

    private List collectContextInformation(ITextViewer viewer, int offset, IProgressMonitor monitor) {
        ArrayList proposals = new ArrayList();
        ContentAssistInvocationContext context = this.createContext(viewer, offset);
        List providers = this.getCategories();
        for (CompletionProposalCategory cat : providers) {
            List computed = cat.computeContextInformation(context, this.fPartition, new SubProgressMonitor(monitor, 1));
            proposals.addAll(computed);
            if (this.fErrorMessage != null) continue;
            this.fErrorMessage = cat.getErrorMessage();
        }
        return proposals;
    }

    protected List filterAndSortContextInformation(List contexts, IProgressMonitor monitor) {
        return contexts;
    }

    public final void setCompletionProposalAutoActivationCharacters(char[] activationSet) {
        this.fCompletionAutoActivationCharacters = activationSet;
    }

    public final char[] getCompletionProposalAutoActivationCharacters() {
        return this.fCompletionAutoActivationCharacters;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        if (this.fNumberOfComputedResults > 0) {
            return null;
        }
        if (this.fErrorMessage != null) {
            return this.fErrorMessage;
        }
        return JavaUIMessages.JavaEditor_codeassist_noCompletions;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    protected IProgressMonitor createProgressMonitor() {
        return new NullProgressMonitor();
    }

    protected ContentAssistInvocationContext createContext(ITextViewer viewer, int offset) {
        return new ContentAssistInvocationContext(viewer, offset);
    }

    private List getCategories() {
        if (this.fCategoryIteration == null) {
            return this.fCategories;
        }
        int iteration = this.fRepetition % this.fCategoryIteration.size();
        this.fAssistant.setStatusMessage(this.createIterationMessage());
        this.fAssistant.setEmptyMessage(this.createEmptyMessage());
        ++this.fRepetition;
        return (List)this.fCategoryIteration.get(iteration);
    }

    private List getCategoryIteration() {
        ArrayList<List<CompletionProposalCategory>> sequence = new ArrayList<List<CompletionProposalCategory>>();
        sequence.add(this.getDefaultCategories());
        for (CompletionProposalCategory cat : this.getSeparateCategories()) {
            sequence.add(Collections.singletonList(cat));
        }
        return sequence;
    }

    private List getDefaultCategories() {
        ArrayList<CompletionProposalCategory> included = new ArrayList<CompletionProposalCategory>();
        for (CompletionProposalCategory category : this.fCategories) {
            if (!category.isIncluded() || !category.hasComputers(this.fPartition)) continue;
            included.add(category);
        }
        return included;
    }

    private List getSeparateCategories() {
        ArrayList<CompletionProposalCategory> sorted = new ArrayList<CompletionProposalCategory>();
        for (CompletionProposalCategory category : this.fCategories) {
            if (!category.isSeparateCommand() || !category.hasComputers(this.fPartition)) continue;
            sorted.add(category);
        }
        Collections.sort(sorted, ORDER_COMPARATOR);
        return sorted;
    }

    private String createEmptyMessage() {
        return Messages.format(JavaTextMessages.ContentAssistProcessor_empty_message, new String[]{this.getCategoryLabel(this.fRepetition)});
    }

    private String createIterationMessage() {
        return Messages.format(JavaTextMessages.ContentAssistProcessor_toggle_affordance_update_message, new String[]{this.getCategoryLabel(this.fRepetition), this.fIterationGesture, this.getCategoryLabel(this.fRepetition + 1)});
    }

    private String getCategoryLabel(int repetition) {
        int iteration = repetition % this.fCategoryIteration.size();
        if (iteration == 0) {
            return JavaTextMessages.ContentAssistProcessor_defaultProposalCategory;
        }
        return this.toString((CompletionProposalCategory)((List)this.fCategoryIteration.get(iteration)).get(0));
    }

    private String toString(CompletionProposalCategory category) {
        return category.getDisplayName();
    }

    private String getIterationGesture() {
        KeySequence binding = this.getIterationBinding();
        return binding != null ? Messages.format(JavaTextMessages.ContentAssistProcessor_toggle_affordance_press_gesture, new Object[]{binding.format()}) : JavaTextMessages.ContentAssistProcessor_toggle_affordance_click_gesture;
    }

    private KeySequence getIterationBinding() {
        IBindingService bindingSvc = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        TriggerSequence binding = bindingSvc.getBestActiveBindingFor("org.eclipse.ui.edit.text.contentAssist.proposals");
        if (binding instanceof KeySequence) {
            return (KeySequence)binding;
        }
        return null;
    }
}

