/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.search;

import java.io.IOException;
import java.net.URL;
import java.nio.channels.OverlappingFileLockException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Hits;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.IHelpResource;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.ITocsChangedListener;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.search.AnalyzerDescriptor;
import org.eclipse.help.internal.search.ISearchHitCollector;
import org.eclipse.help.internal.search.ISearchQuery;
import org.eclipse.help.internal.search.IndexingOperation;
import org.eclipse.help.internal.search.PluginVersionInfo;
import org.eclipse.help.internal.search.ProgressDistributor;
import org.eclipse.help.internal.search.QueryTooComplexException;
import org.eclipse.help.internal.search.SearchHit;
import org.eclipse.help.internal.search.SearchIndex;
import org.eclipse.help.internal.search.SearchIndexCache;
import org.eclipse.help.internal.search.SearchIndexWithIndexingProgress;
import org.eclipse.help.internal.search.SearchProgressMonitor;
import org.eclipse.help.internal.search.federated.FederatedSearchEntry;
import org.eclipse.help.internal.search.federated.FederatedSearchJob;
import org.eclipse.help.internal.util.URLCoder;
import org.eclipse.help.internal.xhtml.XHTMLSupport;
import org.eclipse.help.search.LuceneSearchParticipant;
import org.osgi.framework.Bundle;

public class SearchManager
implements ITocsChangedListener {
    private static final String EMPTY_STRING = "";
    private static final String SEARCH_PARTICIPANT_XP_FULLNAME = "org.eclipse.help.base.luceneSearchParticipants";
    private static final String SEARCH_PARTICIPANT_XP_NAME = "searchParticipant";
    private static final String BINDING_XP_NAME = "binding";
    private static final Object PARTICIPANTS_NOT_FOUND = new Object();
    private Map indexes = new HashMap();
    private Map indexCaches = new HashMap();
    private Map analyzerDescriptors = new HashMap();
    private Map searchParticipantsById = new HashMap();
    private Map searchParticipantsByPlugin = new HashMap();
    private ArrayList globalSearchParticipants;

    public SearchManager() {
        HelpPlugin.getDefault().addTocsChangedListener((ITocsChangedListener)this);
    }

    public static List asList(Hits hits) {
        ArrayList<SearchHit> list = new ArrayList<SearchHit>(hits.length());
        int i = 0;
        while (i < hits.length()) {
            try {
                Document doc = hits.doc(i);
                float score = hits.score(i);
                String href = doc.get("name");
                String summary = doc.get("summary");
                String id = doc.get("id");
                String participantId = doc.get("participantId");
                String label = doc.get("raw_title");
                String filters = doc.get("filters");
                list.add(new SearchHit(href, label, summary, score, null, id, participantId, filters));
            }
            catch (IOException e) {
                HelpBasePlugin.logError("An error occured while reading search hits", e);
            }
            ++i;
        }
        return list;
    }

    private boolean filtersMatch(String filters) {
        StringTokenizer tok = new StringTokenizer(filters, ",");
        while (tok.hasMoreTokens()) {
            String filter = tok.nextToken();
            if (XHTMLSupport.getFilterProcessor().isFilteredIn(filter)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchIndexWithIndexingProgress getIndex(String locale) {
        Map map = this.indexes;
        synchronized (map) {
            Object index = this.indexes.get(locale);
            if (index == null) {
                index = new SearchIndexWithIndexingProgress(locale, this.getAnalyzer(locale), HelpPlugin.getTocManager());
                this.indexes.put(locale, index);
            }
            return (SearchIndexWithIndexingProgress)index;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SearchIndexCache getIndexCache(String locale) {
        Map map = this.indexCaches;
        synchronized (map) {
            Object index = this.indexCaches.get(locale);
            if (index == null) {
                index = new SearchIndexCache(locale, this.getAnalyzer(locale), HelpPlugin.getTocManager());
                this.indexCaches.put(locale, index);
            }
            return (SearchIndexCache)index;
        }
    }

    private AnalyzerDescriptor getAnalyzer(String locale) {
        AnalyzerDescriptor analyzerDesc = (AnalyzerDescriptor)this.analyzerDescriptors.get(locale);
        if (analyzerDesc != null) {
            return analyzerDesc;
        }
        analyzerDesc = new AnalyzerDescriptor(locale);
        this.analyzerDescriptors.put(locale, analyzerDesc);
        String lang = analyzerDesc.getLang();
        if (locale != null && !locale.equals(lang)) {
            this.analyzerDescriptors.put(lang, analyzerDesc);
        }
        return analyzerDesc;
    }

    public static String trimQuery(String href) {
        int qloc = href.indexOf(63);
        if (qloc != -1) {
            return href.substring(0, qloc);
        }
        return href;
    }

    public boolean isIndexable(String url) {
        ArrayList list = this.getParticipantDescriptors(SearchManager.getPluginId(url = SearchManager.trimQuery(url)));
        if (list == null) {
            return false;
        }
        int dotLoc = url.lastIndexOf(46);
        String ext = url.substring(dotLoc + 1);
        int i = 0;
        while (i < list.size()) {
            ParticipantDescriptor desc = (ParticipantDescriptor)list.get(i);
            if (desc.matches(ext)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isParticipantEnabled(boolean headless) {
        if (!headless) {
            return BaseHelpSystem.getMode() == 0;
        }
        return true;
    }

    public static String getPluginId(String href) {
        IProduct product;
        int i;
        if ((href = SearchManager.trimQuery(href)).charAt(0) == '/') {
            href = href.substring(1);
        }
        String pluginId = (i = href.indexOf(47)) == -1 ? EMPTY_STRING : href.substring(0, i);
        if ("PRODUCT_PLUGIN".equals(pluginId = URLCoder.decode((String)pluginId)) && (product = Platform.getProduct()) != null) {
            pluginId = product.getDefiningBundle().getSymbolicName();
        }
        return pluginId;
    }

    public LuceneSearchParticipant getGlobalParticipant(String participantId) {
        ParticipantDescriptor desc = this.getGlobalParticipantDescriptor(participantId);
        return desc != null ? desc.getParticipant() : null;
    }

    public IHelpResource getParticipantCategory(String participantId) {
        ParticipantDescriptor desc = this.getGlobalParticipantDescriptor(participantId);
        return desc != null ? desc.getCategory() : null;
    }

    public URL getParticipantIconURL(String participantId) {
        ParticipantDescriptor desc = this.getGlobalParticipantDescriptor(participantId);
        return desc != null ? desc.getIconURL() : null;
    }

    private ParticipantDescriptor getGlobalParticipantDescriptor(String participantId) {
        if (this.globalSearchParticipants == null) {
            this.createGlobalSearchParticipants();
        }
        int i = 0;
        while (i < this.globalSearchParticipants.size()) {
            ParticipantDescriptor desc = (ParticipantDescriptor)this.globalSearchParticipants.get(i);
            if (desc.getId().equals(participantId)) {
                return desc;
            }
            ++i;
        }
        return null;
    }

    public LuceneSearchParticipant getParticipant(String participantId) {
        ParticipantDescriptor desc = (ParticipantDescriptor)this.searchParticipantsById.get(participantId);
        if (desc != null) {
            return desc.getParticipant();
        }
        return null;
    }

    public LuceneSearchParticipant getParticipant(String pluginId, String fileName) {
        ArrayList list = this.getParticipantDescriptors(pluginId);
        if (list == null) {
            return null;
        }
        int dotLoc = fileName.lastIndexOf(46);
        String ext = fileName.substring(dotLoc + 1);
        int i = 0;
        while (i < list.size()) {
            ParticipantDescriptor desc = (ParticipantDescriptor)list.get(i);
            if (desc.matches(ext)) {
                return desc.getParticipant();
            }
            ++i;
        }
        return null;
    }

    public boolean isParticipantBound(String pluginId, String participantId) {
        ArrayList list = this.getParticipantDescriptors(pluginId);
        if (list != null) {
            for (ParticipantDescriptor desc : list) {
                if (!participantId.equals(desc.getId())) continue;
                return true;
            }
        }
        return false;
    }

    public Set getPluginsWithSearchParticipants() {
        HashSet<String> set = new HashSet<String>();
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(SEARCH_PARTICIPANT_XP_FULLNAME);
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (element.getName().equals(BINDING_XP_NAME) || element.getName().equals(SEARCH_PARTICIPANT_XP_NAME)) {
                set.add(element.getContributor().getName());
            }
            ++i;
        }
        LuceneSearchParticipant[] gps = this.getGlobalParticipants();
        int i2 = 0;
        while (i2 < gps.length) {
            Set ids = gps[i2].getContributingPlugins();
            set.addAll(ids);
            ++i2;
        }
        return set;
    }

    public void clearSearchParticipants() {
        for (ParticipantDescriptor desc : this.searchParticipantsById.values()) {
            desc.clear();
        }
    }

    private ArrayList createSearchParticipants(String pluginId) {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(SEARCH_PARTICIPANT_XP_FULLNAME);
        if (elements.length == 0) {
            return null;
        }
        ArrayList<ParticipantDescriptor> list = null;
        ArrayList<IConfigurationElement> binding = null;
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (element.getContributor().getName().equals(pluginId)) {
                if (BINDING_XP_NAME.equals(element.getName())) {
                    String refId = element.getAttribute("participantId");
                    int j = 0;
                    while (j < elements.length) {
                        String id;
                        IConfigurationElement rel = elements[j];
                        if (rel.getName().equals(SEARCH_PARTICIPANT_XP_NAME) && rel.getAttribute("extensions") != null && (id = rel.getAttribute("id")) != null && id.equals(refId)) {
                            if (binding == null) {
                                binding = new ArrayList<IConfigurationElement>();
                            }
                            binding.add(rel);
                            break;
                        }
                        ++j;
                    }
                } else if (SEARCH_PARTICIPANT_XP_NAME.equals(element.getName()) && element.getAttribute("extensions") != null && SearchManager.isParticipantEnabled(String.valueOf(true).equals(element.getAttribute("headless")))) {
                    if (list == null) {
                        list = new ArrayList<ParticipantDescriptor>();
                    }
                    ParticipantDescriptor desc = new ParticipantDescriptor(element);
                    list.add(desc);
                    this.searchParticipantsById.put(desc.getId(), desc);
                }
            }
            ++i;
        }
        if (binding != null) {
            list = this.addBoundDescriptors(list, binding);
        }
        return list;
    }

    private ArrayList addBoundDescriptors(ArrayList list, ArrayList binding) {
        int i = 0;
        while (i < binding.size()) {
            IConfigurationElement refEl = (IConfigurationElement)binding.get(i);
            Collection collection = this.searchParticipantsByPlugin.values();
            boolean found = false;
            Iterator iter = collection.iterator();
            block1: while (iter.hasNext()) {
                if (found) break;
                Object entry = iter.next();
                if (entry == PARTICIPANTS_NOT_FOUND) continue;
                ArrayList participants = (ArrayList)entry;
                int j = 0;
                while (j < participants.size()) {
                    ParticipantDescriptor desc = (ParticipantDescriptor)participants.get(j);
                    if (desc.contains(refEl)) {
                        if (list == null) {
                            list = new ArrayList();
                        }
                        list.add(desc);
                        found = true;
                        continue block1;
                    }
                    ++j;
                }
            }
            if (!found) {
                if (list == null) {
                    list = new ArrayList<ParticipantDescriptor>();
                }
                ParticipantDescriptor d = new ParticipantDescriptor(refEl);
                list.add(d);
                this.searchParticipantsById.put(d.getId(), d);
            }
            ++i;
        }
        return list;
    }

    public LuceneSearchParticipant[] getGlobalParticipants() {
        if (this.globalSearchParticipants == null) {
            this.createGlobalSearchParticipants();
        }
        ArrayList<LuceneSearchParticipant> result = new ArrayList<LuceneSearchParticipant>();
        int i = 0;
        while (i < this.globalSearchParticipants.size()) {
            ParticipantDescriptor desc = (ParticipantDescriptor)this.globalSearchParticipants.get(i);
            LuceneSearchParticipant p = desc.getParticipant();
            if (p != null) {
                result.add(p);
            }
            ++i;
        }
        return result.toArray(new LuceneSearchParticipant[result.size()]);
    }

    private void createGlobalSearchParticipants() {
        this.globalSearchParticipants = new ArrayList();
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(SEARCH_PARTICIPANT_XP_FULLNAME);
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (element.getName().equals(SEARCH_PARTICIPANT_XP_NAME) && element.getAttribute("extensions") == null && SearchManager.isParticipantEnabled(String.valueOf(true).equals(element.getAttribute("headless")))) {
                ParticipantDescriptor desc = new ParticipantDescriptor(element);
                this.globalSearchParticipants.add(desc);
            }
            ++i;
        }
    }

    private ArrayList getParticipantDescriptors(String pluginId) {
        Object result = this.searchParticipantsByPlugin.get(pluginId);
        if (result == null) {
            result = this.createSearchParticipants(pluginId);
            if (result == null) {
                result = PARTICIPANTS_NOT_FOUND;
            }
            this.searchParticipantsByPlugin.put(pluginId, result);
        }
        if (result == PARTICIPANTS_NOT_FOUND) {
            return null;
        }
        return (ArrayList)result;
    }

    public void search(ISearchQuery searchQuery, ISearchHitCollector collector, IProgressMonitor pm) throws QueryTooComplexException {
        block6: {
            SearchIndexWithIndexingProgress index = this.getIndex(searchQuery.getLocale());
            try {
                this.ensureIndexUpdated(pm, index);
                if (!index.exists()) {
                    return;
                }
            }
            catch (IndexingOperation.IndexingException indexingException) {
                if (!HelpBasePlugin.DEBUG_SEARCH) break block6;
                System.out.println(String.valueOf(this.getClass().getName()) + " IndexUpdateException occurred.");
            }
        }
        ArrayList hits = new ArrayList();
        ArrayList potentialHits = new ArrayList();
        ArrayList needReindexingHits = new ArrayList();
        String[] highlightTerms = new String[1];
        this.searchPass1(searchQuery, hits, potentialHits, highlightTerms);
        if (!potentialHits.isEmpty()) {
            this.searchPass2(searchQuery, potentialHits, needReindexingHits);
            if (!needReindexingHits.isEmpty()) {
                this.reindex(needReindexingHits, searchQuery.getLocale());
            }
            this.searchPass3(searchQuery, hits);
            Collections.sort(hits);
        }
        if (highlightTerms[0] == null) {
            highlightTerms[0] = EMPTY_STRING;
        }
        collector.addHits(hits, highlightTerms[0]);
    }

    public void search(String expression, FederatedSearchEntry[] entries) {
        int i = 0;
        while (i < entries.length) {
            FederatedSearchJob job = new FederatedSearchJob(expression, entries[i]);
            job.schedule();
            ++i;
        }
    }

    private void searchPass1(ISearchQuery searchQuery, Collection hits, Collection potentialFalseHits, String[] highlightTerms) {
        final Collection fHits = hits;
        final Collection fPotentialFalseHits = potentialFalseHits;
        final String[] fHighlightTerms = highlightTerms;
        ISearchHitCollector collector = new ISearchHitCollector(){

            public void addHits(List hits, String wordsSearched) {
                boolean isInfocenter = HelpSystem.isShared();
                boolean showPotentialHits = HelpBasePlugin.getDefault().getPluginPreferences().getBoolean("show_potential_hits");
                fHighlightTerms[0] = wordsSearched;
                for (SearchHit hit : hits) {
                    String filters = hit.getFilters();
                    if (!showPotentialHits && !isInfocenter && filters != null) {
                        fPotentialFalseHits.add(hit);
                        continue;
                    }
                    fHits.add(hit);
                }
            }
        };
        SearchIndexWithIndexingProgress index = this.getIndex(searchQuery.getLocale());
        index.search(searchQuery, collector);
    }

    private void searchPass2(ISearchQuery searchQuery, Collection potentialFalseHits, Collection needReindexingHits) {
        final ArrayList secondPassDefiniteHits = new ArrayList();
        final Collection fNeedReindexingHits = needReindexingHits;
        ISearchHitCollector collector = new ISearchHitCollector(){

            public void addHits(List hits, String wordsSearched) {
                for (SearchHit hit : hits) {
                    String filters = hit.getFilters();
                    if (SearchManager.this.filtersMatch(filters)) {
                        secondPassDefiniteHits.add(hit);
                        continue;
                    }
                    fNeedReindexingHits.add(hit);
                }
            }
        };
        SearchIndexCache indexCache = this.getIndexCache(searchQuery.getLocale());
        if (indexCache.exists()) {
            indexCache.search(searchQuery, collector);
        }
        HashSet unaccountedFor = new HashSet(potentialFalseHits);
        unaccountedFor.removeAll(secondPassDefiniteHits);
        unaccountedFor.removeAll(needReindexingHits);
        for (SearchHit hit : unaccountedFor) {
            String filters = (String)indexCache.getIndexedDocs().get(hit.getHref());
            if (filters != null && this.filtersMatch(filters)) continue;
            needReindexingHits.add(hit);
        }
    }

    private void searchPass3(ISearchQuery searchQuery, Collection definiteHits) {
        final Collection fDefiniteHits = definiteHits;
        ISearchHitCollector collector = new ISearchHitCollector(){

            public void addHits(List hits, String wordsSearched) {
                fDefiniteHits.addAll(hits);
            }
        };
        SearchIndexCache indexCache = this.getIndexCache(searchQuery.getLocale());
        indexCache.search(searchQuery, collector);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void ensureIndexUpdated(IProgressMonitor pm, SearchIndexWithIndexingProgress index) throws OperationCanceledException, IndexingOperation.IndexingException {
        block12: {
            block13: {
                progressDistrib = index.getProgressDistributor();
                progressDistrib.addMonitor(pm);
                configurationLocked = false;
                try {
                    if (1 == BaseHelpSystem.getMode()) break block12;
                    configurationLocked = index.tryLock();
                    if (configurationLocked) break block12;
                    pm.beginTask("", 1);
                    pm.worked(1);
                    pm.done();
                    break block13;
                    {
                        catch (OverlappingFileLockException v0) {}
                        break block12;
                    }
                }
                catch (Throwable var5_5) {
                    progressDistrib.removeMonitor(pm);
                    if (configurationLocked) {
                        index.releaseLock();
                    }
                    throw var5_5;
                }
            }
lbl21:
            // 2 sources

            while (true) {
                progressDistrib.removeMonitor(pm);
                if (configurationLocked) {
                    index.releaseLock();
                }
                return;
            }
        }
        if (index.isClosed() || !index.needsUpdating()) {
            pm.beginTask("", 1);
            pm.worked(1);
            pm.done();
            ** continue;
        }
        if (pm instanceof SearchProgressMonitor) {
            ((SearchProgressMonitor)pm).started();
        }
        this.updateIndex(pm, index, progressDistrib);
        progressDistrib.removeMonitor(pm);
        if (configurationLocked) {
            index.releaseLock();
        }
    }

    private synchronized void updateIndex(IProgressMonitor pm, SearchIndex index, ProgressDistributor progressDistrib) throws IndexingOperation.IndexingException {
        if (index.isClosed() || !index.needsUpdating()) {
            pm.beginTask(EMPTY_STRING, 1);
            pm.worked(1);
            pm.done();
            return;
        }
        if (HelpBasePlugin.DEBUG_SEARCH) {
            System.out.println("SearchManager indexing " + index.getLocale());
        }
        try {
            PluginVersionInfo versions = index.getDocPlugins();
            if (versions == null) {
                pm.beginTask(EMPTY_STRING, 1);
                pm.worked(1);
                pm.done();
                return;
            }
            IndexingOperation indexer = new IndexingOperation(index);
            indexer.execute(progressDistrib);
            return;
        }
        catch (OperationCanceledException oce) {
            progressDistrib.operationCanceled();
            HelpBasePlugin.logWarning("Search cancelled.");
            throw oce;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Map map = this.indexes;
        synchronized (map) {
            Iterator it = this.indexes.values().iterator();
            while (it.hasNext()) {
                ((SearchIndex)it.next()).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void tocsChanged() {
        ArrayList activeIndexes = new ArrayList();
        Map map = this.indexes;
        synchronized (map) {
            activeIndexes.addAll(this.indexes.values());
        }
        for (SearchIndexWithIndexingProgress ix : activeIndexes) {
            ix.close();
            Map map2 = this.indexes;
            synchronized (map2) {
                this.indexes.remove(ix.getLocale());
                ProgressDistributor pm = ix.getProgressDistributor();
                pm.beginTask(EMPTY_STRING, 1);
                pm.worked(1);
                pm.done();
                SearchProgressMonitor.reinit(ix.getLocale());
            }
        }
    }

    private void reindex(List hits, String locale) {
        SearchIndexCache indexCache = this.getIndexCache(locale);
        if (indexCache.exists()) {
            indexCache.beginDeleteBatch();
            for (SearchHit hit : hits) {
                indexCache.removeDocument(hit.getHref());
            }
            indexCache.endDeleteBatch();
        }
        indexCache.beginAddBatch(false);
        for (SearchHit hit : hits) {
            String filters = hit.getFilters();
            filters = this.setCurrentValues(filters);
            indexCache.addDocument(hit.getHref(), SearchIndex.getIndexableURL(locale, hit.getHref()), filters);
        }
        indexCache.endAddBatch(true, true);
    }

    private String setCurrentValues(String filters) {
        StringBuffer buf = new StringBuffer();
        StringTokenizer tok = new StringTokenizer(filters, ",");
        boolean first = true;
        while (tok.hasMoreTokens()) {
            if (!first) {
                buf.append(',');
            }
            first = false;
            String filter = tok.nextToken();
            int index = filter.indexOf(61);
            if (index > 0) {
                String key = filter.substring(0, index);
                String value = filter.substring(index + 1);
                boolean isPositive = XHTMLSupport.getFilterProcessor().isFilteredIn(key, value, true);
                buf.append(String.valueOf(key) + (isPositive ? "=" : "!=") + value);
                continue;
            }
            buf.append(String.valueOf(filter) + '=' + XHTMLSupport.getFilterProcessor().getCurrentValue(filter));
        }
        return buf.toString();
    }

    private static class ParticipantDescriptor
    implements IHelpResource {
        private IConfigurationElement element;
        private LuceneSearchParticipant participant;

        public ParticipantDescriptor(IConfigurationElement element) {
            this.element = element;
        }

        public String getId() {
            return this.element.getAttribute("id");
        }

        public boolean matches(String extension) {
            String ext = this.element.getAttribute("extensions");
            if (ext == null) {
                return false;
            }
            StringTokenizer stok = new StringTokenizer(ext, ",");
            while (stok.hasMoreTokens()) {
                String token = stok.nextToken().trim();
                if (!token.equalsIgnoreCase(extension)) continue;
                return true;
            }
            return false;
        }

        public boolean hasExtensions() {
            return this.element.getAttribute("extensions") != null;
        }

        public IHelpResource getCategory() {
            return this;
        }

        public LuceneSearchParticipant getParticipant() {
            if (this.participant == null) {
                try {
                    Object obj = this.element.createExecutableExtension("participant");
                    if (obj instanceof LuceneSearchParticipant) {
                        this.participant = (LuceneSearchParticipant)obj;
                        this.participant.init(this.getId());
                    }
                }
                catch (CoreException e) {
                    HelpPlugin.logError((String)"Exception occurred creating Lucene search participant.", (Throwable)e);
                }
            }
            return this.participant;
        }

        public boolean contains(IConfigurationElement el) {
            return this.element.equals((Object)el);
        }

        public String getHref() {
            return null;
        }

        public String getLabel() {
            return this.element.getAttribute("name");
        }

        public URL getIconURL() {
            String relativePath = this.element.getAttribute("icon");
            if (relativePath == null) {
                return null;
            }
            String bundleId = this.element.getContributor().getName();
            Bundle bundle = Platform.getBundle((String)bundleId);
            if (bundle == null) {
                return null;
            }
            return FileLocator.find((Bundle)bundle, (IPath)new Path(relativePath), null);
        }

        public void clear() {
            if (this.participant != null) {
                this.participant.clear();
            }
        }
    }
}

