/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.internal.models.sql.constraints;

import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.rdb.internal.models.sql.expressions.SearchCondition;
import org.eclipse.wst.rdb.internal.models.sql.schema.Schema;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Assertion</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * 4.17.4 Assertions
 * 
 * An assertion is a named constraint that may relate to the content of individual rows of a table, to the entire contents of a table, or to a state required to exist among a number of tables. An assertion is described by an assertion descriptor. In addition to the components of every constraint descriptor an assertion descriptor includes:
 *  - The <search condition> .
 * An assertion is satisfied if and only if the specified <search condition> is not False.
 * 
 * Syntax defined in section 11.37 <assertion definition>
 * Function: Specify an integrity constraint.
 * Format: <assertion definition> ::= CREATE ASSERTION <constraint name> CHECK <left paren> <search condition> <right paren> [ <constraint characteristics> ]
 * 
 * 10.8
 * 2) The <qualified identifier> of <constraint name> shall not be equivalent to the <qualified identifier> of the
 * <constraint name> of any other constraint defined in the same schema.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.wst.rdb.internal.models.sql.constraints.Assertion#getSearchCondition <em>Search Condition</em>}</li>
 *   <li>{@link org.eclipse.wst.rdb.internal.models.sql.constraints.Assertion#getSchema <em>Schema</em>}</li>
 *   <li>{@link org.eclipse.wst.rdb.internal.models.sql.constraints.Assertion#getConstrainedTables <em>Constrained Tables</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.wst.rdb.internal.models.sql.constraints.SQLConstraintsPackage#getAssertion()
 * @model 
 * @generated
 */
public interface Assertion extends Constraint{
	/**
	 * Returns the value of the '<em><b>Search Condition</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Search Condition</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Search Condition</em>' containment reference.
	 * @see #setSearchCondition(SearchCondition)
	 * @see org.eclipse.wst.rdb.internal.models.sql.constraints.SQLConstraintsPackage#getAssertion_SearchCondition()
	 * @model containment="true"
	 * @generated
	 */
	SearchCondition getSearchCondition();

	/**
	 * Sets the value of the '{@link org.eclipse.wst.rdb.internal.models.sql.constraints.Assertion#getSearchCondition <em>Search Condition</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Search Condition</em>' containment reference.
	 * @see #getSearchCondition()
	 * @generated
	 */
	void setSearchCondition(SearchCondition value);

	/**
	 * Returns the value of the '<em><b>Schema</b></em>' reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.wst.rdb.internal.models.sql.schema.Schema#getAssertions <em>Assertions</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Schema</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Schema</em>' reference.
	 * @see #setSchema(Schema)
	 * @see org.eclipse.wst.rdb.internal.models.sql.constraints.SQLConstraintsPackage#getAssertion_Schema()
	 * @see org.eclipse.wst.rdb.internal.models.sql.schema.Schema#getAssertions
	 * @model opposite="assertions" required="true"
	 * @generated
	 */
	Schema getSchema();

	/**
	 * Sets the value of the '{@link org.eclipse.wst.rdb.internal.models.sql.constraints.Assertion#getSchema <em>Schema</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Schema</em>' reference.
	 * @see #getSchema()
	 * @generated
	 */
	void setSchema(Schema value);

	/**
	 * Returns the value of the '<em><b>Constrained Tables</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.wst.rdb.internal.models.sql.tables.BaseTable}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Constrained Tables</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Constrained Tables</em>' reference list.
	 * @see org.eclipse.wst.rdb.internal.models.sql.constraints.SQLConstraintsPackage#getAssertion_ConstrainedTables()
	 * @model type="org.eclipse.wst.rdb.internal.models.sql.tables.BaseTable" required="true" derived="true"
	 * @generated
	 */
	EList getConstrainedTables();

} // Assertion
