/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.internal;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IActionDefinition;
import org.eclipse.wst.common.project.facet.core.IConstraint;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IGroup;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.IVersionExpr;
import org.eclipse.wst.common.project.facet.core.internal.Constraint;
import org.eclipse.wst.common.project.facet.core.internal.FacetCorePlugin;
import org.eclipse.wst.common.project.facet.core.internal.IVersion;
import org.eclipse.wst.common.project.facet.core.internal.ProjectFacet;
import org.eclipse.wst.common.project.facet.core.internal.VersionExpr;
import org.eclipse.wst.common.project.facet.core.internal.Versionable;

public final class ProjectFacetVersion
implements IProjectFacetVersion,
IVersion {
    private ProjectFacet facet;
    private String version;
    private IConstraint constraint;
    private String plugin;

    ProjectFacetVersion() {
    }

    public IProjectFacet getProjectFacet() {
        return this.facet;
    }

    void setProjectFacet(ProjectFacet facet) {
        this.facet = facet;
    }

    public String getVersionString() {
        return this.version;
    }

    void setVersionString(String version) {
        this.version = version;
    }

    public Versionable getVersionable() {
        return this.facet;
    }

    public IConstraint getConstraint() {
        if (this.constraint == null) {
            this.constraint = new Constraint(this, IConstraint.Type.AND, new Object[0]);
        }
        return this.constraint;
    }

    void setConstraint(IConstraint constraint) {
        this.constraint = constraint;
    }

    public String getPluginId() {
        return this.plugin;
    }

    void setPluginId(String plugin) {
        this.plugin = plugin;
    }

    public boolean supports(Set base, IFacetedProject.Action.Type type) {
        try {
            return this.getActionDefinitionInternal(base, type) != null;
        }
        catch (CoreException e) {
            FacetCorePlugin.log((Exception)((Object)e));
            return false;
        }
    }

    public boolean supports(IFacetedProject.Action.Type type) {
        try {
            return this.getActionDefinition(type) != null;
        }
        catch (CoreException e) {
            FacetCorePlugin.log((Exception)((Object)e));
            return false;
        }
    }

    public Set getActionDefinitions() {
        return this.facet.getActionDefinitions(this);
    }

    public Set getActionDefinitions(IFacetedProject.Action.Type type) {
        HashSet<IActionDefinition> result = new HashSet<IActionDefinition>();
        Iterator itr = this.getActionDefinitions().iterator();
        while (itr.hasNext()) {
            IActionDefinition def = (IActionDefinition)itr.next();
            if (def.getActionType() != type) continue;
            result.add(def);
        }
        if (result.size() > 1 && type != IFacetedProject.Action.Type.VERSION_CHANGE) {
            String msg = Resources.bind(Resources.multipleActionDefinitions, this.facet.getId(), this.version, type.toString());
            FacetCorePlugin.logWarning(msg, true);
        }
        return result;
    }

    public IActionDefinition getActionDefinition(Set base, IFacetedProject.Action.Type type) throws CoreException {
        IActionDefinition def = this.getActionDefinitionInternal(base, type);
        if (def == null) {
            String msg = NLS.bind((String)Resources.actionNotSupported, (Object)this.toString(), (Object)type.toString());
            throw new CoreException(FacetCorePlugin.createErrorStatus(msg));
        }
        return def;
    }

    private IActionDefinition getActionDefinitionInternal(Set base, IFacetedProject.Action.Type type) throws CoreException {
        Set definitions = this.getActionDefinitions(type);
        if (definitions.size() > 0) {
            if (type == IFacetedProject.Action.Type.VERSION_CHANGE) {
                String fromVersion = null;
                Iterator itr = base.iterator();
                while (itr.hasNext()) {
                    IProjectFacetVersion x = (IProjectFacetVersion)itr.next();
                    if (x.getProjectFacet() != this.facet) continue;
                    fromVersion = x.getVersionString();
                    break;
                }
                if (fromVersion != null) {
                    itr = definitions.iterator();
                    while (itr.hasNext()) {
                        IActionDefinition def = (IActionDefinition)itr.next();
                        IVersionExpr vexpr = (IVersionExpr)def.getProperty("from.versions");
                        if (vexpr != null && !vexpr.evaluate(fromVersion)) continue;
                        return def;
                    }
                }
            } else {
                return (IActionDefinition)definitions.iterator().next();
            }
        }
        return null;
    }

    public IActionDefinition getActionDefinition(IFacetedProject.Action.Type type) throws CoreException {
        Set definitions = this.getActionDefinitions(type);
        if (definitions.size() == 0) {
            return null;
        }
        return (IActionDefinition)definitions.iterator().next();
    }

    public Object createActionConfig(IFacetedProject.Action.Type type, String pjname) throws CoreException {
        if (!this.supports(type)) {
            String msg = NLS.bind((String)Resources.actionNotSupported, (Object)this.toString(), (Object)type.toString());
            throw new CoreException(FacetCorePlugin.createErrorStatus(msg));
        }
        IActionDefinition def = this.getActionDefinition(type);
        if (def == null) {
            return null;
        }
        return def.createConfigObject(this, pjname);
    }

    public boolean isSameActionConfig(IFacetedProject.Action.Type type, IProjectFacetVersion fv) throws CoreException {
        return ((ProjectFacetVersion)fv).getActionDefinition(type) == this.getActionDefinition(type);
    }

    public boolean isValidFor(Set fixed) {
        IProjectFacet f;
        Iterator itr = fixed.iterator();
        while (itr.hasNext()) {
            f = (IProjectFacet)itr.next();
            if (this.facet != f) continue;
            return true;
        }
        Iterator itr1 = fixed.iterator();
        while (itr1.hasNext()) {
            f = (IProjectFacet)itr1.next();
            boolean conflictsWithAllVersions = true;
            Iterator itr2 = f.getVersions().iterator();
            while (itr2.hasNext()) {
                IProjectFacetVersion fv = (IProjectFacetVersion)itr2.next();
                if (this.conflictsWith(fv) || fv.conflictsWith(this)) continue;
                conflictsWithAllVersions = false;
                break;
            }
            if (!conflictsWithAllVersions) continue;
            return false;
        }
        return true;
    }

    public boolean conflictsWith(IProjectFacetVersion fv) {
        if (this == fv) {
            return false;
        }
        if (this.facet == fv.getProjectFacet()) {
            return true;
        }
        return this.conflictsWith(fv, this.getConstraint());
    }

    private boolean conflictsWith(IProjectFacetVersion fv, IConstraint op) {
        if (op.getType() == IConstraint.Type.AND) {
            Iterator itr = op.getOperands().iterator();
            while (itr.hasNext()) {
                if (!this.conflictsWith(fv, (IConstraint)itr.next())) continue;
                return true;
            }
            return false;
        }
        if (op.getType() == IConstraint.Type.OR) {
            boolean allBranchesConflict = true;
            Iterator itr = op.getOperands().iterator();
            while (itr.hasNext()) {
                if (this.conflictsWith(fv, (IConstraint)itr.next())) continue;
                allBranchesConflict = false;
                break;
            }
            return allBranchesConflict;
        }
        if (op.getType() == IConstraint.Type.CONFLICTS) {
            Object firstOperand = op.getOperand(0);
            if (firstOperand instanceof IGroup) {
                IGroup group = (IGroup)firstOperand;
                return group.getMembers().contains(fv);
            }
            IProjectFacet f = (IProjectFacet)firstOperand;
            VersionExpr vexpr = op.getOperands().size() == 2 ? (VersionExpr)op.getOperand(1) : null;
            try {
                return fv.getProjectFacet() == f && (vexpr == null || vexpr.evaluate((IVersion)((Object)fv)));
            }
            catch (CoreException e) {
                FacetCorePlugin.log((Exception)((Object)e));
                return false;
            }
        }
        if (op.getType() == IConstraint.Type.REQUIRES) {
            IProjectFacet rf = (IProjectFacet)op.getOperand(0);
            VersionExpr vexpr = (VersionExpr)op.getOperand(1);
            boolean soft = (Boolean)op.getOperand(2);
            if (soft) {
                return true;
            }
            boolean conflictsWithAllVersions = true;
            try {
                String vexprstr = vexpr.toString();
                Iterator itr = rf.getVersions(vexprstr).iterator();
                while (itr.hasNext()) {
                    IProjectFacetVersion rfv = (IProjectFacetVersion)itr.next();
                    if (rfv.conflictsWith(fv)) continue;
                    conflictsWithAllVersions = false;
                    break;
                }
            }
            catch (CoreException e) {
                FacetCorePlugin.log((Exception)((Object)e));
                return false;
            }
            return conflictsWithAllVersions;
        }
        throw new IllegalStateException();
    }

    public String toString() {
        return String.valueOf(this.facet.getLabel()) + " " + this.version;
    }

    private static final class Resources
    extends NLS {
        public static String actionNotSupported;
        public static String multipleActionDefinitions;
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.common.project.facet.core.internal.ProjectFacetVersion");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String string = clazz.getName();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.wst.common.project.facet.core.internal.ProjectFacetVersion$Resources");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Resources.initializeMessages((String)string, (Class)clazz2);
        }

        private Resources() {
        }

        public static String bind(String template, Object arg1, Object arg2, Object arg3) {
            return NLS.bind((String)template, (Object[])new Object[]{arg1, arg2, arg3});
        }
    }
}

