/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.server.internal.ui.explorer.actions.popup;

import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IConnectionNode;
import org.eclipse.wst.rdb.core.internal.ui.util.CatalogUtil;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;
import org.eclipse.wst.rdb.server.internal.ui.explorer.actions.popup.AbstractAction;
import org.eclipse.wst.rdb.server.internal.ui.util.ServerUIDebugOptions;
import org.eclipse.wst.rdb.server.internal.ui.util.logging.Logger;
import org.eclipse.wst.rdb.server.internal.ui.util.resources.ResourceLoader;

public class UpdateOfflineItems
extends AbstractAction {
    private static final String JOB_NAME = ResourceLoader.INSTANCE.queryString("DATATOOLS.SERVER.UI.EXPLORER.UPDATE_OFFLINE");
    private static final ISchedulingRule MUTEX = new ISchedulingRule(){

        public boolean isConflicting(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }
    };
    private ISelection selection;

    protected void setSelection(ISelection selection) {
        this.selection = selection;
    }

    protected ISelection getSelection() {
        return this.selection;
    }

    public void run(IAction action) {
        IConnectionNode connection = (IConnectionNode)((IStructuredSelection)this.selection).getFirstElement();
        Database database = connection.getConnectionInfo().getSharedDatabase();
        if (database != null) {
            UpdateJob j = new UpdateJob(connection, database);
            j.setUser(true);
            j.schedule();
        }
    }

    private class UpdateJob
    extends Job {
        private Database database;
        private IConnectionNode connection;

        public UpdateJob(IConnectionNode connection, Database database) {
            super(JOB_NAME);
            this.connection = connection;
            this.database = database;
            this.setRule(MUTEX);
        }

        public boolean belongsTo(Object family) {
            return family == JOB_NAME;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public IStatus run(IProgressMonitor monitor) {
            try {
                try {
                    monitor.beginTask(String.valueOf(JOB_NAME) + " - " + this.connection.getName(), 100);
                    monitor.worked(5);
                    CatalogUtil.load((EObject)this.database, (IProgressMonitor)monitor, (int)90);
                    if (!monitor.isCanceled()) {
                        monitor.subTask("");
                        this.connection.getConnectionInfo().cacheDatabase(this.database);
                    }
                }
                catch (IOException e) {
                    Logger.log((Object)this, e, ServerUIDebugOptions.SERVER_EXPLORER_LOG);
                    IStatus iStatus = Status.CANCEL_STATUS;
                    Object var3_4 = null;
                    monitor.done();
                    return iStatus;
                }
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                monitor.done();
                throw throwable;
            }
            {
                Object var3_6 = null;
            }
            monitor.done();
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        }
    }
}

