/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.axis.creation.ui.task;

import java.io.File;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.ws.internal.axis.consumption.core.AxisConsumptionCoreMessages;
import org.eclipse.jst.ws.internal.axis.consumption.core.common.JavaWSDLParameter;
import org.eclipse.jst.ws.internal.axis.consumption.ui.AxisConsumptionUIMessages;
import org.eclipse.jst.ws.internal.axis.consumption.ui.util.ClasspathUtils;
import org.eclipse.jst.ws.internal.axis.consumption.ui.util.FileUtil;
import org.eclipse.jst.ws.internal.axis.consumption.ui.util.PlatformUtils;
import org.eclipse.jst.ws.internal.axis.consumption.ui.util.WSDLUtils;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.common.ServerUtils;
import org.eclipse.jst.ws.internal.consumption.ui.wsil.Utils;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.parser.discovery.WebServicesParserExt;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;

public class DefaultsForServerJavaWSDLCommand
extends AbstractDataModelOperation {
    private JavaWSDLParameter javaWSDLParam_ = null;
    private IProject serviceProject_;
    private String javaBeanName_;
    private String WSDLServiceURL_;
    private String WSDLServicePathname_;
    private WebServicesParser WSParser_;
    private String serviceServerTypeID_;
    private final String WSDL_FOLDER = "wsdl";
    public final String SERVICE_EXT = "/services/";
    private final String WSDL_EXT = "wsdl";
    public final byte MODE_BEAN = 0;
    public final String SERVICE_NAME_EXT = "Service";
    private final String TEMP_URI = "http://tempuri.org/";

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        int index;
        IEnvironment environment = this.getEnvironment();
        if (this.javaWSDLParam_ == null) {
            IStatus status = StatusUtils.errorStatus((String)AxisConsumptionCoreMessages.MSG_ERROR_JAVA_WSDL_PARAM_NOT_SET);
            environment.getStatusHandler().reportError(status);
            return status;
        }
        if (this.javaBeanName_ == null) {
            this.javaBeanName_ = this.javaWSDLParam_.getBeanName();
            if (this.javaBeanName_ == null) {
                this.javaWSDLParam_.setBeanName(this.javaBeanName_);
            }
        }
        this.javaWSDLParam_.setServerSide((byte)1);
        this.javaWSDLParam_.setSkeletonDeploy(false);
        this.javaWSDLParam_.setBeanName(this.javaBeanName_);
        String classpath = ClasspathUtils.getInstance().getClasspathString(this.serviceProject_);
        this.javaWSDLParam_.setClasspath(classpath);
        String simpleBeanName = this.javaBeanName_;
        if (this.javaBeanName_ != null && (index = this.javaBeanName_.lastIndexOf(46)) != -1) {
            simpleBeanName = this.javaBeanName_.substring(index + 1);
        }
        String namespace = WSDLUtils.makeNamespace((String)this.javaWSDLParam_.getBeanName());
        this.javaWSDLParam_.setNamespace(namespace);
        this.javaWSDLParam_.setPortTypeName(simpleBeanName);
        this.javaWSDLParam_.setServiceName(String.valueOf(simpleBeanName) + "Service");
        IPath moduleServerRoot = null;
        IPath modulePath = this.serviceProject_.getFullPath();
        IPath webinfPath = this.serviceProject_.getFullPath();
        try {
            if (J2EEUtils.isWebComponent((IProject)this.serviceProject_)) {
                moduleServerRoot = ResourceUtils.getJavaSourceLocation((IProject)this.serviceProject_);
                modulePath = J2EEUtils.getWebContentPath((IProject)this.serviceProject_);
                webinfPath = J2EEUtils.getWebInfPath((IProject)this.serviceProject_);
            }
        }
        catch (Exception e) {
            IStatus status = StatusUtils.errorStatus((String)AxisConsumptionUIMessages.MSG_ERROR_DEFAULT_BEAN, (Throwable)e);
            environment.getStatusHandler().reportError(status);
            return status;
        }
        IPath wsdlPath = modulePath.append("wsdl").append(simpleBeanName).addFileExtension("wsdl");
        try {
            IFolder folder = ResourceUtils.getWorkspaceRoot().getFolder(modulePath.append("wsdl"));
            FileUtil.createFolder((IFolder)folder, (boolean)true, (boolean)true);
        }
        catch (CoreException e) {
            IStatus status = StatusUtils.errorStatus((String)AxisConsumptionUIMessages.MSG_ERROR_WRITE_WSDL, (Throwable)e);
            environment.getStatusHandler().reportError(status);
            return status;
        }
        String wsdlLocation = ResourceUtils.getWorkspaceRoot().getFile(wsdlPath).getLocation().toString();
        this.javaWSDLParam_.setOutputWsdlLocation(wsdlLocation);
        this.javaWSDLParam_.setInputWsdlLocation(new File(wsdlLocation).toURI().toString());
        this.WSDLServicePathname_ = wsdlPath.toString();
        if (wsdlPath != null) {
            IResource res;
            String wsdlURL;
            this.WSDLServiceURL_ = wsdlURL = PlatformUtils.getFileURLFromPath((IPath)new Path(wsdlLocation));
            if ((wsdlURL == null || wsdlURL.length() <= 0) && (res = ResourceUtils.findResource((String)this.WSDLServicePathname_)) != null) {
                wsdlURL = new Utils().toFileSystemURI(res);
            }
            if (wsdlURL != null && wsdlURL.length() > 0 && this.WSParser_ == null) {
                this.WSParser_ = new WebServicesParserExt();
            }
        }
        this.javaWSDLParam_.setStyle("WRAPPED");
        this.javaWSDLParam_.setUse("LITERAL");
        String projectURL = null;
        if (this.serviceServerTypeID_ != null && this.serviceServerTypeID_.length() > 0) {
            projectURL = ServerUtils.getEncodedWebComponentURL((IProject)this.serviceProject_, (String)this.serviceServerTypeID_);
        }
        if (projectURL == null) {
            projectURL = "http://tempuri.org/" + this.serviceProject_.getName();
            this.javaWSDLParam_.setGuessProjectURL(true);
        }
        this.javaWSDLParam_.setProjectURL(projectURL);
        String serviceURL = String.valueOf(projectURL) + "/services/" + simpleBeanName;
        this.javaWSDLParam_.setUrlLocation(serviceURL);
        this.javaWSDLParam_.setMetaInfOnly(true);
        String javaOutput = ResourceUtils.findResource((IPath)moduleServerRoot).getLocation().toString();
        String serviceName = this.javaWSDLParam_.getServiceName();
        IPath outputPath = ResourceUtils.findResource((IPath)webinfPath).getLocation();
        String output = this.serviceProject_.getFullPath().toString();
        if (outputPath != null) {
            output = outputPath.append(serviceName).toString();
        }
        this.javaWSDLParam_.setJavaOutput(javaOutput);
        this.javaWSDLParam_.setOutput(output);
        return Status.OK_STATUS;
    }

    public JavaWSDLParameter getJavaWSDLParam() {
        return this.javaWSDLParam_;
    }

    public void setJavaWSDLParam(JavaWSDLParameter javaWSDLParam) {
        this.javaWSDLParam_ = javaWSDLParam;
    }

    public void setServiceProject(IProject serviceProject) {
        this.serviceProject_ = serviceProject;
    }

    public void setJavaBeanName(String javaBeanName) {
        this.javaBeanName_ = javaBeanName;
    }

    public String getWSDLServiceURL() {
        return this.WSDLServiceURL_;
    }

    public String getWSDLServicePathname() {
        return this.WSDLServicePathname_;
    }

    public void setParser(WebServicesParser wsParser) {
        this.WSParser_ = wsParser;
    }

    public WebServicesParser getParser() {
        return this.WSParser_;
    }

    public void setObjectSelection(IStructuredSelection objectSelection) {
        Object object;
        if (objectSelection != null && !objectSelection.isEmpty() && (object = objectSelection.getFirstElement()) instanceof String) {
            this.setJavaBeanName((String)object);
        }
    }

    public void setServiceServerTypeID(String id) {
        this.serviceServerTypeID_ = id;
    }
}

