/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jem.util.RegistryReader;
import org.eclipse.jem.util.UITester;
import org.eclipse.jem.util.logger.proxy.Logger;

public class UIContextDetermination {
    private static final int UNKNOWN = 100;
    public static final String HEADLESS_CONTEXT_LITERAL = "Headless";
    public static final String UI_CONTEXT_LITERAL = "UI";
    public static final int HEADLESS_CONTEXT = 102;
    public static final int UI_CONTEXT = 100;
    private static Map cachedExtensions = null;
    private static int currentContext = 100;

    private UIContextDetermination() {
    }

    public static Object createInstance(String key) {
        Object result = null;
        if (cachedExtensions == null) {
            UIContextDetermination.initExtensions();
        }
        IConfigurationElement contextSensitiveClass = (IConfigurationElement)cachedExtensions.get(key);
        try {
            if (contextSensitiveClass != null) {
                result = contextSensitiveClass.createExecutableExtension("className");
            }
        }
        catch (CoreException e) {
            Logger.getLogger().logError("Problem loading extension not found for key \"" + key + "\".");
            Logger.getLogger().logError(e);
        }
        if (result == null) {
            Logger.getLogger().logError("Extension not found for key \"" + key + "\".");
        }
        return result;
    }

    public static int getCurrentContext() {
        if (currentContext == 100) {
            currentContext = 102;
            new UITesterRegistryReader().readRegistry();
        }
        return currentContext;
    }

    private static void initExtensions() {
        if (cachedExtensions == null) {
            cachedExtensions = new HashMap();
            new UIContextDeterminationRegistryReader().readRegistry();
        }
    }

    private static int convertLiteral(String literal) {
        return UI_CONTEXT_LITERAL.equals(literal) ? 100 : 102;
    }

    private static class UIContextDeterminationRegistryReader
    extends RegistryReader {
        public static final String UI_CONTEXT_SENSTIVE_CLASS_ELEMENT = "uiContextSensitiveClass";
        public static final String UI_CONTEXT_SENSTIVE_CLASS_KEY_ATTR = "key";
        public static final String UI_CONTEXT_SENSTIVE_CLASS_CLASSNAME_ATTR = "className";
        public static final String UI_CONTEXT_SENSTIVE_CLASS_CONTEXT_ATTR = "context";

        public UIContextDeterminationRegistryReader() {
            super("org.eclipse.jem.util", UI_CONTEXT_SENSTIVE_CLASS_ELEMENT);
        }

        public boolean readElement(IConfigurationElement element) {
            boolean result = false;
            if (element.getName().equals(UI_CONTEXT_SENSTIVE_CLASS_ELEMENT)) {
                String key = element.getAttribute(UI_CONTEXT_SENSTIVE_CLASS_KEY_ATTR);
                String context = element.getAttribute(UI_CONTEXT_SENSTIVE_CLASS_CONTEXT_ATTR);
                if (!cachedExtensions.containsKey(key) || UIContextDetermination.getCurrentContext() == UIContextDetermination.convertLiteral(context)) {
                    cachedExtensions.put(key, element);
                }
                result = true;
            }
            return result;
        }
    }

    private static class UITesterRegistryReader
    extends RegistryReader {
        public static final String UI_TESTER_ELEMENT = "uiTester";
        public static final String UI_TESTER_CLASSNAME_ATTR = "className";

        public UITesterRegistryReader() {
            super("org.eclipse.jem.util", UI_TESTER_ELEMENT);
        }

        public boolean readElement(IConfigurationElement element) {
            boolean result = false;
            if (element.getName().equals(UI_TESTER_ELEMENT)) {
                result = true;
                try {
                    UITester tester;
                    if (UITesterRegistryReader.canCreateExecutableExtension(element) && (tester = (UITester)element.createExecutableExtension(UI_TESTER_CLASSNAME_ATTR)).isCurrentContextUI()) {
                        currentContext = 100;
                    }
                }
                catch (Throwable throwable) {
                    Logger.getLogger().log("UIContextDetermination is proceeding in HEADLESS mode");
                }
            }
            return result;
        }
    }
}

