/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.sdo.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryImpl;
import org.eclipse.emf.ecore.sdo.EChangeSummary;
import org.eclipse.emf.ecore.sdo.EDataGraph;
import org.eclipse.emf.ecore.sdo.SDOFactory;
import org.eclipse.emf.ecore.sdo.SDOPackage;
import org.eclipse.emf.ecore.sdo.impl.DynamicEDataObjectImpl;
import org.eclipse.emf.ecore.sdo.util.DataGraphResourceFactoryImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.xmi.EcoreBuilder;
import org.eclipse.emf.ecore.xmi.NameInfo;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLLoad;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.XMLSave;
import org.eclipse.emf.ecore.xmi.impl.SAXXMLHandler;
import org.eclipse.emf.ecore.xmi.impl.XMLHelperImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLLoadImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLSaveImpl;
import org.eclipse.emf.ecore.xmi.util.DefaultEcoreBuilder;
import org.w3c.dom.Element;
import org.xml.sax.helpers.DefaultHandler;

public class DataGraphResourceFactoryImpl
extends ResourceFactoryImpl {
    public Resource createResource(URI uri) {
        DataGraphResourceImpl result = new DataGraphResourceImpl(uri);
        result.setEncoding("UTF-8");
        result.getDefaultLoadOptions().put("USE_LEXICAL_HANDLER", Boolean.TRUE);
        result.getDefaultLoadOptions().put("EXTENDED_META_DATA", Boolean.TRUE);
        result.getDefaultSaveOptions().put("EXTENDED_META_DATA", Boolean.TRUE);
        result.getDefaultSaveOptions().put("USE_ENCODED_ATTRIBUTE_STYLE", Boolean.TRUE);
        result.getDefaultSaveOptions().put("LINE_WIDTH", new Integer(80));
        result.getDefaultLoadOptions().put("ANY_TYPE", SDOPackage.eINSTANCE.getEDataObjectAnyType());
        result.getDefaultSaveOptions().put("ANY_TYPE", SDOPackage.eINSTANCE.getEDataObjectAnyType());
        result.getDefaultLoadOptions().put("ANY_SIMPLE_TYPE", SDOPackage.eINSTANCE.getEDataObjectSimpleAnyType());
        result.getDefaultSaveOptions().put("ANY_SIMPLE_TYPE", SDOPackage.eINSTANCE.getEDataObjectSimpleAnyType());
        return result;
    }

    public static class DataGraphResourceImpl
    extends XMLResourceImpl {
        public DataGraphResourceImpl(URI uri) {
            super(uri);
        }

        protected XMLHelper createXMLHelper() {
            return new HelperImpl((XMLResource)this);
        }

        protected EObject getEObjectByID(String id) {
            Object rootObject;
            EList contents = this.getContents();
            if (contents.size() >= 1 && (rootObject = contents.get(0)) instanceof EDataGraph) {
                EDataGraph eDataGraph = (EDataGraph)rootObject;
                EObject result = eDataGraph.getRootResource().getEObject(id);
                if (result != null) {
                    return result;
                }
                EChangeSummary eChangeSummary = eDataGraph.getEChangeSummary();
                if (eChangeSummary != null && (result = ((EObject)eDataGraph.getChangeSummary()).eResource().getEObject(id)) != null) {
                    return result;
                }
            }
            return super.getEObjectByID(id);
        }

        protected XMLSave createXMLSave() {
            return new SaveImpl(this.createXMLHelper());
        }

        protected XMLLoad createXMLLoad() {
            return new LoadImpl(this.createXMLHelper());
        }

        public static class HelperImpl
        extends XMLHelperImpl {
            protected EDataGraph eDataGraph;
            protected List resources;
            protected List uris;

            public HelperImpl(XMLResource xmlResource) {
                super(xmlResource);
            }

            public void setResource(XMLResource resource) {
                super.setResource(resource);
                if (!resource.getContents().isEmpty()) {
                    this.eDataGraph = (EDataGraph)resource.getContents().get(0);
                    this.resources = new ArrayList();
                    this.uris = new ArrayList();
                    this.resources.add(this.eDataGraph.getRootResource());
                    this.uris.add("#" + resource.getURIFragment((EObject)this.eDataGraph) + "/@eRootObject");
                    if (this.eDataGraph.getEChangeSummary() != null) {
                        this.resources.add(((EObject)this.eDataGraph.getChangeSummary()).eResource());
                        this.uris.add("#" + resource.getURIFragment((EObject)this.eDataGraph) + "/@eChangeSummary");
                    }
                    if (this.eDataGraph.eResource() != null && this.eDataGraph.eResource().getResourceSet() != null) {
                        int count = 0;
                        Iterator i = this.eDataGraph.eResource().getResourceSet().getResources().iterator();
                        while (i.hasNext()) {
                            Resource ePackageResource = (Resource)i.next();
                            EList resourceContents = ePackageResource.getContents();
                            if (resourceContents.size() != 1 || !(resourceContents.get(0) instanceof EPackage)) continue;
                            this.resources.add(ePackageResource);
                            this.uris.add("#" + resource.getURIFragment((EObject)this.eDataGraph) + "/@models." + count++);
                        }
                    }
                }
            }

            public String getID(EObject eObject) {
                return super.getID(eObject);
            }

            public String getIDREF(EObject eObject) {
                return super.getIDREF(eObject);
            }

            public String getHREF(EObject eObject) {
                return super.getHREF(eObject);
            }

            protected URI getHREF(Resource otherResource, EObject obj) {
                int index = this.resources.indexOf(otherResource);
                if (index == -1) {
                    return super.getHREF(otherResource, obj);
                }
                return this.createHREF((String)this.uris.get(index), otherResource.getURIFragment(obj));
            }

            protected URI createHREF(String baseURI, String fragment) {
                if (fragment.startsWith("/")) {
                    return URI.createURI((String)(String.valueOf(baseURI) + fragment.substring(1)));
                }
                return URI.createURI((String)("#" + fragment));
            }

            public EClassifier getType(EFactory eFactory, String typeName) {
                if (eFactory == SDOFactory.eINSTANCE && "datagraph".equals(typeName)) {
                    return super.getType(eFactory, "EDataGraph");
                }
                return super.getType(eFactory, typeName);
            }

            public void populateNameInfo(NameInfo nameInfo, EClass c) {
                if (c == SDOPackage.eINSTANCE.getEDataGraph()) {
                    if (this.extendedMetaData != null) {
                        this.extendedMetaData.demandPackage("commonj.sdo").setNsPrefix("sdo");
                    }
                    nameInfo.setQualifiedName(this.getQName("commonj.sdo", "datagraph"));
                    nameInfo.setNamespaceURI("commonj.sdo");
                    nameInfo.setLocalPart("datagraph");
                } else if (c == SDOPackage.eINSTANCE.getEChangeSummary()) {
                    if (this.extendedMetaData != null) {
                        this.extendedMetaData.demandPackage("commonj.sdo").setNsPrefix("sdo");
                    }
                    nameInfo.setQualifiedName("changeSummary");
                    nameInfo.setNamespaceURI(null);
                    nameInfo.setLocalPart("changeSummary");
                } else {
                    super.populateNameInfo(nameInfo, c);
                }
            }

            public String getQName(EClass c) {
                if (c == SDOPackage.eINSTANCE.getEDataGraph()) {
                    if (this.extendedMetaData != null) {
                        this.extendedMetaData.demandPackage("commonj.sdo").setNsPrefix("sdo");
                    }
                    return this.getQName("commonj.sdo", "datagraph");
                }
                if (c == SDOPackage.eINSTANCE.getEChangeSummary()) {
                    if (this.extendedMetaData != null) {
                        this.extendedMetaData.demandPackage("commonj.sdo").setNsPrefix("sdo");
                    }
                    return this.getQName(null, "changeSummary");
                }
                return super.getQName(c);
            }
        }

        public static class SaveImpl
        extends XMLSaveImpl {
            protected EDataGraph eDataGraph;

            public SaveImpl(XMLHelper xmlHelper) {
                super(xmlHelper);
            }

            public void traverse(List contents) {
                if (contents.size() >= 1 && contents.get(0) instanceof EDataGraph) {
                    EChangeSummary changeSummary;
                    EObject eRootObject;
                    EReference xmlnsPrefixMapFeature;
                    this.eDataGraph = (EDataGraph)contents.get(0);
                    Object datagraphMark = null;
                    if (!this.toDOM) {
                        if (this.declareXML) {
                            this.doc.add("<?xml version=\"" + this.xmlVersion + "\" encoding=\"" + this.encoding + "\"?>");
                            this.doc.addLine();
                        }
                        String elementName = this.helper.getQName(this.eDataGraph.eClass());
                        this.doc.startElement(elementName);
                        datagraphMark = this.doc.mark();
                    } else {
                        this.helper.populateNameInfo(this.nameInfo, this.eDataGraph.eClass());
                        this.currentNode = this.document.createElementNS(this.nameInfo.getNamespaceURI(), this.nameInfo.getQualifiedName());
                        this.document.appendChild(this.currentNode);
                    }
                    if (this.eDataGraph.eResource() != null && this.eDataGraph.eResource().getResourceSet() != null) {
                        ArrayList ePackages = new ArrayList();
                        Iterator i = this.eDataGraph.eResource().getResourceSet().getResources().iterator();
                        while (i.hasNext()) {
                            EList resourceContents = ((Resource)i.next()).getContents();
                            if (resourceContents.size() != 1 || !(resourceContents.get(0) instanceof EPackage)) continue;
                            ePackages.add(resourceContents.get(0));
                        }
                        if (!ePackages.isEmpty()) {
                            if (!this.toDOM) {
                                this.doc.startElement("models");
                                this.doc.addAttribute("xmlns", "");
                            } else {
                                this.currentNode = this.currentNode.appendChild(this.document.createElementNS(null, "models"));
                                ((Element)this.currentNode).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "");
                            }
                            i = ePackages.iterator();
                            while (i.hasNext()) {
                                this.writeTopObject((EObject)((EPackage)i.next()));
                            }
                            if (!this.toDOM) {
                                this.doc.endElement();
                            } else {
                                this.currentNode = this.currentNode.getParentNode();
                            }
                        }
                    }
                    if ((xmlnsPrefixMapFeature = this.extendedMetaData.getXMLNSPrefixMapFeature((eRootObject = this.eDataGraph.getERootObject()).eClass())) != null) {
                        EMap xmlnsPrefixMap = (EMap)eRootObject.eGet((EStructuralFeature)xmlnsPrefixMapFeature);
                        this.helper.setPrefixToNamespaceMap(xmlnsPrefixMap);
                    }
                    if ((changeSummary = this.eDataGraph.getEChangeSummary()) != null) {
                        this.helper.setMustHavePrefix(true);
                        if (changeSummary.isLogging()) {
                            changeSummary.summarize();
                            this.writeTopObject((EObject)changeSummary);
                        } else {
                            this.writeTopObject((EObject)changeSummary);
                        }
                        this.helper.setMustHavePrefix(false);
                    }
                    if (eRootObject != null && this.writeTopObject(eRootObject) == null && !this.toDOM) {
                        this.doc.addLine();
                        this.doc.setMixed(false);
                    }
                    if (!this.toDOM) {
                        this.doc.endElement();
                        this.doc.resetToMark(datagraphMark);
                    } else {
                        this.currentNode = this.document.getFirstChild();
                    }
                    this.addNamespaceDeclarations();
                } else {
                    super.traverse(contents);
                }
            }

            protected void writeTopAttributes(EObject top) {
                if (top == this.eDataGraph.getEChangeSummary()) {
                    if (!this.toDOM) {
                        this.doc.addAttribute("xmlns", "");
                    } else {
                        ((Element)this.currentNode).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "");
                    }
                }
            }

            protected EObject getSchemaLocationRoot(EObject eObject) {
                return this.eDataGraph.getERootObject();
            }
        }

        public static class LoadImpl
        extends XMLLoadImpl {
            public LoadImpl(XMLHelper xmlHelper) {
                super(xmlHelper);
            }

            protected DefaultHandler makeDefaultHandler() {
                return new SAXXMLHandler(this, this.resource, this.helper, this.options){
                    protected EDataGraph eDataGraph;
                    protected boolean isInModels;
                    protected List ePackages;
                    final /* synthetic */ LoadImpl this$2;
                    {
                        this.this$2 = loadImpl;
                        this.ePackages = new ArrayList<E>();
                    }

                    protected EMap recordNamespacesSchemaLocations(EObject root) {
                        EObject dgroot = this.eDataGraph.getERootObject();
                        if (dgroot == null) {
                            return null;
                        }
                        EMap prefixToNamespaceMap = super.recordNamespacesSchemaLocations(dgroot);
                        if (prefixToNamespaceMap != null) {
                            Iterator i = prefixToNamespaceMap.iterator();
                            while (i.hasNext()) {
                                Map.Entry entry = (Map.Entry)i.next();
                                String prefix = (String)entry.getKey();
                                String namespace = (String)entry.getValue();
                                if (!namespace.equals("commonj.sdo")) continue;
                                prefixToNamespaceMap.removeKey((Object)prefix);
                                break;
                            }
                        }
                        return prefixToNamespaceMap;
                    }

                    protected void handleFeature(String prefix, String name) {
                        if (this.isInModels && this.objects.size() == 2) {
                            EObject modelObject = this.createObjectByType(prefix, name, false);
                            this.processObject(modelObject);
                            this.ePackages.add(modelObject);
                        } else if (this.objects.size() == 1) {
                            this.eDataGraph = (EDataGraph)this.objects.peek();
                            this.eDataGraph.getResourceSet();
                            if ("".equals(prefix) && "changeSummary".equals(name)) {
                                EChangeSummary eChangeSummary = (EChangeSummary)this.createObjectFromFactory(SDOFactory.eINSTANCE, "EChangeSummary");
                                this.eDataGraph.setEChangeSummary(eChangeSummary);
                                this.processObject((EObject)eChangeSummary);
                            } else if ("".equals(prefix) && "models".equals(name)) {
                                this.isInModels = true;
                                this.types.push((Object)"object");
                                this.objects.push((EObject)this.eDataGraph);
                                this.mixedTargets.push(null);
                            } else if (this.eDataGraph.getERootObject() == null) {
                                String namespaceURI;
                                if (this.useNewMethods) {
                                    this.handleSchemaLocation();
                                }
                                this.processSchemaLocations(prefix, name);
                                if (this.processAnyXML && this.extendedMetaData.getPackage(namespaceURI = this.helper.getURI(prefix)) == null) {
                                    EStructuralFeature rootFeature = this.extendedMetaData.demandFeature(namespaceURI, name, true);
                                    rootFeature.getEContainingClass().getEPackage().setEFactoryInstance((EFactory)new DynamicEDataObjectImpl.FactoryImpl());
                                }
                                EObject rootObject = this.createObjectByType(prefix, name, false);
                                this.eDataGraph.setERootObject(rootObject);
                                this.processObject(rootObject);
                                if (rootObject != null && rootObject.eClass() == ExtendedMetaData.INSTANCE.getDocumentRoot(rootObject.eClass().getEPackage())) {
                                    super.handleFeature(prefix, name);
                                    Object mixedTarget = this.mixedTargets.pop();
                                    Object object = this.objects.pop();
                                    this.mixedTargets.pop();
                                    this.objects.pop();
                                    this.mixedTargets.push(mixedTarget);
                                    this.objects.push(object);
                                }
                            }
                        } else {
                            super.handleFeature(prefix, name);
                        }
                    }

                    public void endElement(String uri, String localName, String name) {
                        if (this.isInModels && this.objects.size() == 2) {
                            if (!this.ePackages.isEmpty()) {
                                Iterator<E> i = this.ePackages.iterator();
                                while (i.hasNext()) {
                                    EPackage ePackage = (EPackage)i.next();
                                    ePackage.setEFactoryInstance((EFactory)new DynamicEDataObjectImpl.FactoryImpl());
                                    Resource resource = this.resourceSet.createResource(URI.createURI((String)"*.ecore"));
                                    resource.getContents().add((Object)ePackage);
                                    if (ePackage.getNsURI() != null) {
                                        resource.setURI(URI.createURI((String)ePackage.getNsURI()));
                                    }
                                    if (this.extendedMetaData != null) {
                                        this.extendedMetaData.putPackage(this.extendedMetaData.getNamespace(ePackage), ePackage);
                                        continue;
                                    }
                                    this.packageRegistry.put((Object)ePackage.getNsURI(), (Object)ePackage);
                                }
                                this.handleForwardReferences();
                            }
                            this.isInModels = false;
                        }
                        super.endElement(uri, localName, name);
                    }

                    protected EPackage getPackageForURI(String uriString) {
                        if ("commonj.sdo".equals(uriString)) {
                            return SDOPackage.eINSTANCE;
                        }
                        return super.getPackageForURI(uriString);
                    }

                    protected EObject createObjectFromFactory(EFactory factory, String typeName) {
                        if (factory == SDOFactory.eINSTANCE && "datagraph".equals(typeName)) {
                            return super.createObjectFromFactory(factory, "EDataGraph");
                        }
                        return super.createObjectFromFactory(factory, typeName);
                    }

                    protected void handleTopLocations(String prefix, String name) {
                    }

                    protected EcoreBuilder createEcoreBuilder(Map options, ExtendedMetaData extendedMetaData) {
                        return new DefaultEcoreBuilder(this, extendedMetaData){
                            final /* synthetic */ 1 this$3;
                            {
                                super($anonymous0);
                                this.this$3 = var1_1;
                            }

                            public Collection generate(Map urisToLocations) throws Exception {
                                Collection result = super.generate(urisToLocations);
                                return this.updateDynamicFactory(result);
                            }

                            public Collection generate(Collection urisToLocations) throws Exception {
                                Collection result = super.generate(urisToLocations);
                                return this.updateDynamicFactory(result);
                            }

                            protected Collection updateDynamicFactory(Collection result) {
                                Iterator<E> i = result.iterator();
                                while (i.hasNext()) {
                                    Resource resource = (Resource)i.next();
                                    Iterator<E> j = EcoreUtil.getObjectsByType((Collection)resource.getContents(), (EClassifier)EcorePackage.eINSTANCE.getEPackage()).iterator();
                                    while (j.hasNext()) {
                                        EPackage ePackage = (EPackage)j.next();
                                        ePackage.setEFactoryInstance((EFactory)new DynamicEDataObjectImpl.FactoryImpl());
                                    }
                                }
                                return result;
                            }
                        };
                    }

                    protected EPackage handleMissingPackage(String uriString) {
                        EPackage result = super.handleMissingPackage(uriString);
                        if (this.processAnyXML && this.objects.size() == 1) {
                            result = this.extendedMetaData.demandPackage(uriString);
                        }
                        return result;
                    }
                };
            }
        }
    }
}

