#! /usr/local/bin/python2.4
# The Python Imaging Library
# $Id: pilfont.py 2134 2004-10-06 08:55:20Z fredrik $
#
# PIL raster font compiler
#
# history:
# 1997-08-25 fl   created
# 2002-03-10 fl   use "from PIL import"
#

VERSION = "0.4"

import site
import glob, os, sys

# drivers
from PIL import BdfFontFile
from PIL import PcfFontFile

if len(sys.argv) <= 1:
    print "PILFONT", VERSION, "-- PIL font compiler."
    print
    print "Usage: pilfont fontfiles..."
    print
    print "Convert given font files to the PIL raster font format."
    print "This version of pilfont supports X BDF and PCF fonts."
    sys.exit(1)

files = []
for f in sys.argv[1:]:
    files = files + glob.glob(f)

for f in files:

    print f + "...",

    try:

        fp = open(f, "rb")

        try:
            p = PcfFontFile.PcfFontFile(fp)
        except SyntaxError:
            fp.seek(0)
            p = BdfFontFile.BdfFontFile(fp)

        p.save(f)

    except (SyntaxError, IOError):
        print "failed"

    else:
        print "OK"
