#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    12/31/2004  - P. Harvey Created
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.04';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::Canon::CameraInfo',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorBalance1',
	'Image::ExifTool::Canon::ColorBalance2',
	'Image::ExifTool::Canon::ColorBalance3',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::ColorInfoD30',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PictureInfo',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::PreviewImage',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'abspeakaudiofilepath' => { 117 => 'absPeakAudioFilePath' },
	'actionadvised' => { 42 => 0x2a },
	'activearea' => { 38 => 0xc68d },
	'addoriginaldecisiondata' => { 20 => 0x11, 21 => 0x13, 23 => 0x14 },
	'address' => { 55 => 'Address' },
	'adjustmentmode' => { 104 => 0x15 },
	'advancedraw' => { 82 => 0x76a43203 },
	'advisory' => { 115 => 'Advisory' },
	'aebbracketvalue' => { 17 => 0x11 },
	'aebsequence' => { 18 => 0x9, 19 => 0x9, 20 => 0x8, 21 => 0x9, 23 => 0x9, 24 => 0x7 },
	'aelock' => { 88 => 0x201 },
	'aesetting' => { 1 => 0x21 },
	'afareas' => { 88 => 0x304 },
	'afassist' => { 18 => 0x5, 24 => 0x5 },
	'afassistbeam' => { 20 => 0x4, 21 => 0x5, 22 => 0x4, 23 => 0x5 },
	'afmode' => { 69 => 0x0, 104 => 0x5 },
	'afpoint' => { 1 => 0x13, 35 => 0x18, 69 => 0x1 },
	'afpointactivationarea' => { 19 => 0x11, 23 => 0x11 },
	'afpointillumination' => { 19 => 0xa },
	'afpointregistration' => { 18 => 0x7 },
	'afpoints' => { 64 => 0x10 },
	'afpointselection' => { 19 => 0xb },
	'afpointselectionmethod' => { 20 => 0xc, 21 => 0xd, 23 => 0xd },
	'afpointspotmetering' => { 19 => 0xd },
	'afpointsused' => { 14 => 0x16, 69 => 0x2 },
	'afpointsused2' => { 17 => 0xe },
	'afpointsused20d' => { 14 => 0x1a },
	'afpointsused5d' => { 0 => 0x38 },
	'afresponse' => { 74 => 0xad },
	'afsearch' => { 88 => 0x303 },
	'aiservotrackingsensitivity' => { 19 => 0x14 },
	'album' => { 117 => 'album' },
	'alttapename' => { 117 => 'altTapeName' },
	'alttimecodetimeformat' => { 117 => 'altTimecodeTimeFormat' },
	'alttimecodetimevalue' => { 117 => 'altTimecodeTimeValue' },
	'analogzoom' => { 48 => 0x1e, 51 => 'AnalogZoom' },
	'antialiasstrength' => { 38 => 0xc632 },
	'aperturevalue' => { 38 => 0x9202, 92 => 0x1002, 110 => 'ApertureValue' },
	'applicationrecordversion' => { 42 => 0x0 },
	'armidentifier' => { 43 => 0x78 },
	'armversion' => { 43 => 0x7a },
	'artist' => { 38 => 0x13b, 94 => 'Artist', 114 => 'Artist', 117 => 'artist' },
	'asshotwhitexy' => { 38 => 0xc629 },
	'assistbuttonfunction' => { 18 => 0xd },
	'audio' => { 95 => 0x20 },
	'audiochanneltype' => { 117 => 'audioChannelType' },
	'audiocompression' => { 50 => 'Compression' },
	'audiocompressor' => { 117 => 'audioCompressor' },
	'audioduration' => { 42 => 0x99 },
	'audiomoddate' => { 117 => 'audioModDate' },
	'audiooutcue' => { 42 => 0x9a },
	'audiosamplerate' => { 117 => 'audioSampleRate' },
	'audiosampletype' => { 117 => 'audioSampleType' },
	'audiosamplingrate' => { 42 => 0x97 },
	'audiosamplingresolution' => { 42 => 0x98 },
	'audiotype' => { 42 => 0x96 },
	'author' => { 52 => 'Author', 94 => 'Author', 100 => 'Author', 112 => 'Author' },
	'authorsposition' => { 113 => 'AuthorsPosition' },
	'autoafpoint' => { 96 => 0xf },
	'autobracket' => { 104 => 0x19 },
	'autobracketing' => { 40 => 0x1100 },
	'autobracketrelease' => { 74 => 0x8a },
	'autobrightness' => { 107 => 'AutoBrightness' },
	'autocontrast' => { 107 => 'AutoContrast' },
	'autoexposure' => { 107 => 'AutoExposure' },
	'autoexposurebracketing' => { 17 => 0x10 },
	'autofocus' => { 90 => 0x209 },
	'autoiso' => { 36 => 0x3008 },
	'autorotate' => { 17 => 0x1b },
	'autoshadows' => { 107 => 'AutoShadows' },
	'auxiliarylens' => { 74 => 0x82 },
	'avvalue' => { 27 => 0x2 },
	'baseiso' => { 31 => 0x101c },
	'baselineexposure' => { 38 => 0xc62a },
	'baselinenoise' => { 38 => 0xc62b },
	'baselinesharpness' => { 38 => 0xc62c },
	'baseurl' => { 115 => 'BaseURL' },
	'bayergreensplit' => { 38 => 0xc62d },
	'bayerpattern' => { 66 => 0x17 },
	'beatspliceparamsriseindecibel' => { 117 => 'beatSpliceParamsRiseInDecibel' },
	'beatspliceparamsriseintimeduration' => { 117 => 'beatSpliceParamsRiseInTimeDuration' },
	'beatspliceparamsusefilebeatsmarker' => { 117 => 'beatSpliceParamsUseFileBeatsMarker' },
	'bestqualityscale' => { 38 => 0xc65c },
	'bestshotmode' => { 36 => 0x3007 },
	'bitdepth' => { 56 => 'BitDepth', 66 => 0x11 },
	'bitspercomponent' => { 44 => 0x87 },
	'bitspersample' => { 38 => 0x102, 114 => 'BitsPerSample' },
	'blacklevel' => { 92 => 0x1012 },
	'blackpoint' => { 96 => 0x200 },
	'bluebalance' => { 51 => 'BlueBalance', 92 => 0x1018, 96 => 0x1b },
	'bluehue' => { 107 => 'BlueHue' },
	'bluesaturation' => { 107 => 'BlueSaturation' },
	'blurwarning' => { 40 => 0x1300 },
	'bodyfirmwareversion' => { 89 => 0x104 },
	'bracketmode' => { 8 => 0x3 },
	'bracketsequence' => { 36 => 0x301d },
	'bracketshotnumber' => { 8 => 0x5 },
	'bracketstep' => { 62 => 0xe },
	'bracketvalue' => { 8 => 0x4 },
	'brightness' => { 38 => 0xfe53, 51 => 'Brightness', 62 => 0x2c, 107 => 'Brightness' },
	'brightnessadj' => { 77 => 0x0 },
	'brightnessvalue' => { 38 => 0x9203, 92 => 0x1003, 110 => 'BrightnessValue' },
	'bulbduration' => { 17 => 0x18 },
	'burstmode' => { 46 => 0xa, 95 => 0x2a },
	'burstmode2' => { 46 => 0x18 },
	'bwfilter' => { 62 => 0x2a, 67 => 0x39 },
	'bwmode' => { 92 => 0x203 },
	'by-line' => { 42 => 0x50 },
	'by-linetitle' => { 42 => 0x55 },
	'calibrationilluminant1' => { 38 => 0xc65a },
	'calibrationilluminant2' => { 38 => 0xc65b },
	'cameraid' => { 92 => 0x209, 103 => 0x209 },
	'cameraiso' => { 1 => 0x10 },
	'cameraprofile' => { 107 => 'CameraProfile' },
	'cameraserialnumber' => { 38 => 0xc62f },
	'camerasettingsversion' => { 88 => 0x0 },
	'cameratype' => { 17 => 0x1a, 92 => 0x207 },
	'cameratype2' => { 89 => 0x100 },
	'canonexposuremode' => { 1 => 0x14 },
	'canonfiledescription' => { 31 => 0x805 },
	'canonfilelength' => { 11 => 0xe },
	'canonfirmwareversion' => { 11 => 0x7, 31 => 0x80b },
	'canonflashinfo' => { 31 => 0x1028 },
	'canonflashmode' => { 1 => 0x4 },
	'canonimageheight' => { 14 => 0x3 },
	'canonimageheightasshot' => { 14 => 0x5 },
	'canonimagesize' => { 1 => 0xa },
	'canonimagetype' => { 11 => 0x6, 31 => 0x815 },
	'canonimagewidth' => { 14 => 0x2 },
	'canonimagewidthasshot' => { 14 => 0x4 },
	'canonmodelid' => { 11 => 0x10 },
	'caption-abstract' => { 42 => 0x78 },
	'captionwriter' => { 113 => 'CaptionWriter' },
	'casioimagesize' => { 36 => 0x9 },
	'category' => { 42 => 0xf, 113 => 'Category' },
	'ccdisosensitivity' => { 36 => 0x3014 },
	'ccdscanmode' => { 92 => 0x1039 },
	'ccdsensitivity' => { 35 => 0x14, 76 => 0x6 },
	'celllength' => { 38 => 0x109 },
	'cellwidth' => { 38 => 0x108 },
	'certificate' => { 120 => 'Certificate' },
	'cfapattern' => { 38 => 0xa302 },
	'cfapatterncolumns' => { 110 => 'CFAPatternColumns' },
	'cfapatternrows' => { 110 => 'CFAPatternRows' },
	'cfapatternvalues' => { 110 => 'CFAPatternValues' },
	'channels' => { 50 => 'Channels' },
	'chromablurradius' => { 38 => 0xc631 },
	'chromaticaberrationb' => { 107 => 'ChromaticAberrationB' },
	'chromaticaberrationr' => { 107 => 'ChromaticAberrationR' },
	'city' => { 42 => 0x5a, 55 => 'City', 113 => 'City' },
	'classifystate' => { 42 => 0xe1 },
	'codec' => { 61 => 'Codec' },
	'codedcharacterset' => { 43 => 0x5a },
	'coloraberrationcontrol' => { 82 => 0xc89224b },
	'coloradjustment' => { 104 => 0x14 },
	'coloradjustmentmode' => { 103 => 0x210 },
	'colorantsa' => { 121 => 'ColorantsA' },
	'colorantsb' => { 121 => 'ColorantsB' },
	'colorantsblack' => { 121 => 'ColorantsBlack' },
	'colorantsblue' => { 121 => 'ColorantsBlue' },
	'colorantscyan' => { 121 => 'ColorantsCyan' },
	'colorantsgreen' => { 121 => 'ColorantsGreen' },
	'colorantsl' => { 121 => 'ColorantsL' },
	'colorantsmagenta' => { 121 => 'ColorantsMagenta' },
	'colorantsmode' => { 121 => 'ColorantsMode' },
	'colorantsred' => { 121 => 'ColorantsRed' },
	'colorantsswatchname' => { 121 => 'ColorantsSwatchName' },
	'colorantstype' => { 121 => 'ColorantsType' },
	'colorantsyellow' => { 121 => 'ColorantsYellow' },
	'colorbalance1' => { 74 => 0xc },
	'colorbalanceadj' => { 82 => 0x76a43202 },
	'colorbalanceblue' => { 62 => 0x1e },
	'colorbalancegreen' => { 62 => 0x1d },
	'colorbalancered' => { 62 => 0x1c },
	'colorbooster' => { 82 => 0x5f0e7d23 },
	'colorboostlevel' => { 78 => 0x1 },
	'colorboosttype' => { 78 => 0x0 },
	'colorcontrol' => { 92 => 0x102b },
	'coloreffect' => { 95 => 0x28 },
	'colorfilter' => { 62 => 0x29, 67 => 0x38 },
	'colorhue' => { 6 => 0x2, 74 => 0x8d },
	'colormatrix' => { 7 => 0xa, 91 => 0x200, 92 => 0x1011 },
	'colormode' => { 36 => 0x3015, 40 => 0x1210, 46 => 0x66, 62 => 0x28, 65 => 0x101, 67 => 0x7, 74 => 0x3, 76 => 0x4, 92 => 0x101, 95 => 0x32 },
	'colormoirereduction' => { 83 => 0x5 },
	'colornoisereduction' => { 107 => 'ColorNoiseReduction' },
	'colorprofile' => { 62 => 0x33 },
	'colorrepresentation' => { 44 => 0x3c },
	'colorsequence' => { 44 => 0x41 },
	'colorspace' => { 6 => 0x3, 11 => 0xb4, 31 => 0x10b4, 38 => 0xa001, 56 => 'ColorSpace', 64 => 0x25, 74 => 0x1e, 88 => 0x507, 96 => 0x37, 104 => 0xb, 110 => 'ColorSpace' },
	'colortempasshot' => { 3 => 0x1d, 4 => 0x1c, 5 => 0x43 },
	'colortempauto' => { 3 => 0x22, 4 => 0x26, 5 => 0x48 },
	'colortempcloudy' => { 3 => 0x31, 4 => 0x35, 5 => 0x5c },
	'colortempcustom' => { 5 => 0x84 },
	'colortempcustom1' => { 3 => 0x45 },
	'colortempcustom2' => { 3 => 0x4a },
	'colortempdaylight' => { 3 => 0x27, 4 => 0x2b, 5 => 0x52 },
	'colortemperature' => { 7 => 0x9, 11 => 0xae, 16 => 0x9, 31 => 0x10ae, 51 => 'ColorTemperature', 63 => [0x6e,0x49], 64 => 0x3f, 65 => 0x10b, 67 => 0x3c },
	'colortempflash' => { 3 => 0x40, 4 => 0x49, 5 => 0x70 },
	'colortempfluorescent' => { 3 => 0x3b, 4 => 0x3f, 5 => 0x66 },
	'colortempkelvin' => { 4 => 0x44, 5 => 0x6b },
	'colortempmeasured' => { 5 => 0x4d },
	'colortemppc1' => { 4 => 0x94, 5 => 0x75 },
	'colortemppc2' => { 4 => 0x99, 5 => 0x7a },
	'colortemppc3' => { 4 => 0x9e, 5 => 0x7f },
	'colortempshade' => { 3 => 0x2c, 4 => 0x30, 5 => 0x57 },
	'colortemptungsten' => { 3 => 0x36, 4 => 0x3a, 5 => 0x61 },
	'colortempunknown' => { 4 => 0x21 },
	'colortempunknown10' => { 4 => 0x76 },
	'colortempunknown11' => { 4 => 0x7b },
	'colortempunknown12' => { 4 => 0x80 },
	'colortempunknown13' => { 4 => 0x85 },
	'colortempunknown14' => { 4 => 0x8a },
	'colortempunknown15' => { 4 => 0x8f },
	'colortempunknown16' => { 4 => 0xa3 },
	'colortempunknown2' => { 4 => 0x4e },
	'colortempunknown3' => { 4 => 0x53 },
	'colortempunknown4' => { 4 => 0x58 },
	'colortempunknown5' => { 4 => 0x5d },
	'colortempunknown6' => { 4 => 0x62 },
	'colortempunknown7' => { 4 => 0x67 },
	'colortempunknown8' => { 4 => 0x6c },
	'colortempunknown9' => { 4 => 0x71 },
	'colortone' => { 1 => 0x2a },
	'colortonefaithful' => { 0 => 0x107 },
	'colortonelandscape' => { 0 => 0x105 },
	'colortoneneutral' => { 0 => 0x106 },
	'colortoneportrait' => { 0 => 0x104 },
	'colortonestandard' => { 0 => 0x103 },
	'colortoneuserdef1' => { 0 => 0x109 },
	'colortoneuserdef2' => { 0 => 0x10a },
	'colortoneuserdef3' => { 0 => 0x10b },
	'comment' => { 39 => 'Comment', 52 => 'Comment', 94 => 'Comment' },
	'componentsconfiguration' => { 38 => 0x9101, 56 => 'Components', 110 => 'ComponentsConfiguration' },
	'componentversion' => { 31 => 0x80c },
	'composer' => { 117 => 'composer' },
	'compressedbitsperpixel' => { 38 => 0x9102, 110 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 65 => 0x40, 92 => 0x40 },
	'compression' => { 38 => 0x103, 114 => 'Compression' },
	'compressionfactor' => { 88 => 0x50d },
	'compressionratio' => { 56 => 'Compression', 92 => 0x1034 },
	'contact' => { 42 => 0x76 },
	'contentlocationcode' => { 42 => 0x1a },
	'contentlocationname' => { 42 => 0x1b },
	'continuousdrive' => { 1 => 0x5 },
	'contrast' => { 1 => 0xd, 35 => 0xc, 36 => [0x3012,0x20], 38 => [0xa408,0xfe54], 40 => 0x1004, 51 => 'Contrast', 62 => 0x20, 63 => 0x31, 64 => 0x27, 67 => 0x2, 92 => 0x1029, 95 => 0x2c, 96 => 0x20, 104 => 0xd, 107 => 'Contrast', 110 => 'Contrast' },
	'contrastfaithful' => { 0 => 0xec },
	'contrastlandscape' => { 0 => 0xea },
	'contrastmonochrome' => { 0 => 0xed },
	'contrastneutral' => { 0 => 0xeb },
	'contrastportrait' => { 0 => 0xe9 },
	'contrastsetting' => { 88 => 0x505 },
	'contraststandard' => { 0 => 0xe8 },
	'contrastuserdef1' => { 0 => 0xee },
	'contrastuserdef2' => { 0 => 0xef },
	'contrastuserdef3' => { 0 => 0xf0 },
	'contributedmediaduration' => { 117 => 'contributedMediaDuration' },
	'contributedmediamanaged' => { 117 => 'contributedMediaManaged' },
	'contributedmediapath' => { 117 => 'contributedMediaPath' },
	'contributedmediastarttime' => { 117 => 'contributedMediaStartTime' },
	'contributedmediatrack' => { 117 => 'contributedMediaTrack' },
	'contributedmediawebstatement' => { 117 => 'contributedMediaWebStatement' },
	'contributor' => { 108 => 'contributor' },
	'contributors' => { 52 => 'Contributors' },
	'converter' => { 38 => 0xfe4d, 76 => 0xb },
	'copyright' => { 38 => 0x8298, 52 => 'Copyright', 94 => 'Copyright', 100 => 'Copyright', 114 => 'Copyright', 117 => 'copyright' },
	'copyrightflag' => { 98 => 0x40a },
	'copyrightnotice' => { 42 => 0x74 },
	'coringfilter' => { 92 => 0x102d },
	'country' => { 55 => 'Country', 113 => 'Country' },
	'country-primarylocationcode' => { 42 => 0x64 },
	'country-primarylocationname' => { 42 => 0x65 },
	'countrycode' => { 111 => 'CountryCode' },
	'coverage' => { 108 => 'coverage' },
	'crc32' => { 109 => 'crc32' },
	'createdate' => { 38 => 0x9004, 52 => 'CreateDate', 100 => 'CreationDate', 115 => 'CreateDate' },
	'creationdate' => { 112 => 'CreationDate' },
	'creationtime' => { 94 => 'Creation Time' },
	'creator' => { 100 => 'Creator', 108 => 'creator', 112 => 'Creator' },
	'creatorcontactinfociadrcity' => { 111 => 'CreatorContactInfoCiAdrCity' },
	'creatorcontactinfociadrctry' => { 111 => 'CreatorContactInfoCiAdrCtry' },
	'creatorcontactinfociadrextadr' => { 111 => 'CreatorContactInfoCiAdrExtadr' },
	'creatorcontactinfociadrpcode' => { 111 => 'CreatorContactInfoCiAdrPcode' },
	'creatorcontactinfociadrregion' => { 111 => 'CreatorContactInfoCiAdrRegion' },
	'creatorcontactinfociemailwork' => { 111 => 'CreatorContactInfoCiEmailWork' },
	'creatorcontactinfocitelwork' => { 111 => 'CreatorContactInfoCiTelWork' },
	'creatorcontactinfociurlwork' => { 111 => 'CreatorContactInfoCiUrlWork' },
	'creatortool' => { 115 => 'CreatorTool' },
	'credit' => { 42 => 0x6e, 113 => 'Credit' },
	'creditlinereq' => { 119 => 'CreditLineReq' },
	'cropangle' => { 107 => 'CropAngle' },
	'cropbottom' => { 79 => 0x36, 107 => 'CropBottom' },
	'cropheight' => { 107 => 'CropHeight' },
	'crophispeed' => { 74 => 0x1b },
	'cropleft' => { 79 => 0x1e, 107 => 'CropLeft' },
	'cropoutputscale' => { 79 => 0xbe },
	'cropright' => { 79 => 0x2e, 107 => 'CropRight' },
	'croptop' => { 79 => 0x26, 107 => 'CropTop' },
	'cropunits' => { 107 => 'CropUnits' },
	'cropwidth' => { 107 => 'CropWidth' },
	'curves' => { 82 => 0x76a43201 },
	'customrendered' => { 38 => 0xa401, 110 => 'CustomRendered' },
	'customsaturation' => { 88 => 0x503 },
	'd-lightinghq' => { 82 => 0x2175eb78 },
	'd-lightinghqselected' => { 82 => 0x6a6e36b6 },
	'd-lightinghs' => { 82 => 0xce5554aa },
	'd-lightinghsadjustment' => { 81 => 0x0 },
	'd-lightinghscolorboost' => { 80 => 0x2, 81 => 0x1 },
	'd-lightinghshighlight' => { 80 => 0x1 },
	'd-lightinghsshadow' => { 80 => 0x0 },
	'datacompressionmethod' => { 44 => 0x6e },
	'dataimprint' => { 62 => 0x34 },
	'date' => { 96 => 0x6, 108 => 'date' },
	'datecreated' => { 42 => 0x37, 113 => 'DateCreated' },
	'datesent' => { 43 => 0x46 },
	'datetime' => { 114 => 'DateTime' },
	'datetimedigitized' => { 110 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 34 => 0x0, 38 => 0x9003, 52 => 'OriginalDate', 110 => 'DateTimeOriginal' },
	'datetimestamp' => { 46 => 0x64 },
	'decposition' => { 62 => 0x32 },
	'defaultcroporigin' => { 38 => 0xc61f },
	'defaultcropsize' => { 38 => 0xc620 },
	'defaultscale' => { 38 => 0xc61e },
	'deletedimagecount' => { 74 => 0xa6 },
	'derivedfromdocumentid' => { 118 => 'DerivedFromDocumentID' },
	'derivedfrominstanceid' => { 118 => 'DerivedFromInstanceID' },
	'derivedfrommanager' => { 118 => 'DerivedFromManager' },
	'derivedfrommanagervariant' => { 118 => 'DerivedFromManagerVariant' },
	'derivedfrommanageto' => { 118 => 'DerivedFromManageTo' },
	'derivedfrommanageui' => { 118 => 'DerivedFromManageUI' },
	'derivedfromrenditionclass' => { 118 => 'DerivedFromRenditionClass' },
	'derivedfromrenditionparams' => { 118 => 'DerivedFromRenditionParams' },
	'derivedfromversionid' => { 118 => 'DerivedFromVersionID' },
	'description' => { 94 => 'Description', 108 => 'description' },
	'destination' => { 43 => 0x5 },
	'destinationcity' => { 96 => 0x24 },
	'destinationcitycode' => { 96 => 0x1001 },
	'destinationdst' => { 96 => 0x26 },
	'developmentdynamicrange' => { 40 => 0x1403 },
	'devicesettingdescriptioncolumns' => { 110 => 'DeviceSettingDescriptionColumns' },
	'devicesettingdescriptionrows' => { 110 => 'DeviceSettingDescriptionRows' },
	'devicesettingdescriptionsettings' => { 110 => 'DeviceSettingDescriptionSettings' },
	'digitalcreationdate' => { 42 => 0x3e },
	'digitalcreationtime' => { 42 => 0x3f },
	'digitalgain' => { 16 => 0xb },
	'digitalzoom' => { 1 => 0xc, 35 => 0xa, 46 => 0x68, 51 => 'DigitalZoom', 62 => 0xc, 74 => 0x86, 76 => 0xa, 92 => 0x204, 96 => 0x1e, 103 => 0x204 },
	'digitalzoomon' => { 103 => 0x21b },
	'digitalzoomratio' => { 38 => 0xa404, 110 => 'DigitalZoomRatio' },
	'directory' => { 39 => 'Directory' },
	'disclaimer' => { 94 => 'Disclaimer' },
	'displayaperture' => { 1 => 0x23 },
	'displayedunitsx' => { 99 => 0x2 },
	'displayedunitsy' => { 99 => 0x6 },
	'distance1' => { 46 => 0x28 },
	'distance2' => { 46 => 0x2c },
	'distance3' => { 46 => 0x30 },
	'distance4' => { 46 => 0x34 },
	'distortioncorrection' => { 88 => 0x50b },
	'distortioncorrection2' => { 91 => 0x1011 },
	'dngbackwardversion' => { 38 => 0xc613 },
	'dnglensinfo' => { 38 => 0xc630 },
	'dngversion' => { 38 => 0xc612 },
	'document' => { 94 => 'Document' },
	'documenthistory' => { 42 => 0xe7 },
	'documentid' => { 118 => 'DocumentID' },
	'documentname' => { 38 => 0x10d },
	'documentnotes' => { 42 => 0xe6 },
	'dotrange' => { 38 => 0x150 },
	'drivemode' => { 62 => 0x6, 104 => 0x3 },
	'duration' => { 50 => 'Duration', 61 => 'Duration', 117 => 'duration' },
	'dynamicrange' => { 40 => 0x1400 },
	'dynamicrangesetting' => { 40 => 0x1402 },
	'easymode' => { 1 => 0xb },
	'edgenoisereduction' => { 83 => 0x4 },
	'editorialupdate' => { 42 => 0x8 },
	'editstatus' => { 42 => 0x7 },
	'elevation' => { 55 => 'Elevation' },
	'engineer' => { 117 => 'engineer' },
	'enhancedarktones' => { 77 => 0x8 },
	'enhancement' => { 35 => 0x16, 36 => 0x3016 },
	'envelopenumber' => { 43 => 0x28 },
	'envelopepriority' => { 43 => 0x3c },
	'enveloperecordversion' => { 43 => 0x0 },
	'epsonimageheight' => { 92 => 0x20c },
	'epsonimagewidth' => { 92 => 0x20b },
	'epsonsoftware' => { 92 => 0x20d },
	'equipmentversion' => { 89 => 0x0 },
	'ettlii' => { 20 => 0xd, 21 => 0xe, 22 => 0x7, 23 => 0xe },
	'excursiontolerance' => { 44 => 0x82 },
	'exifcamerainfo' => { 42 => 0xe8 },
	'exifimageheight' => { 110 => 'PixelYDimension' },
	'exifimagelength' => { 38 => 0xa003 },
	'exifimagewidth' => { 38 => 0xa002, 110 => 'PixelXDimension' },
	'exifversion' => { 38 => 0x9000, 110 => 'ExifVersion' },
	'expirationdate' => { 42 => 0x25 },
	'expirationtime' => { 42 => 0x26 },
	'exposure' => { 38 => 0xfe51, 107 => 'Exposure' },
	'exposurebracketvalue' => { 74 => 0x19 },
	'exposurecompensation' => { 17 => 0x6, 27 => 0x0, 38 => 0x9204, 46 => 0x24, 51 => 'ExposureComp', 62 => 0xd, 63 => 0x53, 64 => 0x1e, 92 => 0x1006, 96 => 0x16, 104 => 0xc, 110 => 'ExposureBiasValue' },
	'exposuredifference' => { 74 => 0xe },
	'exposureindex' => { 38 => 0xa215, 110 => 'ExposureIndex' },
	'exposurelevelincrements' => { 18 => 0x6, 19 => 0x6, 20 => 0x5, 21 => 0x6, 22 => 0x5, 23 => 0x6, 24 => 0x4 },
	'exposuremode' => { 38 => 0xa402, 51 => 'ExposureMode', 62 => 0x1, 63 => 0xa, 64 => 0x0, 88 => 0x200, 104 => 0x8, 110 => 'ExposureMode' },
	'exposureprogram' => { 38 => 0x8822, 110 => 'ExposureProgram' },
	'exposuretime' => { 0 => 0x4, 17 => 0x16, 38 => 0x829a, 46 => 0x20, 48 => 0x38, 51 => 'ExposureTime', 62 => 0x9, 63 => 0x35, 64 => 0x48, 96 => 0x12, 110 => 'ExposureTime' },
	'exposurewarning' => { 40 => 0x1302 },
	'extender' => { 89 => 0x301 },
	'extenderfirmwareversion' => { 89 => 0x304 },
	'extendermake' => { 53 => 'Make' },
	'extendermodel' => { 53 => 'Model', 89 => 0x303 },
	'extenderserialnumber' => { 53 => 'SerialNumber', 89 => 0x302 },
	'externalflash' => { 90 => 0x1201 },
	'externalflashbounce' => { 92 => 0x1026 },
	'externalflashmode' => { 92 => 0x1028 },
	'externalflashzoom' => { 92 => 0x1027 },
	'ffid' => { 109 => 'ffid' },
	'filedatarate' => { 117 => 'fileDataRate' },
	'fileformat' => { 29 => 0x0, 43 => 0x14 },
	'filemodifydate' => { 39 => 'FileModifyDate' },
	'filename' => { 39 => 'FileName' },
	'filenumber' => { 8 => 0x1, 11 => 0x8, 31 => 0x1817 },
	'filenumbermemory' => { 62 => 0x1a },
	'filesource' => { 38 => 0xa300, 40 => 0x8000, 110 => 'FileSource' },
	'fileversion' => { 43 => 0x16 },
	'fillflashautoreduction' => { 18 => 0xe, 19 => 0xe, 24 => 0xa },
	'fillorder' => { 38 => 0x10a },
	'filmmode' => { 40 => 0x1401 },
	'filter' => { 35 => 0x17, 36 => 0x3017 },
	'filtereffect' => { 8 => 0xe },
	'filtereffectmonochrome' => { 0 => 0xff },
	'finderdisplayduringexposure' => { 19 => 0x1 },
	'firmware' => { 104 => 0x17, 105 => 'Firmware' },
	'firmwareid' => { 66 => 0x0 },
	'firmwarerevision' => { 0 => 0xa4 },
	'firmwareversion' => { 51 => 'FirmwareVersion', 74 => 0x1, 95 => 0x2 },
	'fixtureidentifier' => { 42 => 0x16 },
	'flash' => { 38 => 0x9209, 63 => 0x1f, 64 => 0x15 },
	'flashactivity' => { 1 => 0x1c },
	'flashbias' => { 95 => 0x24 },
	'flashbits' => { 1 => 0x1d },
	'flashchargelevel' => { 92 => 0x1010 },
	'flashcompensation' => { 105 => 'FlashCompensation' },
	'flashdevice' => { 92 => 0x1005 },
	'flashdistance' => { 36 => 0x2034 },
	'flashenergy' => { 38 => 0xa20b, 110 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 74 => 0x18 },
	'flashexposurecomp' => { 17 => 0xf, 54 => 'ExposureComp', 62 => 0x23, 74 => 0x12, 92 => 0x1023 },
	'flashexposurecompensation' => { 88 => 0x401 },
	'flashfired' => { 46 => 0x5d, 54 => 'Fired', 62 => 0x14, 110 => 'FlashFired' },
	'flashfiring' => { 20 => 0x6, 21 => 0x7, 23 => 0x7 },
	'flashfirmwareversion' => { 89 => 0x1002 },
	'flashfunction' => { 110 => 'FlashFunction' },
	'flashguidenumber' => { 17 => 0xd, 28 => 0x0, 54 => 'GuideNumber' },
	'flashintensity' => { 35 => [0x19,0x5] },
	'flashmake' => { 54 => 'Make' },
	'flashmetering' => { 62 => 0x3f },
	'flashmode' => { 35 => 0x4, 46 => 0x5c, 54 => 'Mode', 62 => 0x2, 74 => 0x87, 88 => 0x400, 92 => 0x1004, 96 => 0xc, 101 => 0x20, 103 => 0x225, 110 => 'FlashMode' },
	'flashmodel' => { 54 => 'Model', 89 => 0x1001 },
	'flashpixversion' => { 38 => 0xa000, 110 => 'FlashpixVersion' },
	'flashredeyemode' => { 110 => 'FlashRedEyeMode' },
	'flashreturn' => { 110 => 'FlashReturn' },
	'flashserialnumber' => { 54 => 'SerialNumber', 89 => 0x1003 },
	'flashsetting' => { 74 => 0x8 },
	'flashstrength' => { 40 => 0x1011 },
	'flashsyncspeedav' => { 18 => 0x3, 20 => 0x2, 21 => 0x3, 22 => 0x2, 23 => 0x3, 24 => 0x6 },
	'flashthreshold' => { 28 => 0x1 },
	'flashtype' => { 54 => 'Type', 74 => 0x9, 89 => 0x1000 },
	'flickerreduce' => { 103 => 0x218 },
	'fliphorizontal' => { 82 => 0x76a43206 },
	'fnumber' => { 17 => 0x15, 38 => 0x829d, 46 => 0x1e, 48 => 0x3c, 51 => 'FNumber', 62 => 0xa, 63 => 0x36, 64 => 0x47, 96 => 0x13, 110 => 'FNumber' },
	'focallength' => { 0 => 0xa, 10 => 0x1, 36 => 0x1d, 38 => 0x920a, 51 => 'FocalLength', 62 => 0x12, 96 => 0x1d, 110 => 'FocalLength' },
	'focallengthin35mmformat' => { 38 => 0xa405, 110 => 'FocalLengthIn35mmFilm' },
	'focalplanediagonal' => { 89 => 0x103, 92 => 0x205 },
	'focalplaneresolutionunit' => { 38 => 0xa210, 110 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 38 => 0xa20e, 110 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 10 => 0x2 },
	'focalplaneyresolution' => { 38 => 0xa20f, 110 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 10 => 0x3 },
	'focaltype' => { 0 => 0x2d, 10 => 0x0 },
	'focalunits' => { 1 => 0x19 },
	'focus' => { 76 => 0x8 },
	'focusarea' => { 62 => 0x31 },
	'focuscontinuous' => { 1 => 0x20 },
	'focusdistance' => { 51 => 'FocusDistance', 62 => 0x13, 90 => 0x305 },
	'focusdistancelower' => { 17 => 0x14 },
	'focusdistanceupper' => { 17 => 0x13 },
	'focusinfoversion' => { 90 => 0x0 },
	'focusingscreen' => { 19 => 0x0, 23 => 0x0 },
	'focusmode' => { 1 => 0x7, 35 => 0x3, 36 => [0x3003,0xd], 40 => 0x1021, 46 => 0x38, 51 => 'FocusMode', 62 => 0x30, 64 => 0xe, 74 => 0x7, 88 => 0x301, 92 => 0x100b, 95 => 0x7, 96 => 0xd },
	'focuspixel' => { 40 => 0x1023 },
	'focusposition' => { 96 => 0x10 },
	'focusprocess' => { 88 => 0x302 },
	'focusrange' => { 1 => 0x12 },
	'focussetting' => { 104 => 0x6 },
	'focusstepcount' => { 92 => 0x100e },
	'focuswarning' => { 40 => 0x1301 },
	'foldername' => { 62 => 0x27 },
	'fontschildfontfiles' => { 121 => 'FontsChildFontFiles' },
	'fontscomposite' => { 121 => 'FontsComposite' },
	'fontsfontface' => { 121 => 'FontsFontFace' },
	'fontsfontfamily' => { 121 => 'FontsFontFamily' },
	'fontsfontfilename' => { 121 => 'FontsFontFileName' },
	'fontsfontname' => { 121 => 'FontsFontName' },
	'fontsfonttype' => { 121 => 'FontsFontType' },
	'fontsversionstring' => { 121 => 'FontsVersionString' },
	'for' => { 100 => 'For' },
	'format' => { 108 => 'format' },
	'framenumber' => { 40 => 0x8003, 96 => 0x29 },
	'freebytes' => { 31 => 0x1 },
	'freememorycardimages' => { 63 => [0x37,0x54], 64 => [0x2d,0x4a] },
	'fujiflashmode' => { 40 => 0x1010 },
	'fullsizeimage' => { 56 => 'data' },
	'fullsizeimagename' => { 56 => '1Name' },
	'fullsizeimagetype' => { 56 => '0Type' },
	'gaincontrol' => { 38 => 0xa407, 110 => 'GainControl' },
	'gamma' => { 38 => 0xa500 },
	'gammacompensatedvalue' => { 44 => 0x91 },
	'genre' => { 117 => 'genre' },
	'globalaltitude' => { 98 => 0x419 },
	'globalangle' => { 98 => 0x40d },
	'gpsaltitude' => { 41 => 0x6, 110 => 'GPSAltitude' },
	'gpsaltituderef' => { 41 => 0x5, 110 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 41 => 0x1c, 110 => 'GPSAreaInformation' },
	'gpsdatestamp' => { 41 => 0x1d },
	'gpsdestbearing' => { 41 => 0x18, 110 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 41 => 0x17, 110 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 41 => 0x1a, 110 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 41 => 0x19, 110 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 41 => 0x14, 110 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 41 => 0x13 },
	'gpsdestlongitude' => { 41 => 0x16, 110 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 41 => 0x15 },
	'gpsdifferential' => { 41 => 0x1e, 110 => 'GPSDifferential' },
	'gpsdop' => { 41 => 0xb, 110 => 'GPSDOP' },
	'gpsimgdirection' => { 41 => 0x11, 110 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 41 => 0x10, 110 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 41 => 0x2, 110 => 'GPSLatitude' },
	'gpslatituderef' => { 41 => 0x1 },
	'gpslongitude' => { 41 => 0x4, 110 => 'GPSLongitude' },
	'gpslongituderef' => { 41 => 0x3 },
	'gpsmapdatum' => { 41 => 0x12, 110 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 41 => 0xa, 110 => 'GPSMeasureMode' },
	'gpsprocessingmethod' => { 41 => 0x1b, 110 => 'GPSProcessingMethod' },
	'gpssatellites' => { 41 => 0x8, 110 => 'GPSSatellites' },
	'gpsspeed' => { 41 => 0xd, 110 => 'GPSSpeed' },
	'gpsspeedref' => { 41 => 0xc, 110 => 'GPSSpeedRef' },
	'gpsstatus' => { 41 => 0x9, 110 => 'GPSStatus' },
	'gpstimestamp' => { 41 => 0x7, 110 => 'GPSTimeStamp' },
	'gpstrack' => { 41 => 0xf, 110 => 'GPSTrack' },
	'gpstrackref' => { 41 => 0xe, 110 => 'GPSTrackRef' },
	'gpsversionid' => { 41 => 0x0, 110 => 'GPSVersionID' },
	'gradation' => { 88 => 0x50f },
	'grayresponseunit' => { 38 => 0x122 },
	'greenhue' => { 107 => 'GreenHue' },
	'greensaturation' => { 107 => 'GreenSaturation' },
	'halftonehints' => { 38 => 0x141 },
	'hascrop' => { 107 => 'HasCrop' },
	'hassettings' => { 107 => 'HasSettings' },
	'headline' => { 42 => 0x69, 113 => 'Headline' },
	'highisonoisereduction' => { 74 => 0xb1 },
	'highlight' => { 104 => 0xf },
	'historyaction' => { 118 => 'HistoryAction' },
	'historyinstanceid' => { 118 => 'HistoryInstanceID' },
	'historyparameters' => { 118 => 'HistoryParameters' },
	'historysoftwareagent' => { 118 => 'HistorySoftwareAgent' },
	'historywhen' => { 118 => 'HistoryWhen' },
	'hometowncity' => { 96 => 0x23 },
	'hometowncitycode' => { 96 => 0x1000 },
	'hometowndst' => { 96 => 0x25 },
	'hostcomputer' => { 38 => 0x13c },
	'hue' => { 67 => 0x3b },
	'hueadjustment' => { 74 => 0x92 },
	'icc_profile' => { 39 => 'ICC_Profile' },
	'identifier' => { 108 => 'identifier', 115 => 'Identifier' },
	'imageadjustment' => { 74 => 0x80, 76 => 0x5 },
	'imageboundary' => { 74 => 0x16 },
	'imagecount' => { 74 => 0xa5 },
	'imagedatasize' => { 74 => 0xa2 },
	'imagedescription' => { 38 => 0x10e, 114 => 'ImageDescription' },
	'imagedustoff' => { 82 => 0xfe443a45 },
	'imageheight' => { 38 => 0x101, 66 => 0xc, 114 => 'ImageLength' },
	'imagenumber' => { 0 => 0xd0, 51 => 'ImageNumber', 63 => 0xae, 64 => 0x5e, 105 => 'ImageNumber' },
	'imagenumber2' => { 64 => 0x62 },
	'imageoptimization' => { 74 => 0xa9 },
	'imageorientation' => { 42 => 0x83 },
	'imageprocessing' => { 74 => 0x1a },
	'imageprocessingversion' => { 91 => 0x0 },
	'imagequality' => { 51 => 'ImageQuality', 95 => 0x1 },
	'imagequality2' => { 88 => 0x603 },
	'imagesize' => { 56 => 'ImageSize' },
	'imagestabilization' => { 1 => 0x22, 36 => 0x3020, 51 => 'ImageStabilization', 63 => 0xbd, 64 => 0x71, 65 => [0x18,0x107], 74 => 0xac },
	'imagestabilizer' => { 95 => 0x1a },
	'imagetype' => { 42 => 0x82 },
	'imageuniqueid' => { 38 => 0xa420, 110 => 'ImageUniqueID' },
	'imagewidth' => { 38 => 0x100, 66 => 0xe, 114 => 'ImageWidth' },
	'infinitylensstep' => { 92 => 0x103b },
	'inkset' => { 38 => 0x14c },
	'instructions' => { 113 => 'Instructions' },
	'instrument' => { 117 => 'instrument' },
	'intellectualgenre' => { 111 => 'IntellectualGenre' },
	'interchangecolorspace' => { 44 => 0x40 },
	'internalflash' => { 62 => 0x2b, 90 => 0x1208 },
	'internalserialnumber' => { 89 => 0x102, 95 => 0x25 },
	'interopindex' => { 38 => 0x1 },
	'interopversion' => { 38 => 0x2 },
	'intervallength' => { 62 => 0x10 },
	'intervalmode' => { 62 => 0x26 },
	'intervalnumber' => { 62 => 0x11 },
	'introtime' => { 117 => 'introTime' },
	'iptc-naa' => { 38 => 0x83bb },
	'iptcbitspersample' => { 44 => 0x56 },
	'iptcimageheight' => { 44 => 0x1e },
	'iptcimagerotation' => { 44 => 0x66 },
	'iptcimagewidth' => { 44 => 0x14 },
	'iptcpicturenumber' => { 44 => 0xa },
	'iptcpixelheight' => { 44 => 0x32 },
	'iptcpixelwidth' => { 44 => 0x28 },
	'iso' => { 17 => 0x2, 36 => 0x14, 38 => 0x8827, 46 => 0x60, 48 => 0x4e, 51 => 'ISO', 62 => 0x8, 74 => 0x2, 96 => 0x14, 110 => 'ISOSpeedRatings' },
	'isoexpansion' => { 20 => 0x7, 21 => 0x8, 23 => 0x8 },
	'isoselection' => { 74 => 0xf },
	'isosetting' => { 46 => 0x5e, 51 => 'ISOSetting', 62 => 0x24, 63 => 0x26, 64 => 0x1c, 67 => 0x6, 74 => 0x13, 101 => 0x27 },
	'isospeedexpansion' => { 19 => 0x3 },
	'isovalue' => { 92 => 0x1001 },
	'jobid' => { 42 => 0xb8 },
	'jobrefid' => { 116 => 'JobRefId' },
	'jobrefname' => { 116 => 'JobRefName' },
	'jobrefurl' => { 116 => 'JobRefUrl' },
	'jpgfromraw' => { 31 => 0x2007, 37 => 'JpgFromRaw' },
	'jpgfromrawlength' => { 38 => [0x117,0x202] },
	'jpgfromrawstart' => { 38 => [0x111,0x201] },
	'key' => { 117 => 'key' },
	'keywords' => { 42 => 0x19, 52 => 'Keywords', 100 => 'Keywords', 112 => 'Keywords' },
	'kodakimageheight' => { 46 => 0xe, 47 => 0x70 },
	'kodakimagewidth' => { 46 => 0xc, 47 => 0x6c },
	'kodakmaker' => { 47 => 0x8 },
	'kodakmodel' => { 46 => 0x0, 47 => 0x28 },
	'label' => { 94 => 'Label', 115 => 'Label' },
	'language' => { 108 => 'language' },
	'languageidentifier' => { 42 => 0x87 },
	'lastfilenumber' => { 62 => 0x1b },
	'lasturl' => { 118 => 'LastURL' },
	'latitude' => { 55 => 'Latitude' },
	'lcddisplayreturntoshoot' => { 23 => 0x12 },
	'lcdpanels' => { 19 => 0x8 },
	'lcheditor' => { 82 => 0x8ae85e },
	'lens' => { 38 => 0xfdea, 74 => 0x84, 104 => 0xa, 105 => 'Lens' },
	'lensafstopbutton' => { 18 => 0x11, 19 => 0x13, 20 => 0x10, 21 => 0x12, 23 => 0x13, 24 => 0x9 },
	'lensdataversion' => { 73 => 0x0 },
	'lensdistortionparams' => { 92 => 0x206 },
	'lensfirmwareversion' => { 89 => 0x204 },
	'lensfstops' => { 73 => 0x7, 74 => 0x8b },
	'lensid' => { 65 => 0x10c },
	'lensidnumber' => { 73 => 0x6 },
	'lensinfo' => { 105 => 'LensInfo' },
	'lensmake' => { 57 => 'Make' },
	'lensmodel' => { 57 => 'Model' },
	'lensserialnumber' => { 57 => 'SerialNumber', 89 => 0x202 },
	'lenstemperature' => { 92 => 0x1008 },
	'lenstype' => { 0 => 0xd, 1 => 0x16, 11 => 0x95, 74 => 0x83, 89 => 0x201, 96 => 0x3f },
	'license' => { 106 => 'license' },
	'licensetype' => { 109 => 'licensetype' },
	'lightsource' => { 38 => 0x9208, 74 => 0x90, 110 => 'LightSource' },
	'lightsourcespecial' => { 103 => 0x21d },
	'linearresponselimit' => { 38 => 0xc62e },
	'localcaption' => { 42 => 0x79 },
	'localizedcameramodel' => { 38 => 0xc615 },
	'location' => { 111 => 'Location' },
	'logcomment' => { 117 => 'logComment' },
	'longexposurenoisereduction' => { 20 => 0x1, 21 => 0x2, 22 => 0x1, 23 => 0x2, 24 => 0x1 },
	'longfocal' => { 0 => 0x14, 1 => 0x17 },
	'longitude' => { 55 => 'Longitude' },
	'loop' => { 117 => 'loop' },
	'luminancesmoothing' => { 107 => 'LuminanceSmoothing' },
	'macro' => { 40 => 0x1020, 92 => 0x202, 101 => 0x21, 103 => 0x202 },
	'macromode' => { 1 => 0x1, 62 => 0xb, 88 => 0x300, 95 => 0x1c },
	'magnification' => { 53 => 'Magnification' },
	'magnifiedview' => { 21 => 0x11 },
	'make' => { 32 => 0x0, 38 => 0x10f, 51 => 'Make', 94 => 'Make', 114 => 'Make' },
	'makernote' => { 110 => 'MakerNote' },
	'makernotecanon' => { 38 => 0x927c },
	'makernotecasio' => { 38 => 0x927c },
	'makernotecasio2' => { 38 => 0x927c },
	'makernotefujifilm' => { 38 => 0x927c },
	'makernotejvc' => { 38 => 0x927c },
	'makernotejvctext' => { 38 => 0x927c },
	'makernotekodak1a' => { 38 => 0x927c },
	'makernotekodak1b' => { 38 => 0x927c },
	'makernotekodak2' => { 38 => 0x927c },
	'makernotekodak3' => { 38 => 0x927c },
	'makernotekodak4' => { 38 => 0x927c },
	'makernotekodak5' => { 38 => 0x927c },
	'makernotekodak6a' => { 38 => 0x927c },
	'makernotekodak6b' => { 38 => 0x927c },
	'makernotekodakunknown' => { 38 => 0x927c },
	'makernotekyocera' => { 38 => 0x927c },
	'makernoteleica' => { 38 => 0x927c },
	'makernoteminolta' => { 38 => 0x927c },
	'makernoteminolta2' => { 38 => 0x927c },
	'makernoteminolta3' => { 38 => 0x927c },
	'makernoteminolta4' => { 38 => 0x927c },
	'makernotenikon' => { 38 => 0x927c },
	'makernotenikon2' => { 38 => 0x927c },
	'makernotenikon3' => { 38 => 0x927c },
	'makernoteoffset' => { 103 => 0xff },
	'makernoteolympus' => { 38 => 0x927c },
	'makernotepanasonic' => { 38 => 0x927c },
	'makernotepanasonic2' => { 38 => 0x927c },
	'makernotepentax' => { 38 => 0x927c },
	'makernotericoh' => { 38 => 0x927c },
	'makernotericohtext' => { 38 => 0x927c },
	'makernotesafety' => { 38 => 0xc635 },
	'makernotesanyo' => { 38 => 0x927c },
	'makernotesigma' => { 38 => 0x927c },
	'makernotesony' => { 38 => 0x927c },
	'makernotesonysr2' => { 38 => 0x927c },
	'makernotesonysrf' => { 38 => 0x927c },
	'makernotetype' => { 102 => 0x1 },
	'makernoteunknown' => { 38 => 0x927c },
	'makernoteversion' => { 65 => 0x0, 92 => 0x0, 102 => 0x2 },
	'managedfromdocumentid' => { 118 => 'ManagedFromDocumentID' },
	'managedfrominstanceid' => { 118 => 'ManagedFromInstanceID' },
	'managedfrommanager' => { 118 => 'ManagedFromManager' },
	'managedfrommanagervariant' => { 118 => 'ManagedFromManagerVariant' },
	'managedfrommanageto' => { 118 => 'ManagedFromManageTo' },
	'managedfrommanageui' => { 118 => 'ManagedFromManageUI' },
	'managedfromrenditionclass' => { 118 => 'ManagedFromRenditionClass' },
	'managedfromrenditionparams' => { 118 => 'ManagedFromRenditionParams' },
	'managedfromversionid' => { 118 => 'ManagedFromVersionID' },
	'manager' => { 118 => 'Manager' },
	'managervariant' => { 118 => 'ManagerVariant' },
	'manageto' => { 118 => 'ManageTo' },
	'manageui' => { 118 => 'ManageUI' },
	'manualflash' => { 90 => 0x1209 },
	'manualfocusdistance' => { 74 => 0x85, 92 => 0x100c, 103 => 0x223 },
	'manualtv' => { 19 => 0x5 },
	'marked' => { 120 => 'Marked' },
	'markerscomment' => { 117 => 'markersComment' },
	'markersduration' => { 117 => 'markersDuration' },
	'markerslocation' => { 117 => 'markersLocation' },
	'markersname' => { 117 => 'markersName' },
	'markersstarttime' => { 117 => 'markersStartTime' },
	'markerstarget' => { 117 => 'markersTarget' },
	'markerstype' => { 117 => 'markersType' },
	'maskedareas' => { 38 => 0xc68e },
	'masterdocumentid' => { 42 => 0xb9 },
	'maxaperture' => { 1 => 0x1a, 51 => 'MaxAperture', 62 => 0x17 },
	'maxapertureatcurrentfocal' => { 89 => 0x20a },
	'maxapertureatmaxfocal' => { 40 => 0x1407, 51 => 'MaxApertureAtMaxFocal', 73 => 0xb, 89 => 0x206 },
	'maxapertureatminfocal' => { 40 => 0x1406, 73 => 0xa },
	'maxaperturevalue' => { 38 => 0x9205, 110 => 'MaxApertureValue' },
	'maxfocallength' => { 40 => 0x1405, 51 => 'MaxFocalLength', 73 => 0x9, 89 => 0x208 },
	'maximumdensityrange' => { 44 => 0x8c },
	'maxpagesizeh' => { 121 => 'MaxPageSizeH' },
	'maxpagesizeunit' => { 121 => 'MaxPageSizeUnit' },
	'maxpagesizew' => { 121 => 'MaxPageSizeW' },
	'maxsamplevalue' => { 38 => 0x119 },
	'mcuversion' => { 73 => 0xc },
	'measuredev' => { 31 => 0x1814, 51 => 'MeasuredEV' },
	'menubuttondisplayposition' => { 18 => 0xb, 20 => 0xa, 21 => 0xb, 23 => 0xb },
	'menubuttonreturn' => { 24 => 0xb },
	'metadatadate' => { 115 => 'MetadataDate' },
	'metadatamoddate' => { 117 => 'metadataModDate' },
	'meteringmode' => { 1 => 0x11, 38 => 0x9207, 46 => 0x1c, 62 => 0x7, 63 => 0x25, 88 => 0x202, 96 => 0x17, 104 => 0x9, 110 => 'MeteringMode' },
	'minaperture' => { 1 => 0x1b, 51 => 'MinAperture' },
	'minfocallength' => { 40 => 0x1404, 51 => 'MinFocalLength', 73 => 0x8, 89 => 0x207 },
	'minoltadate' => { 62 => 0x15 },
	'minoltaimagesize' => { 62 => 0x4, 63 => 0xc, 64 => 0x2, 65 => 0x103 },
	'minoltamodelid' => { 62 => 0x25 },
	'minoltaquality' => { 62 => 0x5, 63 => 0xd, 64 => 0x3, 65 => [0x102,0x103], 92 => [0x102,0x103] },
	'minoltatime' => { 62 => 0x16 },
	'minsamplevalue' => { 38 => 0x118 },
	'mirrorlockup' => { 18 => 0xc, 19 => 0xc, 20 => 0xb, 21 => 0xc, 22 => 0x6, 23 => 0xc, 24 => 0x3 },
	'moddate' => { 112 => 'ModDate' },
	'model' => { 32 => 0x6, 38 => 0x110, 51 => 'Model', 94 => 'Model', 114 => 'Model' },
	'modifiedcolortemp' => { 12 => 0x9 },
	'modifieddigitalgain' => { 12 => 0xb },
	'modifiedparamflag' => { 9 => 0x1 },
	'modifiedpicturestyle' => { 12 => 0xa },
	'modifiedsaturation' => { 88 => 0x504 },
	'modifiedsensorbluelevel' => { 12 => 0x5 },
	'modifiedsensorredlevel' => { 12 => 0x4 },
	'modifiedsharpness' => { 12 => 0x2 },
	'modifiedsharpnessfreq' => { 12 => 0x3 },
	'modifiedtonecurve' => { 12 => 0x1 },
	'modifiedwhitebalance' => { 12 => 0x8 },
	'modifiedwhitebalanceblue' => { 12 => 0x7 },
	'modifiedwhitebalancered' => { 12 => 0x6 },
	'modifydate' => { 38 => 0x132, 52 => 'ModifyDate', 100 => 'ModDate', 115 => 'ModifyDate' },
	'moirefilter' => { 38 => 0xfe58 },
	'monthdaycreated' => { 46 => 0x12, 48 => 0xe },
	'ndfilter' => { 17 => 0x1c },
	'nearlensstep' => { 92 => 0x103c },
	'newsphotoversion' => { 44 => 0x0 },
	'nickname' => { 115 => 'Nickname' },
	'nikoncaptureversion' => { 74 => 0xe09 },
	'noisereduction' => { 8 => 0x8, 63 => 0xb0, 64 => 0x60, 74 => 0x95, 82 => 0x753dcbc0, 88 => 0x50a, 92 => 0x103a, 95 => 0x2d, 96 => 0x49 },
	'noisereduction2' => { 91 => 0x1010 },
	'noisereductionintensity' => { 83 => 0x9 },
	'noisereductionmethod' => { 83 => 0x11 },
	'noisereductionsharpness' => { 83 => 0xd },
	'npages' => { 121 => 'NPages' },
	'nullrecord' => { 31 => 0x0 },
	'numberofbeats' => { 117 => 'numberOfBeats' },
	'numindexentries' => { 44 => 0x54 },
	'objectattributereference' => { 42 => 0x4 },
	'objectcycle' => { 42 => 0x4b },
	'objectdistance' => { 35 => 0x6, 36 => 0x2022 },
	'objectname' => { 42 => 0x5 },
	'objectpreviewdata' => { 42 => 0xca },
	'objectpreviewfileformat' => { 42 => 0xc8 },
	'objectpreviewfileversion' => { 42 => 0xc9 },
	'objecttypereference' => { 42 => 0x3 },
	'oecfcolumns' => { 110 => 'OECFColumns' },
	'oecfnames' => { 110 => 'OECFNames' },
	'oecfrows' => { 110 => 'OECFRows' },
	'oecfvalues' => { 110 => 'OECFValues' },
	'oldsubfiletype' => { 38 => 0xff },
	'olympusimageheight' => { 92 => 0x102f },
	'olympusimageheight2' => { 91 => 0x615 },
	'olympusimagewidth' => { 92 => 0x102e },
	'olympusimagewidth2' => { 91 => 0x614 },
	'onetouchwb' => { 92 => 0x302 },
	'opticalzoomon' => { 103 => 0x219 },
	'ordernumber' => { 40 => 0x8002 },
	'orientation' => { 38 => 0x112, 51 => 'Orientation', 114 => 'Orientation' },
	'originalfilename' => { 31 => 0x816, 49 => 0x20 },
	'originalrawfiledata' => { 38 => 0xc68c },
	'originalrawfilename' => { 38 => 0xc68b },
	'originaltransmissionreference' => { 42 => 0x67 },
	'originatingprogram' => { 42 => 0x41 },
	'os' => { 109 => 'os' },
	'outcue' => { 117 => 'outCue' },
	'outputheight' => { 79 => 0xce },
	'outputheightinches' => { 79 => 0x96 },
	'outputpixels' => { 79 => 0xd6 },
	'outputresolution' => { 79 => 0xb6 },
	'outputwidth' => { 79 => 0xc6 },
	'outputwidthinches' => { 79 => 0x8e },
	'owner' => { 120 => 'Owner' },
	'ownerid' => { 42 => 0xbc },
	'ownername' => { 11 => 0x9, 31 => 0x810, 38 => 0xfde8, 51 => 'OwnerName', 105 => 'OwnerName' },
	'pagename' => { 38 => 0x11d },
	'pagenumber' => { 38 => 0x129 },
	'panoramadirection' => { 13 => 0x5 },
	'panoramaframe' => { 13 => 0x2 },
	'panoramamode' => { 46 => 0x3c, 88 => 0x601 },
	'pdfversion' => { 112 => 'PDFVersion' },
	'pentaximagesize' => { 96 => 0x9 },
	'pentaxmode' => { 96 => 0x1 },
	'pentaxmodelid' => { 96 => 0x5 },
	'pf0customfuncregistration' => { 26 => 0x1 },
	'pf10retainprogramshift' => { 26 => 0xb },
	'pf13drivepriority' => { 26 => 0xe },
	'pf14disablefocussearch' => { 26 => 0xf },
	'pf15disableafassistbeam' => { 26 => 0x10 },
	'pf16autofocuspointshoot' => { 26 => 0x11 },
	'pf17disableafpointsel' => { 26 => 0x12 },
	'pf18enableautoafpointsel' => { 26 => 0x13 },
	'pf19continuousshootspeed' => { 26 => 0x14 },
	'pf19shootingspeedhigh' => { 25 => 0xa },
	'pf19shootingspeedlow' => { 25 => 0x9 },
	'pf1disableshootingmodes' => { 26 => 0x2 },
	'pf1value' => { 25 => 0x1 },
	'pf20limitcontinousshots' => { 26 => 0x15 },
	'pf20maxcontinousshots' => { 25 => 0xb },
	'pf21enablequietoperation' => { 26 => 0x16 },
	'pf23felocktime' => { 25 => 0xd },
	'pf23postreleasetime' => { 25 => 0xe },
	'pf23settimerlengths' => { 26 => 0x18 },
	'pf23shutterbuttontime' => { 25 => 0xc },
	'pf24lightlcdduringbulb' => { 26 => 0x19 },
	'pf25aemode' => { 25 => 0xf },
	'pf25afmode' => { 25 => 0x12 },
	'pf25afpointsel' => { 25 => 0x13 },
	'pf25colormatrix' => { 25 => 0x17 },
	'pf25defaultclearsettings' => { 26 => 0x1a },
	'pf25drivemode' => { 25 => 0x11 },
	'pf25imagesize' => { 25 => 0x14 },
	'pf25meteringmode' => { 25 => 0x10 },
	'pf25parameters' => { 25 => 0x16 },
	'pf25wbmode' => { 25 => 0x15 },
	'pf26shortenreleaselag' => { 26 => 0x1b },
	'pf27reversedialrotation' => { 26 => 0x1c },
	'pf27value' => { 25 => 0x18 },
	'pf28noquickdialexpcomp' => { 26 => 0x1d },
	'pf29quickdialswitchoff' => { 26 => 0x1e },
	'pf2disablemeteringmodes' => { 26 => 0x3 },
	'pf2value' => { 25 => 0x2 },
	'pf30enlargementmode' => { 26 => 0x1f },
	'pf31originaldecisiondata' => { 26 => 0x20 },
	'pf3manualexposuremetering' => { 26 => 0x4 },
	'pf3value' => { 25 => 0x3 },
	'pf4exposuretimelimits' => { 26 => 0x5 },
	'pf4exposuretimemax' => { 25 => 0x5 },
	'pf4exposuretimemin' => { 25 => 0x4 },
	'pf5aperturelimits' => { 26 => 0x6 },
	'pf5aperturemax' => { 25 => 0x7 },
	'pf5aperturemin' => { 25 => 0x6 },
	'pf6presetshootingmodes' => { 26 => 0x7 },
	'pf7bracketcontinuousshoot' => { 26 => 0x8 },
	'pf8bracketshots' => { 25 => 0x8 },
	'pf8setbracketshots' => { 26 => 0x9 },
	'pf9changebracketsequence' => { 26 => 0xa },
	'photoeffect' => { 1 => 0x28 },
	'photoeffects' => { 82 => 0xab5eca5e },
	'photoeffectsblue' => { 84 => 0x8 },
	'photoeffectsgreen' => { 84 => 0x6 },
	'photoeffectsred' => { 84 => 0x4 },
	'photoeffectstype' => { 84 => 0x0 },
	'photometricinterpretation' => { 38 => 0x106, 114 => 'PhotometricInterpretation' },
	'photoshopquality' => { 97 => 0x0 },
	'pictinfo' => { 103 => 0x208 },
	'picturemode' => { 40 => 0x1031, 88 => 0x520, 96 => 0xb },
	'picturemodebwfilter' => { 88 => 0x525 },
	'picturemodecontrast' => { 88 => 0x523 },
	'picturemodehue' => { 88 => 0x522 },
	'picturemodesaturation' => { 88 => 0x521 },
	'picturemodesharpness' => { 88 => 0x524 },
	'picturemodetone' => { 88 => 0x526 },
	'picturestyle' => { 0 => 0x6c, 16 => 0xa },
	'planarconfiguration' => { 38 => 0x11c, 114 => 'PlanarConfiguration' },
	'platenames' => { 121 => 'PlateNames' },
	'pngwarning' => { 94 => 'Warning' },
	'precaptureframes' => { 92 => 0x300 },
	'predictor' => { 38 => 0x13d },
	'preservedfilename' => { 118 => 'PreservedFileName' },
	'previewfocalplanexresolution' => { 15 => 0x6 },
	'previewfocalplaneyresolution' => { 15 => 0x8 },
	'previewimage' => { 36 => 0x2000, 37 => 'PreviewImage', 38 => 0x927c, 59 => 'data', 65 => 0x81, 92 => 0x280 },
	'previewimagedata' => { 96 => 0x2000 },
	'previewimageheight' => { 15 => 0x4 },
	'previewimagelength' => { 15 => 0x2, 36 => 0x3, 38 => [0x117,0x202], 65 => 0x89, 75 => 0x202, 88 => 0x102, 92 => 0x1037, 96 => 0x3, 101 => 0x1e },
	'previewimagename' => { 59 => '1Name' },
	'previewimagesize' => { 36 => 0x2, 59 => 'ImageSize', 96 => 0x2 },
	'previewimagestart' => { 15 => 0x5, 36 => 0x4, 38 => [0x111,0x201], 65 => 0x88, 75 => 0x201, 88 => 0x101, 92 => 0x1036, 96 => 0x4, 101 => 0x1c },
	'previewimagetype' => { 59 => '0Type' },
	'previewimagevalid' => { 88 => 0x100, 92 => 0x1035 },
	'previewimagewidth' => { 15 => 0x3 },
	'previewquality' => { 15 => 0x1 },
	'primarychromaticities' => { 38 => 0x13f, 114 => 'PrimaryChromaticities' },
	'printim' => { 38 => 0xc4a5 },
	'producer' => { 112 => 'Producer' },
	'productid' => { 43 => 0x32 },
	'programmode' => { 67 => 0x5 },
	'programshift' => { 74 => 0xd },
	'programversion' => { 42 => 0x46 },
	'projectrefpath' => { 117 => 'projectRefPath' },
	'projectreftype' => { 117 => 'projectRefType' },
	'province-state' => { 42 => 0x5f },
	'publisher' => { 108 => 'publisher' },
	'pulldown' => { 117 => 'pullDown' },
	'quality' => { 1 => 0x3, 35 => 0x2, 36 => 0x3002, 40 => 0x1000, 46 => 0x9, 74 => 0x4, 76 => 0x3, 92 => 0x201, 96 => 0x8, 104 => 0x16 },
	'qualitymode' => { 36 => 0x8 },
	'quantizationmethod' => { 44 => 0x78 },
	'quickshot' => { 103 => 0x213 },
	'rasterizedcaption' => { 42 => 0x7d },
	'rating' => { 109 => 'rating', 115 => 'Rating' },
	'rawandjpgrecording' => { 18 => 0x8 },
	'rawdatauniqueid' => { 38 => 0xc65d },
	'rawdepth' => { 66 => 0x10 },
	'rawdevcolorspace' => { 93 => 0x108 },
	'rawdevcontrastvalue' => { 93 => 0x106 },
	'rawdeveditstatus' => { 93 => 0x10b },
	'rawdevengine' => { 93 => 0x109 },
	'rawdevexposurebiasvalue' => { 93 => 0x100 },
	'rawdevgraypoint' => { 93 => 0x103 },
	'rawdevmemorycoloremphasis' => { 93 => 0x105 },
	'rawdevnoisereduction' => { 93 => 0x10a },
	'rawdevsaturationemphasis' => { 93 => 0x104 },
	'rawdevsettings' => { 93 => 0x10c },
	'rawdevsharpnessvalue' => { 93 => 0x107 },
	'rawdevversion' => { 93 => 0x0 },
	'rawdevwbfineadjustment' => { 93 => 0x102 },
	'rawdevwhitebalancevalue' => { 93 => 0x101 },
	'rawfile' => { 38 => 0xfe4c },
	'rawfilename' => { 107 => 'RawFileName' },
	'rawimagecenter' => { 74 => 0x99 },
	'rawimagesize' => { 96 => 0x39 },
	'rawjpgheight' => { 33 => 0x4 },
	'rawjpgquality' => { 8 => 0x6, 33 => 0x1 },
	'rawjpgsize' => { 8 => 0x7, 33 => 0x2 },
	'rawjpgwidth' => { 33 => 0x3 },
	'recordid' => { 31 => 0x1804 },
	'recordingmode' => { 35 => 0x1 },
	'recordmode' => { 36 => 0x3000 },
	'recordshutterrelease' => { 103 => 0x217 },
	'redbalance' => { 51 => 'RedBalance', 92 => 0x1017, 96 => 0x1c },
	'redeyecorrection' => { 85 => 0x0 },
	'redhue' => { 107 => 'RedHue' },
	'redsaturation' => { 107 => 'RedSaturation' },
	'referenceblackwhite' => { 38 => 0x214, 114 => 'ReferenceBlackWhite' },
	'referencedate' => { 42 => 0x2f },
	'referencenumber' => { 42 => 0x32 },
	'references' => { 52 => 'References' },
	'referenceservice' => { 42 => 0x2d },
	'relatedaudiofile' => { 50 => 'data' },
	'relatedaudiofilename' => { 50 => '1Name' },
	'relatedaudiofiletype' => { 50 => '0Type' },
	'relatedimagelength' => { 38 => 0x1002 },
	'relatedimagewidth' => { 38 => 0x1001 },
	'relatedsoundfile' => { 38 => 0xa004, 110 => 'RelatedSoundFile' },
	'relatedvideofile' => { 61 => 'data' },
	'relatedvideofilename' => { 61 => '1Name' },
	'relatedvideofiletype' => { 61 => '0Type' },
	'relation' => { 108 => 'relation' },
	'relativepeakaudiofilepath' => { 117 => 'relativePeakAudioFilePath' },
	'relativetimestamp' => { 117 => 'relativeTimestamp' },
	'releasedate' => { 42 => 0x1e, 117 => 'releaseDate' },
	'releasesetting' => { 31 => 0x1016 },
	'releasetime' => { 42 => 0x23 },
	'renditionclass' => { 118 => 'RenditionClass' },
	'renditionofdocumentid' => { 118 => 'RenditionOfDocumentID' },
	'renditionofinstanceid' => { 118 => 'RenditionOfInstanceID' },
	'renditionofmanager' => { 118 => 'RenditionOfManager' },
	'renditionofmanagervariant' => { 118 => 'RenditionOfManagerVariant' },
	'renditionofmanageto' => { 118 => 'RenditionOfManageTo' },
	'renditionofmanageui' => { 118 => 'RenditionOfManageUI' },
	'renditionofrenditionclass' => { 118 => 'RenditionOfRenditionClass' },
	'renditionofrenditionparams' => { 118 => 'RenditionOfRenditionParams' },
	'renditionofversionid' => { 118 => 'RenditionOfVersionID' },
	'renditionparams' => { 118 => 'RenditionParams' },
	'resampleparamsquality' => { 117 => 'resampleParamsQuality' },
	'resaved' => { 103 => 0x21e },
	'resolution' => { 56 => 'Resolution' },
	'resolutionmode' => { 104 => 0x4 },
	'resolutionunit' => { 38 => 0x128, 45 => 0x2, 114 => 'ResolutionUnit' },
	'resolutionunits' => { 56 => 'ResolutionUnits' },
	'reuseallowed' => { 119 => 'ReuseAllowed' },
	'revision' => { 109 => 'revision' },
	'ricohdate' => { 101 => 0x6 },
	'ricohimageheight' => { 101 => 0x2 },
	'ricohimagewidth' => { 101 => 0x0 },
	'rights' => { 108 => 'rights' },
	'romoperationmode' => { 31 => 0x80d },
	'rotation' => { 30 => 0x3, 63 => 0x50, 64 => 0x46, 82 => 0x76a43207, 95 => 0x30 },
	'routing' => { 100 => 'Routing' },
	'rowsperstrip' => { 38 => 0x116 },
	'safetyshiftinavortv' => { 18 => 0x10, 19 => 0x10, 20 => 0xf, 21 => 0x10, 23 => 0x10 },
	'samplebits' => { 50 => 'SampleBits' },
	'samplerate' => { 50 => 'SampleRate' },
	'samplesperpixel' => { 38 => 0x115, 114 => 'SamplesPerPixel' },
	'samplestructure' => { 44 => 0x5a },
	'sanyoquality' => { 103 => 0x201 },
	'sanyothumbnail' => { 103 => 0x100 },
	'saturation' => { 1 => 0xe, 6 => 0x1, 35 => 0xd, 36 => [0x3013,0x1f], 38 => [0xa409,0xfe55], 40 => 0x1003, 51 => 'Saturation', 62 => 0x1f, 63 => 0x32, 64 => 0x28, 67 => 0x1, 74 => [0x94,0xaa], 96 => 0x1f, 101 => 0x28, 104 => 0x10, 107 => 'Saturation', 110 => 'Saturation' },
	'saturationfaithful' => { 0 => 0xfe },
	'saturationlandscape' => { 0 => 0xfc },
	'saturationneutral' => { 0 => 0xfd },
	'saturationportrait' => { 0 => 0xfb },
	'saturationstandard' => { 0 => 0xfa },
	'saturationuserdef1' => { 0 => 0x100 },
	'saturationuserdef2' => { 0 => 0x101 },
	'saturationuserdef3' => { 0 => 0x102 },
	'saveid' => { 118 => 'SaveID' },
	'scaledresolution' => { 79 => 0x9e },
	'scaletype' => { 117 => 'scaleType' },
	'scanningdirection' => { 44 => 0x64 },
	'scene' => { 111 => 'Scene', 117 => 'scene' },
	'scenecapturetype' => { 38 => 0xa406, 110 => 'SceneCaptureType' },
	'scenemode' => { 74 => 0x8f, 88 => 0x509 },
	'sceneselect' => { 103 => 0x21f },
	'scenetype' => { 38 => 0xa301, 110 => 'SceneType' },
	'securityclassification' => { 38 => 0x9212 },
	'self-timer' => { 1 => 0x2 },
	'self-timer2' => { 17 => 0x1d },
	'selftimer' => { 36 => 0x3001, 95 => 0x2e, 103 => 0x214 },
	'selftimermode' => { 38 => 0x882b },
	'selftimertime' => { 31 => 0x1806 },
	'seminfo' => { 38 => 0x8546 },
	'sensingmethod' => { 38 => 0xa217, 110 => 'SensingMethod' },
	'sensorbluelevel' => { 16 => 0x5 },
	'sensorcleaning' => { 24 => 0xd },
	'sensorheight' => { 66 => 0x8 },
	'sensorpixelsize' => { 74 => 0x9a },
	'sensorredlevel' => { 16 => 0x4 },
	'sensorsize' => { 51 => 'SensorSize' },
	'sensortemperature' => { 90 => 0x1500, 92 => 0x1007 },
	'sensorwidth' => { 66 => 0xa },
	'sequence' => { 88 => 0x600 },
	'sequencenumber' => { 17 => 0x9, 36 => 0x301c, 40 => 0x1101, 46 => 0x1d, 95 => 0x2b },
	'sequenceshotinterval' => { 103 => 0x224 },
	'sequentialshot' => { 103 => 0x20e },
	'serialnumber' => { 11 => 0xc, 31 => 0x180b, 38 => 0xfde9, 51 => 'SerialNumber', 74 => 0xa0, 89 => 0x101, 92 => [0x404,0x101a], 104 => 0x2, 105 => 'SerialNumber' },
	'serialnumberformat' => { 11 => 0x15, 31 => 0x183b },
	'serviceidentifier' => { 43 => 0x1e },
	'setbuttoncrosskeysfunc' => { 22 => 0x0 },
	'setbuttonfunction' => { 18 => 0x1, 24 => 0xc },
	'setfunctionwhenshooting' => { 20 => 0x0, 21 => 0x1, 23 => 0x1 },
	'shadingcompensation' => { 88 => 0x50c },
	'shadingcompensation2' => { 91 => 0x1012 },
	'shadow' => { 104 => 0xe },
	'shadows' => { 38 => 0xfe52, 107 => 'Shadows' },
	'shadowscale' => { 38 => 0xc633 },
	'shadowtint' => { 107 => 'ShadowTint' },
	'sharpness' => { 1 => 0xf, 16 => 0x2, 35 => 0xb, 36 => [0x3011,0x21], 38 => [0xa40a,0xfe56], 40 => 0x1001, 46 => 0x6b, 48 => 0x37, 51 => 'Sharpness', 62 => 0x21, 63 => 0x30, 64 => 0x26, 67 => 0x3, 74 => 0x6, 92 => 0x100f, 96 => 0x21, 101 => 0x22, 102 => 0x1003, 104 => 0x11, 107 => 'Sharpness', 110 => 'Sharpness' },
	'sharpnessfactor' => { 92 => 0x102a },
	'sharpnessfaithful' => { 0 => 0xf5 },
	'sharpnessfrequency' => { 16 => 0x3 },
	'sharpnesslandscape' => { 0 => 0xf3 },
	'sharpnessmonochrome' => { 0 => 0xf6 },
	'sharpnessneutral' => { 0 => 0xf4 },
	'sharpnessportrait' => { 0 => 0xf2 },
	'sharpnesssetting' => { 88 => 0x506 },
	'sharpnessstandard' => { 0 => 0xf1 },
	'sharpnessuserdef1' => { 0 => 0xf7 },
	'sharpnessuserdef2' => { 0 => 0xf8 },
	'sharpnessuserdef3' => { 0 => 0xf9 },
	'shootingmode' => { 51 => 'ShootingMode', 74 => 0x89, 95 => 0x1f },
	'shortdescription' => { 109 => 'shortdescription' },
	'shortdocumentid' => { 42 => 0xba },
	'shortfocal' => { 0 => 0x12, 1 => 0x18 },
	'shortownername' => { 0 => 0xac },
	'shotdate' => { 117 => 'shotDate' },
	'shotlocation' => { 117 => 'shotLocation' },
	'shotname' => { 117 => 'shotName' },
	'shutter-aelock' => { 18 => 0x4, 20 => 0x3, 21 => 0x4, 22 => 0x3, 23 => 0x4, 24 => 0x2 },
	'shutteraelbutton' => { 19 => 0x4 },
	'shuttercount' => { 8 => 0x1 },
	'shuttercurtainsync' => { 18 => 0xf, 19 => 0xf, 20 => 0xe, 21 => 0xf, 22 => 0x8, 23 => 0xf, 24 => 0x8 },
	'shuttermode' => { 46 => 0x1b },
	'shutterreleasemethod' => { 31 => 0x1010 },
	'shutterreleasenocfcard' => { 18 => 0x2, 19 => 0x2, 24 => 0xf },
	'shutterreleasetiming' => { 31 => 0x1011 },
	'shutterspeedvalue' => { 38 => 0x9201, 92 => 0x1000, 110 => 'ShutterSpeedValue' },
	'similarityindex' => { 42 => 0xe4 },
	'slowshutter' => { 17 => 0x8 },
	'slowsync' => { 40 => 0x1030 },
	'smoothingparameter1' => { 91 => 0x300 },
	'smoothingparameter2' => { 91 => 0x310 },
	'smoothingthreshold2' => { 91 => 0x610 },
	'smoothingthresholds' => { 91 => 0x600 },
	'smoothness' => { 38 => 0xfe57 },
	'software' => { 38 => 0x131, 52 => 'Software', 94 => 'Software', 104 => 0x18, 114 => 'Software' },
	'softwareversion' => { 103 => 0x207 },
	'source' => { 42 => 0x73, 94 => 'Source', 108 => 'source', 109 => 'source', 113 => 'Source' },
	'sourceresolution' => { 79 => 0xae },
	'spatialfrequencyresponsecolumns' => { 110 => 'SpatialFrequencyResponseColumns' },
	'spatialfrequencyresponsenames' => { 110 => 'SpatialFrequencyResponseNames' },
	'spatialfrequencyresponserows' => { 110 => 'SpatialFrequencyResponseRows' },
	'spatialfrequencyresponsevalues' => { 110 => 'SpatialFrequencyResponseValues' },
	'speakerplacement' => { 117 => 'speakerPlacement' },
	'specialinstructions' => { 42 => 0x28 },
	'specialmode' => { 92 => 0x200, 103 => 0x200 },
	'spectralsensitivity' => { 38 => 0x8824, 110 => 'SpectralSensitivity' },
	'spotfocuspointx' => { 62 => 0x2d },
	'spotfocuspointy' => { 62 => 0x2e },
	'spotmode' => { 95 => 0xf },
	'starttimecodetimeformat' => { 117 => 'startTimecodeTimeFormat' },
	'starttimecodetimevalue' => { 117 => 'startTimecodeTimeValue' },
	'state' => { 55 => 'State', 113 => 'State' },
	'storagemethod' => { 66 => 0x12 },
	'straightenangle' => { 82 => 0x2fc08431 },
	'stretchmode' => { 117 => 'stretchMode' },
	'sub-location' => { 42 => 0x5c },
	'subfile' => { 58 => 'data' },
	'subfiledirectory' => { 58 => '1Directory' },
	'subfilemimetype' => { 58 => '2MIME' },
	'subfilename' => { 58 => '1Name' },
	'subfileresource' => { 58 => 'resource' },
	'subfiletype' => { 38 => 0xfe, 58 => '0Type' },
	'subject' => { 100 => 'Subject', 108 => 'subject', 112 => 'Subject' },
	'subjectarea' => { 110 => 'SubjectArea' },
	'subjectcode' => { 111 => 'SubjectCode' },
	'subjectdistance' => { 38 => 0x9206, 46 => 0x3e, 110 => 'SubjectDistance' },
	'subjectdistancerange' => { 38 => 0xa40c, 110 => 'SubjectDistanceRange' },
	'subjectlocation' => { 38 => [0x9214,0xa214], 110 => 'SubjectLocation' },
	'subjectprogram' => { 62 => 0x22 },
	'subjectreference' => { 42 => 0xc },
	'subsectime' => { 38 => 0x9290 },
	'subsectimedigitized' => { 38 => 0x9292 },
	'subsectimeoriginal' => { 38 => 0x9291 },
	'superimposeddisplay' => { 18 => 0xa, 20 => 0x9, 21 => 0xa, 23 => 0xa, 24 => 0xe },
	'supplementalcategories' => { 42 => 0x14, 113 => 'SupplementalCategories' },
	'supplementaltype' => { 44 => 0x37 },
	'switchtoregisteredafpoint' => { 19 => 0x12 },
	'tapename' => { 117 => 'tapeName' },
	'targetaperture' => { 17 => 0x4 },
	'targetcompressionratio' => { 29 => 0x1 },
	'targetdistancesetting' => { 31 => 0x1807 },
	'targetexposuretime' => { 17 => 0x5 },
	'targetimagetype' => { 31 => 0x100a },
	'temperature' => { 107 => 'Temperature' },
	'tempo' => { 117 => 'tempo' },
	'thresholding' => { 38 => 0x107 },
	'thumbnailfilename' => { 31 => 0x817 },
	'thumbnailimage' => { 31 => 0x2008, 37 => 'ThumbnailImage', 60 => 'data', 92 => 0x100 },
	'thumbnailimagename' => { 60 => '1Name' },
	'thumbnailimagesize' => { 60 => 'ImageSize' },
	'thumbnailimagetype' => { 60 => '0Type' },
	'thumbnaillength' => { 38 => 0x202 },
	'thumbnailoffset' => { 38 => 0x201 },
	'thumbnailsformat' => { 115 => 'ThumbnailsFormat' },
	'thumbnailsheight' => { 115 => 'ThumbnailsHeight' },
	'thumbnailsimage' => { 115 => 'ThumbnailsImage' },
	'thumbnailswidth' => { 115 => 'ThumbnailsWidth' },
	'tilelength' => { 38 => 0x143 },
	'tilewidth' => { 38 => 0x142 },
	'time' => { 96 => 0x7 },
	'timecreated' => { 42 => 0x3c, 46 => 0x14, 48 => 0x10 },
	'timescaleparamsframeoverlappingpercentage' => { 117 => 'timeScaleParamsFrameOverlappingPercentage' },
	'timescaleparamsframesize' => { 117 => 'timeScaleParamsFrameSize' },
	'timescaleparamsquality' => { 117 => 'timeScaleParamsQuality' },
	'timesent' => { 43 => 0x50 },
	'timesignature' => { 117 => 'timeSignature' },
	'timestamp' => { 0 => 0x11c, 94 => 'TimeStamp' },
	'timezone' => { 36 => 0x3006 },
	'timezonecode' => { 34 => 0x1 },
	'timezoneinfo' => { 34 => 0x2 },
	'timezoneoffset' => { 38 => 0x882a },
	'tint' => { 107 => 'Tint' },
	'title' => { 52 => 'Title', 94 => 'Title', 100 => 'Title', 108 => 'title', 112 => 'Title' },
	'tonecomp' => { 74 => 0x81 },
	'tonecurve' => { 16 => 0x1, 96 => 0x402, 107 => 'ToneCurve' },
	'tonecurvename' => { 107 => 'ToneCurveName' },
	'tonecurves' => { 96 => 0x403 },
	'toningeffect' => { 8 => 0xf },
	'toningeffectmonochrome' => { 0 => 0x108 },
	'totalzoom' => { 46 => 0x62 },
	'tracknumber' => { 117 => 'trackNumber' },
	'transferfunction' => { 114 => 'TransferFunction' },
	'transmissionreference' => { 113 => 'TransmissionReference' },
	'tvvalue' => { 27 => 0x1 },
	'type' => { 108 => 'type' },
	'uniquecameramodel' => { 38 => 0xc614 },
	'uniquedocumentid' => { 42 => 0xbb },
	'uniqueobjectname' => { 43 => 0x64 },
	'unsharp1color' => { 86 => 0x13 },
	'unsharp1halowidth' => { 86 => 0x19 },
	'unsharp1intensity' => { 86 => 0x17 },
	'unsharp1threshold' => { 86 => 0x1b },
	'unsharp2color' => { 86 => 0x2e },
	'unsharp2halowidth' => { 86 => 0x34 },
	'unsharp2intensity' => { 86 => 0x32 },
	'unsharp2threshold' => { 86 => 0x36 },
	'unsharp3color' => { 86 => 0x49 },
	'unsharp3halowidth' => { 86 => 0x4f },
	'unsharp3intensity' => { 86 => 0x4d },
	'unsharp3threshold' => { 86 => 0x51 },
	'unsharp4color' => { 86 => 0x64 },
	'unsharp4halowidth' => { 86 => 0x6a },
	'unsharp4intensity' => { 86 => 0x68 },
	'unsharp4threshold' => { 86 => 0x6c },
	'unsharpcount' => { 86 => 0x0 },
	'unsharpmask' => { 82 => 0x76a43200 },
	'urgency' => { 42 => 0xa, 113 => 'Urgency' },
	'url' => { 52 => 'URL', 94 => 'URL', 98 => 0x40b },
	'usageterms' => { 120 => 'UsageTerms' },
	'usercomment' => { 31 => 0x805, 38 => 0x9286, 110 => 'UserComment' },
	'userdef1picturestyle' => { 0 => 0x10c },
	'userdef2picturestyle' => { 0 => 0x10e },
	'userdef3picturestyle' => { 0 => 0x110 },
	'usmlenselectronicmf' => { 19 => 0x7 },
	'validbits' => { 91 => 0x611, 92 => 0x102c },
	'variousmodes' => { 46 => 0x26 },
	'variousmodes2' => { 46 => 0x3a },
	'variprogram' => { 74 => 0xab },
	'version' => { 40 => 0x0, 100 => 'Version', 107 => 'Version' },
	'versionid' => { 118 => 'VersionID' },
	'versionscomments' => { 118 => 'VersionsComments' },
	'versionseventaction' => { 118 => 'VersionsEventAction' },
	'versionseventinstanceid' => { 118 => 'VersionsEventInstanceID' },
	'versionseventparameters' => { 118 => 'VersionsEventParameters' },
	'versionseventsoftwareagent' => { 118 => 'VersionsEventSoftwareAgent' },
	'versionseventwhen' => { 118 => 'VersionsEventWhen' },
	'versionsmodifier' => { 118 => 'VersionsModifier' },
	'versionsmodifydate' => { 118 => 'VersionsModifyDate' },
	'versionsversion' => { 118 => 'VersionsVersion' },
	'videoalphamode' => { 117 => 'videoAlphaMode' },
	'videoalphapremultiplecolora' => { 117 => 'videoAlphaPremultipleColorA' },
	'videoalphapremultiplecolorb' => { 117 => 'videoAlphaPremultipleColorB' },
	'videoalphapremultiplecolorblack' => { 117 => 'videoAlphaPremultipleColorBlack' },
	'videoalphapremultiplecolorblue' => { 117 => 'videoAlphaPremultipleColorBlue' },
	'videoalphapremultiplecolorcyan' => { 117 => 'videoAlphaPremultipleColorCyan' },
	'videoalphapremultiplecolorgreen' => { 117 => 'videoAlphaPremultipleColorGreen' },
	'videoalphapremultiplecolorl' => { 117 => 'videoAlphaPremultipleColorL' },
	'videoalphapremultiplecolormagenta' => { 117 => 'videoAlphaPremultipleColorMagenta' },
	'videoalphapremultiplecolormode' => { 117 => 'videoAlphaPremultipleColorMode' },
	'videoalphapremultiplecolorred' => { 117 => 'videoAlphaPremultipleColorRed' },
	'videoalphapremultiplecolorswatchname' => { 117 => 'videoAlphaPremultipleColorSwatchName' },
	'videoalphapremultiplecolortype' => { 117 => 'videoAlphaPremultipleColorType' },
	'videoalphapremultiplecoloryellow' => { 117 => 'videoAlphaPremultipleColorYellow' },
	'videoalphaunityistransparent' => { 117 => 'videoAlphaUnityIsTransparent' },
	'videocolorspace' => { 117 => 'videoColorSpace' },
	'videocompressor' => { 117 => 'videoCompressor' },
	'videofieldorder' => { 117 => 'videoFieldOrder' },
	'videoframerate' => { 117 => 'videoFrameRate' },
	'videoframesizeh' => { 117 => 'videoFrameSizeH' },
	'videoframesizeunit' => { 117 => 'videoFrameSizeUnit' },
	'videoframesizew' => { 117 => 'videoFrameSizeW' },
	'videomoddate' => { 117 => 'videoModDate' },
	'videopixelaspectratio' => { 117 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 117 => 'videoPixelDepth' },
	'vignetteamount' => { 107 => 'VignetteAmount' },
	'vignettecontrol' => { 82 => 0x76a43205 },
	'vignettecontrolintensity' => { 82 => 0xac6bd5c0 },
	'vignettemidpoint' => { 107 => 'VignetteMidpoint' },
	'voicememo' => { 103 => 0x216 },
	'wb_rbgglevels' => { 70 => 0x0 },
	'wb_rblevels' => { 91 => 0x100 },
	'wb_rgbglevels' => { 72 => 0x0 },
	'wb_rggblevels' => { 71 => 0x0 },
	'wb_rggblevelsasshot' => { 3 => 0x19, 4 => 0x18, 5 => 0x3f },
	'wb_rggblevelsauto' => { 2 => 0x0, 3 => 0x1e, 4 => 0x22, 5 => 0x44 },
	'wb_rggblevelscloudy' => { 2 => 0xc, 3 => 0x2d, 4 => 0x31, 5 => 0x58 },
	'wb_rggblevelscustom' => { 2 => 0x1c, 5 => 0x80 },
	'wb_rggblevelscustom1' => { 3 => 0x41 },
	'wb_rggblevelscustom2' => { 3 => 0x46 },
	'wb_rggblevelsdaylight' => { 2 => 0x4, 3 => 0x23, 4 => 0x27, 5 => 0x4e },
	'wb_rggblevelsflash' => { 2 => 0x18, 3 => 0x3c, 4 => 0x45, 5 => 0x6c },
	'wb_rggblevelsfluorescent' => { 2 => 0x14, 3 => 0x37, 4 => 0x3b, 5 => 0x62 },
	'wb_rggblevelskelvin' => { 2 => 0x20, 4 => 0x40, 5 => 0x67 },
	'wb_rggblevelsmeasured' => { 5 => 0x49 },
	'wb_rggblevelspc1' => { 4 => 0x90, 5 => 0x71 },
	'wb_rggblevelspc2' => { 4 => 0x95, 5 => 0x76 },
	'wb_rggblevelspc3' => { 4 => 0x9a, 5 => 0x7b },
	'wb_rggblevelsshade' => { 2 => 0x8, 3 => 0x28, 4 => 0x2c, 5 => 0x53 },
	'wb_rggblevelstungsten' => { 2 => 0x10, 3 => 0x32, 4 => 0x36, 5 => 0x5d },
	'wb_rggblevelsunknown' => { 4 => 0x1d },
	'wb_rggblevelsunknown10' => { 4 => 0x72 },
	'wb_rggblevelsunknown11' => { 4 => 0x77 },
	'wb_rggblevelsunknown12' => { 4 => 0x7c },
	'wb_rggblevelsunknown13' => { 4 => 0x81 },
	'wb_rggblevelsunknown14' => { 4 => 0x86 },
	'wb_rggblevelsunknown15' => { 4 => 0x8b },
	'wb_rggblevelsunknown16' => { 4 => 0x9f },
	'wb_rggblevelsunknown2' => { 4 => 0x4a },
	'wb_rggblevelsunknown3' => { 4 => 0x4f },
	'wb_rggblevelsunknown4' => { 4 => 0x54 },
	'wb_rggblevelsunknown5' => { 4 => 0x59 },
	'wb_rggblevelsunknown6' => { 4 => 0x5e },
	'wb_rggblevelsunknown7' => { 4 => 0x63 },
	'wb_rggblevelsunknown8' => { 4 => 0x68 },
	'wb_rggblevelsunknown9' => { 4 => 0x6d },
	'wbadjbluebalance' => { 87 => 0x8 },
	'wbadjlighting' => { 87 => 0x15 },
	'wbadjmode' => { 87 => 0x10 },
	'wbadjredbalance' => { 87 => 0x0 },
	'wbadjtemperature' => { 87 => 0x18 },
	'wbbracketmode' => { 8 => 0x9 },
	'wbbracketvalueab' => { 8 => 0xc },
	'wbbracketvaluegm' => { 8 => 0xd },
	'wblevels' => { 68 => 0x4 },
	'wbmode' => { 67 => 0x4, 92 => 0x1015 },
	'wbscale' => { 68 => 0x0 },
	'wbshiftab' => { 16 => 0xc },
	'wbshiftgm' => { 16 => 0xd },
	'webstatement' => { 120 => 'WebStatement' },
	'whitebalance' => { 16 => 0x8, 17 => 0x7, 35 => 0x7, 36 => [0x19,0x2012], 38 => [0xa403,0xfe4e], 40 => 0x1002, 46 => 0x40, 62 => 0x3, 63 => 0xe, 64 => 0x4, 74 => 0x5, 76 => 0x7, 95 => 0x3, 96 => 0x19, 101 => 0x26, 104 => 0x7, 107 => 'WhiteBalance', 110 => 'WhiteBalance' },
	'whitebalance2' => { 88 => 0x500 },
	'whitebalanceadj' => { 82 => 0x76a43204 },
	'whitebalancebias' => { 36 => 0x2011, 95 => 0x23 },
	'whitebalanceblue' => { 16 => 0x7 },
	'whitebalancebracket' => { 88 => 0x502 },
	'whitebalancefinetune' => { 74 => 0xb },
	'whitebalancemode' => { 96 => 0x1a },
	'whitebalancered' => { 16 => 0x6 },
	'whitebalancetemperature' => { 88 => 0x501 },
	'whitepoint' => { 38 => 0x13e, 96 => 0x201, 114 => 'WhitePoint' },
	'widefocuszone' => { 62 => 0x2f },
	'widerange' => { 103 => 0x20f },
	'worldtimelocation' => { 96 => 0x22 },
	'writer-editor' => { 42 => 0x7a },
	'x3filllight' => { 104 => 0x12 },
	'xmp' => { 39 => 'XMP' },
	'xpauthor' => { 38 => 0x9c9d },
	'xpcomment' => { 38 => 0x9c9c },
	'xpkeywords' => { 38 => 0x9c9e },
	'xposition' => { 38 => 0x11e },
	'xpsubject' => { 38 => 0x9c9f },
	'xptitle' => { 38 => 0x9c9b },
	'xresolution' => { 38 => 0x11a, 45 => 0x3, 99 => 0x0, 114 => 'XResolution' },
	'ycbcrcoefficients' => { 38 => 0x211, 114 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 38 => 0x213, 114 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 38 => 0x212, 114 => 'YCbCrSubSampling' },
	'yearcreated' => { 46 => 0x10, 48 => 0xc },
	'yposition' => { 38 => 0x11f },
	'yresolution' => { 38 => 0x11b, 45 => 0x5, 99 => 0x4, 114 => 'YResolution' },
	'zonematching' => { 65 => 0x10a, 67 => 0x3a },
	'zonematchingon' => { 64 => 0x75 },
	'zoomsourcewidth' => { 1 => 0x24 },
	'zoomstepcount' => { 90 => 0x300, 92 => 0x100d },
	'zoomtargetwidth' => { 1 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'adobephotoshop' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'afaperture' => 1,
	'afcp_iptc' => 1,
	'afinfo' => 1,
	'afpointsused1d' => 1,
	'albumartist' => 1,
	'albumcoverurl' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitle' => 1,
	'aliaslayermetadata' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphaoffset' => 1,
	'alphasample' => 1,
	'analogbalance' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'applicationnotes' => 1,
	'archivallocation' => 1,
	'artistlen' => 1,
	'artisturl' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'aspectratio' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'asshoticcprofile' => 1,
	'asshotneutral' => 1,
	'asshotpreprofilematrix' => 1,
	'association' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'audiences' => 1,
	'audiobitrate' => 1,
	'audiobytes' => 1,
	'audiochannels' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecname' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audioinfo' => 1,
	'audiolayer' => 1,
	'audiomode' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'authorlen' => 1,
	'authorship' => 1,
	'authorurl' => 1,
	'aux' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'aviheader' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'badfaxlines' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'basisobject' => 1,
	'batterylevel' => 1,
	'beatsperminute' => 1,
	'binaryfilter' => 1,
	'bitrate' => 1,
	'bitratemutualexclusion' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperrunlength' => 1,
	'blacklevel2' => 1,
	'blackleveldeltah' => 1,
	'blackleveldeltav' => 1,
	'blacklevelrepeatdim' => 1,
	'blocklocation' => 1,
	'blocksize' => 1,
	'blueadjust' => 1,
	'bluegain' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bracketshot' => 1,
	'brightnessdata' => 1,
	'broadcast' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'bufferaverage' => 1,
	'burstshot' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bytesperminute' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'calibrationdatetime' => 1,
	'camera' => 1,
	'camerabacktype' => 1,
	'cameracalibration1' => 1,
	'cameracalibration2' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'cameraowner' => 1,
	'cameraprofileversion' => 1,
	'camerasettings' => 1,
	'camerasetup' => 1,
	'cameraspecification' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canoncamerainfo' => 1,
	'canoncamerasettings' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canoncustomfunctions10d' => 1,
	'canoncustomfunctions20d' => 1,
	'canoncustomfunctionsd30' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonpanorama' => 1,
	'canonpictureinfo' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedevicefid' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'casio' => 1,
	'cc' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'centerdarkrect' => 1,
	'cfalayout' => 1,
	'cfapattern2' => 1,
	'cfaplanecolor' => 1,
	'cfarepeatpatterndim' => 1,
	'channelmode' => 1,
	'charcount' => 1,
	'chartarget' => 1,
	'chromaticadaptation' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'cleanfaxdata' => 1,
	'clipboundary' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'cmcontrast' => 1,
	'cmexposurecompensation' => 1,
	'cmhue' => 1,
	'cmmflags' => 1,
	'cmsaturation' => 1,
	'cmsharpness' => 1,
	'cmwhitebalance' => 1,
	'cmwhitebalancecomp' => 1,
	'cmwhitebalancegraypoint' => 1,
	'codecflavorid' => 1,
	'codeclist' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codingmethods' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantorder' => 1,
	'coloranttable' => 1,
	'coloraverages' => 1,
	'colorbalance' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance2' => 1,
	'colorbalance3' => 1,
	'colorbalanceunknown' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorinfo' => 1,
	'colorinfod30' => 1,
	'colormap' => 1,
	'colormatrix1' => 1,
	'colormatrix2' => 1,
	'colormodesetting' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspecification' => 1,
	'colortable' => 1,
	'colortransferfuncs' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'compatibility' => 1,
	'compilation' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'compositinglayerheader' => 1,
	'composition' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compressed' => 1,
	'compressedtext' => 1,
	'compressiontype' => 1,
	'compressor' => 1,
	'compressorid' => 1,
	'concreteflag' => 1,
	'conditionalfec' => 1,
	'conductor' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'consecutivebadfaxlines' => 1,
	'cont' => 1,
	'containerformat' => 1,
	'contake' => 1,
	'contentbranding' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdistributor' => 1,
	'contentencryption' => 1,
	'contentgroupdescription' => 1,
	'contentrating' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'coringvalues' => 1,
	'cpuversions' => 1,
	'crdinfo' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'cropdata' => 1,
	'cropped' => 1,
	'cross-reference' => 1,
	'crs' => 1,
	'currentbitrate' => 1,
	'currenticcprofile' => 1,
	'currentpreprofilematrix' => 1,
	'currenttime' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'darkcorrectiontype' => 1,
	'data' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'datareference' => 1,
	'datatype' => 1,
	'datetimecreated' => 1,
	'dc' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'decode' => 1,
	'decodertable' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defineobject' => 1,
	'delay' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'depth' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'deviceattributes' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicesettingdescription' => 1,
	'devicesettings' => 1,
	'dex' => 1,
	'dictionary' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'dimensions' => 1,
	'director' => 1,
	'discardobjects' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunits' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'dngmakernotes' => 1,
	'dngprivatedata' => 1,
	'dof' => 1,
	'donotshow' => 1,
	'dotsperinch' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'dvdid' => 1,
	'edit1' => 1,
	'edit2' => 1,
	'edit3' => 1,
	'edit4' => 1,
	'edit5' => 1,
	'edit6' => 1,
	'edit7' => 1,
	'edit8' => 1,
	'edit9' => 1,
	'edittagarray' => 1,
	'effectivebw' => 1,
	'effectivemaxaperture' => 1,
	'effectsvisible' => 1,
	'emphasis' => 1,
	'encodedby' => 1,
	'encodersettings' => 1,
	'encoding' => 1,
	'encodingsettings' => 1,
	'encodingtime' => 1,
	'encryption' => 1,
	'endpoints' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'events' => 1,
	'exif' => 1,
	'exif_profile' => 1,
	'exifinfo' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'exportimage' => 1,
	'exposureadjust' => 1,
	'exposureinfo' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedstreamprops' => 1,
	'extenderstatus' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'extrasamples' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fileid' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'fileowner' => 1,
	'fileproperties' => 1,
	'filerul' => 1,
	'filesize' => 1,
	'filetype' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filtering' => 1,
	'finalimageheight' => 1,
	'finalimagewidth' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'flags' => 1,
	'flashinfo' => 1,
	'flashon' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashversion' => 1,
	'focallength35efl' => 1,
	'focusinfo' => 1,
	'focuspos' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'framecount' => 1,
	'framepriority' => 1,
	'framerate' => 1,
	'framesize' => 1,
	'frametype' => 1,
	'free' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'fujifilm' => 1,
	'gain' => 1,
	'gamut' => 1,
	'gdalmetadata' => 1,
	'gdalnodata' => 1,
	'genr' => 1,
	'genreid' => 1,
	'geo' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geotiffasciiparams' => 1,
	'geotiffdirectory' => 1,
	'geotiffdoubleparams' => 1,
	'geotiffversion' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'globalinfo' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'gpsdatetime' => 1,
	'gpsinfo' => 1,
	'gpsposition' => 1,
	'graphicstechnologystandardoutput' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greengain' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'groupcaption' => 1,
	'grouping' => 1,
	'groupmutualexclusion' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasaudio' => 1,
	'hasfiletransferstream' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'hasscript' => 1,
	'hasvideo' => 1,
	'hcusage' => 1,
	'hdrl' => 1,
	'header' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'heightresolution' => 1,
	'highlightendpoints' => 1,
	'huesetting' => 1,
	'hyperfocaldistance' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'id' => 1,
	'id3' => 1,
	'id3v1' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'idsbasevalue' => 1,
	'ifd0_offset' => 1,
	'image' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagedata' => 1,
	'imagedatadiscard' => 1,
	'imagedepth' => 1,
	'imagefields' => 1,
	'imageformat' => 1,
	'imageheader' => 1,
	'imagehistory' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imageoffset' => 1,
	'imageprintstatus' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imageresources' => 1,
	'imagerotated' => 1,
	'imagerotationstatus' => 1,
	'imagesourcedata' => 1,
	'imagesourceek' => 1,
	'imagestatus' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'index' => 1,
	'indexable' => 1,
	'indexed' => 1,
	'indexedcolourtablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'info' => 1,
	'information' => 1,
	'initialkey' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputprofile' => 1,
	'instructionset' => 1,
	'integrationtime' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphmatrix' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpretedby' => 1,
	'involvedpeople' => 1,
	'iptc' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isospeed' => 1,
	'isrc' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'jfifversion' => 1,
	'jngheader' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegqtables' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jumptoxpep' => 1,
	'kids' => 1,
	'kodak' => 1,
	'kodakbordersifd' => 1,
	'kodakeffectsifd' => 1,
	'konicaminolta' => 1,
	'languagelist' => 1,
	'lastmodifier' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lastsavedby' => 1,
	'layersgroupinfo' => 1,
	'layerstateinfo' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lensaperturerange' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdataunknown' => 1,
	'lensfocalrange' => 1,
	'lensspec' => 1,
	'lightness' => 1,
	'lights' => 1,
	'linearizationtable' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookuptable' => 1,
	'loopstyle' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'lyricist' => 1,
	'lyrics' => 1,
	'lyrics_synchronised' => 1,
	'macintoshprintinfo' => 1,
	'magnifyobject' => 1,
	'makeandmodel' => 1,
	'makernotebyteorder' => 1,
	'makernotelength' => 1,
	'makernotes' => 1,
	'mandatorybackground' => 1,
	'marker' => 1,
	'markerid' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'maxbitrate' => 1,
	'maxdatarate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxsubfilesize' => 1,
	'maxval' => 1,
	'mcdi' => 1,
	'mdat' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mdlabname' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementobserver' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediaclassprimaryid' => 1,
	'mediaclasssecondaryid' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediaindex' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'mimetype' => 1,
	'minf' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minpacketsize' => 1,
	'mngheader' => 1,
	'modeextension' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modeltiepoint' => 1,
	'modeltransform' => 1,
	'modenumber' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'montage' => 1,
	'mood' => 1,
	'mosaicpattern' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'movieheader' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'msstereo' => 1,
	'multiquality' => 1,
	'musiciancredits' => 1,
	'name' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'namelength' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'nefcurve1' => 1,
	'nefcurve2' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'nexttrackid' => 1,
	'nikon' => 1,
	'nikoncapturedata' => 1,
	'nikoncaptureoffsets' => 1,
	'nikonpreview' => 1,
	'nikontags' => 1,
	'noise' => 1,
	'noisereductiondata' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'npts' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofinks' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numstreams' => 1,
	'objectid' => 1,
	'objectsizeannounced' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'offsetorigin' => 1,
	'offsetxy' => 1,
	'olympus' => 1,
	'opacity' => 1,
	'operation' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'opticalzoom' => 1,
	'optimalbitrate' => 1,
	'opto-electricconvfactor' => 1,
	'orderingrestrictions' => 1,
	'originalalbum' => 1,
	'originalalbumtitle' => 1,
	'originalartist' => 1,
	'originaldocumentsize' => 1,
	'originalimagebroker' => 1,
	'originallyricist' => 1,
	'originalmakernoteoffset' => 1,
	'originalmedia' => 1,
	'originalmedium' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'otherimagelength' => 1,
	'otherimagestart' => 1,
	'outputdataobjectlist' => 1,
	'outputprofile' => 1,
	'outputresponse' => 1,
	'packets' => 1,
	'padding' => 1,
	'page' => 1,
	'pagecount' => 1,
	'pages' => 1,
	'palette' => 1,
	'palettehistogram' => 1,
	'panasonic' => 1,
	'panasonicrawversion' => 1,
	'parentalrating' => 1,
	'parentalratingreason' => 1,
	'partialpalette' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'patternangle' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdf' => 1,
	'peakbitrate' => 1,
	'peakvalue' => 1,
	'pentax' => 1,
	'pentaxtags' => 1,
	'people' => 1,
	'performers' => 1,
	'performersortorder' => 1,
	'period' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'photoeffectsdata' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopsettings' => 1,
	'photoshopthumbnail' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'picture' => 1,
	'pieceinfo' => 1,
	'pixelaspectratio' => 1,
	'pixelcalibration' => 1,
	'pixelformat' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelscale' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixelsperunitx' => 1,
	'pixelsperunity' => 1,
	'pixelunits' => 1,
	'places' => 1,
	'planes' => 1,
	'playallframes' => 1,
	'playcounter' => 1,
	'playduration' => 1,
	'playlistdelay' => 1,
	'playselection' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2csa' => 1,
	'preferredrate' => 1,
	'preferredvolume' => 1,
	'preroll' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewdate' => 1,
	'previewdescription' => 1,
	'previewduration' => 1,
	'previewifd_offset' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewmimetype' => 1,
	'previewpict' => 1,
	'previewtime' => 1,
	'previewtype' => 1,
	'previewversion' => 1,
	'primaryplatform' => 1,
	'printflags' => 1,
	'printflagsinfo' => 1,
	'printquality' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'private' => 1,
	'proccessinginfo' => 1,
	'producednotice' => 1,
	'product' => 1,
	'profile' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecopyright' => 1,
	'profilecreator' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profilesequencedesc' => 1,
	'profiletype' => 1,
	'profileversion' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'projectedcstype' => 1,
	'projection' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'promotionurl' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protectiontype' => 1,
	'provider' => 1,
	'providercopyright' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'ps2crdvmsize' => 1,
	'ps2renteringintent' => 1,
	'pstringcaption' => 1,
	'publisherurl' => 1,
	'quickmaskinfo' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rasterpadding' => 1,
	'rawdata' => 1,
	'rawdatarotation' => 1,
	'rawdevelopment' => 1,
	'rawimagemode' => 1,
	'rawinfo' => 1,
	'rawjpginfo' => 1,
	'readerrequirements' => 1,
	'reconstructiontype' => 1,
	'recordingdates' => 1,
	'recordingtime' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'redadjust' => 1,
	'redeyedata' => 1,
	'redeyereduction' => 1,
	'redgain' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'reductionmatrix1' => 1,
	'reductionmatrix2' => 1,
	'redx' => 1,
	'redy' => 1,
	'relatedimagefile' => 1,
	'relatedimagefileformat' => 1,
	'renderingintent' => 1,
	'requirements' => 1,
	'reserved1' => 1,
	'resolutioninfo' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resultaspectratio' => 1,
	'revisionnumber' => 1,
	'rgb_profile' => 1,
	'ricoh' => 1,
	'ricohdatetime1' => 1,
	'ricohdatetime2' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rjmd' => 1,
	'roidescription' => 1,
	'rollguidelements' => 1,
	'root' => 1,
	'rotationangle' => 1,
	'sampleformat' => 1,
	'samplerate2' => 1,
	'samplesize' => 1,
	'saturationsetting' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbaexposurerecord' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'scale' => 1,
	'scalefactor35efl' => 1,
	'scandate' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerserialnumber' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'scriptcommand' => 1,
	'security' => 1,
	'seekable' => 1,
	'seekpoint' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'sendduration' => 1,
	'sensorbottomborder' => 1,
	'sensorid' => 1,
	'sensorinfo' => 1,
	'sensorleftborder' => 1,
	'sensorrightborder' => 1,
	'sensortopborder' => 1,
	'serviceorganizationname' => 1,
	'setsubtitle' => 1,
	'shadowendpoints' => 1,
	'shareduserrating' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sigma' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'significantbits' => 1,
	'simpleindex' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'site' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'slices' => 1,
	'slideshow' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'softwarerelease' => 1,
	'sony' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimagevolumename' => 1,
	'sourceurl' => 1,
	'spatialfrequencyresponse' => 1,
	'spatialorientation' => 1,
	'specialeffectsopticalfilter' => 1,
	'spothalftone' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srf2_key' => 1,
	'srgbrendering' => 1,
	'stbl' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitrateprops' => 1,
	'streamcount' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamstarttime' => 1,
	'streamtype' => 1,
	'streamtypeinfo' => 1,
	'stridable' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'subifd' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimageheader' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subsecdatetimeoriginal' => 1,
	'subtitle' => 1,
	'subtitledescription' => 1,
	'suggestedpalette' => 1,
	'summaryinfo' => 1,
	't4options' => 1,
	't6options' => 1,
	'taggingtime' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targetprinter' => 1,
	'targetxy' => 1,
	'technician' => 1,
	'technology' => 1,
	'template' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'text' => 1,
	'textinfo' => 1,
	'textualdata' => 1,
	'things' => 1,
	'thumbnail' => 1,
	'thumbnailclip' => 1,
	'thumbnailresource' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tileoffsets' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timeoffset' => 1,
	'timescale' => 1,
	'titlelen' => 1,
	'titlesortorder' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonespaceflow' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topmag' => 1,
	'totaledittime' => 1,
	'track' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackcreatedate' => 1,
	'trackduration' => 1,
	'trackheader' => 1,
	'trackid' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackmodifydate' => 1,
	'trackversion' => 1,
	'trackvolume' => 1,
	'transferrange' => 1,
	'transfomation' => 1,
	'transform' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentindex' => 1,
	'trapped' => 1,
	'typeoforiginal' => 1,
	'ucrbg' => 1,
	'uncompressed' => 1,
	'unicodealphanames' => 1,
	'uniquefileidentifier' => 1,
	'units' => 1,
	'unknown' => 1,
	'unknownblock1' => 1,
	'unknownblock2' => 1,
	'unknowntags' => 1,
	'unsharpdata' => 1,
	'unused' => 1,
	'url_list' => 1,
	'usedextensionnumbers' => 1,
	'useradjsba_rgbshifts' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'userselectgrouptitle' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'uuid-geojp2' => 1,
	'uuid-unknown' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validpixeldepth' => 1,
	'vbrpeak' => 1,
	'vendorid' => 1,
	'version2' => 1,
	'versioninfo' => 1,
	'versionyear' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videobitrate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecname' => 1,
	'videoheight' => 1,
	'videomode' => 1,
	'videoquality' => 1,
	'videowidth' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'visibleoutputs' => 1,
	'wangannotation' => 1,
	'warning' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'wb_bluelevel' => 1,
	'wb_grbglevels' => 1,
	'wb_greenlevel' => 1,
	'wb_rblevelsauto' => 1,
	'wb_rblevelscloudy' => 1,
	'wb_rblevelscoolwhitefluor' => 1,
	'wb_rblevelsdaylightfluor' => 1,
	'wb_rblevelsdaywhitefluor' => 1,
	'wb_rblevelseveningsunlight' => 1,
	'wb_rblevelsfineweather' => 1,
	'wb_rblevelsshade' => 1,
	'wb_rblevelstungsten' => 1,
	'wb_rblevelsused' => 1,
	'wb_rblevelswhitefluorescent' => 1,
	'wb_redlevel' => 1,
	'wbadjdata' => 1,
	'whitebalancecomp' => 1,
	'whitebalancematching' => 1,
	'whitebalancetable' => 1,
	'whitelevel' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'wide' => 1,
	'widthresolution' => 1,
	'windowlocation' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'wordcount' => 1,
	'workflowurl' => 1,
	'workingpath' => 1,
	'writer' => 1,
	'xclippathunits' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xml' => 1,
	'xmldata' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpmm' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yclippathunits' => 1,
	'year' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'ytarget' => 1,
	'zoom' => 1,
	'zoompos' => 1,
);

#++++ End automatically generated code ++++

# insert any user-defined tags into our tag lookup
if (defined %Image::ExifTool::UserDefined) {
    my ($table, %tableNum, $tagID);
    my $tnum = 0; # make hash lookup to get table numbers
    foreach $table (@tableList) {
        $tableNum{$table} = $tnum++;
    }
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        $tnum = $tableNum{$table};
        unless ($tnum) {
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $userTable = $Image::ExifTool::UserDefined{$table};
        foreach $tagID (Image::ExifTool::TagTableKeys($userTable)) {
            my $newInfo = $$userTable{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = ucfirst($tagID);
            } else {
                $newInfo = $$userTable{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc($$newInfo{Name});
            # add to lookup even though we don't know it is writable
            # (to save speed by not having to load the module)
            my $lookup = $tagLookup{$lcTag};
            $lookup or $lookup = $tagLookup{$lcTag} = { };
            if ($$lookup{$tnum}) {
                my $le = $$lookup{$tnum};
                my @ids = (ref $le eq 'ARRAY') ? @{$le} : ( $le );
                # only add new tag ID if it didn't already exist
                next if grep /^$tagID$/, @ids;
                push @ids, $tagID;
                $$lookup{$tnum} = \@ids;
            } else {
                $$lookup{$tnum} = $tagID;
            }
            # add any new subdirectory tables
            next unless $$newInfo{SubDirectory};
            my $subTable = $newInfo->{SubDirectory}->{TagTable};
            next unless $subTable and not defined $tableNum{$subTable};
            next if $Image::ExifTool::UserDefined{$subTable};
            no strict 'refs';
            next unless defined %$subTable;
            $Image::ExifTool::UserDefined{$subTable} = \%$subTable;
            push @userTables, $subTable;
            # save parent table name so we can load it when necessary
            $$subTable{PARENT} = $table;
        }
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList);
    my $lookup = $tagLookup{$lcTag};
    if ($lookup) {
        foreach $tableNum (keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $tagID = $$lookup{$tableNum};
            my @tagIDs;
            if (ref $tagID eq 'ARRAY') {
                @tagIDs = @$tagID;
            } else {
                push @tagIDs, $tagID;
            }
            foreach $tagID (@tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    if ($writeProc) {
                        &$writeProc();
                        @infoList = GetTagInfoList($table,$tagID);
                    }
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2006, Phil Harvey (phil at owl.phy.queensu.ca)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
