<?php
/**
 * The Text_Filter_emails:: class finds email addresses in a block of text and
 * turns them into links.
 *
 * Parameters:
 * <pre>
 * always_mailto -- If true, a mailto: link is generated always.  Only if no
 *                  mail/compose registry API method exists otherwise.
 * class         -- CSS class of the generated <a> tag.  Defaults to none.
 * </pre>
 *
 * $Horde: framework/Text_Filter/Filter/emails.php,v 1.15.10.4.2.1 2005/10/25 12:27:56 jan Exp $
 *
 * Copyright 2003-2005 Tyler Colbert <tyler-hordeml@colberts.us>
 * Copyright 2004-2005 Jan Schneider <jan@horde.org>
 *
 * See the enclosed file COPYING for license information (LGPL). If you did not
 * receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 *
 * @author Tyler Colbert <tyler-hordeml@colberts.us>
 * @author Jan Schneider <jan@horde.org>
 * @package Horde_Text
 */
class Text_Filter_emails extends Text_Filter {

    /**
     * Filter parameters.
     *
     * @var array
     */
    var $_params = array('always_mailto' => false,
                         'class' => '',
                         'capital_tags' => false);

    /**
     * Returns a hash with replace patterns.
     *
     * @return array  Patterns hash.
     */
    function getPatterns()
    {
        global $registry;

        $class = empty($this->_params['class']) ? '' : ' class="' . $this->_params['class'] . '"';
        $tag = $this->_params['capital_tags'] ? 'A' : 'a';

        $regexp = <<<EOR
            /
            # Version 1: mailto: links with any valid email characters.
            # Pattern 1: Outlook parenthesizes in sqare brackets
            (\[\s*)?
            # Pattern 2: mailto: protocol prefix
            (mailto:\s?)
            # Pattern 3: email address
            ([^\s\?"<]*)
            # Pattern 4 to 6: Optional parameters
            ((\?)([^\s"<]*[\w+#?\/&=]))?
            # Pattern 7: Closing Outlook square bracket
            ((?(1)\s*\]))

            |
            # Version 2 Pattern 8: simple email addresses.
            (\b[\w-+.=]+@[-A-Z0-9.]*[A-Z0-9])
            # Pattern 9 to 11: Optional parameters
            ((\?)([^\s"<]*[\w+#?\/&=]))?

            /eix
EOR;

        if (is_a($registry, 'Registry') &&
            $registry->hasMethod('mail/compose') &&
            !$this->_params['always_mailto']) {
            /* If we have a mail/compose registry method, use it. */
            $replacement = <<<EOP
                '$8' === '' ?

                '$1$2<$tag$class href="' .
                str_replace('&amp;', '&', \$GLOBALS['registry']->call('mail/compose', array(array('to' => '$3'), call_user_func(create_function('\$a', '\$p=array();foreach(\$a as \$b){\$b=explode("=",\$b,2);\$p[\$b[0]]=@\$b[1];}return \$p;'), explode('&', '$6'))))) .
                '" onmouseover="window.status=\'' .
                addslashes(sprintf(_("Compose Message (%s)"), '$3')) .
                '\'; return true;" onmouseout="window.status=\'\';">$3$4</$tag>$7' :

                '<$tag$class href="' .
                str_replace('&amp;', '&', \$GLOBALS['registry']->call('mail/compose', array(array('to' => '$8')), '&$11')) .
                '" onmouseover="window.status=\'' .
                addslashes(sprintf(_("Compose Message (%s)"), '$8')) .
                '\'; return true;" onmouseout="window.status=\'\';">$8$9</$tag>'
EOP;
        } else {
            /* Otherwise, generate a standard mailto: and let the
             * browser handle it. */
            $replacement = <<<EOP
                '$8' === '' ?

                '$1$2<$tag$class href="mailto:$3$4" onmouseover="window.status=\'' .
                addslashes(sprintf(_("Compose Message (%s)"), '$3')) .
                '\'; return true;" onmouseout="window.status=\'\';">$3$4</$tag>$7' :

                '<$tag$class href="mailto:$8$9" onmouseover="window.status=\'' .
                addslashes(sprintf(_("Compose Message (%s)"), '$8')) .
                '\'; return true;" onmouseout="window.status=\'\';">$8$9</$tag>'
EOP;
        }

        return array('regexp' => array($regexp => $replacement));
    }

}
