<?php

include_once 'Horde/SyncML/Command.php';

/**
 * The Horde_SyncML_Command_Final class.
 *
 * $Horde: framework/SyncML/SyncML/Command/Final.php,v 1.10.10.3 2005/07/07 14:59:01 chuck Exp $
 *
 * Copyright 2003-2005 Anthony Mills <amills@pyramid6.com>
 *
 * See the enclosed file COPYING for license information (LGPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 *
 * @author  Anthony Mills <amills@pyramid6.com>
 * @since   Horde 3.0
 * @package Horde_SyncML
 */
class Horde_SyncML_Command_Final extends Horde_SyncML_Command {

    function output($currentCmdID, &$output)
    {
        $state = &$_SESSION['SyncML.state'];
        $attrs = array();

        // If the client hasn't sent us device info, request it now.
        $di = SyncML_Device::deviceInfo();
        if (empty($di->_Man)) {
            $output->startElement($state->getURI(), 'Get', $attrs);

            $output->startElement($state->getURI(), 'CmdID', $attrs);
            $chars = $currentCmdID;
            $output->characters($chars);
            $output->endElement($state->getURI(), 'CmdID');

            $output->startElement($state->getURI(), 'Meta', $attrs);
            $attrs[] = array(
                'attribute'=>'xmlns',
                'value'    =>'syncml:metinf'
            );
            $output->startElement($state->getURI(), 'Type', $attrs);
            $attrs = array();
            $chars = 'application/vnd.syncml-devinf+xml';
            $output->characters($chars);
            $output->endElement($state->getURI(), 'Type');
            $output->endElement($state->getURI(), 'Meta');

            $output->startElement($state->getURI(), 'Item', $attrs);
            $output->startElement($state->getURI(), 'Target', $attrs);
            $output->startElement($state->getURI(), 'LocURI', $attrs);
            $chars = './devinf11';
            $output->characters($chars);
            $output->endElement($state->getURI(), 'LocURI');
            $output->endElement($state->getURI(), 'Target');
            $output->endElement($state->getURI(), 'Item');

            $output->endElement($state->getURI(), 'Get');

            // Mark this id down as needing a results packet routed to
            // the Put command.
            $state->setExpectedResultType($currentCmdID, 'Put');

            $currentCmdID++;
        }

        $output->startElement($state->getURI(), 'Final', $attrs);
        $output->endElement($state->getURI(), 'Final');

        return $currentCmdID;
    }

}
