/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.sourcelookup;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.internal.ui.contexts.DebugContextManager;
import org.eclipse.debug.internal.ui.contexts.provisional.IDebugContextListener;
import org.eclipse.debug.internal.ui.contexts.provisional.ISourceDisplayAdapter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

public class SourceLookupService
implements IDebugContextListener,
ISourceDisplayAdapter {
    private IWorkbenchWindow fWindow;

    public SourceLookupService(IWorkbenchWindow window) {
        this.fWindow = window;
        DebugContextManager.getDefault().addDebugContextListener(this, window);
    }

    public void dispose() {
        DebugContextManager.getDefault().removeDebugContextListener(this, this.fWindow);
    }

    public synchronized void contextActivated(ISelection selection, IWorkbenchPart part) {
        IStructuredSelection structuredSelection;
        if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 1) {
            Object context = structuredSelection.getFirstElement();
            IWorkbenchPage page = null;
            page = part == null ? this.fWindow.getActivePage() : part.getSite().getPage();
            this.displaySource(context, page, false);
        }
    }

    public void contextChanged(ISelection selection, IWorkbenchPart part) {
    }

    public void displaySource(Object context, IWorkbenchPage page, boolean forceSourceLookup) {
        IAdaptable adaptable;
        ISourceDisplayAdapter adapter;
        if (context instanceof IAdaptable && (adapter = (ISourceDisplayAdapter)(adaptable = (IAdaptable)context).getAdapter(ISourceDisplayAdapter.class)) != null) {
            adapter.displaySource(context, page, forceSourceLookup);
        }
    }
}

