/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.PageEventAction;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;

public class SaveAllAction
extends PageEventAction
implements IPropertyListener {
    private List partsWithListeners = new ArrayList(1);
    private IWorkbenchPart openPart;

    public SaveAllAction(IWorkbenchWindow window) {
        super(WorkbenchMessages.SaveAll_text, window);
        this.setToolTipText(WorkbenchMessages.SaveAll_toolTip);
        this.setId("saveAll");
        this.setEnabled(false);
        window.getWorkbench().getHelpSystem().setHelp(this, "org.eclipse.ui.save_all_action_context");
        this.setImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_ETOOL_SAVEALL_EDIT"));
        this.setDisabledImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_ETOOL_SAVEALL_EDIT_DISABLED"));
        this.setActionDefinitionId("org.eclipse.ui.file.saveAll");
    }

    public void pageActivated(IWorkbenchPage page) {
        super.pageActivated(page);
        this.updateState();
    }

    public void pageClosed(IWorkbenchPage page) {
        super.pageClosed(page);
        this.updateState();
    }

    public void partClosed(IWorkbenchPart part) {
        super.partClosed(part);
        if (part instanceof ISaveablePart) {
            part.removePropertyListener(this);
            this.partsWithListeners.remove(part);
            this.updateState();
        }
    }

    public void partOpened(IWorkbenchPart part) {
        super.partOpened(part);
        if (part instanceof ISaveablePart) {
            part.addPropertyListener(this);
            this.partsWithListeners.add(part);
            this.openPart = part;
            this.updateState();
            this.openPart = null;
        }
    }

    public void propertyChanged(Object source, int propID) {
        if (source instanceof ISaveablePart && propID == 257) {
            this.updateState();
        }
    }

    public void run() {
        if (this.getWorkbenchWindow() == null) {
            return;
        }
        IWorkbenchPage page = this.getActivePage();
        if (page != null) {
            page.saveAllEditors(false);
        }
    }

    protected void updateState() {
        if (this.openPart != null && this.openPart.getSite().getPage().equals(this.getActivePage()) && ((ISaveablePart)((Object)this.openPart)).isDirty()) {
            this.setEnabled(true);
        } else {
            WorkbenchPage page = (WorkbenchPage)this.getActivePage();
            this.setEnabled(page != null && page.getDirtyParts().length > 0);
        }
    }

    public void dispose() {
        super.dispose();
        for (IWorkbenchPart part : this.partsWithListeners) {
            part.removePropertyListener(this);
        }
        this.partsWithListeners.clear();
    }
}

