/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.structuremergeviewer;

import com.ibm.icu.text.MessageFormat;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.util.Assert;

public class Differencer {
    public static final int NO_CHANGE = 0;
    public static final int ADDITION = 1;
    public static final int DELETION = 2;
    public static final int CHANGE = 3;
    public static final int CHANGE_TYPE_MASK = 3;
    public static final int LEFT = 4;
    public static final int RIGHT = 8;
    public static final int CONFLICTING = 12;
    public static final int DIRECTION_MASK = 12;
    public static final int PSEUDO_CONFLICT = 16;

    public Object findDifferences(boolean threeWay, IProgressMonitor pm, Object data, Object ancestor, Object left, Object right) {
        List l;
        Node root = new Node();
        int code = this.traverse(threeWay, root, pm, threeWay ? ancestor : null, left, right);
        if (code != 0 && (l = root.fChildren).size() > 0) {
            Node first = (Node)l.get(0);
            return first.visit(this, data, 0);
        }
        return null;
    }

    private int traverse(boolean threeWay, Node parent, IProgressMonitor pm, Object ancestor, Object left, Object right) {
        Object[] ancestorChildren = this.getChildren(ancestor);
        Object[] rightChildren = this.getChildren(right);
        Object[] leftChildren = this.getChildren(left);
        int code = 0;
        Node node = new Node(parent, ancestor, left, right);
        boolean content = true;
        if ((threeWay && ancestorChildren != null || !threeWay) && rightChildren != null && leftChildren != null) {
            int i;
            HashSet<Object> allSet = new HashSet<Object>(20);
            HashMap<Object, Object> ancestorSet = null;
            HashMap<Object, Object> rightSet = null;
            HashMap<Object, Object> leftSet = null;
            if (ancestorChildren != null) {
                ancestorSet = new HashMap<Object, Object>(10);
                i = 0;
                while (i < ancestorChildren.length) {
                    Object object = ancestorChildren[i];
                    ancestorSet.put(object, object);
                    allSet.add(object);
                    ++i;
                }
            }
            if (rightChildren != null) {
                rightSet = new HashMap<Object, Object>(10);
                i = 0;
                while (i < rightChildren.length) {
                    Object object = rightChildren[i];
                    rightSet.put(object, object);
                    allSet.add(object);
                    ++i;
                }
            }
            if (leftChildren != null) {
                leftSet = new HashMap<Object, Object>(10);
                i = 0;
                while (i < leftChildren.length) {
                    Object object = leftChildren[i];
                    leftSet.put(object, object);
                    allSet.add(object);
                    ++i;
                }
            }
            for (Object e : allSet) {
                Object rightChild;
                Object leftChild;
                Object ancestorChild;
                int c;
                content = false;
                if (pm != null) {
                    if (pm.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    this.updateProgress(pm, e);
                }
                if (((c = this.traverse(threeWay, node, pm, ancestorChild = ancestorSet != null ? ancestorSet.get(e) : null, leftChild = leftSet != null ? leftSet.get(e) : null, rightChild = rightSet != null ? rightSet.get(e) : null)) & 3) == 0) continue;
                code |= 3;
                code |= c & 0xC;
            }
        }
        if (content) {
            code = this.compare(threeWay, ancestor, left, right);
        }
        node.fCode = code;
        return code;
    }

    protected Object visit(Object data, int result, Object ancestor, Object left, Object right) {
        return new DiffNode((IDiffContainer)data, result, (ITypedElement)ancestor, (ITypedElement)left, (ITypedElement)right);
    }

    private int compare(boolean threeway, Object ancestor, Object left, Object right) {
        int description = 0;
        if (threeway) {
            if (ancestor == null) {
                if (left == null) {
                    if (right == null) {
                        Assert.isTrue((boolean)false);
                    } else {
                        description = 9;
                    }
                } else if (right == null) {
                    description = 5;
                } else {
                    description = 13;
                    if (this.contentsEqual(left, right)) {
                        description |= 0x10;
                    }
                }
            } else if (left == null) {
                description = right == null ? 30 : (this.contentsEqual(ancestor, right) ? 6 : 15);
            } else if (right == null) {
                description = this.contentsEqual(ancestor, left) ? 10 : 15;
            } else {
                boolean ay = this.contentsEqual(ancestor, left);
                boolean am = this.contentsEqual(ancestor, right);
                if (!ay || !am) {
                    if (ay && !am) {
                        description = 11;
                    } else if (!ay && am) {
                        description = 7;
                    } else {
                        description = 15;
                        if (this.contentsEqual(left, right)) {
                            description |= 0x10;
                        }
                    }
                }
            }
        } else if (left == null) {
            if (right == null) {
                Assert.isTrue((boolean)false);
            } else {
                description = 1;
            }
        } else if (right == null) {
            description = 2;
        } else if (!this.contentsEqual(left, right)) {
            description = 3;
        }
        return description;
    }

    /*
     * Exception decompiling
     */
    protected boolean contentsEqual(Object input1, Object input2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [22[DOLOOP]], but top level block is 7[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private InputStream getStream(Object o) {
        if (o instanceof IStreamContentAccessor) {
            try {
                return ((IStreamContentAccessor)o).getContents();
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    protected Object[] getChildren(Object input) {
        if (input instanceof IStructureComparator) {
            return ((IStructureComparator)input).getChildren();
        }
        return null;
    }

    protected void updateProgress(IProgressMonitor progressMonitor, Object node) {
        if (node instanceof ITypedElement) {
            String name = ((ITypedElement)node).getName();
            String fmt = Utilities.getString("Differencer.progressFormat");
            String msg = MessageFormat.format((String)fmt, (Object[])new String[]{name});
            progressMonitor.subTask(msg);
        }
    }

    static class Node {
        List fChildren;
        int fCode;
        Object fAncestor;
        Object fLeft;
        Object fRight;

        Node() {
        }

        Node(Node parent, Object ancestor, Object left, Object right) {
            parent.add(this);
            this.fAncestor = ancestor;
            this.fLeft = left;
            this.fRight = right;
        }

        void add(Node child) {
            if (this.fChildren == null) {
                this.fChildren = new ArrayList();
            }
            this.fChildren.add(child);
        }

        Object visit(Differencer d, Object parent, int level) {
            if (this.fCode == 0) {
                return null;
            }
            Object data = d.visit(parent, this.fCode, this.fAncestor, this.fLeft, this.fRight);
            if (this.fChildren != null) {
                for (Node n : this.fChildren) {
                    n.visit(d, data, level + 1);
                }
            }
            return data;
        }
    }
}

