/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.datatransfer;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.ant.internal.ui.datatransfer.AppletUtil;
import org.eclipse.ant.internal.ui.datatransfer.DataTransferMessages;
import org.eclipse.ant.internal.ui.datatransfer.EclipseClasspath;
import org.eclipse.ant.internal.ui.datatransfer.ExportUtil;
import org.eclipse.ant.internal.ui.datatransfer.SourceAnalyzer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.SAXException;

public class BuildFileCreator {
    protected static final String IMPORT_BUILDFILE_PROCESSING_TARGET = "eclipse.ant.import";
    protected static final String WARNING = " WARNING: Eclipse auto-generated file." + ExportUtil.NEWLINE + "              Any modifications will be overwritten.";
    protected static final String NOTE = "              To include a user specific buildfile here, simply create one in the same" + ExportUtil.NEWLINE + "              directory with the processing instruction " + "<?" + "eclipse.ant.import" + "?>" + ExportUtil.NEWLINE + "              as the first entry and export the buildfile again. ";
    protected static String BUILD_XML = "build.xml";
    protected static String JUNIT_OUTPUT_DIR = "junit";
    protected static boolean CHECK_SOURCE_CYCLES = true;
    protected static boolean CREATE_ECLIPSE_COMPILE_TARGET = true;
    private Document doc;
    private Element root;
    private IJavaProject project;
    private String projectName;
    private String projectRoot;
    private Map variable2valueMap;
    private Shell shell;
    private Set visited = new TreeSet();
    private Node classpathNode;

    private BuildFileCreator() {
    }

    public BuildFileCreator(IJavaProject project, Shell shell) throws ParserConfigurationException {
        this.project = project;
        this.projectName = project.getProject().getName();
        this.projectRoot = ExportUtil.getProjectRoot(project);
        this.variable2valueMap = new LinkedHashMap();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        this.doc = dbf.newDocumentBuilder().newDocument();
        this.shell = shell;
    }

    public static List createBuildFiles(Set projects, Shell shell, IProgressMonitor pm) throws JavaModelException, ParserConfigurationException, TransformerConfigurationException, TransformerException, IOException, CoreException, InterruptedException {
        ArrayList res = new ArrayList();
        try {
            BuildFileCreator.createBuildFilesLoop(projects, shell, pm, res);
        }
        finally {
            if (pm != null) {
                pm.done();
            }
        }
        return res;
    }

    private static void createBuildFilesLoop(Set projects, Shell shell, IProgressMonitor pm, List res) throws CoreException, ParserConfigurationException, JavaModelException, TransformerConfigurationException, TransformerFactoryConfigurationError, TransformerException, UnsupportedEncodingException, InterruptedException {
        ArrayList<IFile> files = new ArrayList<IFile>();
        for (IJavaProject currentProject : projects) {
            IFile file = currentProject.getProject().getFile(BUILD_XML);
            files.add(file);
        }
        Map validator2files = ExportUtil.getFileModificationValidator(files);
        Set confirmedFiles = ExportUtil.validateEdit(shell, validator2files);
        if (pm != null) {
            pm.beginTask(DataTransferMessages.AntBuildfileExportPage_0, confirmedFiles.size());
        }
        int i = 0;
        for (IJavaProject currentProject : projects) {
            IFile file = currentProject.getProject().getFile(BUILD_XML);
            if (confirmedFiles.contains(file)) {
                if (pm != null) {
                    pm.subTask(currentProject.getProject().getName());
                }
                BuildFileCreator instance = new BuildFileCreator(currentProject, shell);
                instance.createRoot();
                instance.createImports();
                EclipseClasspath classpath = new EclipseClasspath(currentProject);
                if (CHECK_SOURCE_CYCLES) {
                    SourceAnalyzer.checkCycles(currentProject, classpath, shell);
                }
                instance.createClasspaths(classpath);
                instance.createInit(classpath.srcDirs, classpath.classDirs);
                instance.createClean(classpath.classDirs);
                instance.createCleanAll();
                instance.createBuild(classpath.srcDirs, classpath.classDirs, classpath.inclusionLists, classpath.exclusionLists);
                instance.createBuildRef();
                if (CREATE_ECLIPSE_COMPILE_TARGET) {
                    instance.addInitEclipseCompiler();
                    instance.addBuildEclipse();
                }
                instance.createRun();
                instance.addSubProperties(currentProject, classpath);
                instance.createProperty();
                String xml = ExportUtil.toString(instance.doc);
                ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes("UTF-8"));
                if (file.exists()) {
                    file.setContents((InputStream)is, true, true, null);
                } else {
                    file.create((InputStream)is, true, null);
                }
                if (pm != null) {
                    pm.worked(1);
                    if (pm.isCanceled()) {
                        throw new InterruptedException();
                    }
                }
                res.add(instance.projectName);
            }
            ++i;
        }
    }

    public void createProperty() {
        boolean source = "generate".equals(this.project.getOption("org.eclipse.jdt.core.compiler.debug.sourceFile", true));
        boolean lines = "generate".equals(this.project.getOption("org.eclipse.jdt.core.compiler.debug.lineNumber", true));
        boolean vars = "generate".equals(this.project.getOption("org.eclipse.jdt.core.compiler.debug.localVariable", true));
        ArrayList<String> debuglevel = new ArrayList<String>();
        if (source) {
            debuglevel.add("source");
        }
        if (lines) {
            debuglevel.add("lines");
        }
        if (vars) {
            debuglevel.add("vars");
        }
        if (debuglevel.size() == 0) {
            debuglevel.add("none");
        }
        this.variable2valueMap.put("debuglevel", ExportUtil.toString(debuglevel, ","));
        String target = this.project.getOption("org.eclipse.jdt.core.compiler.codegen.targetPlatform", true);
        this.variable2valueMap.put("target", target);
        String sourceLevel = this.project.getOption("org.eclipse.jdt.core.compiler.source", true);
        this.variable2valueMap.put("source", sourceLevel);
        boolean first = true;
        Node node = this.root.getFirstChild();
        for (String key : this.variable2valueMap.keySet()) {
            String value = (String)this.variable2valueMap.get(key);
            Element prop = this.doc.createElement("property");
            prop.setAttribute("name", key);
            prop.setAttribute("value", value);
            if (first) {
                first = false;
            } else {
                node = node.getNextSibling();
            }
            node = this.root.insertBefore(prop, node);
        }
        Element env = this.doc.createElement("property");
        env.setAttribute("environment", "env");
        this.root.insertBefore(env, this.root.getFirstChild());
    }

    public void createRoot() {
        this.root = this.doc.createElement("project");
        this.root.setAttribute("name", this.projectName);
        this.root.setAttribute("default", "build");
        this.root.setAttribute("basedir", ".");
        this.doc.appendChild(this.root);
        Comment comment = this.doc.createComment(String.valueOf(WARNING) + ExportUtil.NEWLINE + NOTE);
        this.doc.insertBefore(comment, this.root);
    }

    public void createImports() {
        File dir = new File(this.projectRoot);
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File acceptDir, String name) {
                return name.endsWith(".xml") && !name.endsWith(BUILD_XML);
            }
        };
        File[] files = dir.listFiles(filter);
        if (files == null) {
            return;
        }
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            try {
                Document docCandidate = ExportUtil.parseXmlFile(file);
                Node node = docCandidate.getFirstChild();
                if (node instanceof ProcessingInstruction && IMPORT_BUILDFILE_PROCESSING_TARGET.equals(((ProcessingInstruction)node).getTarget().trim())) {
                    Element element = this.doc.createElement("import");
                    element.setAttribute("file", file.getName());
                    this.root.appendChild(element);
                }
            }
            catch (ParserConfigurationException e) {
                AntUIPlugin.log("invalid XML file not imported: " + file.getAbsolutePath(), e);
            }
            catch (SAXException e) {
                AntUIPlugin.log("invalid XML file not imported: " + file.getAbsolutePath(), e);
            }
            catch (IOException e) {
                AntUIPlugin.log("invalid XML file not imported: " + file.getAbsolutePath(), e);
            }
            ++i;
        }
    }

    public void createClasspaths(EclipseClasspath classpath) throws JavaModelException {
        this.createClasspaths(null, this.project, classpath);
    }

    public void createClasspaths(String pathId, IJavaProject currentProject, EclipseClasspath classpath) throws JavaModelException {
        if (currentProject == null) {
            AntUIPlugin.log("project is not loaded in workspace: " + pathId, null);
            return;
        }
        Element element = this.doc.createElement("path");
        if (pathId == null) {
            pathId = String.valueOf(currentProject.getProject().getName()) + ".classpath";
        }
        element.setAttribute("id", pathId);
        this.visited.add(pathId);
        this.variable2valueMap.putAll(classpath.variable2valueMap);
        for (String entry : ExportUtil.removeDuplicates(classpath.rawClassPathEntries)) {
            String currentProjectRoot;
            if (EclipseClasspath.isProjectReference(entry)) {
                Element pathElement = this.doc.createElement("path");
                IJavaProject referencedProject = EclipseClasspath.resolveProjectReference(entry);
                if (referencedProject == null) {
                    AntUIPlugin.log("project is not loaded in workspace: " + pathId, null);
                    continue;
                }
                String refPathId = String.valueOf(referencedProject.getProject().getName()) + ".classpath";
                pathElement.setAttribute("refid", refPathId);
                element.appendChild(pathElement);
                if (!this.visited.add(refPathId)) continue;
                this.createClasspaths(null, referencedProject, new EclipseClasspath(referencedProject));
                continue;
            }
            if (EclipseClasspath.isUserLibraryReference(entry) || EclipseClasspath.isUserSystemLibraryReference(entry) || EclipseClasspath.isLibraryReference(entry)) {
                this.addUserLibrary(element, entry);
                continue;
            }
            String prefix = "";
            if (!(entry.startsWith("${") || this.projectName.equals(currentProject.getProject().getName()) || new Path(entry = ExportUtil.getRelativePath(entry, currentProjectRoot = ExportUtil.getProjectRoot(currentProject))).isAbsolute())) {
                prefix = "${" + currentProject.getProject().getName() + ".location}/";
            }
            Element pathElement = this.doc.createElement("pathelement");
            String path = ExportUtil.getRelativePath(String.valueOf(prefix) + entry, this.projectRoot);
            pathElement.setAttribute("location", path);
            element.appendChild(pathElement);
        }
        this.addToClasspathBlock(element);
    }

    private void addUserLibrary(Element element, String entry) {
        Element pathElement = this.doc.createElement("path");
        IClasspathContainer container = EclipseClasspath.resolveUserLibraryReference(entry);
        String name = ExportUtil.removePrefixAndSuffix(entry, "${", "}");
        pathElement.setAttribute("refid", name);
        if (!EclipseClasspath.isUserSystemLibraryReference(entry)) {
            element.appendChild(pathElement);
        }
        if (this.visited.add(entry)) {
            Element userElement = this.doc.createElement("path");
            userElement.setAttribute("id", name);
            IClasspathEntry[] entries = container.getClasspathEntries();
            int i = 0;
            while (i < entries.length) {
                String jarFile = entries[i].getPath().toString();
                if (EclipseClasspath.isLibraryReference(entry)) {
                    IPath home = JavaCore.getClasspathVariable((String)"ECLIPSE_HOME");
                    if (home.isPrefixOf(entries[i].getPath())) {
                        this.variable2valueMap.put("ECLIPSE_HOME", home.toString());
                        jarFile = "${ECLIPSE_HOME}" + jarFile.substring(home.toString().length());
                    } else if (!new File(jarFile).exists() && jarFile.startsWith(String.valueOf('/') + this.projectName) && new File(this.projectRoot, jarFile.substring((String.valueOf('/') + this.projectName).length())).exists()) {
                        jarFile = jarFile.substring((String.valueOf('/') + this.projectName).length() + 1);
                    }
                }
                jarFile = ExportUtil.getRelativePath(jarFile, this.projectRoot);
                Element userPathElement = this.doc.createElement("pathelement");
                userPathElement.setAttribute("location", jarFile);
                userElement.appendChild(userPathElement);
                ++i;
            }
            this.addToClasspathBlock(userElement);
        }
    }

    private void addToClasspathBlock(Element element) {
        if (this.classpathNode == null) {
            this.classpathNode = this.root.appendChild(element);
        } else {
            this.classpathNode = this.classpathNode.getNextSibling();
            this.classpathNode = this.root.insertBefore(element, this.classpathNode);
        }
    }

    public void addSubProperties(IJavaProject subproject, EclipseClasspath classpath) throws JavaModelException {
        for (IJavaProject subProject : ExportUtil.getClasspathProjectsRecursive(subproject)) {
            String location = String.valueOf(subProject.getProject().getName()) + ".location";
            String subProjectRoot = ExportUtil.getProjectRoot(subProject);
            String relativePath = ExportUtil.getRelativePath(subProjectRoot, this.projectRoot);
            this.variable2valueMap.put(location, relativePath);
            this.variable2valueMap.putAll(classpath.variable2valueMap);
        }
    }

    public void createInit(List srcDirs, List classDirs) {
        Element element = this.doc.createElement("target");
        element.setAttribute("name", "init");
        List classDirsUnique = ExportUtil.removeDuplicates(classDirs);
        for (String classDir : classDirsUnique) {
            if (classDir.equals(".") || EclipseClasspath.isReference(classDir)) continue;
            Element pathElement = this.doc.createElement("mkdir");
            pathElement.setAttribute("dir", classDir);
            element.appendChild(pathElement);
        }
        this.root.appendChild(element);
        this.createCopyResources(srcDirs, classDirs, element);
    }

    private void createCopyResources(List srcDirs, List classDirs, Element element) {
        String filter = this.project.getOption("org.eclipse.jdt.core.builder.resourceCopyExclusionFilter", true);
        StringTokenizer tokenizer = new StringTokenizer(filter, ",");
        List filters = Collections.list(tokenizer);
        filters.add("*.java");
        int i = 0;
        while (i < filters.size()) {
            String item = ((String)filters.get(i)).trim();
            if (item.equals("*")) {
                return;
            }
            filters.set(i, "**/" + item);
            ++i;
        }
        i = 0;
        while (i < srcDirs.size()) {
            String srcDir = (String)srcDirs.get(i);
            String classDir = (String)classDirs.get(i);
            if (!EclipseClasspath.isReference(classDir)) {
                Element copyElement = this.doc.createElement("copy");
                copyElement.setAttribute("todir", classDir);
                copyElement.setAttribute("includeemptydirs", "false");
                Element filesetElement = this.doc.createElement("fileset");
                filesetElement.setAttribute("dir", srcDir);
                filesetElement.setAttribute("excludes", ExportUtil.toString(filters, ", "));
                copyElement.appendChild(filesetElement);
                element.appendChild(copyElement);
            }
            ++i;
        }
    }

    public void createClean(List classDirs) {
        Element element = this.doc.createElement("target");
        element.setAttribute("name", "clean");
        List classDirUnique = ExportUtil.removeDuplicates(classDirs);
        for (String classDir : classDirUnique) {
            if (classDir.equals(".") || EclipseClasspath.isReference(classDir)) continue;
            Element deleteElement = this.doc.createElement("delete");
            deleteElement.setAttribute("dir", classDir);
            element.appendChild(deleteElement);
        }
        this.root.appendChild(element);
        if (classDirs.contains(".")) {
            Element deleteElement = this.doc.createElement("delete");
            Element filesetElement = this.doc.createElement("fileset");
            filesetElement.setAttribute("dir", ".");
            filesetElement.setAttribute("includes", "**/*.class");
            deleteElement.appendChild(filesetElement);
            element.appendChild(deleteElement);
        }
    }

    public void createCleanAll() throws JavaModelException {
        Element element = this.doc.createElement("target");
        element.setAttribute("name", "cleanall");
        element.setAttribute("depends", "clean");
        List subProjects = ExportUtil.getClasspathProjectsRecursive(this.project);
        for (IJavaProject subProject : subProjects) {
            Element antElement = this.doc.createElement("ant");
            antElement.setAttribute("antfile", "${" + subProject.getProject().getName() + ".location}/" + BUILD_XML);
            antElement.setAttribute("target", "clean");
            antElement.setAttribute("inheritAll", "false");
            element.appendChild(antElement);
        }
        this.root.appendChild(element);
    }

    public void createBuild(List srcDirs, List classDirs, List inclusionLists, List exclusionLists) throws JavaModelException {
        Element element = this.doc.createElement("target");
        element.setAttribute("name", "build");
        element.setAttribute("depends", "build-subprojects,build-project");
        this.root.appendChild(element);
        element = this.doc.createElement("target");
        element.setAttribute("name", "build-subprojects");
        List subProjects = ExportUtil.getClasspathProjectsRecursive(this.project);
        for (IJavaProject subProject : subProjects) {
            Element antElement = this.doc.createElement("ant");
            antElement.setAttribute("antfile", "${" + subProject.getProject().getName() + ".location}/" + BUILD_XML);
            antElement.setAttribute("target", "build-project");
            antElement.setAttribute("inheritAll", "false");
            if (CREATE_ECLIPSE_COMPILE_TARGET) {
                Element propertysetElement = this.doc.createElement("propertyset");
                Element propertyrefElement = this.doc.createElement("propertyref");
                propertyrefElement.setAttribute("name", "build.compiler");
                propertysetElement.appendChild(propertyrefElement);
                antElement.appendChild(propertysetElement);
            }
            element.appendChild(antElement);
        }
        this.root.appendChild(element);
        element = this.doc.createElement("target");
        element.setAttribute("name", "build-project");
        element.setAttribute("depends", "init");
        Element echoElement = this.doc.createElement("echo");
        echoElement.setAttribute("message", "${ant.project.name}: ${ant.file}");
        element.appendChild(echoElement);
        int i = 0;
        while (i < srcDirs.size()) {
            String srcDir = (String)srcDirs.get(i);
            if (!EclipseClasspath.isReference(srcDir)) {
                String classDir = (String)classDirs.get(i);
                List inclusions = (List)inclusionLists.get(i);
                List exclusions = (List)exclusionLists.get(i);
                Element javacElement = this.doc.createElement("javac");
                javacElement.setAttribute("destdir", classDir);
                javacElement.setAttribute("debug", "true");
                javacElement.setAttribute("debuglevel", "${debuglevel}");
                javacElement.setAttribute("source", "${source}");
                javacElement.setAttribute("target", "${target}");
                Element srcElement = this.doc.createElement("src");
                srcElement.setAttribute("path", srcDir);
                javacElement.appendChild(srcElement);
                for (String inclusion : inclusions) {
                    Element includeElement = this.doc.createElement("include");
                    includeElement.setAttribute("name", inclusion);
                    javacElement.appendChild(includeElement);
                }
                for (String exclusion : exclusions) {
                    Element excludeElement = this.doc.createElement("exclude");
                    excludeElement.setAttribute("name", exclusion);
                    javacElement.appendChild(excludeElement);
                }
                Element classpathRefElement = this.doc.createElement("classpath");
                classpathRefElement.setAttribute("refid", String.valueOf(this.projectName) + ".classpath");
                javacElement.appendChild(classpathRefElement);
                element.appendChild(javacElement);
                this.addCompilerBootClasspath(srcDirs, javacElement);
            }
            ++i;
        }
        this.root.appendChild(element);
    }

    private void createBuildRef() throws JavaModelException {
        TreeSet<IJavaProject> refProjects = new TreeSet<IJavaProject>(ExportUtil.getJavaProjectComparator());
        IJavaProject[] projects = this.project.getJavaModel().getJavaProjects();
        int i = 0;
        while (i < projects.length) {
            List subProjects = ExportUtil.getClasspathProjects(projects[i]);
            for (IJavaProject p : subProjects) {
                if (!this.projectName.equals(p.getProject().getName())) continue;
                refProjects.add(projects[i]);
            }
            ++i;
        }
        Element element = this.doc.createElement("target");
        element.setAttribute("name", "build-refprojects");
        element.setAttribute("description", "Build all projects which reference this project. Useful to propagate changes.");
        for (IJavaProject p : refProjects) {
            String location = String.valueOf(p.getProject().getName()) + ".location";
            String refProjectRoot = ExportUtil.getProjectRoot(p);
            String relativePath = ExportUtil.getRelativePath(refProjectRoot, this.projectRoot);
            this.variable2valueMap.put(location, relativePath);
            Element antElement = this.doc.createElement("ant");
            antElement.setAttribute("antfile", "${" + p.getProject().getName() + ".location}/" + BUILD_XML);
            antElement.setAttribute("target", "clean");
            antElement.setAttribute("inheritAll", "false");
            element.appendChild(antElement);
            antElement = this.doc.createElement("ant");
            antElement.setAttribute("antfile", "${" + p.getProject().getName() + ".location}/" + BUILD_XML);
            antElement.setAttribute("target", "build");
            antElement.setAttribute("inheritAll", "false");
            if (CREATE_ECLIPSE_COMPILE_TARGET) {
                Element propertysetElement = this.doc.createElement("propertyset");
                Element propertyrefElement = this.doc.createElement("propertyref");
                propertyrefElement.setAttribute("name", "build.compiler");
                propertysetElement.appendChild(propertyrefElement);
                antElement.appendChild(propertysetElement);
            }
            element.appendChild(antElement);
        }
        this.root.appendChild(element);
    }

    public void addInitEclipseCompiler() {
        IPath value = JavaCore.getClasspathVariable((String)"ECLIPSE_HOME");
        this.variable2valueMap.put("ECLIPSE_HOME", ExportUtil.getRelativePath("" + value, this.projectRoot));
        Element element = this.doc.createElement("target");
        element.setAttribute("name", "init-eclipse-compiler");
        element.setAttribute("description", "copy Eclipse compiler jars to ant lib directory");
        Element copyElement = this.doc.createElement("copy");
        copyElement.setAttribute("todir", "${ant.library.dir}");
        Element filesetElement = this.doc.createElement("fileset");
        filesetElement.setAttribute("dir", "${ECLIPSE_HOME}/plugins");
        filesetElement.setAttribute("includes", "org.eclipse.jdt.core_*.jar");
        copyElement.appendChild(filesetElement);
        element.appendChild(copyElement);
        Element unzipElement = this.doc.createElement("unzip");
        unzipElement.setAttribute("dest", "${ant.library.dir}");
        Element patternsetElement = this.doc.createElement("patternset");
        patternsetElement.setAttribute("includes", "jdtCompilerAdapter.jar");
        unzipElement.appendChild(patternsetElement);
        unzipElement.appendChild(filesetElement.cloneNode(false));
        element.appendChild(unzipElement);
        this.root.appendChild(element);
    }

    public void addBuildEclipse() {
        Element element = this.doc.createElement("target");
        element.setAttribute("name", "build-eclipse-compiler");
        element.setAttribute("description", "compile project with Eclipse compiler");
        Element propertyElement = this.doc.createElement("property");
        propertyElement.setAttribute("name", "build.compiler");
        propertyElement.setAttribute("value", "org.eclipse.jdt.core.JDTCompilerAdapter");
        element.appendChild(propertyElement);
        Element antcallElement = this.doc.createElement("antcall");
        antcallElement.setAttribute("target", "build");
        element.appendChild(antcallElement);
        this.root.appendChild(element);
    }

    private void addCompilerBootClasspath(List srcDirs, Element javacElement) {
        Element bootclasspathElement = this.doc.createElement("bootclasspath");
        boolean bootclasspathUsed = false;
        for (String entry : srcDirs) {
            if (!EclipseClasspath.isUserSystemLibraryReference(entry)) continue;
            Element pathElement = this.doc.createElement("path");
            pathElement.setAttribute("refid", ExportUtil.removePrefixAndSuffix(entry, "${", "}"));
            bootclasspathElement.appendChild(pathElement);
            bootclasspathUsed = true;
        }
        if (bootclasspathUsed) {
            javacElement.appendChild(bootclasspathElement);
        }
    }

    public void createRun() throws CoreException, TransformerFactoryConfigurationError, UnsupportedEncodingException {
        ILaunchConfiguration[] confs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations();
        boolean junitUsed = false;
        int i = 0;
        while (i < confs.length) {
            ILaunchConfiguration conf = confs[i];
            if (this.projectName.equals(conf.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, ""))) {
                if (conf.getType().getIdentifier().equals(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION)) {
                    this.addJavaApplication(this.variable2valueMap, conf);
                } else if (conf.getType().getIdentifier().equals(IJavaLaunchConfigurationConstants.ID_JAVA_APPLET)) {
                    this.addApplet(this.variable2valueMap, conf);
                } else if (conf.getType().getIdentifier().equals("org.eclipse.jdt.junit.launchconfig")) {
                    this.addJUnit(this.variable2valueMap, conf);
                    junitUsed = true;
                }
            }
            ++i;
        }
        if (junitUsed) {
            this.addJUnitReport();
        }
    }

    public void addJavaApplication(Map variable2value, ILaunchConfiguration conf) throws CoreException {
        Element element = this.doc.createElement("target");
        element.setAttribute("name", conf.getName());
        Element javaElement = this.doc.createElement("java");
        javaElement.setAttribute("fork", "yes");
        javaElement.setAttribute("classname", conf.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, ""));
        javaElement.setAttribute("failonerror", "true");
        String dir = conf.getAttribute(IJavaLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, "");
        ExportUtil.addVariable(variable2value, dir, this.projectRoot);
        if (!dir.equals("")) {
            javaElement.setAttribute("dir", ExportUtil.getRelativePath(dir, this.projectRoot));
        }
        if (!conf.getAttribute(ILaunchManager.ATTR_APPEND_ENVIRONMENT_VARIABLES, true)) {
            javaElement.setAttribute("newenvironment", "true");
        }
        Map props = conf.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, new TreeMap());
        BuildFileCreator.addElements(props, this.doc, javaElement, "env", "key", "value");
        BuildFileCreator.addElement(conf.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, ""), this.doc, javaElement, "jvmarg", "line", variable2value, this.projectRoot);
        BuildFileCreator.addElement(conf.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, ""), this.doc, javaElement, "arg", "line", variable2value, this.projectRoot);
        element.appendChild(javaElement);
        this.addRuntimeClasspath(conf, javaElement);
        this.addRuntimeBootClasspath(conf, javaElement);
        this.root.appendChild(element);
    }

    public void addApplet(Map variable2value, ILaunchConfiguration conf) throws CoreException, TransformerFactoryConfigurationError, UnsupportedEncodingException {
        String value;
        String dir = conf.getAttribute(IJavaLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, "");
        if (dir.equals("")) {
            dir = this.projectRoot;
        }
        ExportUtil.addVariable(variable2value, dir, this.projectRoot);
        try {
            value = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(dir);
        }
        catch (CoreException coreException) {
            value = null;
        }
        String htmlfile = String.valueOf(value != null ? value : dir) + '/' + conf.getName() + ".html";
        if (ExportUtil.existsUserFile(htmlfile) && !ExportUtil.confirm(String.valueOf(DataTransferMessages.AntBuildfileExportPage_4) + ": " + htmlfile, this.shell)) {
            return;
        }
        IJavaProject javaProject = ExportUtil.getJavaProjectByName(this.projectName);
        IFile file = javaProject.getProject().getFile(String.valueOf(conf.getName()) + ".html");
        if (ExportUtil.validateEdit(this.shell, file)) {
            String html = AppletUtil.buildHTMLFile(conf);
            ByteArrayInputStream is = new ByteArrayInputStream(html.getBytes("UTF-8"));
            if (file.exists()) {
                file.setContents((InputStream)is, true, true, null);
            } else {
                file.create((InputStream)is, true, null);
            }
        }
        Element element = this.doc.createElement("target");
        element.setAttribute("name", conf.getName());
        Element javaElement = this.doc.createElement("java");
        javaElement.setAttribute("fork", "yes");
        javaElement.setAttribute("classname", conf.getAttribute(IJavaLaunchConfigurationConstants.ATTR_APPLET_APPLETVIEWER_CLASS, "sun.applet.AppletViewer"));
        javaElement.setAttribute("failonerror", "true");
        if (value != null) {
            javaElement.setAttribute("dir", ExportUtil.getRelativePath(dir, this.projectRoot));
        }
        BuildFileCreator.addElement(conf.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, ""), this.doc, javaElement, "jvmarg", "line", variable2value, this.projectRoot);
        BuildFileCreator.addElement(conf.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, ""), this.doc, javaElement, "arg", "line", variable2value, this.projectRoot);
        BuildFileCreator.addElement(String.valueOf(conf.getName()) + ".html", this.doc, javaElement, "arg", "line", variable2value, this.projectRoot);
        element.appendChild(javaElement);
        this.addRuntimeClasspath(conf, javaElement);
        this.addRuntimeBootClasspath(conf, javaElement);
        this.root.appendChild(element);
    }

    public void addJUnit(Map variable2value, ILaunchConfiguration conf) throws CoreException {
        String testClass = conf.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "");
        Element element = this.doc.createElement("target");
        element.setAttribute("name", conf.getName());
        Element mkdirElement = this.doc.createElement("mkdir");
        mkdirElement.setAttribute("dir", "${junit.output.dir}");
        element.appendChild(mkdirElement);
        Element junitElement = this.doc.createElement("junit");
        junitElement.setAttribute("fork", "yes");
        junitElement.setAttribute("printsummary", "withOutAndErr");
        String dir = conf.getAttribute(IJavaLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, "");
        ExportUtil.addVariable(variable2value, dir, this.projectRoot);
        if (!dir.equals("")) {
            junitElement.setAttribute("dir", ExportUtil.getRelativePath(dir, this.projectRoot));
        }
        if (!conf.getAttribute(ILaunchManager.ATTR_APPEND_ENVIRONMENT_VARIABLES, true)) {
            junitElement.setAttribute("newenvironment", "true");
        }
        Element formatterElement = this.doc.createElement("formatter");
        formatterElement.setAttribute("type", "xml");
        junitElement.appendChild(formatterElement);
        if (!testClass.equals("")) {
            Element testElement = this.doc.createElement("test");
            testElement.setAttribute("name", testClass);
            testElement.setAttribute("todir", "${junit.output.dir}");
            junitElement.appendChild(testElement);
        } else {
            String container = conf.getAttribute("org.eclipse.jdt.junit.CONTAINER", "");
            IType[] types = ExportUtil.findTestsInContainer(container);
            TreeSet sortedTypes = new TreeSet(ExportUtil.getITypeComparator());
            sortedTypes.addAll(Arrays.asList(types));
            for (IType type : sortedTypes) {
                Element testElement = this.doc.createElement("test");
                testElement.setAttribute("name", type.getFullyQualifiedName());
                testElement.setAttribute("todir", "${junit.output.dir}");
                junitElement.appendChild(testElement);
            }
        }
        Map props = conf.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, new TreeMap());
        BuildFileCreator.addElements(props, this.doc, junitElement, "env", "key", "value");
        BuildFileCreator.addElement(conf.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, ""), this.doc, junitElement, "jvmarg", "line", variable2value, this.projectRoot);
        element.appendChild(junitElement);
        this.addRuntimeClasspath(conf, junitElement);
        this.addRuntimeBootClasspath(conf, junitElement);
        this.root.appendChild(element);
    }

    public void addJUnitReport() {
        this.variable2valueMap.put("junit.output.dir", JUNIT_OUTPUT_DIR);
        Element element = this.doc.createElement("target");
        element.setAttribute("name", "junitreport");
        Element junitreport = this.doc.createElement("junitreport");
        junitreport.setAttribute("todir", "${junit.output.dir}");
        Element fileset = this.doc.createElement("fileset");
        fileset.setAttribute("dir", "${junit.output.dir}");
        junitreport.appendChild(fileset);
        Element include = this.doc.createElement("include");
        include.setAttribute("name", "TEST-*.xml");
        fileset.appendChild(include);
        Element report = this.doc.createElement("report");
        report.setAttribute("format", "frames");
        report.setAttribute("todir", "${junit.output.dir}");
        junitreport.appendChild(report);
        element.appendChild(junitreport);
        this.root.appendChild(element);
    }

    private void addRuntimeClasspath(ILaunchConfiguration conf, Element javaElement) throws JavaModelException {
        Element classpathRefElement = this.doc.createElement("classpath");
        EclipseClasspath runtimeClasspath = new EclipseClasspath(this.project, conf, false);
        if (ExportUtil.isDefaultClasspath(this.project, runtimeClasspath)) {
            classpathRefElement.setAttribute("refid", String.valueOf(this.projectName) + ".classpath");
        } else {
            String pathId = "run." + conf.getName() + ".classpath";
            classpathRefElement.setAttribute("refid", pathId);
            this.createClasspaths(pathId, this.project, runtimeClasspath);
        }
        javaElement.appendChild(classpathRefElement);
    }

    private void addRuntimeBootClasspath(ILaunchConfiguration conf, Element javaElement) throws JavaModelException {
        EclipseClasspath bootClasspath = new EclipseClasspath(this.project, conf, true);
        if (bootClasspath.rawClassPathEntries.size() > 0) {
            String pathId = "run." + conf.getName() + ".bootclasspath";
            this.createClasspaths(pathId, this.project, bootClasspath);
            Element bootclasspath = this.doc.createElement("bootclasspath");
            Element classpathRefElement = this.doc.createElement("path");
            classpathRefElement.setAttribute("refid", pathId);
            bootclasspath.appendChild(classpathRefElement);
            Element jrelib = this.doc.createElement("fileset");
            jrelib.setAttribute("dir", "${java.home}/lib");
            jrelib.setAttribute("includes", "*.jar");
            bootclasspath.appendChild(jrelib);
            javaElement.appendChild(bootclasspath);
        }
    }

    private static void addElement(String cmdLineArgs, Document doc, Element element, String elementName, String attributeName, Map variable2valueMap, String projectRoot) {
        if (cmdLineArgs == null || cmdLineArgs.length() == 0) {
            return;
        }
        ExportUtil.addVariable(variable2valueMap, cmdLineArgs, projectRoot);
        Element itemElement = doc.createElement(elementName);
        itemElement.setAttribute(attributeName, cmdLineArgs);
        element.appendChild(itemElement);
    }

    private static void addElements(Map map, Document doc, Element element, String elementName, String keyAttributeName, String valueAttributeName) {
        for (String key : map.keySet()) {
            String value = (String)map.get(key);
            Element itemElement = doc.createElement(elementName);
            itemElement.setAttribute(keyAttributeName, key);
            itemElement.setAttribute(valueAttributeName, value);
            element.appendChild(itemElement);
        }
    }

    public static void setOptions(String buildfilename, String junitdir, boolean checkcycles, boolean eclipsecompiler) {
        if (buildfilename.length() > 0) {
            BUILD_XML = buildfilename;
        }
        if (junitdir.length() > 0) {
            JUNIT_OUTPUT_DIR = junitdir;
        }
        CHECK_SOURCE_CYCLES = checkcycles;
        CREATE_ECLIPSE_COMPILE_TARGET = eclipsecompiler;
    }
}

