/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.search.XMLSearchParticipant;
import org.eclipse.ui.cheatsheets.OpenCheatSheetAction;
import org.xml.sax.Attributes;

public class CheatsheetSearchParticipant
extends XMLSearchParticipant {
    private static final String INTRO_DESC = "cheatsheet/intro/description";
    private static final String ITEM_DESC = "cheatsheet/item/description";
    private static final String CCS_DESC = "compositeCheatsheet/taskGroup/intro";

    public Set getAllDocuments(String locale) {
        HashSet<String> set = new HashSet<String>();
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.ui.cheatsheets.cheatSheetContent");
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (element.getName().equals("cheatsheet")) {
                String fileName = element.getAttribute("contentFile");
                String id = element.getAttribute("id");
                String pluginId = element.getContributor().getName();
                fileName = CheatsheetSearchParticipant.resolveVariables((String)pluginId, (String)fileName, (String)locale);
                set.add("/" + pluginId + "/" + fileName + "?id=" + id);
            }
            ++i;
        }
        return set;
    }

    public Set getContributingPlugins() {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.ui.cheatsheets.cheatSheetContent");
        HashSet<String> set = new HashSet<String>();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (element.getName().equals("cheatsheet")) {
                set.add(element.getContributor().getName());
            }
            ++i;
        }
        return set;
    }

    protected void handleStartElement(String name, Attributes attributes, XMLSearchParticipant.IParsedXMLContent data) {
        if (name.equals("cheatsheet")) {
            data.setTitle(attributes.getValue("title"));
            data.addText(attributes.getValue("title"));
        } else if (name.equals("compositeCheatsheet")) {
            data.addText(attributes.getValue("name"));
            data.setTitle(attributes.getValue("name"));
        } else if (name.equals("item")) {
            data.addText(attributes.getValue("title"));
        } else if (name.equals("subitem")) {
            data.addText(attributes.getValue("label"));
        } else if (name.equals("task") || name.equals("taskGroup")) {
            data.addText(attributes.getValue("name"));
        }
    }

    protected void handleEndElement(String name, XMLSearchParticipant.IParsedXMLContent data) {
    }

    protected void handleText(String text, XMLSearchParticipant.IParsedXMLContent data) {
        String stackPath = this.getElementStackPath();
        String top = this.getTopElement();
        if ("intro".equals(top)) {
            data.addText(text);
            if (stackPath.equalsIgnoreCase(CCS_DESC)) {
                data.addToSummary(text);
            }
        } else if ("onCompletion".equals(top)) {
            data.addText(text);
        } else {
            if (stackPath.equalsIgnoreCase(INTRO_DESC)) {
                data.addText(text);
                data.addToSummary(text);
                return;
            }
            if (stackPath.equalsIgnoreCase(ITEM_DESC)) {
                data.addText(text);
                return;
            }
        }
    }

    public boolean open(String id) {
        OpenCheatSheetAction openAction = new OpenCheatSheetAction(id);
        openAction.run();
        return true;
    }
}

