/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.exports;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.ant.core.AntRunner;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.build.BuildScriptGenerator;
import org.eclipse.pde.internal.core.ExternalModelManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.TargetPlatform;
import org.eclipse.pde.internal.core.XMLPrintHandler;
import org.eclipse.pde.internal.core.exports.FeatureExportInfo;
import org.eclipse.pde.internal.core.exports.FeatureExportOperation;
import org.eclipse.pde.internal.core.iproduct.IArgumentsInfo;
import org.eclipse.pde.internal.core.iproduct.IConfigurationFileInfo;
import org.eclipse.pde.internal.core.iproduct.ILauncherInfo;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.core.iproduct.ISplashInfo;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ProductExportOperation
extends FeatureExportOperation {
    private String fFeatureLocation;
    private String fRoot;
    private IProduct fProduct;

    public ProductExportOperation(FeatureExportInfo info, IProduct product, String root) {
        super(info);
        this.fProduct = product;
        this.fRoot = root;
    }

    /*
     * Unable to fully structure code
     */
    public void run(IProgressMonitor monitor) throws CoreException {
        configurations = this.fInfo.targets;
        if (configurations == null) {
            configurations = new String[][]{{TargetPlatform.getOS(), TargetPlatform.getWS(), TargetPlatform.getOSArch(), TargetPlatform.getNL()}};
        }
        monitor.beginTask("", 10 * configurations.length);
        i = 0;
        while (i < configurations.length) {
            try {
                try {
                    config = configurations[i];
                    if (config[0].equals("macosx") && this.fInfo.targets == null) {
                        this.createMacScript(config, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                    featureID = "org.eclipse.pde.container.feature";
                    this.fFeatureLocation = String.valueOf(this.fBuildTempLocation) + File.separator + featureID;
                    this.createFeature(featureID, this.fFeatureLocation, config, true);
                    this.createBuildPropertiesFile(this.fFeatureLocation);
                    this.createConfigIniFile(config);
                    this.createEclipseProductFile();
                    this.createLauncherIniFile(config[0]);
                    this.doExport(featureID, null, this.fFeatureLocation, config[0], config[1], config[2], (IProgressMonitor)new SubProgressMonitor(monitor, 8));
                }
                catch (IOException v0) {
                }
                catch (InvocationTargetException e) {
                    this.throwCoreException(e);
                }
            }
            finally {
                j = 0;
                ** while (j < this.fInfo.items.length)
            }
lbl-1000:
            // 1 sources

            {
                this.deleteBuildFiles(this.fInfo.items[j]);
                ++j;
                continue;
            }
lbl32:
            // 1 sources

            this.cleanup(this.fInfo.targets == null ? null : configurations[i], (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            ++i;
        }
        monitor.done();
    }

    private File getCustomIniFile() {
        File file;
        String path;
        IConfigurationFileInfo info = this.fProduct.getConfigurationFileInfo();
        if (info != null && info.getUse().equals("custom") && (path = this.getExpandedPath(info.getPath())) != null && (file = new File(path)).exists() && file.isFile()) {
            return file;
        }
        return null;
    }

    protected String[] getPaths() {
        String[] paths = super.getPaths();
        String[] all = new String[paths.length + 1];
        all[0] = String.valueOf(this.fFeatureLocation) + File.separator + "feature.xml";
        System.arraycopy(paths, 0, all, 1, paths.length);
        return all;
    }

    private void createBuildPropertiesFile(String featureLocation) {
        File file = new File(featureLocation);
        if (!file.exists() || !file.isDirectory()) {
            file.mkdirs();
        }
        boolean hasLaunchers = PDECore.getDefault().getFeatureModelManager().findFeatureModel("org.eclipse.platform.launchers") != null;
        Properties properties = new Properties();
        properties.put("root", this.getRootFileLocations(hasLaunchers));
        if (!hasLaunchers) {
            properties.put("root.permissions.755", this.getLauncherName());
            if (TargetPlatform.getWS().equals("motif") && TargetPlatform.getOS().equals("linux")) {
                properties.put("root.linux.motif.x86.permissions.755", "libXm.so.2");
            } else if (TargetPlatform.getOS().equals("macosx")) {
                properties.put("root.macosx.carbon.ppc.permissions.755", "${launcherName}.app/Contents/MacOS/${launcherName}");
            }
        }
        this.save(new File(file, "build.properties"), properties, "Build Configuration");
    }

    private String getRootFileLocations(boolean hasLaunchers) {
        StringBuffer buffer = new StringBuffer();
        File homeDir = ExternalModelManager.getEclipseHome().toFile();
        if (!hasLaunchers && homeDir.exists() && homeDir.isDirectory()) {
            buffer.append("absolute:file:");
            buffer.append(new File(homeDir, "startup.jar").getAbsolutePath());
            if (!TargetPlatform.getOS().equals("macosx")) {
                File file = new File(homeDir, "eclipse");
                if (file.exists()) {
                    buffer.append(",absolute:file:");
                    buffer.append(file.getAbsolutePath());
                }
                if ((file = new File(homeDir, "eclipse.exe")).exists()) {
                    buffer.append(",absolute:file:");
                    buffer.append(file.getAbsolutePath());
                }
                if ((file = new File(homeDir, "libXm.so.2")).exists()) {
                    buffer.append(",absolute:file:");
                    buffer.append(file.getAbsolutePath());
                }
            }
        }
        if (buffer.length() > 0) {
            buffer.append(",");
        }
        buffer.append("/temp/");
        return buffer.toString();
    }

    private void createEclipseProductFile() {
        File dir = new File(this.fFeatureLocation, "temp");
        if (!dir.exists() || !dir.isDirectory()) {
            dir.mkdirs();
        }
        Properties properties = new Properties();
        IPluginModelBase model = PDECore.getDefault().getModelManager().findModel(this.getBrandingPlugin());
        if (model != null) {
            properties.put("name", model.getResourceString(this.fProduct.getName()));
        } else {
            properties.put("name", this.fProduct.getName());
        }
        properties.put("id", this.fProduct.getId());
        if (model != null) {
            properties.put("version", model.getPluginBase().getVersion());
        }
        this.save(new File(dir, ".eclipseproduct"), properties, "Eclipse Product File");
    }

    private void createLauncherIniFile(String os) {
        String programArgs = this.getProgramArguments(os);
        String vmArgs = this.getVMArguments(os);
        if (programArgs.length() == 0 && vmArgs.length() == 0) {
            return;
        }
        File dir = new File(this.fFeatureLocation, "temp");
        if (!dir.exists() || !dir.isDirectory()) {
            dir.mkdirs();
        }
        String lineDelimiter = "win32".equals(os) ? "\r\n" : "\n";
        PrintWriter writer = null;
        try {
            try {
                StringTokenizer tokenizer;
                writer = new PrintWriter(new FileWriter(new File(dir, String.valueOf(this.getLauncherName()) + ".ini")));
                if (programArgs.length() > 0) {
                    tokenizer = new StringTokenizer(programArgs);
                    while (tokenizer.hasMoreTokens()) {
                        writer.print(tokenizer.nextToken());
                        writer.print(lineDelimiter);
                    }
                }
                if (vmArgs.length() > 0) {
                    writer.print("-vmargs");
                    writer.print(lineDelimiter);
                    tokenizer = new StringTokenizer(vmArgs);
                    while (tokenizer.hasMoreTokens()) {
                        writer.print(tokenizer.nextToken());
                        writer.print(lineDelimiter);
                    }
                }
            }
            catch (IOException iOException) {}
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    private String getProgramArguments(String os) {
        IArgumentsInfo info = this.fProduct.getLauncherArguments();
        return info != null ? CoreUtility.normalize(info.getCompleteProgramArguments(os)) : "";
    }

    private String getVMArguments(String os) {
        IArgumentsInfo info = this.fProduct.getLauncherArguments();
        return info != null ? CoreUtility.normalize(info.getCompleteVMArguments(os)) : "";
    }

    private void createConfigIniFile(String[] config) {
        File dir = new File(this.fFeatureLocation, "temp/configuration");
        if (!dir.exists() || !dir.isDirectory()) {
            dir.mkdirs();
        }
        PrintWriter writer = null;
        File custom = this.getCustomIniFile();
        if (custom != null) {
            String path = this.getExpandedPath(this.fProduct.getConfigurationFileInfo().getPath());
            BufferedReader in = null;
            try {
                try {
                    String line;
                    in = new BufferedReader(new FileReader(path));
                    writer = new PrintWriter(new FileWriter(new File(dir, "config.ini")));
                    while ((line = in.readLine()) != null) {
                        writer.println(line);
                    }
                }
                catch (IOException iOException) {}
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (in != null) {
                    in.close();
                }
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {}
            return;
        }
        try {
            try {
                writer = new PrintWriter(new FileWriter(new File(dir, "config.ini")));
                String location = this.getSplashLocation(config[0], config[1], config[2]);
                writer.println("#Product Runtime Configuration File");
                writer.println();
                if (location != null) {
                    writer.println("osgi.splashPath=" + location);
                }
                writer.println("eclipse.product=" + this.fProduct.getId());
                writer.println("osgi.bundles=" + this.getPluginList(config, TargetPlatform.getBundleList()));
                writer.println("osgi.bundles.defaultStartLevel=4");
            }
            catch (IOException iOException) {}
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    private String getSplashLocation(String os, String ws, String arch) {
        ISplashInfo info = this.fProduct.getSplashInfo();
        String plugin = null;
        if (info != null) {
            plugin = info.getLocation();
        }
        if (plugin == null) {
            plugin = this.getBrandingPlugin();
        }
        if (plugin == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer("platform:/base/plugins/");
        buffer.append(plugin);
        State state = this.getState(os, ws, arch);
        BundleDescription bundle = state.getBundle(plugin, null);
        if (bundle != null) {
            BundleDescription[] fragments = bundle.getFragments();
            int i = 0;
            while (i < fragments.length) {
                String id = fragments[i].getSymbolicName();
                if (this.fProduct.containsPlugin(id)) {
                    buffer.append(",platform:/base/plugins/");
                    buffer.append(id);
                }
                ++i;
            }
        }
        return buffer.toString();
    }

    private String getBrandingPlugin() {
        int dot = this.fProduct.getId().lastIndexOf(46);
        return dot != -1 ? this.fProduct.getId().substring(0, dot) : null;
    }

    private String getPluginList(String[] config, String bundleList) {
        if (this.fProduct.useFeatures()) {
            return bundleList;
        }
        StringBuffer buffer = new StringBuffer();
        HashSet<String> initialBundleSet = new HashSet<String>();
        StringTokenizer tokenizer = new StringTokenizer(bundleList, ",");
        while (tokenizer.hasMoreTokens()) {
            String id;
            String token = tokenizer.nextToken();
            int index = token.indexOf(64);
            String string = id = index != -1 ? token.substring(0, index) : token;
            if (!this.fProduct.containsPlugin(id)) continue;
            if (buffer.length() > 0) {
                buffer.append(',');
            }
            buffer.append(id);
            if (index != -1 && index < token.length() - 1) {
                buffer.append(token.substring(index));
            }
            initialBundleSet.add(id);
        }
        if (!this.fProduct.containsPlugin("org.eclipse.update.configurator")) {
            initialBundleSet.add("org.eclipse.osgi");
            Hashtable<String, String> environment = new Hashtable<String, String>(4);
            ((Dictionary)environment).put("osgi.os", config[0]);
            ((Dictionary)environment).put("osgi.ws", config[1]);
            ((Dictionary)environment).put("osgi.arch", config[2]);
            ((Dictionary)environment).put("osgi.nl", config[3]);
            BundleContext context = PDECore.getDefault().getBundleContext();
            int i = 0;
            while (i < this.fInfo.items.length) {
                BundleDescription bundle = (BundleDescription)this.fInfo.items[i];
                String filterSpec = bundle.getPlatformFilter();
                try {
                    String id;
                    if ((filterSpec == null || context.createFilter(filterSpec).match(environment)) && !initialBundleSet.contains(id = ((BundleDescription)this.fInfo.items[i]).getSymbolicName())) {
                        if (buffer.length() > 0) {
                            buffer.append(",");
                        }
                        buffer.append(id);
                    }
                }
                catch (InvalidSyntaxException invalidSyntaxException) {}
                ++i;
            }
        }
        return buffer.toString();
    }

    protected HashMap createAntBuildProperties(String os, String ws, String arch) {
        HashMap properties = super.createAntBuildProperties(os, ws, arch);
        properties.put("launcherName", this.getLauncherName());
        ILauncherInfo info = this.fProduct.getLauncherInfo();
        if (info != null) {
            String images = null;
            if (os.equals("win32")) {
                images = this.getWin32Images(info);
            } else if (os.equals("solaris")) {
                images = this.getSolarisImages(info);
            } else if (os.equals("linux")) {
                images = this.getExpandedPath(info.getIconPath("linuxIcon"));
            } else if (os.equals("macosx")) {
                images = this.getExpandedPath(info.getIconPath("macosxIcon"));
            }
            if (images != null && images.length() > 0) {
                properties.put("launcherIcons", images);
            }
        }
        this.fAntBuildProperties.put("collectingFolder", this.fRoot);
        this.fAntBuildProperties.put("archivePrefix", this.fRoot);
        return properties;
    }

    private String getLauncherName() {
        String name;
        ILauncherInfo info = this.fProduct.getLauncherInfo();
        if (info != null && (name = info.getLauncherName()) != null && name.length() > 0) {
            if ((name = name.trim()).endsWith(".exe")) {
                name = name.substring(0, name.length() - 4);
            }
            return name;
        }
        return "eclipse";
    }

    private String getWin32Images(ILauncherInfo info) {
        StringBuffer buffer = new StringBuffer();
        if (info.usesWinIcoFile()) {
            this.append(buffer, info.getIconPath("icoFile"));
        } else {
            this.append(buffer, info.getIconPath("winSmallLow"));
            this.append(buffer, info.getIconPath("winSmallHigh"));
            this.append(buffer, info.getIconPath("win24Low"));
            this.append(buffer, info.getIconPath("winMediumHigh"));
            this.append(buffer, info.getIconPath("winMediumLow"));
            this.append(buffer, info.getIconPath("winLargeHigh"));
            this.append(buffer, info.getIconPath("winLargeLow"));
        }
        return buffer.length() > 0 ? buffer.toString() : null;
    }

    private String getSolarisImages(ILauncherInfo info) {
        StringBuffer buffer = new StringBuffer();
        this.append(buffer, info.getIconPath("solarisLarge"));
        this.append(buffer, info.getIconPath("solarisMedium"));
        this.append(buffer, info.getIconPath("solarisSmall"));
        this.append(buffer, info.getIconPath("solarisTiny"));
        return buffer.length() > 0 ? buffer.toString() : null;
    }

    private void append(StringBuffer buffer, String path) {
        if ((path = this.getExpandedPath(path)) != null) {
            if (buffer.length() > 0) {
                buffer.append(",");
            }
            buffer.append(path);
        }
    }

    private String getExpandedPath(String path) {
        if (path == null || path.length() == 0) {
            return null;
        }
        IResource resource = PDECore.getWorkspace().getRoot().findMember((IPath)new Path(path));
        if (resource != null) {
            IPath fullPath = resource.getLocation();
            return fullPath == null ? null : fullPath.toOSString();
        }
        return null;
    }

    private void save(File file, Properties properties, String header) {
        try {
            FileOutputStream stream = new FileOutputStream(file);
            properties.store(stream, header);
            stream.flush();
            stream.close();
        }
        catch (IOException e) {
            PDECore.logException(e);
        }
    }

    protected void setupGenerator(BuildScriptGenerator generator, String featureID, String versionId, String os, String ws, String arch, String featureLocation) throws CoreException {
        super.setupGenerator(generator, featureID, versionId, os, ws, arch, featureLocation);
        if (this.fProduct != null) {
            generator.setProduct(this.fProduct.getModel().getInstallLocation());
        }
    }

    private void createMacScript(String[] config, IProgressMonitor monitor) {
        URL url = PDECore.getDefault().getBundle().getEntry("macosx/Info.plist");
        if (url == null) {
            return;
        }
        File scriptFile = null;
        File plist = null;
        InputStream in = null;
        String location = PDECore.getDefault().getStateLocation().toOSString();
        try {
            try {
                in = url.openStream();
                File dir = new File(location, "Eclipse.app/Contents");
                dir.mkdirs();
                plist = new File(dir, "Info.plist");
                CoreUtility.readFile(in, plist);
                scriptFile = this.createScriptFile("macbuild.xml");
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                Document doc = factory.newDocumentBuilder().newDocument();
                Element root = doc.createElement("project");
                root.setAttribute("name", "project");
                root.setAttribute("default", "default");
                doc.appendChild(root);
                Element property = doc.createElement("property");
                property.setAttribute("name", "eclipse.base");
                property.setAttribute("value", "${assemblyTempDir}/${collectingFolder}");
                root.appendChild(property);
                Element target = doc.createElement("target");
                target.setAttribute("name", "default");
                root.appendChild(target);
                Element copy = doc.createElement("copy");
                copy.setAttribute("todir", "${eclipse.base}/macosx.carbon.ppc/${collectingFolder}");
                copy.setAttribute("failonerror", "false");
                copy.setAttribute("overwrite", "true");
                target.appendChild(copy);
                Element fileset = doc.createElement("fileset");
                fileset.setAttribute("dir", "${installFolder}");
                fileset.setAttribute("includes", "Eclipse.app/Contents/MacOS/eclipse");
                copy.appendChild(fileset);
                fileset = doc.createElement("fileset");
                fileset.setAttribute("dir", "${template}");
                fileset.setAttribute("includes", "Eclipse.app/Contents/Info.plist");
                copy.appendChild(fileset);
                XMLPrintHandler.writeFile(doc, scriptFile);
                AntRunner runner = new AntRunner();
                HashMap<String, String> map = new HashMap<String, String>();
                if (!this.fInfo.toDirectory) {
                    String filename = this.fInfo.zipFileName;
                    map.put("archiveFullPath", String.valueOf(this.fInfo.destinationDirectory) + File.separator + filename);
                } else {
                    map.put("assemblyTempDir", this.fInfo.destinationDirectory);
                }
                map.put("collectingFolder", this.fRoot);
                map.put("installFolder", ExternalModelManager.getEclipseHome().toOSString());
                map.put("template", location);
                runner.addUserProperties(map);
                runner.setBuildFileLocation(scriptFile.getAbsolutePath());
                runner.setExecutionTargets(new String[]{"default"});
                runner.run((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            catch (FactoryConfigurationError factoryConfigurationError) {
            }
            catch (ParserConfigurationException parserConfigurationException) {
            }
            catch (CoreException coreException) {
            }
            catch (IOException iOException) {}
        }
        catch (Throwable throwable) {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
            CoreUtility.deleteContent(new File(location, "Eclipse.app"));
            if (scriptFile != null && scriptFile.exists()) {
                scriptFile.delete();
            }
            monitor.done();
            throw throwable;
        }
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException iOException) {}
        CoreUtility.deleteContent(new File(location, "Eclipse.app"));
        if (scriptFile != null && scriptFile.exists()) {
            scriptFile.delete();
        }
        monitor.done();
    }

    protected void setAdditionalAttributes(Element plugin, BundleDescription bundle) {
        boolean unpack = CoreUtility.guessUnpack(bundle);
        plugin.setAttribute("unpack", Boolean.toString(unpack));
    }
}

