/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.junit.wizards;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.junit.Messages;
import org.eclipse.jdt.internal.junit.buildpath.BuildPathSupport;
import org.eclipse.jdt.internal.junit.ui.JUnitPlugin;
import org.eclipse.jdt.internal.junit.util.JUnitStatus;
import org.eclipse.jdt.internal.junit.util.JUnitStubUtility;
import org.eclipse.jdt.internal.junit.util.LayoutUtil;
import org.eclipse.jdt.internal.junit.util.TestSearchEngine;
import org.eclipse.jdt.internal.junit.wizards.MethodStubsSelectionButtonGroup;
import org.eclipse.jdt.internal.junit.wizards.WizardMessages;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.ControlContentAssistHelper;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.JavaTypeCompletionProcessor;
import org.eclipse.jdt.junit.wizards.NewTestCaseWizardPageTwo;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.dialogs.SelectionDialog;

public class NewTestCaseWizardPageOne
extends NewTypeWizardPage {
    private static final String PAGE_NAME = "NewTestCaseCreationWizardPage";
    public static final String CLASS_UNDER_TEST = "NewTestCaseCreationWizardPage.classundertest";
    public static final String JUNIT4TOGGLE = "NewTestCaseCreationWizardPage.junit4toggle";
    private static final String COMPLIANCE_PAGE_ID = "org.eclipse.jdt.ui.propertyPages.CompliancePreferencePage";
    private static final String BUILD_PATH_PAGE_ID = "org.eclipse.jdt.ui.propertyPages.BuildPathsPropertyPage";
    private static final Object BUILD_PATH_KEY_ADD_ENTRY = "add_classpath_entry";
    private static final Object BUILD_PATH_BLOCK = "block_until_buildpath_applied";
    private static final String KEY_NO_LINK = "PropertyAndPreferencePage.nolink";
    private static final String QUESTION_MARK_TAG = "Q";
    private static final String OF_TAG = "Of";
    private static final String TEST_SUFFIX = "Test";
    private static final String PREFIX = "test";
    private static final String STORE_SETUP = "NewTestCaseCreationWizardPage.USE_SETUP";
    private static final String STORE_TEARDOWN = "NewTestCaseCreationWizardPage.USE_TEARDOWN";
    private static final String STORE_SETUP_CLASS = "NewTestCaseCreationWizardPage.USE_SETUPCLASS";
    private static final String STORE_TEARDOWN_CLASS = "NewTestCaseCreationWizardPage.USE_TEARDOWNCLASS";
    private static final String STORE_CONSTRUCTOR = "NewTestCaseCreationWizardPage.USE_CONSTRUCTOR";
    private static final int IDX_SETUP_CLASS = 0;
    private static final int IDX_TEARDOWN_CLASS = 1;
    private static final int IDX_SETUP = 2;
    private static final int IDX_TEARDOWN = 3;
    private static final int IDX_CONSTRUCTOR = 4;
    private NewTestCaseWizardPageTwo fPage2;
    private MethodStubsSelectionButtonGroup fMethodStubsButtons;
    private String fClassUnderTestText;
    private IType fClassUnderTest;
    private Text fClassUnderTestControl;
    private IStatus fClassUnderTestStatus;
    private Button fClassUnderTestButton;
    private JavaTypeCompletionProcessor fClassToTestCompletionProcessor;
    private Button fJUnit4Toggle;
    private boolean fIsJunit4;
    private IStatus fJunit4Status;
    private boolean fIsJunit4Enabled;
    private Link fLink;
    private Label fImage;

    public NewTestCaseWizardPageOne(NewTestCaseWizardPageTwo page2) {
        super(true, PAGE_NAME);
        this.fPage2 = page2;
        this.setTitle(WizardMessages.NewTestCaseWizardPageOne_title);
        this.setDescription(WizardMessages.NewTestCaseWizardPageOne_description);
        String[] buttonNames = new String[]{WizardMessages.NewTestCaseWizardPageOne_methodStub_setUpBeforeClass, WizardMessages.NewTestCaseWizardPageOne_methodStub_tearDownAfterClass, WizardMessages.NewTestCaseWizardPageOne_methodStub_setUp, WizardMessages.NewTestCaseWizardPageOne_methodStub_tearDown, WizardMessages.NewTestCaseWizardPageOne_methodStub_constructor};
        this.enableCommentControl(true);
        this.fMethodStubsButtons = new MethodStubsSelectionButtonGroup(32, buttonNames, 2);
        this.fMethodStubsButtons.setLabelText(WizardMessages.NewTestCaseWizardPageOne_method_Stub_label);
        this.fClassToTestCompletionProcessor = new JavaTypeCompletionProcessor(false, false);
        this.fClassUnderTestStatus = new JUnitStatus();
        this.fClassUnderTestText = "";
        this.fJunit4Status = new JUnitStatus();
        this.fIsJunit4 = false;
    }

    public void init(IStructuredSelection selection) {
        IJavaElement element = this.getInitialJavaElement(selection);
        this.initContainerPage(element);
        this.initTypePage(element);
        if (element != null) {
            IType classToTest = null;
            IType typeInCompUnit = (IType)element.getAncestor(7);
            if (typeInCompUnit != null) {
                if (typeInCompUnit.getCompilationUnit() != null) {
                    classToTest = typeInCompUnit;
                }
            } else {
                ICompilationUnit cu = (ICompilationUnit)element.getAncestor(5);
                if (cu != null) {
                    classToTest = cu.findPrimaryType();
                } else if (element instanceof IClassFile) {
                    try {
                        IClassFile cf = (IClassFile)element;
                        if (cf.isStructureKnown()) {
                            classToTest = cf.getType();
                        }
                    }
                    catch (JavaModelException e) {
                        JUnitPlugin.log(e);
                    }
                }
            }
            if (classToTest != null) {
                try {
                    if (!TestSearchEngine.isTestImplementor(classToTest)) {
                        this.setClassUnderTest(classToTest.getFullyQualifiedName('.'));
                    }
                }
                catch (JavaModelException e) {
                    JUnitPlugin.log(e);
                }
            }
        }
        this.restoreWidgetValues();
        boolean isJunit4 = false;
        if (element != null && element.getElementType() != 1) {
            IJavaProject project = element.getJavaProject();
            try {
                isJunit4 = project.findType("org.junit.Test") != null;
            }
            catch (JavaModelException javaModelException) {}
        }
        this.setJUnit4(isJunit4, true);
        this.updateStatus(this.getStatusList());
    }

    private IStatus junit4Changed() {
        JUnitStatus status = new JUnitStatus();
        return status;
    }

    public void setJUnit4(boolean isJUnit4, boolean isEnabled) {
        this.fIsJunit4Enabled = isEnabled;
        if (this.fJUnit4Toggle != null && !this.fJUnit4Toggle.isDisposed()) {
            this.fJUnit4Toggle.setSelection(isJUnit4);
            this.fJUnit4Toggle.setEnabled(isEnabled);
        }
        this.internalSetJUnit4(isJUnit4);
    }

    public boolean isJUnit4() {
        return this.fIsJunit4;
    }

    private void internalSetJUnit4(boolean isJUnit4) {
        this.fIsJunit4 = isJUnit4;
        this.fJunit4Status = this.junit4Changed();
        if (this.fIsJunit4) {
            this.setSuperClass("java.lang.Object", false);
        } else {
            this.setSuperClass("junit.framework.TestCase", true);
        }
        this.handleFieldChanged(JUNIT4TOGGLE);
    }

    protected void handleFieldChanged(String fieldName) {
        super.handleFieldChanged(fieldName);
        if (fieldName.equals("NewContainerWizardPage.container")) {
            this.fClassUnderTestStatus = this.classUnderTestChanged();
            if (this.fClassUnderTestButton != null && !this.fClassUnderTestButton.isDisposed()) {
                this.fClassUnderTestButton.setEnabled(this.getPackageFragmentRoot() != null);
            }
            this.fJunit4Status = this.junit4Changed();
            this.updateBuildPathMessage();
        } else if (fieldName.equals(JUNIT4TOGGLE)) {
            this.updateBuildPathMessage();
            this.fMethodStubsButtons.setEnabled(0, this.isJUnit4());
            this.fMethodStubsButtons.setEnabled(1, this.isJUnit4());
            this.fMethodStubsButtons.setEnabled(4, !this.isJUnit4());
        }
        this.updateStatus(this.getStatusList());
    }

    protected IStatus[] getStatusList() {
        return new IStatus[]{this.fContainerStatus, this.fPackageStatus, this.fTypeNameStatus, this.fClassUnderTestStatus, this.fModifierStatus, this.fSuperClassStatus, this.fJunit4Status};
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        int nColumns = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.createJUnit4Controls(composite, nColumns);
        this.createContainerControls(composite, nColumns);
        this.createPackageControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createTypeNameControls(composite, nColumns);
        this.createSuperClassControls(composite, nColumns);
        this.createMethodStubSelectionControls(composite, nColumns);
        this.createCommentControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createClassUnderTestControls(composite, nColumns);
        this.createBuildPathConfigureControls(composite, nColumns);
        this.setControl((Control)composite);
        String classUnderTest = this.getClassUnderTestText();
        if (classUnderTest.length() > 0) {
            this.setTypeName(String.valueOf(Signature.getSimpleName((String)classUnderTest)) + TEST_SUFFIX, true);
        }
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.jdt.junit.new_testcase_wizard_page_context");
        this.setFocus();
    }

    protected void createMethodStubSelectionControls(Composite composite, int nColumns) {
        LayoutUtil.setHorizontalSpan((Control)this.fMethodStubsButtons.getLabelControl(composite), nColumns);
        LayoutUtil.createEmptySpace(composite, 1);
        LayoutUtil.setHorizontalSpan((Control)this.fMethodStubsButtons.getSelectionButtonsGroup(composite), nColumns - 1);
    }

    protected void createClassUnderTestControls(Composite composite, int nColumns) {
        Label classUnderTestLabel = new Label(composite, 16448);
        classUnderTestLabel.setFont(composite.getFont());
        classUnderTestLabel.setText(WizardMessages.NewTestCaseWizardPageOne_class_to_test_label);
        classUnderTestLabel.setLayoutData((Object)new GridData());
        this.fClassUnderTestControl = new Text(composite, 2052);
        this.fClassUnderTestControl.setEnabled(true);
        this.fClassUnderTestControl.setFont(composite.getFont());
        this.fClassUnderTestControl.setText(this.fClassUnderTestText);
        this.fClassUnderTestControl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewTestCaseWizardPageOne.this.internalSetClassUnderText(((Text)e.widget).getText());
            }
        });
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = nColumns - 2;
        this.fClassUnderTestControl.setLayoutData((Object)gd);
        this.fClassUnderTestButton = new Button(composite, 8);
        this.fClassUnderTestButton.setText(WizardMessages.NewTestCaseWizardPageOne_class_to_test_browse);
        this.fClassUnderTestButton.setEnabled(true);
        this.fClassUnderTestButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                NewTestCaseWizardPageOne.this.classToTestButtonPressed();
            }

            public void widgetSelected(SelectionEvent e) {
                NewTestCaseWizardPageOne.this.classToTestButtonPressed();
            }
        });
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        gd.horizontalSpan = 1;
        gd.widthHint = LayoutUtil.getButtonWidthHint(this.fClassUnderTestButton);
        this.fClassUnderTestButton.setLayoutData((Object)gd);
        ControlContentAssistHelper.createTextContentAssistant((Text)this.fClassUnderTestControl, (IContentAssistProcessor)this.fClassToTestCompletionProcessor);
    }

    protected void createJUnit4Controls(Composite composite, int nColumns) {
        Composite inner = new Composite(composite, 0);
        inner.setLayoutData((Object)new GridData(4, 0x1000000, false, false, nColumns, 1));
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        inner.setLayout((Layout)layout);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean isSelected = ((Button)e.widget).getSelection();
                NewTestCaseWizardPageOne.this.internalSetJUnit4(isSelected);
            }
        };
        Button junti3Toggle = new Button(inner, 16);
        junti3Toggle.setText(WizardMessages.NewTestCaseWizardPageOne_junit3_radio_label);
        junti3Toggle.setLayoutData((Object)new GridData(4, 2, false, false, 1, 1));
        junti3Toggle.setSelection(!this.fIsJunit4);
        junti3Toggle.setEnabled(this.fIsJunit4Enabled);
        this.fJUnit4Toggle = new Button(inner, 16);
        this.fJUnit4Toggle.setText(WizardMessages.NewTestCaseWizardPageOne_junit4_radio_label);
        this.fJUnit4Toggle.setSelection(this.fIsJunit4);
        this.fJUnit4Toggle.setEnabled(this.fIsJunit4Enabled);
        this.fJUnit4Toggle.setLayoutData((Object)new GridData(4, 2, false, false, 1, 1));
        this.fJUnit4Toggle.addSelectionListener((SelectionListener)listener);
    }

    protected void createBuildPathConfigureControls(Composite composite, int nColumns) {
        Composite inner = new Composite(composite, 0);
        inner.setLayoutData((Object)new GridData(4, 4, false, false, nColumns, 1));
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        inner.setLayout((Layout)layout);
        this.fImage = new Label(inner, 0);
        this.fImage.setImage(JFaceResources.getImage((String)"dialog_messasge_warning_image"));
        this.fImage.setLayoutData((Object)new GridData(1, 1, false, false, 1, 1));
        this.fLink = new Link(inner, 64);
        this.fLink.setText("\n\n");
        this.fLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewTestCaseWizardPageOne.this.performBuildpathConfiguration(e.text);
            }
        });
        GridData gd = new GridData(4, 1, true, false, 1, 1);
        gd.widthHint = this.convertWidthInCharsToPixels(60);
        this.fLink.setLayoutData((Object)gd);
        this.updateBuildPathMessage();
    }

    private void performBuildpathConfiguration(Object data) {
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root == null) {
            return;
        }
        IJavaProject javaProject = root.getJavaProject();
        if ("a3".equals(data)) {
            String id = BUILD_PATH_PAGE_ID;
            HashMap<Object, Object> input = new HashMap<Object, Object>();
            IClasspathEntry newEntry = BuildPathSupport.getJUnit3ClasspathEntry();
            input.put(BUILD_PATH_KEY_ADD_ENTRY, newEntry);
            input.put(BUILD_PATH_BLOCK, Boolean.TRUE);
            PreferencesUtil.createPropertyDialogOn((Shell)this.getShell(), (IAdaptable)javaProject, (String)id, (String[])new String[]{id}, input).open();
        } else if ("a4".equals(data)) {
            String id = BUILD_PATH_PAGE_ID;
            HashMap<Object, Object> input = new HashMap<Object, Object>();
            IClasspathEntry newEntry = BuildPathSupport.getJUnit4ClasspathEntry();
            input.put(BUILD_PATH_KEY_ADD_ENTRY, newEntry);
            input.put(BUILD_PATH_BLOCK, Boolean.TRUE);
            PreferencesUtil.createPropertyDialogOn((Shell)this.getShell(), (IAdaptable)javaProject, (String)id, (String[])new String[]{id}, input).open();
        } else if ("b".equals(data)) {
            String id = BUILD_PATH_PAGE_ID;
            HashMap<Object, Boolean> input = new HashMap<Object, Boolean>();
            input.put(BUILD_PATH_BLOCK, Boolean.TRUE);
            PreferencesUtil.createPropertyDialogOn((Shell)this.getShell(), (IAdaptable)javaProject, (String)id, (String[])new String[]{id}, input).open();
        } else if ("c".equals(data)) {
            String buildPath = BUILD_PATH_PAGE_ID;
            String complianceId = COMPLIANCE_PAGE_ID;
            HashMap<Object, Boolean> input = new HashMap<Object, Boolean>();
            input.put(BUILD_PATH_BLOCK, Boolean.TRUE);
            input.put(KEY_NO_LINK, Boolean.TRUE);
            PreferencesUtil.createPropertyDialogOn((Shell)this.getShell(), (IAdaptable)javaProject, (String)complianceId, (String[])new String[]{buildPath, complianceId}, (Object)data).open();
        }
        this.updateBuildPathMessage();
    }

    private void updateBuildPathMessage() {
        if (this.fLink == null || this.fLink.isDisposed()) {
            return;
        }
        String message = null;
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root != null) {
            try {
                IJavaProject project = root.getJavaProject();
                if (this.isJUnit4()) {
                    if (!JUnitStubUtility.is50OrHigher(project)) {
                        message = WizardMessages.NewTestCaseWizardPageOne_linkedtext_java5required;
                    } else if (project.findType("org.junit.Test") == null) {
                        message = Messages.format(WizardMessages.NewTestCaseWizardPageOne_linkedtext_junit4_notonbuildpath, project.getElementName());
                    }
                } else if (project.findType("junit.framework.TestCase") == null) {
                    message = Messages.format(WizardMessages.NewTestCaseWizardPageOne_linkedtext_junit3_notonbuildpath, project.getElementName());
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        this.fLink.setVisible(message != null);
        this.fImage.setVisible(message != null);
        if (message != null) {
            this.fLink.setText(message);
        }
    }

    private void classToTestButtonPressed() {
        IType type = this.chooseClassToTestType();
        if (type != null) {
            this.setClassUnderTest(type.getFullyQualifiedName('.'));
        }
    }

    private IType chooseClassToTestType() {
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root == null) {
            return null;
        }
        IJavaElement[] elements = new IJavaElement[]{root.getJavaProject()};
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])elements);
        try {
            Object[] resultArray;
            SelectionDialog dialog = JavaUI.createTypeDialog((Shell)this.getShell(), (IRunnableContext)this.getWizard().getContainer(), (IJavaSearchScope)scope, (int)1024, (boolean)false, (String)this.getClassUnderTestText());
            dialog.setTitle(WizardMessages.NewTestCaseWizardPageOne_class_to_test_dialog_title);
            dialog.setMessage(WizardMessages.NewTestCaseWizardPageOne_class_to_test_dialog_message);
            if (dialog.open() == 0 && (resultArray = dialog.getResult()) != null && resultArray.length > 0) {
                return (IType)resultArray[0];
            }
        }
        catch (JavaModelException e) {
            JUnitPlugin.log(e);
        }
        return null;
    }

    protected IStatus packageChanged() {
        IStatus status = super.packageChanged();
        this.fClassToTestCompletionProcessor.setPackageFragment(this.getPackageFragment());
        return status;
    }

    protected IStatus classUnderTestChanged() {
        JUnitStatus status = new JUnitStatus();
        this.fClassUnderTest = null;
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root == null) {
            return status;
        }
        String classToTestName = this.getClassUnderTestText();
        if (classToTestName.length() == 0) {
            return status;
        }
        IStatus val = JavaConventions.validateJavaTypeName((String)classToTestName);
        if (val.getSeverity() == 4) {
            status.setError(WizardMessages.NewTestCaseWizardPageOne_error_class_to_test_not_valid);
            return status;
        }
        IPackageFragment pack = this.getPackageFragment();
        try {
            IType type = this.resolveClassNameToType(root.getJavaProject(), pack, classToTestName);
            if (type == null) {
                status.setError(WizardMessages.NewTestCaseWizardPageOne_error_class_to_test_not_exist);
                return status;
            }
            if (type.isInterface()) {
                status.setWarning(Messages.format(WizardMessages.NewTestCaseWizardPageOne_warning_class_to_test_is_interface, classToTestName));
            }
            if (pack != null && !JUnitStubUtility.isVisible((IMember)type, pack)) {
                status.setWarning(Messages.format(WizardMessages.NewTestCaseWizardPageOne_warning_class_to_test_not_visible, classToTestName));
            }
            this.fClassUnderTest = type;
            this.fPage2.setClassUnderTest(this.fClassUnderTest);
        }
        catch (JavaModelException javaModelException) {
            status.setError(WizardMessages.NewTestCaseWizardPageOne_error_class_to_test_not_valid);
        }
        return status;
    }

    public String getClassUnderTestText() {
        return this.fClassUnderTestText;
    }

    public IType getClassUnderTest() {
        return this.fClassUnderTest;
    }

    public void setClassUnderTest(String name) {
        if (this.fClassUnderTestControl != null && !this.fClassUnderTestControl.isDisposed()) {
            this.fClassUnderTestControl.setText(name);
        }
        this.internalSetClassUnderText(name);
    }

    private void internalSetClassUnderText(String name) {
        this.fClassUnderTestText = name;
        this.fClassUnderTestStatus = this.classUnderTestChanged();
        this.handleFieldChanged(CLASS_UNDER_TEST);
    }

    protected void createTypeMembers(IType type, NewTypeWizardPage.ImportsManager imports, IProgressMonitor monitor) throws CoreException {
        if (this.fMethodStubsButtons.isSelected(4)) {
            this.createConstructor(type, imports);
        }
        if (this.fMethodStubsButtons.isSelected(0)) {
            this.createSetUpClass(type, imports);
        }
        if (this.fMethodStubsButtons.isSelected(1)) {
            this.createTearDownClass(type, imports);
        }
        if (this.fMethodStubsButtons.isSelected(2)) {
            this.createSetUp(type, imports);
        }
        if (this.fMethodStubsButtons.isSelected(3)) {
            this.createTearDown(type, imports);
        }
        if (this.fClassUnderTest != null) {
            this.createTestMethodStubs(type, imports);
        }
        if (this.isJUnit4()) {
            imports.addStaticImport("org.junit.Assert", "*", false);
        }
    }

    private void createConstructor(IType type, NewTypeWizardPage.ImportsManager imports) throws CoreException {
        String content;
        ITypeHierarchy typeHierarchy = null;
        IType[] superTypes = null;
        IMethod methodTemplate = null;
        if (type.exists()) {
            typeHierarchy = type.newSupertypeHierarchy(null);
            superTypes = typeHierarchy.getAllSuperclasses(type);
            int i = 0;
            while (i < superTypes.length) {
                IMethod constrMethod;
                if (superTypes[i].exists() && (constrMethod = superTypes[i].getMethod(superTypes[i].getElementName(), new String[]{"Ljava.lang.String;"})).exists() && constrMethod.isConstructor()) {
                    methodTemplate = constrMethod;
                    break;
                }
                ++i;
            }
        }
        JUnitStubUtility.GenStubSettings settings = JUnitStubUtility.getCodeGenerationSettings(type.getJavaProject());
        settings.createComments = this.isAddComments();
        if (methodTemplate != null) {
            settings.callSuper = true;
            settings.methodOverwrites = true;
            content = JUnitStubUtility.genStub(type.getCompilationUnit(), this.getTypeName(), methodTemplate, settings, null, imports);
        } else {
            String delimiter = this.getLineDelimiter();
            StringBuffer buffer = new StringBuffer(32);
            buffer.append("public ");
            buffer.append(this.getTypeName());
            buffer.append('(');
            if (!this.isJUnit4()) {
                buffer.append(imports.addImport("java.lang.String")).append(" name");
            }
            buffer.append(") {");
            buffer.append(delimiter);
            if (!this.isJUnit4()) {
                buffer.append("super(name);").append(delimiter);
            }
            buffer.append('}');
            buffer.append(delimiter);
            content = buffer.toString();
        }
        type.createMethod(content, null, true, null);
    }

    private IMethod findInHierarchy(IType type, String methodName) throws JavaModelException {
        ITypeHierarchy typeHierarchy = null;
        IType[] superTypes = null;
        if (type.exists()) {
            typeHierarchy = type.newSupertypeHierarchy(null);
            superTypes = typeHierarchy.getAllSuperclasses(type);
            int i = 0;
            while (i < superTypes.length) {
                IMethod testMethod;
                if (superTypes[i].exists() && (testMethod = superTypes[i].getMethod(methodName, new String[0])).exists()) {
                    return testMethod;
                }
                ++i;
            }
        }
        return null;
    }

    private void createSetupStubs(IType type, String methodName, boolean isStatic, String annotationType, NewTypeWizardPage.ImportsManager imports) throws CoreException {
        String content = null;
        IMethod methodTemplate = this.findInHierarchy(type, methodName);
        String annotation = null;
        if (this.isJUnit4()) {
            annotation = String.valueOf('@') + imports.addImport(annotationType);
        }
        JUnitStubUtility.GenStubSettings settings = JUnitStubUtility.getCodeGenerationSettings(type.getJavaProject());
        settings.createComments = this.isAddComments();
        if (methodTemplate != null) {
            settings.callSuper = true;
            settings.methodOverwrites = true;
            content = JUnitStubUtility.genStub(type.getCompilationUnit(), this.getTypeName(), methodTemplate, settings, annotation, imports);
        } else {
            String delimiter = this.getLineDelimiter();
            StringBuffer buffer = new StringBuffer();
            if (settings.createComments) {
                String[] excSignature = new String[]{Signature.createTypeSignature((String)"java.lang.Exception", (boolean)true)};
                String comment = CodeGeneration.getMethodComment((ICompilationUnit)type.getCompilationUnit(), (String)type.getElementName(), (String)methodName, (String[])new String[0], (String[])excSignature, (String)"V", null, (String)delimiter);
                if (comment != null) {
                    buffer.append(comment);
                }
            }
            if (annotation != null) {
                buffer.append(annotation).append(delimiter);
            }
            if (this.isJUnit4()) {
                buffer.append("public ");
            } else {
                buffer.append("protected ");
            }
            if (isStatic) {
                buffer.append("static ");
            }
            buffer.append("void ");
            buffer.append(methodName);
            buffer.append("() throws ");
            buffer.append(imports.addImport("java.lang.Exception"));
            buffer.append(" {}");
            buffer.append(delimiter);
            content = buffer.toString();
        }
        type.createMethod(content, null, false, null);
    }

    private void createSetUp(IType type, NewTypeWizardPage.ImportsManager imports) throws CoreException {
        this.createSetupStubs(type, "setUp", false, "org.junit.Before", imports);
    }

    private void createTearDown(IType type, NewTypeWizardPage.ImportsManager imports) throws CoreException {
        this.createSetupStubs(type, "tearDown", false, "org.junit.After", imports);
    }

    private void createSetUpClass(IType type, NewTypeWizardPage.ImportsManager imports) throws CoreException {
        this.createSetupStubs(type, "setUpBeforeClass", true, "org.junit.BeforeClass", imports);
    }

    private void createTearDownClass(IType type, NewTypeWizardPage.ImportsManager imports) throws CoreException {
        this.createSetupStubs(type, "tearDownAfterClass", true, "org.junit.AfterClass", imports);
    }

    private void createTestMethodStubs(IType type, NewTypeWizardPage.ImportsManager imports) throws CoreException {
        IMethod[] methods = this.fPage2.getCheckedMethods();
        if (methods.length == 0) {
            return;
        }
        IMethod[] allMethodsArray = this.fPage2.getAllMethods();
        ArrayList allMethods = new ArrayList();
        allMethods.addAll(Arrays.asList(allMethodsArray));
        List overloadedMethods = this.getOverloadedMethods(allMethods);
        ArrayList<String> names = new ArrayList<String>();
        int i = 0;
        while (i < methods.length) {
            IMethod method = methods[i];
            String elementName = method.getElementName();
            StringBuffer name = new StringBuffer(PREFIX).append(Character.toUpperCase(elementName.charAt(0))).append(elementName.substring(1));
            StringBuffer buffer = new StringBuffer();
            boolean contains = overloadedMethods.contains(method);
            if (contains) {
                this.appendParameterNamesToMethodName(name, method.getParameterTypes());
            }
            this.replaceIllegalCharacters(name);
            String testName = name.toString();
            if (names.contains(testName)) {
                int suffix = 1;
                while (names.contains(String.valueOf(testName) + Integer.toString(suffix))) {
                    ++suffix;
                }
                name.append(Integer.toString(suffix));
            }
            testName = name.toString();
            names.add(testName);
            if (this.isAddComments()) {
                this.appendMethodComment(buffer, method);
            }
            if (this.isJUnit4()) {
                buffer.append('@').append(imports.addImport("org.junit.Test")).append(this.getLineDelimiter());
            }
            buffer.append("public ");
            if (this.fPage2.getCreateFinalMethodStubsButtonSelection()) {
                buffer.append("final ");
            }
            buffer.append("void ");
            buffer.append(testName);
            buffer.append("()");
            this.appendTestMethodBody(buffer, testName, method, type.getCompilationUnit(), imports);
            type.createMethod(buffer.toString(), null, false, null);
            ++i;
        }
    }

    private void replaceIllegalCharacters(StringBuffer buffer) {
        char character = '\u0000';
        int index = buffer.length() - 1;
        while (index >= 0) {
            character = buffer.charAt(index);
            if (Character.isWhitespace(character)) {
                buffer.deleteCharAt(index);
            } else if (character == '<') {
                buffer.replace(index, index + 1, OF_TAG);
            } else if (character == '?') {
                buffer.replace(index, index + 1, QUESTION_MARK_TAG);
            } else if (!Character.isJavaIdentifierPart(character)) {
                buffer.deleteCharAt(index);
            }
            --index;
        }
    }

    private String getLineDelimiter() throws JavaModelException {
        IType classToTest = this.getClassUnderTest();
        if (classToTest != null && classToTest.exists() && classToTest.getCompilationUnit() != null) {
            return classToTest.getCompilationUnit().findRecommendedLineSeparator();
        }
        return this.getPackageFragment().findRecommendedLineSeparator();
    }

    private void appendTestMethodBody(StringBuffer buffer, String name, IMethod method, ICompilationUnit targetCu, NewTypeWizardPage.ImportsManager imports) throws CoreException {
        String todoTaskTag;
        String delimiter = this.getLineDelimiter();
        buffer.append('{').append(delimiter);
        String todoTask = "";
        if (this.fPage2.isCreateTasks() && (todoTaskTag = JUnitStubUtility.getTodoTaskTag(targetCu.getJavaProject())) != null) {
            todoTask = " // " + todoTaskTag;
        }
        String message = WizardMessages.NewTestCaseWizardPageOne_not_yet_implemented_string;
        buffer.append(Messages.format("fail(\"{0}\");", message)).append(todoTask).append(delimiter);
        buffer.append('}').append(delimiter);
    }

    private void appendParameterNamesToMethodName(StringBuffer buffer, String[] parameters) {
        int i = 0;
        while (i < parameters.length) {
            StringBuffer buf = new StringBuffer(Signature.getSimpleName((String)Signature.toString((String)Signature.getElementType((String)parameters[i]))));
            char character = buf.charAt(0);
            if (buf.length() > 0 && !Character.isUpperCase(character)) {
                buf.setCharAt(0, Character.toUpperCase(character));
            }
            buffer.append(buf.toString());
            int j = 0;
            int arrayCount = Signature.getArrayCount((String)parameters[i]);
            while (j < arrayCount) {
                buffer.append("Array");
                ++j;
            }
            ++i;
        }
    }

    private void appendMethodComment(StringBuffer buffer, IMethod method) throws JavaModelException {
        String delimiter = this.getLineDelimiter();
        StringBuffer buf = new StringBuffer("{@link ");
        JavaElementLabels.getTypeLabel((IType)method.getDeclaringType(), (long)262144L, (StringBuffer)buf);
        buf.append('#');
        buf.append(method.getElementName());
        buf.append('(');
        String[] paramTypes = JUnitStubUtility.getParameterTypeNamesForSeeTag(method);
        int i = 0;
        while (i < paramTypes.length) {
            if (i != 0) {
                buf.append(", ");
            }
            buf.append(paramTypes[i]);
            ++i;
        }
        buf.append(')');
        buf.append('}');
        buffer.append("/**");
        buffer.append(delimiter);
        buffer.append(" * ");
        buffer.append(Messages.format(WizardMessages.NewTestCaseWizardPageOne_comment_class_to_test, buf.toString()));
        buffer.append(delimiter);
        buffer.append(" */");
        buffer.append(delimiter);
    }

    private List getOverloadedMethods(List allMethods) {
        ArrayList<IMethod> overloadedMethods = new ArrayList<IMethod>();
        int i = 0;
        while (i < allMethods.size()) {
            IMethod current = (IMethod)allMethods.get(i);
            String currentName = current.getElementName();
            boolean currentAdded = false;
            ListIterator iter = allMethods.listIterator(i + 1);
            while (iter.hasNext()) {
                IMethod iterMethod = (IMethod)iter.next();
                if (!iterMethod.getElementName().equals(currentName)) continue;
                if (!currentAdded) {
                    overloadedMethods.add(current);
                    currentAdded = true;
                }
                overloadedMethods.add(iterMethod);
                iter.remove();
            }
            ++i;
        }
        return overloadedMethods;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible) {
            this.saveWidgetValues();
        }
    }

    protected IStatus validateIfJUnitProject() {
        JUnitStatus status = new JUnitStatus();
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root != null) {
            try {
                IJavaProject project = root.getJavaProject();
                if (this.isJUnit4()) {
                    if (!JUnitStubUtility.is50OrHigher(project)) {
                        status.setError(WizardMessages.NewTestCaseWizardPageOne_error_java5required);
                        return status;
                    }
                    if (project.findType("org.junit.Test") == null) {
                        status.setWarning(WizardMessages.NewTestCaseWizardPageOne__error_junit4NotOnbuildpath);
                        return status;
                    }
                } else if (project.findType("junit.framework.TestCase") == null) {
                    status.setWarning(WizardMessages.NewTestCaseWizardPageOne_error_junitNotOnbuildpath);
                    return status;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return status;
    }

    protected IStatus superClassChanged() {
        if (this.isJUnit4()) {
            return new JUnitStatus();
        }
        String superClassName = this.getSuperClass();
        JUnitStatus status = new JUnitStatus();
        if (superClassName == null || superClassName.trim().equals("")) {
            status.setError(WizardMessages.NewTestCaseWizardPageOne_error_superclass_empty);
            return status;
        }
        if (this.getPackageFragmentRoot() != null) {
            try {
                IType type = this.resolveClassNameToType(this.getPackageFragmentRoot().getJavaProject(), this.getPackageFragment(), superClassName);
                if (type == null) {
                    status.setWarning(WizardMessages.NewTestCaseWizardPageOne_error_superclass_not_exist);
                    return status;
                }
                if (type.isInterface()) {
                    status.setError(WizardMessages.NewTestCaseWizardPageOne_error_superclass_is_interface);
                    return status;
                }
                if (!TestSearchEngine.isTestImplementor(type)) {
                    status.setError(Messages.format(WizardMessages.NewTestCaseWizardPageOne_error_superclass_not_implementing_test_interface, "junit.framework.Test"));
                    return status;
                }
            }
            catch (JavaModelException e) {
                JUnitPlugin.log(e);
            }
        }
        return status;
    }

    public boolean canFlipToNextPage() {
        return super.canFlipToNextPage() && this.getClassUnderTest() != null;
    }

    private IType resolveClassNameToType(IJavaProject jproject, IPackageFragment pack, String classToTestName) throws JavaModelException {
        IType type = jproject.findType(classToTestName);
        if (type == null && pack != null && !pack.isDefaultPackage()) {
            type = jproject.findType(pack.getElementName(), classToTestName);
        }
        if (type == null) {
            type = jproject.findType("java.lang", classToTestName);
        }
        return type;
    }

    private void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            this.fMethodStubsButtons.setSelection(2, settings.getBoolean(STORE_SETUP));
            this.fMethodStubsButtons.setSelection(3, settings.getBoolean(STORE_TEARDOWN));
            this.fMethodStubsButtons.setSelection(0, settings.getBoolean(STORE_SETUP_CLASS));
            this.fMethodStubsButtons.setSelection(1, settings.getBoolean(STORE_TEARDOWN_CLASS));
            this.fMethodStubsButtons.setSelection(4, settings.getBoolean(STORE_CONSTRUCTOR));
        } else {
            this.fMethodStubsButtons.setSelection(2, false);
            this.fMethodStubsButtons.setSelection(3, false);
            this.fMethodStubsButtons.setSelection(0, false);
            this.fMethodStubsButtons.setSelection(1, false);
            this.fMethodStubsButtons.setSelection(4, false);
        }
    }

    private void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            settings.put(STORE_SETUP, this.fMethodStubsButtons.isSelected(2));
            settings.put(STORE_TEARDOWN, this.fMethodStubsButtons.isSelected(3));
            settings.put(STORE_SETUP_CLASS, this.fMethodStubsButtons.isSelected(0));
            settings.put(STORE_TEARDOWN_CLASS, this.fMethodStubsButtons.isSelected(1));
            settings.put(STORE_CONSTRUCTOR, this.fMethodStubsButtons.isSelected(4));
        }
    }
}

