/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.osgi.internal.resolver.BundleDescriptionImpl;
import org.eclipse.osgi.internal.resolver.ComputeNodeOrder;
import org.eclipse.osgi.internal.resolver.StateImpl;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.GenericDescription;
import org.eclipse.osgi.service.resolver.GenericSpecification;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateHelper;
import org.eclipse.osgi.service.resolver.VersionConstraint;

public class StateHelperImpl
implements StateHelper {
    private static StateHelper instance = new StateHelperImpl();

    public BundleDescription[] getDependentBundles(BundleDescription[] bundles) {
        if (bundles == null || bundles.length == 0) {
            return new BundleDescription[0];
        }
        HashSet reachable = new HashSet(bundles.length);
        int i = 0;
        while (i < bundles.length) {
            if (bundles[i].isResolved()) {
                this.addDependentBundles(bundles[i], reachable);
            }
            ++i;
        }
        return reachable.toArray(new BundleDescription[reachable.size()]);
    }

    private void addDependentBundles(BundleDescription bundle, Set reachable) {
        if (reachable.contains(bundle)) {
            return;
        }
        reachable.add(bundle);
        BundleDescription[] dependents = bundle.getDependents();
        int i = 0;
        while (i < dependents.length) {
            this.addDependentBundles(dependents[i], reachable);
            ++i;
        }
    }

    public BundleDescription[] getPrerequisites(BundleDescription[] bundles) {
        if (bundles == null || bundles.length == 0) {
            return new BundleDescription[0];
        }
        HashSet reachable = new HashSet(bundles.length);
        int i = 0;
        while (i < bundles.length) {
            this.addPrerequisites(bundles[i], reachable);
            ++i;
        }
        return reachable.toArray(new BundleDescription[reachable.size()]);
    }

    private void addPrerequisites(BundleDescription bundle, Set reachable) {
        if (reachable.contains(bundle)) {
            return;
        }
        reachable.add(bundle);
        List depList = ((BundleDescriptionImpl)bundle).getBundleDependencies();
        BundleDescription[] dependencies = depList.toArray(new BundleDescription[depList.size()]);
        int i = 0;
        while (i < dependencies.length) {
            this.addPrerequisites(dependencies[i], reachable);
            ++i;
        }
    }

    private Map getExportedPackageMap(State state) {
        HashMap<String, HashSet<ExportPackageDescription>> result = new HashMap<String, HashSet<ExportPackageDescription>>(11);
        BundleDescription[] bundles = state.getBundles();
        int i = 0;
        while (i < bundles.length) {
            ExportPackageDescription[] packages = bundles[i].getExportPackages();
            int j = 0;
            while (j < packages.length) {
                ExportPackageDescription description = packages[j];
                HashSet<ExportPackageDescription> exports = (HashSet<ExportPackageDescription>)result.get(description.getName());
                if (exports == null) {
                    exports = new HashSet<ExportPackageDescription>(1);
                    result.put(description.getName(), exports);
                }
                exports.add(description);
                ++j;
            }
            ++i;
        }
        return result;
    }

    private Map getGenericsMap(State state, boolean resolved) {
        HashMap<String, HashSet<GenericDescription>> result = new HashMap<String, HashSet<GenericDescription>>(11);
        BundleDescription[] bundles = state.getBundles();
        int i = 0;
        while (i < bundles.length) {
            if (!resolved || bundles[i].isResolved()) {
                GenericDescription[] generics = bundles[i].getGenericCapabilities();
                int j = 0;
                while (j < generics.length) {
                    GenericDescription description = generics[j];
                    HashSet<GenericDescription> genericSet = (HashSet<GenericDescription>)result.get(description.getName());
                    if (genericSet == null) {
                        genericSet = new HashSet<GenericDescription>(1);
                        result.put(description.getName(), genericSet);
                    }
                    genericSet.add(description);
                    ++j;
                }
            }
            ++i;
        }
        return result;
    }

    private VersionConstraint[] getUnsatisfiedLeaves(State state, BundleDescription[] bundles) {
        Map packages = this.getExportedPackageMap(state);
        Map generics = this.getGenericsMap(state, false);
        HashSet<VersionConstraint> result = new HashSet<VersionConstraint>(11);
        int i = 0;
        while (i < bundles.length) {
            BundleDescription description = bundles[i];
            VersionConstraint[] constraints = this.getUnsatisfiedConstraints(description);
            int j = 0;
            while (j < constraints.length) {
                Set genericSet;
                VersionConstraint constraint = constraints[j];
                boolean satisfied = false;
                if (constraint instanceof BundleSpecification || constraint instanceof HostSpecification) {
                    BundleDescription[] suppliers = state.getBundles(constraint.getName());
                    int k = 0;
                    while (k < suppliers.length && !satisfied) {
                        satisfied |= constraint.isSatisfiedBy(suppliers[k]);
                        ++k;
                    }
                } else if (constraint instanceof ImportPackageSpecification) {
                    Set exports = (Set)packages.get(constraint.getName());
                    if (exports != null) {
                        Iterator iter = exports.iterator();
                        while (iter.hasNext() && !satisfied) {
                            satisfied |= constraint.isSatisfiedBy((ExportPackageDescription)iter.next());
                        }
                    }
                } else if (constraint instanceof GenericSpecification && (genericSet = (Set)generics.get(constraint.getName())) != null) {
                    Iterator iter = genericSet.iterator();
                    while (iter.hasNext() && !satisfied) {
                        satisfied |= constraint.isSatisfiedBy((GenericDescription)iter.next());
                    }
                }
                if (!satisfied) {
                    result.add(constraint);
                }
                ++j;
            }
            ++i;
        }
        return result.toArray(new VersionConstraint[result.size()]);
    }

    public VersionConstraint[] getUnsatisfiedLeaves(BundleDescription[] bundles) {
        if (bundles.length == 0) {
            return new VersionConstraint[0];
        }
        State state = bundles[0].getContainingState();
        return this.getUnsatisfiedLeaves(state, bundles);
    }

    public VersionConstraint[] getUnsatisfiedConstraints(BundleDescription bundle) {
        State containingState = bundle.getContainingState();
        if (containingState == null) {
            throw new IllegalStateException("Does not belong to a state");
        }
        ArrayList<VersionConstraint> unsatisfied = new ArrayList<VersionConstraint>();
        HostSpecification host = bundle.getHost();
        if (host != null && !host.isResolved() && !this.isResolvable(host)) {
            unsatisfied.add(host);
        }
        BundleSpecification[] requiredBundles = bundle.getRequiredBundles();
        int i = 0;
        while (i < requiredBundles.length) {
            if (!requiredBundles[i].isResolved() && !this.isResolvable(requiredBundles[i])) {
                unsatisfied.add(requiredBundles[i]);
            }
            ++i;
        }
        ImportPackageSpecification[] packages = bundle.getImportPackages();
        int i2 = 0;
        while (i2 < packages.length) {
            if (!packages[i2].isResolved() && !this.isResolvable(packages[i2])) {
                unsatisfied.add(packages[i2]);
            }
            ++i2;
        }
        GenericSpecification[] generics = bundle.getGenericRequires();
        int i3 = 0;
        while (i3 < generics.length) {
            if (!generics[i3].isResolved() && !this.isResolvable(generics[i3])) {
                unsatisfied.add(generics[i3]);
            }
            ++i3;
        }
        return unsatisfied.toArray(new VersionConstraint[unsatisfied.size()]);
    }

    public boolean isResolvable(ImportPackageSpecification constraint) {
        ExportPackageDescription[] exports = constraint.getBundle().getContainingState().getExportedPackages();
        int i = 0;
        while (i < exports.length) {
            if (constraint.isSatisfiedBy(exports[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isResolvable(GenericSpecification constraint) {
        Map genericCapabilities = this.getGenericsMap(constraint.getBundle().getContainingState(), true);
        Set genericSet = (Set)genericCapabilities.get(constraint.getName());
        if (genericSet == null) {
            return false;
        }
        Iterator iter = genericSet.iterator();
        while (iter.hasNext()) {
            if (!constraint.isSatisfiedBy((GenericDescription)iter.next())) continue;
            return true;
        }
        return false;
    }

    public boolean isResolvable(BundleSpecification specification) {
        return this.isBundleConstraintResolvable(specification);
    }

    public boolean isResolvable(HostSpecification specification) {
        return this.isBundleConstraintResolvable(specification);
    }

    private boolean isBundleConstraintResolvable(VersionConstraint constraint) {
        BundleDescription[] availableBundles = constraint.getBundle().getContainingState().getBundles(constraint.getName());
        int i = 0;
        while (i < availableBundles.length) {
            if (availableBundles[i].isResolved() && constraint.isSatisfiedBy(availableBundles[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Object[][] sortBundles(BundleDescription[] toSort) {
        ArrayList references = new ArrayList(toSort.length);
        int i = 0;
        while (i < toSort.length) {
            if (toSort[i].isResolved()) {
                this.buildReferences(toSort[i], references);
            }
            ++i;
        }
        return ComputeNodeOrder.computeNodeOrder(toSort, (Object[][])references.toArray((T[])new Object[references.size()][]));
    }

    private void buildReferences(BundleDescription description, List references) {
        HostSpecification host = description.getHost();
        if (host != null) {
            if (host.getHosts() != null) {
                BundleDescription[] hosts = host.getHosts();
                int i = 0;
                while (i < hosts.length) {
                    if (hosts[i] != description) {
                        references.add(new Object[]{description, hosts[i]});
                    }
                    ++i;
                }
            }
        } else {
            this.buildReferences(description, ((BundleDescriptionImpl)description).getBundleDependencies(), references);
        }
    }

    private void buildReferences(BundleDescription description, List dependencies, List references) {
        Iterator iter = dependencies.iterator();
        while (iter.hasNext()) {
            this.addReference(description, (BundleDescription)iter.next(), references);
        }
    }

    private void addReference(BundleDescription description, BundleDescription reference, List references) {
        if (description == reference || reference == null) {
            return;
        }
        references.add(new Object[]{description, reference});
    }

    public ExportPackageDescription[] getVisiblePackages(BundleDescription bundle) {
        StateImpl state = (StateImpl)bundle.getContainingState();
        boolean strict = false;
        if (state != null) {
            strict = state.inStrictMode();
        }
        ArrayList<ExportPackageDescription> packageList = new ArrayList<ExportPackageDescription>();
        ArrayList<String> importList = new ArrayList<String>();
        ImportPackageSpecification[] imports = bundle.getImportPackages();
        int i = 0;
        while (i < imports.length) {
            ExportPackageDescription pkgSupplier = (ExportPackageDescription)imports[i].getSupplier();
            if (pkgSupplier != null) {
                if (!this.isSystemExport(pkgSupplier)) {
                    packageList.add(pkgSupplier);
                }
                BundleSpecification[] requires = pkgSupplier.getExporter().getRequiredBundles();
                ArrayList visited = new ArrayList();
                int j = 0;
                while (j < requires.length) {
                    BundleDescription bundleSupplier = (BundleDescription)requires[j].getSupplier();
                    if (bundleSupplier != null) {
                        this.getPackages(bundleSupplier, bundle.getSymbolicName(), importList, packageList, visited, strict, imports[i].getName());
                    }
                    ++j;
                }
                importList.add(imports[i].getName());
            }
            ++i;
        }
        BundleSpecification[] requires = bundle.getRequiredBundles();
        ArrayList visited = new ArrayList(requires.length);
        int i2 = 0;
        while (i2 < requires.length) {
            BundleDescription bundleSupplier = (BundleDescription)requires[i2].getSupplier();
            if (bundleSupplier != null) {
                this.getPackages(bundleSupplier, bundle.getSymbolicName(), importList, packageList, visited, strict, null);
            }
            ++i2;
        }
        return packageList.toArray(new ExportPackageDescription[packageList.size()]);
    }

    private void getPackages(BundleDescription requiredBundle, String symbolicName, List importList, List packageList, List visited, boolean strict, String pkgName) {
        if (visited.contains(requiredBundle)) {
            return;
        }
        visited.add(requiredBundle);
        ExportPackageDescription[] exports = requiredBundle.getSelectedExports();
        int i = 0;
        while (i < exports.length) {
            if ((pkgName == null || exports[i].getName().equals(pkgName)) && !this.isSystemExport(exports[i]) && this.isFriend(symbolicName, exports[i], strict) && !importList.contains(exports[i].getName())) {
                packageList.add(exports[i]);
            }
            ++i;
        }
        BundleSpecification[] requiredBundles = requiredBundle.getRequiredBundles();
        int i2 = 0;
        while (i2 < requiredBundles.length) {
            if ((pkgName != null || requiredBundles[i2].isExported()) && requiredBundles[i2].getSupplier() != null) {
                this.getPackages((BundleDescription)requiredBundles[i2].getSupplier(), symbolicName, importList, packageList, visited, strict, pkgName);
            }
            ++i2;
        }
    }

    private boolean isSystemExport(ExportPackageDescription export) {
        return (Integer)export.getDirective("x-equinox-ee") >= 0;
    }

    private boolean isFriend(String consumerBSN, ExportPackageDescription export, boolean strict) {
        if (!strict) {
            return true;
        }
        String[] friends = (String[])export.getDirective("x-friends");
        if (friends == null) {
            return true;
        }
        int i = 0;
        while (i < friends.length) {
            if (friends[i].equals(consumerBSN)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int getAccessCode(BundleDescription bundle, ExportPackageDescription export) {
        if (((Boolean)export.getDirective("x-internal")).booleanValue()) {
            return 2;
        }
        if (!this.isFriend(bundle.getSymbolicName(), export, true)) {
            return 2;
        }
        return 1;
    }

    public static StateHelper getInstance() {
        return instance;
    }
}

